/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cmdline;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XSLTExecutable;
import com.ibm.xml.xci.internal.cmdline.CLIParseException;
import com.ibm.xml.xci.internal.cmdline.CLIprocessor;
import com.ibm.xml.xci.internal.cmdline.Contract;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExecuteXSLT {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String cn = ExecuteXSLT.class.getName();
    private static Logger logger = Logger.getLogger(cn);

    public static void main(String[] stringArray) {
        try {
            Object object2;
            Contract contract = new Contract("XSLTModule");
            contract.setArgs(stringArray);
            CLIprocessor.parseArgs(contract);
            if (contract.isHelp()) {
                System.err.println(XCIMessages.createXCIMessage("INFO_CMD_LINE_XSLT_EXECUTE_USAGE", null));
                return;
            }
            ArrayList<String> arrayList = contract.getExpressionFiles();
            if (arrayList.size() != 1) {
                System.err.println(XCIMessages.createXCIMessage("ER_CMD_LINE_TOO_MANY_INPUT_FILES", new String[]{"XSL"}));
                return;
            }
            File file = new File(arrayList.get(0));
            StreamSource streamSource = new StreamSource(file);
            XSLTExecutable xSLTExecutable = null;
            try {
                xSLTExecutable = contract.xFactory.prepareXSLT(streamSource, contract.xStaticContext);
            }
            catch (Exception exception) {
                System.err.println(exception.getLocalizedMessage());
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "main", exception.getLocalizedMessage(), exception);
                }
                return;
            }
            StreamSource streamSource2 = null;
            if (contract.getInputFile() != null) {
                object2 = new File(contract.getInputFile());
                streamSource2 = new StreamSource((File)object2);
            }
            if (contract.getOutputFile() == null) {
                object2 = new StreamResult(System.out);
            } else {
                File file2 = new File(contract.getOutputFile());
                object2 = new StreamResult(file2);
            }
            try {
                xSLTExecutable.execute(streamSource2, contract.xDynamicContext, (Result)object2);
            }
            catch (Exception exception) {
                System.err.println(exception.getLocalizedMessage());
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "main", exception.getLocalizedMessage(), exception);
                }
                return;
            }
        }
        catch (CLIParseException cLIParseException) {
            System.err.println(cLIParseException.getMessage());
            System.err.println(XCIMessages.createXCIMessage("INFO_CMD_LINE_XSLT_EXECUTE_USAGE", null));
        }
    }
}

