/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cmdline;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XOutputParameters;
import com.ibm.xml.xapi.XQueryExecutable;
import com.ibm.xml.xci.internal.cmdline.CLIParseException;
import com.ibm.xml.xci.internal.cmdline.CLIprocessor;
import com.ibm.xml.xci.internal.cmdline.Contract;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExecuteXQuery {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String cn = ExecuteXQuery.class.getName();
    private static Logger logger = LoggerUtil.getLogger(ExecuteXQuery.class);

    public static void main(String[] stringArray) {
        block16: {
            try {
                Object object2;
                Contract contract = new Contract("XQueryModule");
                contract.setArgs(stringArray);
                CLIprocessor.parseArgs(contract);
                if (contract.isHelp()) {
                    System.err.println(XCIMessages.createXCIMessage("INFO_CMD_LINE_XQUERY_EXECUTE_USAGE", null));
                    return;
                }
                ArrayList<String> arrayList = contract.getExpressionFiles();
                if (arrayList.size() != 1) {
                    System.err.println(XCIMessages.createXCIMessage("ER_CMD_LINE_TOO_MANY_INPUT_FILES", new String[]{"XQuery"}));
                    return;
                }
                File file = new File(arrayList.get(0));
                StreamSource streamSource = new StreamSource(file);
                XQueryExecutable xQueryExecutable = null;
                try {
                    xQueryExecutable = contract.xFactory.prepareXQuery(streamSource, contract.xStaticContext);
                }
                catch (Exception exception) {
                    System.err.println(exception.getLocalizedMessage());
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "main", exception.getLocalizedMessage(), exception);
                    }
                    return;
                }
                StreamSource streamSource2 = null;
                if (contract.getInputFile() != null) {
                    object2 = new File(contract.getInputFile());
                    streamSource2 = new StreamSource((File)object2);
                }
                object2 = null;
                try {
                    object2 = xQueryExecutable.execute(streamSource2, contract.xDynamicContext);
                }
                catch (Exception exception) {
                    System.err.println(exception.getLocalizedMessage());
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "main", "", exception);
                    }
                    return;
                }
                StreamResult streamResult = null;
                XOutputParameters xOutputParameters = contract.xFactory.newOutputParameters();
                if (contract.getOutputFile() == null) {
                    streamResult = new StreamResult(System.out);
                } else {
                    File file2 = new File(contract.getOutputFile());
                    streamResult = new StreamResult(file2);
                }
                if (object2 == null) break block16;
                xOutputParameters.setIndent(true);
                try {
                    object2.exportSequence(streamResult, xOutputParameters);
                }
                catch (Exception exception) {
                    System.err.println(exception.getLocalizedMessage());
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "main", exception.getLocalizedMessage(), exception);
                    }
                    return;
                }
            }
            catch (CLIParseException cLIParseException) {
                System.err.println(cLIParseException.getMessage());
                System.err.println(XCIMessages.createXCIMessage("INFO_CMD_LINE_XQUERY_EXECUTE_USAGE", null));
            }
        }
    }
}

