/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cmdline;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XCompilationParameters;
import com.ibm.xml.xapi.XDynamicContext;
import com.ibm.xml.xapi.XFactory;
import com.ibm.xml.xapi.XStaticContext;
import com.ibm.xml.xci.internal.cmdline.CLIParseException;
import com.ibm.xml.xci.internal.cmdline.Contract;
import com.ibm.xml.xci.internal.cmdline.StaticContextBinding;
import com.ibm.xml.xci.res.XCIMessages;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIprocessor {
    private static final String cn = CLIprocessor.class.getName();
    private static Logger logger = LoggerUtil.getLogger(CLIprocessor.class);
    public static final String VERSION = "2.0";
    private static Logger cliLevelLogger = Logger.getLogger("com.ibm.xml.xci.internal.cmdline");
    public static final String WARNING_MSG = XCIMessages.createXCIMessage("WARN_CMD_LINE_TOOL_WARNING", new String[0]);

    public static boolean checkArgValue(String string2) {
        return !string2.startsWith("-");
    }

    static QName parseQName(String string2) throws CLIParseException {
        String[] stringArray;
        QName qName = null;
        if (string2.contains("=")) {
            stringArray = string2.split("=");
            if (stringArray.length <= 1) {
                throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_FUNC_OR_VAR_INCOMPLETE", new String[0]));
            }
            string2 = stringArray[1];
        }
        if ((stringArray = string2.split(",")).length < 1 || stringArray.length > 2) {
            throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_FUNC_OR_VAR_INCOMPLETE", new String[0]));
        }
        String string3 = stringArray.length >= 1 ? stringArray[0].trim() : null;
        String string4 = stringArray.length >= 2 ? stringArray[1].trim() : null;
        qName = string4 != null ? new QName(string4, string3) : new QName(string3);
        return qName;
    }

    public static StaticContextBinding parseBinding(ArrayList<String> arrayList) throws CLIParseException {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "parseBinding", "parseBinding called ");
        }
        Boolean bl = false;
        Boolean bl2 = false;
        Boolean bl3 = false;
        StaticContextBinding staticContextBinding = new StaticContextBinding();
        ListIterator<String> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string2 = listIterator.next();
            if (LoggerUtil.isFineLoggable(logger)) {
                logger.logp(Level.FINE, cn, "parseBinding", "parseBinding processing " + string2);
            }
            if (string2.startsWith("name=")) {
                bl = true;
                staticContextBinding.setName(CLIprocessor.parseQName(string2));
                continue;
            }
            if (string2.startsWith("type=")) {
                bl2 = true;
                staticContextBinding.setType(CLIprocessor.parseQName(string2));
                continue;
            }
            if (string2.startsWith("argtype=")) {
                bl3 = true;
                staticContextBinding.addArgType(CLIprocessor.parseQName(string2));
                continue;
            }
            throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_UNKNOWN_ARG", new String[]{string2}));
        }
        if (LoggerUtil.isFinestLoggable(logger)) {
            logger.logp(Level.FINEST, cn, "parseBinding", staticContextBinding.dumpContents());
        }
        if (!bl.booleanValue() || !bl2.booleanValue()) {
            throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_FUNC_OR_VAR_INCOMPLETE", new String[0]));
        }
        return staticContextBinding;
    }

    public static void parseArgs(Contract contract) throws CLIParseException {
        int string6;
        Object n5;
        int n2;
        Comparable<Boolean> comparable;
        String[] stringArray = contract.args;
        if (stringArray.length < 1) {
            throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_NO_ARG", new String[0]));
        }
        for (String object32 : stringArray) {
            if (!object32.equalsIgnoreCase("-debug")) continue;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    cliLevelLogger.setLevel(Level.FINEST);
                    LoggerUtil.updateTracingEnabled(logger);
                    return null;
                }
            });
        }
        XFactory xFactory = contract.xFactory;
        XStaticContext xStaticContext = contract.xStaticContext;
        XCompilationParameters xCompilationParameters = contract.params;
        XDynamicContext xDynamicContext = contract.xDynamicContext;
        if (LoggerUtil.isFinestLoggable(logger)) {
            comparable = new StringBuilder(stringArray.length + " options found:\n");
            n2 = 0;
            n5 = stringArray;
            int string3 = ((String[])n5).length;
            for (string6 = 0; string6 < string3; ++string6) {
                String string4 = n5[string6];
                ((StringBuilder)comparable).append(n2 + "=" + string4 + "\n");
                ++n2;
            }
            logger.logp(Level.FINEST, cn, "parseArgs", ((StringBuilder)comparable).toString());
        }
        comparable = false;
        for (n2 = 0; n2 < stringArray.length && stringArray[n2].charAt(0) == '-'; ++n2) {
            Object object2;
            if (LoggerUtil.isFineLoggable(logger)) {
                logger.logp(Level.FINE, cn, "parseArgs", "i = " + n2 + ", processing " + stringArray[n2]);
            }
            if (stringArray[n2].equals("-out")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-out"}));
                }
                xCompilationParameters.setClassName((String)n5);
                comparable = true;
                continue;
            }
            if (stringArray[n2].equals("-dir")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-dir"}));
                }
                xCompilationParameters.setDirectoryName((String)n5);
                continue;
            }
            if (stringArray[n2].equals("-pkg")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-pkg"}));
                }
                xCompilationParameters.setPackageName((String)n5);
                continue;
            }
            if (stringArray[n2].equals("-debug") || stringArray[n2].equals("-dcol")) continue;
            if (stringArray[n2].equals("-feature")) {
                String stringArray2;
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_NAME_AND_VALUE", new String[]{"-feature"}));
                }
                if (!CLIprocessor.checkArgValue(stringArray2 = stringArray[++n2])) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_NAME_AND_VALUE", new String[]{"-feature"}));
                }
                if (!stringArray2.equalsIgnoreCase("true") || !stringArray2.equalsIgnoreCase("false")) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_BOOLEAN_VALUE", new String[]{"-feature"}));
                }
                xStaticContext.setFeature((String)n5, new Boolean(stringArray2));
                continue;
            }
            if (stringArray[n2].equals("-cpm")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-cpm"}));
                }
                if (((String)n5).equals("1.0")) {
                    xStaticContext.setXPathCompatibilityMode(1);
                    continue;
                }
                if (((String)n5).equals(VERSION)) {
                    xStaticContext.setXPathCompatibilityMode(2);
                    continue;
                }
                if (((String)n5).equalsIgnoreCase("Latest")) {
                    xStaticContext.setXPathCompatibilityMode(0);
                    continue;
                }
                throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_COMPATIBILITY_MODE_UNKNOWN", new String[]{n5}));
            }
            if (stringArray[n2].equals("-ns")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-ns"}));
                }
                String[] exception = ((String)n5).split("=");
                if (exception.length < 2) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_NAMESPACE_ARG_FORMAT", new String[0]));
                }
                xStaticContext.declareNamespace(exception[0], exception[1]);
                continue;
            }
            if (stringArray[n2].equals("-schema")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-schema"}));
                }
                try {
                    xFactory.setValidating(1);
                    xFactory.registerSchema(new StreamSource((String)n5));
                }
                catch (Exception arrayList) {
                    if (arrayList.getCause() != null) {
                        System.err.println(WARNING_MSG);
                        System.err.println(arrayList.getCause().getLocalizedMessage());
                    } else {
                        System.err.println(WARNING_MSG);
                        System.err.println(arrayList.getLocalizedMessage());
                    }
                    if (!LoggerUtil.isFineLoggable(logger)) continue;
                    logger.logp(Level.FINE, logger.getName(), "parseArgs", "", arrayList);
                }
                continue;
            }
            if (stringArray[n2].equals("-func")) {
                n5 = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                string6 = 1;
                while (!((Boolean)n5).booleanValue() && n2 + string6 < stringArray.length) {
                    String staticContextBinding = stringArray[n2 + string6];
                    if (staticContextBinding.startsWith("name=") || staticContextBinding.startsWith("type=") || staticContextBinding.startsWith("argtype=")) {
                        arrayList.add(staticContextBinding);
                        ++string6;
                        continue;
                    }
                    n5 = true;
                    --string6;
                }
                n2 += string6;
                StaticContextBinding string5 = CLIprocessor.parseBinding(arrayList);
                object2 = string5.getArgTypesList().toArray(new QName[0]);
                xStaticContext.declareFunction(string5.getName(), string5.getType(), (QName[])object2);
                continue;
            }
            if (stringArray[n2].equals("-var")) {
                n5 = false;
                ArrayList<String> qName = new ArrayList<String>();
                string6 = 1;
                while (!((Boolean)n5).booleanValue() && n2 + string6 < stringArray.length) {
                    String staticContextBinding = stringArray[n2 + string6];
                    if (staticContextBinding.startsWith("name=") || staticContextBinding.startsWith("type=")) {
                        qName.add(staticContextBinding);
                        ++string6;
                        continue;
                    }
                    n5 = true;
                    --string6;
                }
                n2 += string6;
                StaticContextBinding n12 = CLIprocessor.parseBinding(qName);
                xStaticContext.declareVariable(n12.getName(), n12.getType());
                continue;
            }
            if (stringArray[n2].equals("-baseURI")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-baseURI"}));
                }
                xStaticContext.setBaseURI((String)n5);
                continue;
            }
            if (stringArray[n2].equals("-dnet")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-dnet"}));
                }
                xStaticContext.setDefaultElementTypeNamespace((String)n5);
                continue;
            }
            if (stringArray[n2].equals("-dnf")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-dnf"}));
                }
                xStaticContext.setDefaultFunctionNamespace((String)n5);
                continue;
            }
            if (stringArray[n2].equals("-imm")) {
                try {
                    int numberFormatException = Integer.parseInt(stringArray[++n2]);
                    xStaticContext.setIntegerMathMode(numberFormatException);
                    continue;
                }
                catch (NumberFormatException n6) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_INTEGER_VALUE", new String[]{"-imm"}));
                }
            }
            if (stringArray[n2].equals("-bsp")) {
                try {
                    int numberFormatException = Integer.parseInt(stringArray[++n2]);
                    xStaticContext.setBoundarySpacePolicy(numberFormatException);
                    continue;
                }
                catch (NumberFormatException n7) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_INTEGER_VALUE", new String[]{"-bsp"}));
                }
            }
            if (stringArray[n2].equals("-csm")) {
                try {
                    int numberFormatException = Integer.parseInt(stringArray[++n2]);
                    xStaticContext.setConstructionMode(numberFormatException);
                    continue;
                }
                catch (NumberFormatException n8) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_INTEGER_VALUE", new String[]{"-csm"}));
                }
            }
            if (stringArray[n2].equals("-cnmi")) {
                try {
                    int numberFormatException = Integer.parseInt(stringArray[++n2]);
                    xStaticContext.setCopyNamespacesModeInherit(numberFormatException);
                    continue;
                }
                catch (NumberFormatException n9) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_INTEGER_VALUE", new String[]{"-cnmi"}));
                }
            }
            if (stringArray[n2].equals("-cnmp")) {
                try {
                    int numberFormatException = Integer.parseInt(stringArray[++n2]);
                    xStaticContext.setCopyNamespacesModePreserve(numberFormatException);
                    continue;
                }
                catch (NumberFormatException n10) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_INTEGER_VALUE", new String[]{"-cnmp"}));
                }
            }
            if (stringArray[n2].equals("-eso")) {
                try {
                    int numberFormatException = Integer.parseInt(stringArray[++n2]);
                    xStaticContext.setDefaultOrderForEmptySequences(numberFormatException);
                    continue;
                }
                catch (NumberFormatException n11) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_INTEGER_VALUE", new String[]{"-eso"}));
                }
            }
            if (stringArray[n2].equals("-ordm")) {
                try {
                    int numberFormatException = Integer.parseInt(stringArray[++n2]);
                    xStaticContext.setOrderingMode(numberFormatException);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_INTEGER_VALUE", new String[]{"-ordm"}));
                }
            }
            if (stringArray[n2].equals("-i")) {
                contract.setUseStdIn(true);
                continue;
            }
            if (stringArray[n2].equals("-h")) {
                contract.setHelp(true);
                return;
            }
            if (stringArray[n2].equals("-v") || stringArray[n2].equalsIgnoreCase("-version")) {
                System.err.println(VERSION);
                continue;
            }
            if (stringArray[n2].equals("-useCompiler")) {
                contract.xStaticContext.setUseCompiler(true);
                continue;
            }
            if (stringArray[n2].equals("-input")) {
                contract.setInputFile(stringArray[++n2]);
                continue;
            }
            if (stringArray[n2].equals("-outputfile")) {
                contract.setOutputFile(stringArray[++n2]);
                continue;
            }
            if (stringArray[n2].equalsIgnoreCase("-XSLTinitMode")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-XSLTinitMode"}));
                }
                xDynamicContext.setXSLTInitialMode(CLIprocessor.parseQName((String)n5));
                continue;
            }
            if (stringArray[n2].equalsIgnoreCase("-XSLTinitTemplate")) {
                if (!CLIprocessor.checkArgValue((String)(n5 = stringArray[++n2]))) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-XSLTinitTemplate"}));
                }
                xDynamicContext.setXSLTInitialTemplate(CLIprocessor.parseQName((String)n5));
                continue;
            }
            if (stringArray[n2].equals("-bindVar")) {
                n5 = false;
                QName qName = null;
                String string2 = null;
                int n3 = 1;
                while (!((Boolean)n5).booleanValue() && n2 + n3 < stringArray.length) {
                    object2 = stringArray[n2 + n3];
                    if (((String)object2).startsWith("name=")) {
                        qName = CLIprocessor.parseQName((String)object2);
                        ++n3;
                        continue;
                    }
                    if (((String)object2).startsWith("value=")) {
                        string2 = ((String)object2).substring(((String)object2).indexOf("=") + 1);
                        ++n3;
                        continue;
                    }
                    n5 = true;
                    --n3;
                }
                n2 += n3;
                if (qName == null || string2 == null) {
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_ARG_REQUIRES_VALUE", new String[]{"-bindVar"}));
                }
                xDynamicContext.bind(qName, string2);
                continue;
            }
            throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_UNKNOWN_ARG", new String[]{stringArray[n2]}));
        }
        if (!contract.isUseStdIn()) {
            if (stringArray.length == n2) {
                throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_MISSING_INPUT_FILES", new String[0]));
            }
            while (n2 < stringArray.length) {
                contract.getExpressionFiles().add(stringArray[n2]);
                ++n2;
            }
        }
        if (LoggerUtil.isFineLoggable(logger)) {
            logger.logp(Level.FINE, cn, "parseArgs", "Argument parsing complete");
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                cliLevelLogger.setLevel(Level.SEVERE);
                return null;
            }
        });
    }
}

