/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cast;

import com.ibm.xml.jaxp.datatype.Duration2;
import com.ibm.xml.jaxp.datatype.XMLGregorianCalendar2;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CastJV2String {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final DecimalFormat DEC_NOTATION;
    private static final DecimalFormat FORMAT_SCIENTIFIC;

    public static String jVToString(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string2 = Integer.toString(n2);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(long l, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string2 = Long.toString(l);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) throws InvalidDatatypeValueException {
        String string2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string3 = string2 = bl ? "true" : "false";
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(BigInteger bigInteger, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string2 = bigInteger.toString();
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        double d2 = StrictMath.abs(d);
        String string2 = d == Double.POSITIVE_INFINITY ? "INF" : (d == Double.NEGATIVE_INFINITY ? "-INF" : (Double.isNaN(d) ? "NaN" : (d == 0.0 ? (Double.doubleToLongBits(d) == 0L ? "0" : "-0") : (d2 >= 1.0E-6 && d2 < 1000000.0 ? DEC_NOTATION.format(d) : (d2 > 0.0 && d2 <= 1.0E7 ? FORMAT_SCIENTIFIC.format(d) : Double.toString(d))))));
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        String string2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string3 = string2 = bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? "0" : bigDecimal.stripTrailingZeros().toPlainString();
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(XMLGregorianCalendar xMLGregorianCalendar, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string2 = xMLGregorianCalendar instanceof XMLGregorianCalendar2 ? ((XMLGregorianCalendar2)xMLGregorianCalendar).toFOFormat() : CastJV2String.toFOFormat(xMLGregorianCalendar);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(Duration duration2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string2 = duration2 instanceof Duration2 ? ((Duration2)duration2).toFOFormat() : CastJV2String.toFOFormat(duration2);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        String string2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        float f3 = StrictMath.abs(f2);
        if (f2 == Float.POSITIVE_INFINITY) {
            string2 = "INF";
        } else if (f2 == Float.NEGATIVE_INFINITY) {
            string2 = "-INF";
        } else if (Float.isNaN(f2)) {
            string2 = "NaN";
        } else if (f2 == 0.0f) {
            String string3 = String.valueOf(f2);
            string2 = string3.substring(0, string3.indexOf("."));
        } else if (f3 >= 1.0E-6f && f3 < 1000000.0f) {
            Double d = new Double(String.valueOf(f2));
            string2 = DEC_NOTATION.format(d);
        } else if (f3 > 0.0f && f3 < 1.0E7f) {
            Double d = new Double(String.valueOf(f2));
            string2 = FORMAT_SCIENTIFIC.format(d);
        } else {
            string2 = String.valueOf(f2);
        }
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        String string2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string3 = qName.getPrefix();
        String string4 = string2 = string3 == null || "".equals(string3) ? qName.getLocalPart() : string3 + ":" + qName.getLocalPart();
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(short s, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string2 = Short.toString(s);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(byte by2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string2 = Byte.toString(by2);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(URI uRI, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        String string2 = uRI.toString();
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    public static String jVToString(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSTRING, (short)2) || xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSUNTYPEDATOMIC, (short)2));
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) || xSSimpleTypeDefinition.equals(TypeRegistry.XSUNTYPEDATOMIC)) {
            return string2;
        }
        CastUtilities.validate(string2, xSSimpleTypeDefinition);
        return string2;
    }

    private static int maxDayInMonthFor(int n2, int n3) {
        if (n3 == 4 || n3 == 6 || n3 == 9 || n3 == 11) {
            return 30;
        }
        if (n3 == 2) {
            if (CastJV2String.isLeapYear(n2)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    private static String toFOFormat(XMLGregorianCalendar xMLGregorianCalendar) {
        String string2;
        short s = CastUtilities.getCalendarType(xMLGregorianCalendar).getBuiltInKind();
        switch (s) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                try {
                    string2 = xMLGregorianCalendar.toString();
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{CastUtilities.typeString(s), "xs:string"});
                }
            }
            case 8: 
            case 9: {
                try {
                    String string3;
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    String string7 = "";
                    int n2 = xMLGregorianCalendar.getTimezone();
                    if (n2 != Integer.MIN_VALUE) {
                        if (n2 == 0) {
                            string7 = "Z";
                        } else {
                            String string8 = CastUtilities.padToTwoDigitString(Math.abs(n2) / 60);
                            string3 = CastUtilities.padToTwoDigitString(Math.abs(n2) % 60);
                            string7 = (n2 < 0 ? "-" : "+") + string8 + ":" + string3;
                        }
                    }
                    int n3 = xMLGregorianCalendar.getHour();
                    if (s == 10 || s == 8) {
                        int n4 = xMLGregorianCalendar.getYear();
                        int n5 = xMLGregorianCalendar.getMonth();
                        int n6 = xMLGregorianCalendar.getDay();
                        if (n3 == 24) {
                            n3 = 0;
                            if (++n6 > CastJV2String.maxDayInMonthFor(n4, n5)) {
                                n6 = 1;
                                if (++n5 > 12) {
                                    n5 = 1;
                                    if (++n4 == 0) {
                                        n4 = 1;
                                    }
                                }
                            }
                        }
                        string4 = CastUtilities.padToFourDigitString(n4);
                        string5 = CastUtilities.padToTwoDigitString(n5);
                        string6 = CastUtilities.padToTwoDigitString(n6);
                        if (s == 10) {
                            string2 = string4 + "-" + string5 + "-" + string6 + string7;
                            break;
                        }
                    }
                    string3 = n3 == 24 ? "00" : CastUtilities.padToTwoDigitString(n3);
                    String string9 = CastUtilities.padToTwoDigitString(xMLGregorianCalendar.getMinute());
                    String string10 = "";
                    DecimalFormat decimalFormat = new DecimalFormat("00.###", new DecimalFormatSymbols(Locale.ENGLISH));
                    string10 = xMLGregorianCalendar.getMillisecond() != Integer.MIN_VALUE ? decimalFormat.format((double)xMLGregorianCalendar.getSecond() + (double)xMLGregorianCalendar.getMillisecond() / 1000.0) : decimalFormat.format(xMLGregorianCalendar.getSecond());
                    if (s == 9) {
                        string2 = string3 + ":" + string9 + ":" + string10 + string7;
                        break;
                    }
                    string2 = string4 + "-" + string5 + "-" + string6 + "T" + string3 + ":" + string9 + ":" + string10 + string7;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{CastUtilities.typeString(s), "xs:string"});
                }
            }
            case 15: {
                try {
                    String string11 = "";
                    int n7 = xMLGregorianCalendar.getTimezone();
                    if (n7 != Integer.MIN_VALUE) {
                        if (n7 == 0) {
                            string11 = "Z";
                        } else {
                            String string12 = CastUtilities.padToTwoDigitString(Math.abs(n7) / 60);
                            String string13 = CastUtilities.padToTwoDigitString(Math.abs(n7) % 60);
                            string11 = (n7 < 0 ? "-" : "+") + string12 + ":" + string13;
                        }
                    }
                    string2 = "--" + CastUtilities.padToTwoDigitString(xMLGregorianCalendar.getMonth()) + string11;
                    break;
                }
                catch (Exception exception) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{CastUtilities.typeString(s), "xs:string"});
                }
            }
            default: {
                throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{CastUtilities.typeString(s), "xs:string"});
            }
        }
        return string2;
    }

    private static String toFOFormat(Duration duration2) {
        String string2;
        int n2;
        int n3;
        int n4 = duration2.getSign();
        if (n4 == 0) {
            if (!(duration2.isSet(DatatypeConstants.SECONDS) || duration2.isSet(DatatypeConstants.MINUTES) || duration2.isSet(DatatypeConstants.HOURS) || duration2.isSet(DatatypeConstants.DAYS))) {
                return "P0M";
            }
            return "PT0S";
        }
        int n5 = duration2.getSeconds() + duration2.getMinutes() * 60 + duration2.getHours() * 3600;
        int n6 = duration2.getDays();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (n5 != 0) {
            n6 += n5 / 86400;
            n3 = n5 % 86400;
            n7 = n3 / 3600;
            n8 = (n3 %= 3600) / 60;
            n9 = n3 %= 60;
        }
        n3 = duration2.getMonths() + duration2.getYears() * 12;
        int n10 = 0;
        int n11 = 0;
        if (n3 != 0) {
            n10 = n3 / 12;
            n11 = n3 % 12;
        }
        BigDecimal bigDecimal = (BigDecimal)duration2.getField(DatatypeConstants.SECONDS);
        String string3 = "";
        if (null != bigDecimal && bigDecimal != new BigDecimal(0) && (n2 = (string2 = bigDecimal.toPlainString()).indexOf(46)) >= 0) {
            string3 = string2.substring(n2, string2.length());
        }
        if (string3.equals(".000") || string3.equals(".00") || string3.equals(".0")) {
            string3 = "";
        } else if (string3.length() == 4 && string3.indexOf("00") == 2) {
            string3 = string3.substring(0, 2);
        } else if (string3.length() == 4 && string3.charAt(3) == '0') {
            string3 = string3.substring(0, 3);
        } else if (string3.length() == 3 && string3.charAt(2) == '0') {
            string3 = string3.substring(0, 2);
        }
        string2 = (n4 < 0 ? "-" : "") + "P";
        String string4 = n3 != 0 ? (n10 != 0 ? n10 + "Y" : "") + (n11 != 0 ? n11 + "M" : "") : "";
        String string5 = n6 != 0 ? n6 + "D" : "";
        String string6 = "";
        if (n5 % 86400 != 0) {
            string6 = n9 == 0 && string3.length() == 0 ? "T" + (n7 != 0 ? n7 + "H" : "") + (n8 != 0 ? n8 + "M" : "") : "T" + (n7 != 0 ? n7 + "H" : "") + (n8 != 0 ? n8 + "M" : "") + (n9 != 0 ? n9 + string3 + "S" : "0" + string3 + "S");
        } else if (string3.length() != 0) {
            string6 = "T0" + string3 + "S";
        }
        return string2 + string4 + string5 + string6;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        DEC_NOTATION = new DecimalFormat("0.####################", decimalFormatSymbols);
        FORMAT_SCIENTIFIC = new DecimalFormat("0.0#################E0", decimalFormatSymbols);
    }
}

