/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cast;

import com.ibm.xml.jaxp.datatype.Duration2;
import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSDateTime;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;

public class CastJV2Duration {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static Duration getDuration(String string2) {
        return CastUtilities.javaxFactory.newDuration(string2);
    }

    public static Duration jVToDuration(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSDURATION, (short)2));
        return ((XSDateTime)CastUtilities.validate(string2, xSSimpleTypeDefinition)).getDuration();
    }

    public static Duration jVToDuration(Duration duration2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSDURATION, (short)2));
        if (!bl) {
            switch (xSSimpleTypeDefinition.getBuiltInKind()) {
                case 46: {
                    if (duration2 instanceof Duration2) {
                        return ((Duration2)duration2).asDurationYearMonth();
                    }
                    return CastJV2Duration.asDurationYearMonth(duration2);
                }
                case 47: {
                    if (duration2 instanceof Duration2) {
                        return ((Duration2)duration2).asDurationDayTime();
                    }
                    return CastJV2Duration.asDurationDayTime(duration2);
                }
            }
            return duration2;
        }
        return ((XSDateTime)CastUtilities.validate(duration2.toString(), xSSimpleTypeDefinition)).getDuration();
    }

    private static Duration asDurationYearMonth(Duration duration2) {
        int n2;
        int n3 = duration2.isSet(DatatypeConstants.YEARS) ? duration2.getYears() : Integer.MIN_VALUE;
        int n4 = n2 = duration2.isSet(DatatypeConstants.MONTHS) ? duration2.getMonths() : Integer.MIN_VALUE;
        if (n3 == Integer.MIN_VALUE && n2 == Integer.MIN_VALUE) {
            return CastUtilities.javaxFactory.newDurationYearMonth(true, Integer.MIN_VALUE, 0);
        }
        return CastUtilities.javaxFactory.newDurationYearMonth(duration2.getSign() >= 0, duration2.isSet(DatatypeConstants.YEARS) ? duration2.getYears() : Integer.MIN_VALUE, duration2.isSet(DatatypeConstants.MONTHS) ? duration2.getMonths() : Integer.MIN_VALUE);
    }

    private static Duration asDurationDayTime(Duration duration2) {
        Object object2;
        int n2;
        BigDecimal bigDecimal = (BigDecimal)duration2.getField(DatatypeConstants.SECONDS);
        String string2 = "0";
        if (null != bigDecimal && bigDecimal != new BigDecimal(0) && (n2 = ((String)(object2 = bigDecimal.toPlainString())).indexOf(46)) >= 0) {
            string2 = ((String)object2).substring(n2 + 1, ((String)object2).length());
            while (string2.length() < 3) {
                string2 = string2 + "0";
            }
        }
        if (((BigInteger)(object2 = new BigInteger(string2))).compareTo(BigInteger.ZERO) != 0) {
            BigInteger bigInteger = BigInteger.valueOf(duration2.getSeconds());
            bigInteger = bigInteger.add(BigInteger.valueOf(duration2.getMinutes() * 60));
            bigInteger = bigInteger.add(BigInteger.valueOf(duration2.getHours() * 3600));
            bigInteger = bigInteger.add(BigInteger.valueOf(86400 * duration2.getDays()));
            bigInteger = bigInteger.multiply(BigInteger.valueOf(1000L));
            object2 = ((BigInteger)object2).add(bigInteger);
            if (duration2.getSign() < 0) {
                object2 = ((BigInteger)object2).negate();
            }
            return CastUtilities.javaxFactory.newDurationDayTime(((BigInteger)object2).longValue());
        }
        if (!(duration2.isSet(DatatypeConstants.DAYS) || duration2.isSet(DatatypeConstants.HOURS) || duration2.isSet(DatatypeConstants.MINUTES) || duration2.isSet(DatatypeConstants.SECONDS))) {
            return CastUtilities.javaxFactory.newDurationDayTime(true, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0);
        }
        return CastUtilities.javaxFactory.newDurationDayTime(duration2.getSign() >= 0, duration2.isSet(DatatypeConstants.DAYS) ? duration2.getDays() : Integer.MIN_VALUE, duration2.isSet(DatatypeConstants.HOURS) ? duration2.getHours() : Integer.MIN_VALUE, duration2.isSet(DatatypeConstants.MINUTES) ? duration2.getMinutes() : Integer.MIN_VALUE, duration2.isSet(DatatypeConstants.SECONDS) ? duration2.getSeconds() : Integer.MIN_VALUE);
    }
}

