/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.values.chars.ByteEncodedChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.dp.values.chars.CharsReader;
import com.ibm.xml.xci.dp.values.chars.EncodedChars;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class CharsetEncodedChars
extends CharsBase
implements EncodedChars {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Bytes bytes;
    private ByteBuffer buffer;
    private final CharsetDecoder decoder;
    private int currentIndex = 0;
    private int length;

    public static EncodedChars make(ByteBuffer byteBuffer, ByteOrder byteOrder, Charset charset) {
        if (charset == null) {
            return new ByteEncodedChars(BytesUtils.make(byteBuffer));
        }
        return new CharsetEncodedChars(byteBuffer, byteOrder, charset.newDecoder());
    }

    public static EncodedChars make(Bytes bytes2, ByteOrder byteOrder, Charset charset) {
        if (charset == null) {
            return new ByteEncodedChars(bytes2);
        }
        return new CharsetEncodedChars(bytes2, byteOrder, charset.newDecoder());
    }

    private CharsetEncodedChars(ByteBuffer byteBuffer, ByteOrder byteOrder, CharsetDecoder charsetDecoder) {
        this.buffer = byteBuffer.slice();
        if (byteOrder != null) {
            this.toByteBuffer().order(byteOrder);
        }
        this.decoder = charsetDecoder;
        this.length = -1;
    }

    private CharsetEncodedChars(Bytes bytes2, ByteOrder byteOrder, CharsetDecoder charsetDecoder) {
        this.bytes = bytes2;
        this.decoder = charsetDecoder;
        this.length = -1;
    }

    public ByteBuffer toByteBuffer() {
        if (this.buffer == null) {
            assert (this.bytes != null) : "Cannot create buffer from null bytes...?";
            this.buffer = this.bytes.toByteBuffer(false).slice();
        }
        return this.buffer;
    }

    public Bytes toBytes() {
        if (this.bytes == null) {
            assert (this.buffer != null) : "Cannot create bytes from null buffer...?";
            this.bytes = BytesUtils.make(this.buffer);
        }
        return this.bytes;
    }

    void move(int n2) {
        if (!this.hasCharAt(n2) || this.length >= 0 && n2 >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 < this.currentIndex) {
            this.currentIndex = 0;
            this.toByteBuffer().position(0);
        }
        while (this.currentIndex < n2) {
            CharsetEncodedChars.getCharacter(this.toByteBuffer(), this.decoder);
            ++this.currentIndex;
        }
    }

    char advance() {
        char c = CharsetEncodedChars.getCharacter(this.toByteBuffer(), this.decoder);
        ++this.currentIndex;
        if (this.length < 0 && !this.toByteBuffer().hasRemaining()) {
            this.length = this.currentIndex;
        }
        return c;
    }

    public boolean hasCharAt(int n2) {
        int n3;
        if (n2 < 0) {
            return false;
        }
        if (this.length >= 0) {
            return n2 < this.length;
        }
        int n4 = this.toByteBuffer().position();
        for (n3 = this.currentIndex; n3 < n2 && this.toByteBuffer().hasRemaining(); ++n3) {
            CharsetEncodedChars.getCharacter(this.toByteBuffer(), this.decoder);
        }
        if (!this.toByteBuffer().hasRemaining()) {
            this.length = n3;
            this.toByteBuffer().position(n4);
            return false;
        }
        this.currentIndex = n3;
        return true;
    }

    public int byteOffset(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_INDEX_SIZE", null));
        }
        if (!this.hasCharAt(n2) && n2 != this.length) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_INDEX_SIZE", null));
        }
        if (n2 < this.currentIndex) {
            this.currentIndex = 0;
            this.toByteBuffer().position(0);
        }
        while (this.currentIndex < n2) {
            CharsetEncodedChars.getCharacter(this.toByteBuffer(), this.decoder);
            ++this.currentIndex;
        }
        return this.toByteBuffer().position();
    }

    public CharSequence subSequence(int n2) {
        if (!this.hasCharAt(n2)) {
            if (n2 == this.length) {
                return "";
            }
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_INDEX_SIZE", null));
        }
        return new SemiSubEncodedCharSequence(this, n2);
    }

    public Reader toReader(boolean bl) {
        return new CharsReader(this);
    }

    public Bytes toEncodedBytes(String string2) {
        if (string2.equals(this.decoder.charset().name())) {
            return this.toBytes();
        }
        return super.toEncodedBytes(string2);
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        int n2 = 0;
        while (this.hasCharAt(n2)) {
            writer.write(this.charAt(n2));
            ++n2;
        }
        return n2;
    }

    public void writeEncodedBytesTo(OutputStream outputStream, Charset charset, boolean bl) throws IOException {
        if (charset == this.decoder.charset()) {
            this.toBytes().writeBytesTo(outputStream, false);
        } else {
            super.writeEncodedBytesTo(outputStream, charset, bl);
        }
    }

    public boolean isConstant() {
        return true;
    }

    public Chars constant(boolean bl) {
        return this;
    }

    public char charAt(int n2) {
        this.move(n2);
        return this.advance();
    }

    public int length() {
        if (this.length < 0) {
            int n2 = this.toByteBuffer().position();
            int n3 = this.currentIndex;
            while (this.toByteBuffer().hasRemaining()) {
                ++n3;
                CharsetEncodedChars.getCharacter(this.toByteBuffer(), this.decoder);
            }
            this.length = n3;
            this.toByteBuffer().position(n2);
        }
        return this.length;
    }

    public CharSequence subSequence(int n2, int n3) {
        if (n2 == n3) {
            return "";
        }
        return new SubEncodedCharSequence(this, n2, n3);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (this.hasCharAt(n2)) {
            stringBuilder.append(this.charAt(n2));
            ++n2;
        }
        return stringBuilder.toString();
    }

    static char getCharacter(ByteBuffer byteBuffer, CharsetDecoder charsetDecoder) {
        char c;
        if (!byteBuffer.hasRemaining()) {
            throw new IndexOutOfBoundsException("Buffer has no position after " + byteBuffer.position());
        }
        if (charsetDecoder == null) {
            int n2 = CharsetEncodedChars.getByte(byteBuffer);
            c = (char)(n2 >= 0 ? n2 : n2 + 256);
            System.out.println("Buffer byte #" + byteBuffer.position() + " exported as character.");
        } else {
            CharBuffer charBuffer = CharBuffer.allocate(1);
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (coderResult.isError() || charBuffer.position() == 0) {
                throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_UNICODE_DECODER", new String[]{charsetDecoder.charset().displayName(), coderResult.toString()}));
            }
            charBuffer.position(0);
            c = charBuffer.charAt(0);
        }
        return c;
    }

    static byte getByte(ByteBuffer byteBuffer) {
        return byteBuffer.get();
    }

    public CharSequence lexicalValue() {
        return this.toString();
    }

    private static class SubEncodedCharSequence
    implements CharSequence {
        private CharsetEncodedChars base;
        private int offset;
        private int length;

        private SubEncodedCharSequence(CharsetEncodedChars charsetEncodedChars, int n2, int n3) {
            assert (n2 >= 0 && n2 < n3) : "SubEncodedCharSequence only for nonempty subsequences.";
            this.base = charsetEncodedChars;
            this.offset = n2;
            this.length = n3 - n2;
        }

        public int length() {
            return this.length;
        }

        public char charAt(int n2) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("No " + n2 + (n2 % 10 == 1 ? "st" : (n2 % 10 == 2 ? "nd" : "rd")) + " character in sequence.");
            }
            return this.base.charAt(this.offset + n2);
        }

        public CharSequence subSequence(int n2, int n3) {
            if (n2 == n3) {
                return "";
            }
            return new SubEncodedCharSequence(this.base, this.offset + n2, this.offset + n3);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.length(); ++i) {
                stringBuilder.append(this.charAt(i));
            }
            return stringBuilder.toString();
        }
    }

    private static class SemiSubEncodedCharSequence
    implements CharSequence {
        private CharsetEncodedChars base;
        private int offset;

        private SemiSubEncodedCharSequence(CharsetEncodedChars charsetEncodedChars, int n2) {
            assert (n2 >= 0 && charsetEncodedChars.hasCharAt(n2)) : "Malformed subSequence (negative or overshot start).";
            this.base = charsetEncodedChars;
            this.offset = n2;
        }

        public int length() {
            int n2 = this.base.length() - this.offset;
            return n2 < 0 ? 0 : n2;
        }

        public char charAt(int n2) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_INDEX_SIZE", null));
            }
            return this.base.charAt(this.offset + n2);
        }

        public CharSequence subSequence(int n2, int n3) {
            if (n2 == n3) {
                return "";
            }
            return new SubEncodedCharSequence(this.base, this.offset + n2, this.offset + n3);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.length(); ++i) {
                stringBuilder.append(this.charAt(i));
            }
            return stringBuilder.toString();
        }
    }
}

