/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.values.chars.CharArrayChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class CharBufferChars
extends CharsBase
implements Chars {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private CharBuffer buffer;

    public static Chars make(CharSequence charSequence) {
        if (charSequence instanceof Chars) {
            return (Chars)charSequence;
        }
        if (charSequence instanceof String) {
            return new StringChars((String)charSequence);
        }
        return new CharBufferChars(CharBuffer.wrap(charSequence));
    }

    public static Chars make(char[] cArray) {
        return new CharArrayChars(cArray);
    }

    public static Chars make(Bytes bytes2, Charset charset) {
        return new CharBufferChars(charset.decode(bytes2.toByteBuffer(false)));
    }

    private CharBufferChars(CharBuffer charBuffer) {
        this.buffer = charBuffer.slice();
    }

    private CharBufferChars(char[] cArray) {
        this.buffer = CharBuffer.wrap(cArray);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public boolean hasCharAt(int n2) {
        return 0 <= n2 && n2 < this.buffer.length();
    }

    public CharSequence subSequence(int n2) {
        return this.buffer.subSequence(n2, this.length());
    }

    public char[] toCharArray() {
        if (this.buffer.hasArray() && this.buffer.arrayOffset() == 0) {
            return this.buffer.array();
        }
        char[] cArray = new char[this.length()];
        this.buffer.get(cArray);
        this.buffer.rewind();
        return cArray;
    }

    public int toCharArray(char[] cArray, int n2) {
        int n3 = this.length();
        this.buffer.get(cArray, n2, n3);
        this.buffer.rewind();
        return n3;
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        int n2 = this.length();
        for (int i = 0; i < n2; ++i) {
            writer.write(this.charAt(i));
        }
        if (bl) {
            this.buffer = null;
        }
        return n2;
    }

    public int length() {
        return this.buffer.length();
    }

    public char charAt(int n2) {
        return this.buffer.get(n2);
    }

    public CharSequence subSequence(int n2, int n3) {
        return this.buffer.subSequence(n2, n3);
    }

    public CharSequence lexicalValue() {
        return this.buffer;
    }

    public Chars constant(boolean bl) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }
}

