/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.dp.values.chars.EncodedChars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;

class ByteEncodedChars
extends CharsBase
implements EncodedChars {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Bytes buffer;

    ByteEncodedChars(Bytes bytes2) {
        this.buffer = bytes2;
    }

    public int byteOffset(int n2) {
        return n2;
    }

    public boolean hasCharAt(int n2) {
        return this.buffer.hasByteAt(n2);
    }

    public CharSequence subSequence(int n2) {
        return new ByteEncodedChars(this.buffer.byteSubSequence(n2));
    }

    public int length() {
        return (int)this.buffer.byteLength();
    }

    public char charAt(int n2) {
        return (char)this.buffer.byteAt(n2);
    }

    public CharSequence subSequence(int n2, int n3) {
        return new ByteEncodedChars(this.buffer.byteSubSequence(n2, n3));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            stringBuilder.append(this.charAt(i));
        }
        return stringBuilder.toString();
    }

    public char[] toCharArray() {
        return this.toString().toCharArray();
    }

    public Bytes toEncodedBytes(String string2) {
        try {
            return BytesUtils.make(StringChars.toString(this.lexicalValue()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        writer.write(this.toString());
        return this.length();
    }

    public void writeEncodedBytesTo(OutputStream outputStream, Charset charset, boolean bl) throws IOException {
        this.toEncodedBytes(UTF8.name()).writeBytesTo(outputStream, false);
    }

    public CharSequence lexicalValue() {
        return new ByteEncodedChars(this.buffer);
    }
}

