/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.values.CDataListBase;
import com.ibm.xml.xci.internal.values.CharsCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class ArrayCData
extends CDataListBase {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CData[] atom;
    protected String string;

    public ArrayCData(CData[] cDataArray, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        if (cDataArray != null) {
            this.setArray(cDataArray);
        }
    }

    public ArrayCData(ArrayCData arrayCData, boolean bl) {
        super(arrayCData.getXSTypeDefinition());
        if (bl) {
            int n2 = arrayCData.getSize();
            this.atom = new CData[n2];
            arrayCData.arrayCopy(0, this.atom, 0, n2);
        } else {
            this.setArray(arrayCData.atom);
        }
    }

    protected ArrayCData(CData cData, int n2, int n3, int n4, int n5) {
        super(cData.getXSTypeDefinition());
        assert (n2 < n4) : "Only construct subarray for non-trivial subsequences.";
        XSSimpleTypeDefinition xSSimpleTypeDefinition = this.getXSTypeDefinition();
        this.atom = new CData[n4 - n2 + 1];
        this.atom[0] = n3 == 0 ? cData.itemAt(n2) : CharsCData.toCData(cData.itemAt(n2).subSequence(n3), xSSimpleTypeDefinition);
        for (int i = n2 + 1; i < n4; ++i) {
            this.atom[i - n2] = cData.itemAt(i);
        }
        this.atom[n4 - n2] = n5 < 0 || !this.itemAt(n4).hasCharAt(n5) ? cData.itemAt(n4) : CharsCData.toCData(cData.itemAt(n4).subSequence(0, n5), xSSimpleTypeDefinition);
    }

    protected void setArray(CData[] cDataArray) {
        this.string = cDataArray.length == 0 ? "" : null;
        this.atom = cDataArray;
    }

    public void arrayCopy(int n2, CData[] cDataArray, int n3, int n4) {
        System.arraycopy(this.atom, n2, cDataArray, n3, n4);
    }

    public int getSize() {
        return this.atom.length;
    }

    public CData itemAt(int n2) {
        try {
            return this.atom[n2 - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE", new String[]{String.valueOf(n2), String.valueOf(this.getSize())}));
        }
    }

    public String getString(int n2) {
        return this.itemAt(n2).getString(1);
    }

    public int length() {
        if (this.string != null) {
            return this.string.length();
        }
        int n2 = 0;
        for (int i = 1; i <= this.getSize(); ++i) {
            n2 += (i > 1 ? 1 : 0) + this.itemAt(i).length();
        }
        return n2;
    }

    public char charAt(int n2) {
        if (this.string != null) {
            return this.string.charAt(n2);
        }
        if (n2 >= 0) {
            int n3 = this.getSize();
            int n4 = 0;
            for (int i = 1; i <= n3; ++i) {
                int n5 = n2 - n4;
                if (this.itemAt(i).hasCharAt(n5)) {
                    return this.itemAt(i).charAt(n5);
                }
                if (i >= n3) continue;
                int n6 = this.itemAt(i).length();
                if (n5 == n6) {
                    return ' ';
                }
                n4 += 1 + this.itemAt(i).length();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public CharSequence subSequence(int n2, int n3) {
        if (this.string != null) {
            return this.string.subSequence(n2, n3);
        }
        if (n2 >= 0) {
            int n4 = 0;
            for (int i = 1; i <= this.getSize(); ++i) {
                CData cData = this.itemAt(i);
                int n5 = n4;
                if (n2 >= (n4 += (i > 0 ? 1 : 0) + cData.length())) continue;
                if (i == this.getSize() || n3 < n4) {
                    return cData.subSequence(n2 - n5, n3 - n5);
                }
                return super.subSequence(n2, n3);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        writer.write(this.toString());
        return this.toString().length();
    }

    public boolean isEmpty() {
        return this.getSize() == 0 || this.getSize() == 1 && this.itemAt(1).isEmpty();
    }

    public boolean hasCharAt(int n2) {
        if (n2 < 0) {
            return false;
        }
        if (this.string != null) {
            return n2 < this.string.length();
        }
        int n3 = 0;
        for (int i = 1; i <= this.getSize(); ++i) {
            if (this.itemAt(i).hasCharAt(n2 - n3)) {
                return true;
            }
            n3 += (i > 0 ? 1 : 0) + this.itemAt(i).length();
        }
        return false;
    }

    public CharSequence subSequence(int n2) {
        if (this.string != null) {
            return this.string.subSequence(n2, this.string.length());
        }
        if (n2 >= 0) {
            int n3 = 0;
            for (int i = 1; i <= this.getSize(); ++i) {
                CData cData = this.itemAt(i);
                int n4 = n3;
                if (n2 >= (n3 += (i > 0 ? 1 : 0) + cData.length())) continue;
                if (i == this.getSize()) {
                    return cData.subSequence(n2 - n4);
                }
                return new ArrayCData(this, i, n2 - n4, this.getSize(), -1);
            }
        }
        throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_INVALIDSTARTVALUE", null));
    }

    public BigDecimal getBigDecimal(int n2) {
        return this.itemAt(n2).getBigDecimal(1);
    }

    public BigInteger getBigInteger(int n2) {
        return this.itemAt(n2).getBigInteger(1);
    }

    public boolean getBoolean(int n2) {
        return this.itemAt(n2).getBoolean(1);
    }

    public byte getByte(int n2) {
        return this.itemAt(n2).getByte(1);
    }

    public double getDouble(int n2) {
        return this.itemAt(n2).getDouble(1);
    }

    public Duration getDuration(int n2) throws ParseException {
        return this.itemAt(n2).getDuration(1);
    }

    public float getFloat(int n2) {
        return this.itemAt(n2).getFloat(1);
    }

    public Bytes getHexBinary(int n2) {
        return this.itemAt(n2).getHexBinary(1);
    }

    public int getInt(int n2) {
        return this.itemAt(n2).getInt(1);
    }

    public long getLong(int n2) {
        return this.itemAt(n2).getLong(1);
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        return this.itemAt(n2).getQName(1, namespaceContext);
    }

    public String getQNameLocalPart(int n2) {
        return this.itemAt(n2).getQNameLocalPart(1);
    }

    public String getQNameNamespaceURI(int n2) {
        return this.itemAt(n2).getQNameNamespaceURI(1);
    }

    public String getQNamePrefix(int n2) {
        return this.itemAt(n2).getQNamePrefix(1);
    }

    public short getShort(int n2) {
        return this.itemAt(n2).getShort(1);
    }

    public URI getURI(int n2) throws URISyntaxException {
        return this.itemAt(n2).getURI(1);
    }

    public String getURIString(int n2) {
        return this.itemAt(n2).getURIString(1);
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        return this.itemAt(n2).getXMLGregorianCalendar(1);
    }

    public Object getObject(int n2) {
        return this.itemAt(n2).getObject(1);
    }

    public XSSimpleTypeDefinition getXSTypeDefinition(int n2) {
        return this.itemAt(n2).getXSTypeDefinition();
    }
}

