/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.mutate;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.mutate.CursorState;
import com.ibm.xml.xci.dp.util.mutate.Item;
import com.ibm.xml.xci.dp.util.mutate.MutationFixer;
import com.ibm.xml.xci.dp.util.mutate.OrdinalDecimal;
import com.ibm.xml.xci.dp.util.mutate.change.ChangeRecord;
import com.ibm.xml.xci.dp.util.mutate.change.ItemChange;
import com.ibm.xml.xci.util.SimpleNameTest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CursorStateChildSequence
implements CursorState {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private MutationFixer cursor;
    private Item parentElement;
    private ChangeRecord changes;
    private List<Item> beforeList = new ArrayList<Item>();
    private List<Item> afterList = new ArrayList<Item>();
    private Item current;
    private NodeTest filter;

    public CursorStateChildSequence(MutationFixer mutationFixer, Item item2, ChangeRecord changeRecord, NodeTest nodeTest) {
        this.cursor = mutationFixer;
        this.parentElement = item2;
        this.changes = changeRecord;
        this.filter = nodeTest;
        this.populateList(this.afterList, this.beforeList);
        this.toNext();
    }

    private CursorStateChildSequence(CursorStateChildSequence cursorStateChildSequence) {
        this.cursor = cursorStateChildSequence.cursor;
        this.parentElement = cursorStateChildSequence.parentElement;
        this.changes = cursorStateChildSequence.changes;
        this.filter = cursorStateChildSequence.filter;
        this.current = cursorStateChildSequence.current;
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.changes.addAttribute(this.current, volatileCData, volatileCData2);
    }

    @Override
    public Item currentItem() {
        return this.current;
    }

    @Override
    public boolean removeAttribute(VolatileCData volatileCData) {
        NodeTest nodeTest = SimpleNameTest.attribute(volatileCData);
        Cursor cursor2 = this.cursor.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        boolean bl = this.changes.removeAttribute(this.current, volatileCData, cursor2.toAttributes(nodeTest));
        cursor2.release();
        return bl;
    }

    private void populateList(List<Item> list, List<Item> list2) {
        list.clear();
        List<Item> list3 = this.parentElement.getChildren(this.filter);
        OrdinalDecimal ordinalDecimal = new OrdinalDecimal();
        for (Item object2 : list3) {
            object2.setLocation(ordinalDecimal);
            if (this.changes.isRemovedChild(this.parentElement, object2)) continue;
            if (this.getSameFromList(list2, object2) == null) {
                list.add(object2);
            }
            ordinalDecimal = ordinalDecimal.after();
        }
        List<ItemChange> list4 = this.changes.getAddedItems(this.parentElement);
        if (list4 != null) {
            for (ItemChange itemChange : list4) {
                Item item2 = itemChange.getItem();
                if (this.getSameFromList(list2, item2) != null) continue;
                ordinalDecimal = item2.getLocation();
                boolean bl = false;
                int n2 = 0;
                while (!bl && n2 < list.size()) {
                    Item item3 = list.get(n2);
                    OrdinalDecimal ordinalDecimal2 = item3.getLocation();
                    bl = ordinalDecimal.compareTo(ordinalDecimal2) < 0;
                    if (bl) continue;
                    ++n2;
                }
                if (n2 < list.size()) {
                    list.add(n2, item2);
                    continue;
                }
                list.add(item2);
            }
        }
    }

    private Item getSameFromList(List<Item> list, Item item2) {
        Item item3 = null;
        Iterator<Item> iterator = list.iterator();
        while (iterator.hasNext() && item3 == null) {
            Item item4 = iterator.next();
            if (!item4.itemIsSameNode(item2) || this.changes.isRemovedChild(this.parentElement, item4)) continue;
            item3 = item4;
        }
        return item3;
    }

    private synchronized int getNextFromList(List<Item> list, boolean bl) {
        int n2 = -1;
        int n3 = list.size();
        for (int i = 0; n2 < 0 && i < n3; ++i) {
            int n4 = bl ? n3 - i - 1 : i;
            Item item2 = list.get(n4);
            if (this.changes.isRemovedChild(this.parentElement, item2)) continue;
            n2 = n4;
        }
        return n2;
    }

    @Override
    public boolean toNext() {
        int n2;
        if (this.current != null) {
            this.beforeList.add(this.current);
        }
        if ((n2 = this.getNextFromList(this.afterList, false)) < 0) {
            this.populateList(this.afterList, this.beforeList);
            n2 = this.getNextFromList(this.afterList, false);
        }
        if (0 <= n2) {
            this.current = this.afterList.get(n2);
            this.afterList.remove(n2);
        } else if (this.current != null) {
            this.beforeList.remove(this.current);
        }
        return 0 <= n2;
    }

    @Override
    public boolean toPrevious() {
        int n2 = this.getNextFromList(this.beforeList, true);
        if (n2 < 0) {
            this.populateList(this.beforeList, this.afterList);
            n2 = this.getNextFromList(this.beforeList, true);
        }
        if (0 <= n2) {
            if (this.current != null) {
                this.afterList.add(this.current);
            }
            this.current = this.beforeList.get(n2);
            this.beforeList.remove(n2);
        }
        return 0 <= n2;
    }

    @Override
    public long contextSize() {
        return this.current != null ? (long)(this.afterList.size() + this.beforeList.size() + 1) : 0L;
    }

    @Override
    public CursorState copy() {
        return new CursorStateChildSequence(this);
    }

    @Override
    public Item parentItem() {
        return this.parentElement;
    }

    public String toString() {
        return "CursorStateChildSequence:" + this.current == null ? "empty" : this.current.toString();
    }
}

