/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.mutate;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.mutate.CursorState;
import com.ibm.xml.xci.dp.util.mutate.Item;
import com.ibm.xml.xci.dp.util.mutate.ItemAttribute;
import com.ibm.xml.xci.dp.util.mutate.change.AttributeChange;
import com.ibm.xml.xci.dp.util.mutate.change.ChangeRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CursorStateAttributeSequence
implements CursorState {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Item parentElement;
    private ChangeRecord changes;
    private List<ItemAttribute> beforeList = new ArrayList<ItemAttribute>();
    private List<ItemAttribute> afterList = new ArrayList<ItemAttribute>();
    private ItemAttribute current;

    CursorStateAttributeSequence(Item item2, ChangeRecord changeRecord) {
        this.parentElement = item2;
        this.changes = changeRecord;
        this.populateList(this.afterList, this.beforeList);
        this.toNext();
    }

    private CursorStateAttributeSequence(CursorStateAttributeSequence cursorStateAttributeSequence) {
        this.parentElement = cursorStateAttributeSequence.parentElement;
        this.changes = cursorStateAttributeSequence.changes;
        this.current = cursorStateAttributeSequence.current;
    }

    private synchronized int getNextFromList(List<ItemAttribute> list, boolean bl) {
        int n2 = -1;
        int n3 = list.size();
        for (int i = 0; n2 < 0 && i < n3; ++i) {
            int n4 = bl ? n3 - i - 1 : i;
            ItemAttribute itemAttribute = list.get(n4);
            if (this.changes.isRemovedAttribute(this.parentElement, itemAttribute.itemName())) continue;
            n2 = n4;
        }
        return n2;
    }

    private synchronized ItemAttribute getNamedFromList(List<ItemAttribute> list, VolatileCData volatileCData) {
        ItemAttribute itemAttribute = null;
        Iterator<ItemAttribute> iterator = list.iterator();
        while (iterator.hasNext() && itemAttribute == null) {
            ItemAttribute itemAttribute2 = iterator.next();
            if (!itemAttribute2.itemName().equals(volatileCData)) continue;
            itemAttribute = itemAttribute2;
        }
        return itemAttribute;
    }

    private void populateList(List<ItemAttribute> list, List<ItemAttribute> list2) {
        list.clear();
        List<ItemAttribute> list3 = this.parentElement.getAttributes();
        for (ItemAttribute object2 : list3) {
            if (this.changes.isRemovedAttribute(this.parentElement, object2.itemName()) || this.getNamedFromList(list2, object2.itemName()) != null) continue;
            list.add(object2);
        }
        List<AttributeChange> list4 = this.changes.getAddedAttributes(this.parentElement);
        if (list4 != null) {
            for (AttributeChange attributeChange : list4) {
                if (this.getNamedFromList(list2, attributeChange.itemName()) != null) continue;
                list.add(new ItemAttribute(this.parentElement, attributeChange.itemName(), attributeChange.itemValue()));
            }
        }
    }

    @Override
    public boolean toNext() {
        int n2 = this.getNextFromList(this.afterList, false);
        if (n2 < 0) {
            this.populateList(this.afterList, this.beforeList);
            n2 = this.getNextFromList(this.afterList, false);
        }
        if (0 <= n2) {
            if (this.current != null) {
                this.beforeList.add(this.current);
            }
            this.current = this.afterList.get(n2);
            this.afterList.remove(n2);
        }
        return 0 <= n2;
    }

    @Override
    public boolean toPrevious() {
        int n2 = this.getNextFromList(this.beforeList, true);
        if (n2 < 0) {
            this.populateList(this.beforeList, this.afterList);
            n2 = this.getNextFromList(this.beforeList, true);
        }
        if (0 <= n2) {
            if (this.current != null) {
                this.afterList.add(this.current);
            }
            this.current = this.beforeList.get(n2);
            this.beforeList.remove(n2);
        }
        return 0 <= n2;
    }

    @Override
    public Item currentItem() {
        ItemAttribute itemAttribute = null;
        if (this.current != null && !this.changes.isRemovedAttribute(this.parentElement, this.current.itemName())) {
            itemAttribute = this.current;
        }
        return itemAttribute;
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
    }

    @Override
    public boolean removeAttribute(VolatileCData volatileCData) {
        return false;
    }

    public CursorState fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return null;
    }

    @Override
    public long contextSize() {
        return this.current != null ? (long)(this.afterList.size() + this.beforeList.size() + 1) : 0L;
    }

    @Override
    public CursorState copy() {
        return new CursorStateAttributeSequence(this);
    }

    @Override
    public Item parentItem() {
        return this.parentElement;
    }

    public String toString() {
        return "CursorStateAttributeSequence of:" + this.parentElement.toString() + ", attribute " + this.current == null ? "no attributes" : this.current.toString();
    }
}

