/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.misc;

import com.ibm.xml.xci.res.XCIMessages;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public class URIUtility {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static HashMap<String, ProtocolHandler> handlers = new HashMap();

    public static URI toURI(String string2) throws URISyntaxException {
        int n2 = string2.indexOf(":");
        if (n2 == -1) {
            throw new URISyntaxException(string2, XCIMessages.createXCIMessage("ER_URI_SYNTAX", new String[]{string2}));
        }
        String string3 = string2.substring(0, n2);
        ProtocolHandler protocolHandler = handlers.get(string3);
        return protocolHandler == null ? DefaultProtocolHandler.SINGLETON.toURI(string2) : protocolHandler.toURI(string2);
    }

    public static URI resolveURI(URI uRI, URI uRI2) {
        if (uRI2.isAbsolute()) {
            return uRI2;
        }
        String string2 = uRI.getScheme();
        ProtocolHandler protocolHandler = handlers.get(string2);
        return protocolHandler == null ? DefaultProtocolHandler.SINGLETON.resolveURI(uRI, uRI2) : protocolHandler.resolveURI(uRI, uRI2);
    }

    public static URI toURI(URL uRL) {
        String string2 = uRL.getProtocol();
        ProtocolHandler protocolHandler = handlers.get(string2);
        return protocolHandler == null ? DefaultProtocolHandler.SINGLETON.toURI(uRL) : protocolHandler.toURI(uRL);
    }

    public static URI resolveBaseURI(URI uRI) {
        String string2 = uRI.getScheme();
        ProtocolHandler protocolHandler = handlers.get(string2);
        return protocolHandler == null ? DefaultProtocolHandler.SINGLETON.resolveBaseURI(uRI) : protocolHandler.resolveBaseURI(uRI);
    }

    public static void register(String string2, ProtocolHandler protocolHandler) {
        handlers.put(string2, protocolHandler);
    }

    public static String getPathExt(URL uRL) {
        String string2 = uRL.getPath();
        if (string2 == null) {
            return null;
        }
        int n2 = string2.lastIndexOf(46);
        if (n2 == -1) {
            return null;
        }
        return string2.substring(n2 + 1);
    }

    private URIUtility() {
    }

    static {
        handlers.put("jar", JARProtocolHandler.SINGLETON);
        handlers.put("file", FileProtocolHandler.SINGLETON);
        handlers.put("wsjar", WSJarProtocolHandler.SINGLETON);
    }

    static class WSJarProtocolHandler
    extends JARProtocolHandler {
        static WSJarProtocolHandler SINGLETON = new WSJarProtocolHandler();

        WSJarProtocolHandler() {
        }

        public URI toURI(String string2) throws URISyntaxException {
            String string3 = string2.substring("wsjar:".length());
            return new URI("wsjar", string3, null);
        }
    }

    static class FileProtocolHandler
    extends DefaultProtocolHandler {
        static FileProtocolHandler SINGLETON = new FileProtocolHandler();

        FileProtocolHandler() {
        }

        public URI resolveBaseURI(URI uRI) {
            String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("user.dir");
                }
            });
            string2 = string2.replaceAll("\\\\", "/");
            uRI = URI.create("file:/" + string2 + "/" + uRI.getRawSchemeSpecificPart());
            return super.resolveBaseURI(uRI);
        }
    }

    static class JARProtocolHandler
    extends DefaultProtocolHandler {
        static JARProtocolHandler SINGLETON = new JARProtocolHandler();

        JARProtocolHandler() {
        }

        public URI resolveBaseURI(URI uRI) {
            return uRI;
        }

        public URI resolveURI(URI uRI, URI uRI2) {
            String string2 = uRI.toString();
            int n2 = string2.lastIndexOf(47);
            try {
                return new URI(string2.subSequence(0, n2 + 1) + uRI2.toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }

        public URI toURI(URL uRL) {
            String string2 = uRL.getPath();
            try {
                return new URI(uRL.getProtocol(), string2, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    static class DefaultProtocolHandler
    extends ProtocolHandler {
        static DefaultProtocolHandler SINGLETON = new DefaultProtocolHandler();

        DefaultProtocolHandler() {
        }

        public URI toURI(String string2) throws URISyntaxException {
            return new URI(string2);
        }

        public URI toURI(URL uRL) {
            try {
                return new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }

        public URI resolveBaseURI(URI uRI) {
            String string2;
            String string3 = uRI.getRawAuthority();
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = uRI.getRawPath()) == null) {
                throw new RuntimeException(XCIMessages.createXCIMessage("ER_URI_INVALID", new String[]{uRI.toString()}));
            }
            URI uRI2 = URI.create(uRI.getScheme() + ":" + string3 + string2);
            int n2 = string2.lastIndexOf("/");
            uRI = URI.create(n2 == -1 ? string2 : string2.substring(n2 + 1));
            return uRI2;
        }

        public URI resolveURI(URI uRI, URI uRI2) {
            return uRI.resolve(uRI2);
        }
    }

    public static abstract class ProtocolHandler {
        public abstract URI toURI(String var1) throws URISyntaxException;

        public abstract URI toURI(URL var1);

        public abstract URI resolveBaseURI(URI var1);

        public abstract URI resolveURI(URI var1, URI var2);
    }
}

