/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractSimpleDelegatingCursor;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamResult;

public class TraceCursor
extends AbstractSimpleDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int traceFocusCount;
    private final String prefix;
    private final boolean echo;
    private final int id;
    private final Writer writer;
    private int level;

    public TraceCursor(Cursor cursor2, String string2, boolean bl) {
        this(cursor2, string2, bl, new PrintWriter(System.out), 0);
    }

    public TraceCursor(Cursor cursor2, String string2, boolean bl, Writer writer) {
        this(cursor2, string2, bl, writer, 0);
    }

    public TraceCursor(Cursor cursor2, String string2, boolean bl, OutputStream outputStream) {
        this(cursor2, string2, bl, new OutputStreamWriter(outputStream), 0);
    }

    private TraceCursor(Cursor cursor2, String string2, boolean bl, Writer writer, int n2) {
        super(cursor2);
        this.echo = bl;
        this.prefix = string2;
        this.writer = writer;
        this.id = traceFocusCount++;
        this.level = n2;
        this.write("<init>");
    }

    protected void write(String string2) {
        try {
            this.writer.write(this.prefix);
            this.writer.write(Integer.toString(this.id));
            this.writer.write("(");
            this.writer.write(Integer.toString(this.level));
            this.writer.write(")");
            this.writer.write(".");
            this.writer.write(string2);
            if (this.echo) {
                this.writer.write(": ");
                this.writer.write(this.toString());
            }
            this.writer.flush();
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String dumpDocument() {
        Cursor cursor2 = this.getDelegate().fork(Copier.SOURCE_FEATURES.union(Cursor.Profile.TO_ROOT), true);
        cursor2.toRoot();
        StringWriter stringWriter = new StringWriter();
        Cursor cursor3 = cursor2.factory().document(new StreamResult(stringWriter), new RequestInfo(Copier.TARGET_FEATURES));
        Copier.copy(cursor2, cursor3);
        cursor2.release();
        cursor3.release();
        return stringWriter.toString();
    }

    public Cursor.Profile profile() {
        this.write("features()");
        return super.profile();
    }

    public boolean toAttributes(NodeTest nodeTest) {
        this.write("toAttributes()");
        ++this.level;
        return super.toAttributes(nodeTest);
    }

    public boolean toNamespaceDecls() {
        this.write("toNamespaceDecls()");
        ++this.level;
        return super.toNamespaceDecls();
    }

    public boolean toChildren(NodeTest nodeTest) {
        this.write("toChildren()");
        ++this.level;
        return super.toChildren(nodeTest);
    }

    public boolean toNext() {
        this.write("toNext()");
        return super.toNext();
    }

    public boolean toParent() {
        this.write("toParent()");
        --this.level;
        return super.toParent();
    }

    public boolean toPosition(long l) {
        this.write("toPosition()");
        boolean bl = super.toPosition(l);
        this.write("Current node is now " + KINDS[super.itemKind()] + "(" + super.itemName() + ")");
        return bl;
    }

    public boolean toPrevious() {
        this.write("toPrevious()");
        boolean bl = super.toPrevious();
        this.write("Current node is now " + KINDS[super.itemKind()] + "(" + super.itemName() + ")");
        return bl;
    }

    public boolean toRoot() {
        this.write("toRoot()");
        this.level = 0;
        return super.toRoot();
    }

    public boolean toSelf() {
        this.write("toSelf()");
        super.toSelf();
        return true;
    }

    public void release() {
        this.write("release()");
        super.release();
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        this.write("fork()");
        return new TraceCursor(this.getDelegate().fork(bl, profile, profile2), this.prefix, this.echo, this.writer, this.level);
    }

    public String itemBaseUri() {
        return this.itemBaseURI();
    }

    public String itemBaseURI() {
        this.write("getBaseUri()");
        return super.itemBaseURI();
    }

    public short itemKind() {
        this.write("getKind()");
        return super.itemKind();
    }

    public VolatileCData itemName() {
        VolatileCData volatileCData = super.itemName();
        this.write("getName() : " + volatileCData);
        return volatileCData;
    }

    public ExtendedNamespaceContext itemNamespaceContext() {
        this.write("getNamespaceContext()");
        return this.itemNamespaceContext(false);
    }

    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        this.write("getNamespaceContext(laxBinding)");
        return super.itemNamespaceContext(bl);
    }

    public long contextPosition() {
        this.write("getPosition()");
        return super.contextPosition();
    }

    public long contextSize() {
        this.write("getSize()");
        return super.contextSize();
    }

    public XSTypeDefinition itemXSType() {
        this.write("getType()");
        return super.itemXSType();
    }

    public XSElementDeclaration itemXSElementDeclaration() {
        this.write("itemXSElementDeclaration()");
        return super.itemXSElementDeclaration();
    }

    public XSAttributeDeclaration itemXSAttributeDeclaration() {
        this.write("itemXSAttributeDeclaration()");
        return super.itemXSAttributeDeclaration();
    }

    public QName itemTypeName() {
        this.write("getTypeName()");
        return super.itemTypeName();
    }

    public boolean itemIsID() {
        this.write("isId()");
        return super.itemIsID();
    }

    public boolean itemIsIDREFS() {
        this.write("isIdrefs()");
        return super.itemIsIDREFS();
    }

    public boolean itemIsSameDocument(Cursor cursor2) {
        this.write("isSameDocument()");
        return super.itemIsSameDocument(cursor2);
    }

    public boolean itemIsSameNode(Cursor cursor2) {
        this.write("isSameSelf()");
        return super.itemIsSameNode(cursor2);
    }

    public boolean contextIsSingleton() {
        this.write("isSingleton()");
        return super.contextIsSingleton();
    }

    public boolean isWrapped() {
        this.write("isWrapped()");
        return super.isWrapped();
    }

    public boolean openMutation(Cursor.Area area) {
        this.write("openMutation()");
        return super.openMutation(area);
    }

    public void closeMutation() {
        this.write("closeMutation()");
        super.closeMutation();
    }

    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.write("addAttribute(" + volatileCData + ",'" + volatileCData2 + "')");
        super.addAttribute(volatileCData, volatileCData2);
    }

    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        this.write("addComment(" + area.toString() + ", '" + volatileCData + "')");
        super.addComment(area, volatileCData);
    }

    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        this.write("addElement(" + area.toString() + "," + volatileCData + ")");
        super.addElement(area, volatileCData, xSTypeDefinition);
    }

    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.write("addProcessingInstruction(" + area.toString() + ", " + volatileCData + ", '" + volatileCData2 + "')");
        super.addProcessingInstruction(area, volatileCData, volatileCData2);
    }

    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        this.write("addText(" + area.toString() + ", '" + volatileCData + "')");
        super.addText(area, volatileCData);
    }

    public boolean removeAttribute(VolatileCData volatileCData) {
        this.write("removeAttribute()");
        return super.removeAttribute(volatileCData);
    }

    public boolean removeSubtree(Cursor.Area area) {
        this.write("removeNode(" + area.toString() + ")");
        return super.removeSubtree(area);
    }

    public void setItemValue(VolatileCData volatileCData) {
        this.write("setValue('" + volatileCData + "')");
        super.setItemValue(volatileCData);
    }
}

