/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToPreviousFixer
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.TO_PREVIOUS.union(Cursor.Profile.POSITION);
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_SELF);
    protected Cursor cursor;
    protected List<Cursor> previousItems;
    protected int position;

    public ToPreviousFixer(Cursor cursor2) {
        this.cursor = cursor2;
        this.previousItems = new ArrayList<Cursor>();
        this.position = 1;
    }

    protected ToPreviousFixer(Cursor cursor2, List<Cursor> list, int n2) {
        this.cursor = cursor2;
        this.previousItems = new ArrayList<Cursor>();
        for (int i = 0; i < list.size(); ++i) {
            this.previousItems.add(list.get(i).fork(false));
        }
        this.position = n2;
    }

    @Override
    protected Cursor getDelegate() {
        return this.position <= this.previousItems.size() ? this.previousItems.get(this.position - 1) : this.cursor;
    }

    @Override
    public Cursor.Profile profile() {
        return super.profile().union(FIXED_FEATURES);
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return super.futureProfile().union(FIXED_FEATURES);
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        Cursor cursor2 = this.getDelegate();
        if (!FIXED_FEATURES.containedIn(profile) && !FIXED_FEATURES.containedIn(profile2)) {
            if (bl) {
                return cursor2.fork(bl, profile, profile2);
            }
            return this.cursor.fork(bl, profile, profile2);
        }
        if (bl) {
            if (FIXED_FEATURES.containedIn(cursor2.unwrap().futureProfile())) {
                return cursor2.fork(bl, profile, profile2);
            }
            return new ToPreviousFixer(cursor2.fork(bl, profile, profile2));
        }
        return new ToPreviousFixer(this.cursor.fork(bl), this.previousItems, this.position);
    }

    @Override
    public void release() {
        for (int i = 0; i < this.previousItems.size(); ++i) {
            this.previousItems.get(i).release();
        }
        super.release();
    }

    @Override
    protected void navigate() {
        super.navigate();
        while (this.previousItems.size() > 0) {
            Cursor cursor2 = this.previousItems.remove(this.previousItems.size() - 1);
            cursor2.release();
        }
        this.position = 1;
    }

    @Override
    public long contextPosition() {
        return this.position;
    }

    @Override
    public boolean toNext() {
        if (this.position + 1 < this.previousItems.size()) {
            ++this.position;
            return true;
        }
        Cursor cursor2 = this.cursor.fork(true);
        cursor2.toSelf();
        if (this.cursor.toNext()) {
            this.previousItems.add(cursor2);
            ++this.position;
            return true;
        }
        cursor2.release();
        return false;
    }

    @Override
    public boolean toPrevious() {
        if (this.position <= 1) {
            return false;
        }
        --this.position;
        return true;
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        Cursor cursor2 = this.getDelegate();
        if (FIXED_FEATURES.containedIn(cursor2.unwrap().profile()) || FIXED_FEATURES.containedIn(cursor2.unwrap().futureProfile())) {
            return new ToPreviousFixer(this.getDelegate().documentOrder(profile, profile2, bl));
        }
        return super.documentOrder(profile, profile2, bl);
    }
}

