/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;

public class ToPositionFixer
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.TO_POSITION.union(Cursor.Profile.POSITION);
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.TO_PREVIOUS;
    protected Cursor cursor;
    protected long position;

    public ToPositionFixer(Cursor cursor2) {
        this.cursor = cursor2;
        this.position = 1L;
    }

    protected ToPositionFixer(Cursor cursor2, long l) {
        this.cursor = cursor2;
        this.position = l;
    }

    protected Cursor getDelegate() {
        return this.cursor;
    }

    public Cursor.Profile profile() {
        return super.profile().union(FIXED_FEATURES);
    }

    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    public Cursor.Profile futureProfile() {
        return super.futureProfile().union(FIXED_FEATURES);
    }

    public long contextPosition() {
        return this.position;
    }

    protected void navigate() {
        this.position = 1L;
    }

    public boolean toPosition(long l) {
        if (l == this.position) {
            return true;
        }
        if (l <= 0L) {
            return false;
        }
        long l2 = this.position;
        if (l > this.position) {
            while (this.cursor.toNext()) {
                ++this.position;
                if (l != this.position) continue;
                return true;
            }
            while (this.position != l2) {
                --this.position;
                this.cursor.toPrevious();
            }
        } else {
            while (this.cursor.toPrevious()) {
                --this.position;
                if (l != this.position) continue;
                return true;
            }
            while (this.position != l2) {
                ++this.position;
                this.cursor.toNext();
            }
        }
        return false;
    }

    public boolean toNext() {
        if (this.getDelegate().toNext()) {
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean toPrevious() {
        if (this.getDelegate().toPrevious()) {
            --this.position;
            return true;
        }
        return false;
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        Cursor cursor2 = this.getDelegate();
        if (!FIXED_FEATURES.containedIn(profile) && !FIXED_FEATURES.containedIn(profile2)) {
            if (bl) {
                return cursor2.fork(bl, profile, profile2);
            }
            return this.cursor.fork(bl, profile, profile2);
        }
        if (bl) {
            if (FIXED_FEATURES.containedIn(cursor2.unwrap().futureProfile())) {
                return cursor2.fork(bl, profile, profile2);
            }
            return new ToPositionFixer(cursor2.fork(bl, profile, profile2));
        }
        return new ToPositionFixer(this.cursor.fork(false), this.position);
    }

    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        Cursor cursor2 = this.getDelegate();
        if (FIXED_FEATURES.containedIn(cursor2.unwrap().profile()) || FIXED_FEATURES.containedIn(cursor2.unwrap().futureProfile())) {
            return new ToPositionFixer(this.getDelegate().documentOrder(profile, profile2, bl));
        }
        return super.documentOrder(profile, profile2, bl);
    }
}

