/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;

public class ToFollowingSiblingsFixer
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.TO_FOLLOWING_SIBLINGS;
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.TO_PARENT.union(Cursor.Profile.IS_SAME_NODE).union(Cursor.Profile.MINIMAL_NAVIGATION);
    public static final Cursor.Profile UNFIXED_FEATURES = Cursor.Profile.TO_NODE_TEST.union(Cursor.Profile.TO_POSITION).union(Cursor.Profile.SIZE).union(Cursor.Profile.POSITION);
    protected Cursor cursor;
    protected Cursor firstSibling;

    public ToFollowingSiblingsFixer(Cursor cursor2) {
        this.cursor = cursor2;
    }

    protected ToFollowingSiblingsFixer(Cursor cursor2, Cursor cursor3) {
        this.cursor = cursor2;
        this.firstSibling = cursor3;
    }

    protected Cursor getDelegate() {
        return this.cursor;
    }

    public Cursor.Profile profile() {
        return super.profile().union(FIXED_FEATURES).difference(UNFIXED_FEATURES);
    }

    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    public Cursor.Profile futureProfile() {
        return super.futureProfile().union(FIXED_FEATURES).difference(UNFIXED_FEATURES);
    }

    protected void navigate() {
        if (this.firstSibling != null) {
            this.firstSibling.release();
            this.firstSibling = null;
        }
    }

    public boolean toFollowingSiblings(NodeTest nodeTest) {
        Cursor cursor2 = this.cursor.fork(false);
        if (this.cursor.toParent()) {
            this.cursor.toChildren(null);
            while (!this.cursor.itemIsSameNode(cursor2)) {
                this.cursor.toNext();
            }
            if (this.cursor.toNext()) {
                this.navigate();
                this.firstSibling = this.cursor.fork(false, Cursor.Profile.IS_SAME_NODE, Cursor.Profile.IS_SAME_NODE);
                cursor2.release();
                return true;
            }
            this.cursor.release();
            this.cursor = cursor2;
        } else {
            cursor2.release();
        }
        return false;
    }

    public boolean toPrevious() {
        if (this.firstSibling != null && this.cursor.itemIsSameNode(this.firstSibling)) {
            return false;
        }
        return super.toPrevious();
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return new ToFollowingSiblingsFixer(this.cursor.fork(false), this.firstSibling == null ? null : this.firstSibling.fork(false));
    }

    public void release() {
        if (this.firstSibling != null) {
            this.firstSibling.release();
            this.firstSibling = null;
        }
        super.release();
    }
}

