/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractSimpleDelegatingCursor;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;

public class SizePositionFixer
extends AbstractSimpleDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.POSITION.union(Cursor.Profile.SIZE);
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.MINIMAL_STACK_NAVIGATION;
    protected long size;
    protected long position;

    public static Cursor.Profile neededFeatures(Cursor.Profile profile) {
        if (profile.containedIn(Cursor.Profile.SIZE)) {
            return Cursor.Profile.MINIMAL_NAVIGATION;
        }
        return NEEDED_FEATURES.union(profile.difference(FIXED_FEATURES));
    }

    public SizePositionFixer(Cursor cursor2) {
        super(cursor2);
        assert (NEEDED_FEATURES.containedIn(cursor2.profile())) : "Not enough features";
        this.size = -1L;
        this.position = 1L;
    }

    protected void resetSizePosition() {
        this.size = -1L;
        this.position = 1L;
    }

    public boolean contextIsSingleton() {
        if (this.size == -1L) {
            return this.position == 1L && this.contextSize() == 1L;
        }
        return this.size == 1L;
    }

    public long contextPosition() {
        return this.position;
    }

    public long contextSize() {
        if (this.size == -1L) {
            long l = this.position;
            Cursor cursor2 = this.getDelegate().fork(false, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.NONE);
            while (cursor2.toNext()) {
                ++l;
            }
            cursor2.release();
            this.size = l;
        }
        return this.size;
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        Cursor cursor2 = this.getDelegate();
        if (!FIXED_FEATURES.containedIn(profile) && !FIXED_FEATURES.containedIn(profile2)) {
            return cursor2.fork(bl, profile, profile2);
        }
        if (bl && FIXED_FEATURES.containedIn(cursor2.unwrap().futureProfile())) {
            return cursor2.fork(bl, profile, profile2);
        }
        SizePositionFixer sizePositionFixer = new SizePositionFixer(cursor2.fork(bl, profile.difference(FIXED_FEATURES).union(NEEDED_FEATURES), profile2));
        if (!bl) {
            sizePositionFixer.size = this.size;
            sizePositionFixer.position = this.position;
        }
        return sizePositionFixer;
    }

    public Cursor.Profile profile() {
        return super.profile().union(FIXED_FEATURES);
    }

    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    public Cursor.Profile futureProfile() {
        return super.futureProfile().union(FIXED_FEATURES);
    }

    public boolean toAttributes(NodeTest nodeTest) {
        if (super.toAttributes(nodeTest)) {
            this.resetSizePosition();
            return true;
        }
        return false;
    }

    public boolean toChildren(NodeTest nodeTest) {
        if (super.toChildren(nodeTest)) {
            this.resetSizePosition();
            return true;
        }
        return false;
    }

    public boolean toIdrefs(VolatileCData volatileCData) {
        if (super.toIdrefs(volatileCData)) {
            this.resetSizePosition();
            return true;
        }
        return false;
    }

    public boolean toIds(VolatileCData volatileCData) {
        if (super.toIds(volatileCData)) {
            this.resetSizePosition();
            return true;
        }
        return false;
    }

    public boolean toNext() {
        if (super.toNext()) {
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean toParent() {
        if (super.toParent()) {
            this.size = 1L;
            this.position = 1L;
            return true;
        }
        return false;
    }

    public boolean toPosition(long l) {
        if (super.toPosition(l)) {
            this.position = l;
            return true;
        }
        return false;
    }

    public boolean toPrevious() {
        if (super.toPrevious()) {
            --this.position;
            return true;
        }
        return false;
    }

    public boolean toRoot() {
        if (super.toRoot()) {
            this.size = 1L;
            this.position = 1L;
            return true;
        }
        return false;
    }

    public boolean toSelf() {
        super.toSelf();
        this.size = 1L;
        this.position = 1L;
        return true;
    }

    public boolean toFollowingSiblings(NodeTest nodeTest) {
        if (super.toFollowingSiblings(nodeTest)) {
            this.resetSizePosition();
            return true;
        }
        return false;
    }

    public boolean toNamespaceDecls() {
        if (super.toNamespaceDecls()) {
            this.resetSizePosition();
            return true;
        }
        return false;
    }

    public boolean toPrecedingSiblings(NodeTest nodeTest) {
        if (super.toPrecedingSiblings(nodeTest)) {
            this.resetSizePosition();
            return true;
        }
        return false;
    }

    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        super.addComment(area, volatileCData);
        if (this.size != -1L && (area == Cursor.Area.FOLLOWING_SIBLING || area == Cursor.Area.PRECEDING_SIBLING)) {
            ++this.size;
            if (area == Cursor.Area.PRECEDING_SIBLING) {
                ++this.position;
            }
        }
    }

    public void addCopy(Cursor.Area area, Cursor cursor2) {
        super.addCopy(area, cursor2);
        this.resetSizePosition();
    }

    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        super.addElement(area, volatileCData, xSTypeDefinition);
        if (this.size != -1L && (area == Cursor.Area.FOLLOWING_SIBLING || area == Cursor.Area.PRECEDING_SIBLING)) {
            ++this.size;
            if (area == Cursor.Area.PRECEDING_SIBLING) {
                ++this.position;
            }
        }
    }

    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        super.addProcessingInstruction(area, volatileCData, volatileCData2);
        if (this.size != -1L && (area == Cursor.Area.FOLLOWING_SIBLING || area == Cursor.Area.PRECEDING_SIBLING)) {
            ++this.size;
            if (area == Cursor.Area.PRECEDING_SIBLING) {
                ++this.position;
            }
        }
    }

    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        super.addText(area, volatileCData);
        if (this.size != -1L && (area == Cursor.Area.FOLLOWING_SIBLING || area == Cursor.Area.PRECEDING_SIBLING)) {
            ++this.size;
            if (area == Cursor.Area.PRECEDING_SIBLING) {
                ++this.position;
            }
        }
    }

    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        Cursor cursor2 = this.getDelegate();
        if (FIXED_FEATURES.containedIn(cursor2.unwrap().profile()) || FIXED_FEATURES.containedIn(cursor2.unwrap().futureProfile())) {
            return new SizePositionFixer(this.getDelegate().documentOrder(profile, profile2, bl));
        }
        return super.documentOrder(profile, profile2, bl);
    }
}

