/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.internal.util.CopyToResultHelper;
import com.ibm.xml.xci.res.XCIMessages;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveAttributeFixer
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.REMOVE_ATTRIBUTE;
    public static final Cursor.Profile UNFIXED_FEATURES = Cursor.Profile.SIZE.union(Cursor.Profile.POSITION).union(Cursor.Profile.TO_POSITION).union(Cursor.Profile.TO_IDREFS).union(Cursor.Profile.TO_IDS);
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.NODE_IDENTITY.union(Cursor.Profile.MINIMAL_NAVIGATION);
    protected Cursor cursor;
    protected Set<Long> removedAttrs;

    public RemoveAttributeFixer(Cursor cursor2) {
        this.cursor = cursor2;
        this.removedAttrs = new HashSet<Long>();
    }

    protected RemoveAttributeFixer(Cursor cursor2, Set<Long> set2) {
        this.cursor = cursor2;
        this.removedAttrs = set2;
    }

    protected boolean removeNode(long l) {
        return this.removedAttrs.add(l);
    }

    protected boolean hasBeenRemoved(long l) {
        return this.removedAttrs.contains(l);
    }

    @Override
    protected Cursor getDelegate() {
        return this.cursor;
    }

    @Override
    public Cursor.Profile profile() {
        return super.profile().union(FIXED_FEATURES).difference(UNFIXED_FEATURES);
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return super.futureProfile().union(FIXED_FEATURES).difference(UNFIXED_FEATURES);
    }

    @Override
    public boolean removeAttribute(VolatileCData volatileCData) {
        Cursor cursor2 = this.cursor.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        if (cursor2.toAttributes(null)) {
            do {
                if (!cursor2.itemName().equals(volatileCData)) continue;
                long l = cursor2.itemNodeIdentity();
                cursor2.release();
                return this.removeNode(l);
            } while (cursor2.toNext());
        }
        cursor2.release();
        return false;
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        Cursor cursor2 = this.cursor.fork(false);
        if (this.cursor.toAttributes(nodeTest)) {
            while (this.hasBeenRemoved(this.cursor.itemNodeIdentity())) {
                if (this.cursor.toNext()) continue;
                this.cursor.release();
                this.cursor = cursor2;
                return false;
            }
            cursor2.release();
            return true;
        }
        cursor2.release();
        return false;
    }

    @Override
    public boolean toNext() {
        Cursor cursor2 = this.cursor.fork(false);
        if (this.cursor.toNext()) {
            while (this.hasBeenRemoved(this.cursor.itemNodeIdentity())) {
                if (this.cursor.toNext()) continue;
                this.cursor.release();
                this.cursor = cursor2;
                return false;
            }
            cursor2.release();
            return true;
        }
        cursor2.release();
        return false;
    }

    public boolean copyToResult(Result result2, Map map2, boolean bl, boolean bl2) {
        return CopyToResultHelper.copyToResult(this, result2, map2, bl, bl2);
    }

    @Override
    public Object exportAs(String string2, boolean bl) {
        throw new ClassCastException();
    }

    @Override
    public Class<?> exportAsClass(String string2) {
        return null;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return new RemoveAttributeFixer(this.cursor, this.removedAttrs);
    }

    @Override
    public boolean openMutation(Cursor.Area area) {
        return this.cursor.openMutation(area);
    }

    @Override
    public boolean contextIsSingleton() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SIZE"}));
    }

    @Override
    public long contextPosition() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.POSITION"}));
    }

    @Override
    public long contextSize() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SIZE"}));
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SERIALIZE"}));
    }

    @Override
    public boolean toIdrefs(VolatileCData volatileCData) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_IDREFS"}));
    }

    @Override
    public boolean toIds(VolatileCData volatileCData) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_IDS"}));
    }

    @Override
    public boolean toPosition(long l) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_POSITION"}));
    }

    @Override
    public boolean toPrevious() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_PREVIOUS"}));
    }
}

