/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.dp.util.DMUtil;
import com.ibm.xml.xci.dp.util.fixers.Log;
import com.ibm.xml.xci.errors.XCIIllegalContextItemException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalMutationFixer
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.MINIMAL_MUTATION.union(Cursor.Profile.SET_VALUE);
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.NODE_IDENTITY;
    public static final Cursor.Profile UNFIXED_FEATURES = Cursor.Profile.SIZE.union(Cursor.Profile.POSITION).union(Cursor.Profile.TO_POSITION).union(Cursor.Profile.TO_NODE_TEST).union(Cursor.Profile.TO_FOLLOWING_SIBLINGS).union(Cursor.Profile.TO_PRECEDING_SIBLINGS).union(Cursor.Profile.TO_IDREFS).union(Cursor.Profile.TO_IDS);
    protected static final int STATE_UNCHANGED_SIBLINGS = 0;
    protected static final int STATE_MIXED_SIBLINGS_ON_FIRST_LOGGED_CHILDREN = 1;
    protected static final int STATE_CHANGED_SIBLINGS = 2;
    protected static final int STATE_MIXED_SIBLINGS_ON_UNCHANGED_NODE = 3;
    protected static final int STATE_MIXED_SIBLINGS_ON_CHANGED_NODE = 4;
    protected static final int STATE_UNCHANGED_SINGLETON = 5;
    protected static final int STATE_CHANGED_SINGLETON = 6;
    protected Cursor cursor;
    protected final Log log;
    protected Cursor loggedCursor;
    protected int sequenceState;
    protected boolean topLevel;

    public MinimalMutationFixer(Cursor cursor2, Cursor.Profile profile) {
        this.cursor = cursor2;
        this.log = new Log(profile, cursor2.factory());
        this.sequenceState = 0;
    }

    protected MinimalMutationFixer(Cursor cursor2, Log log, int n2, boolean bl) {
        this.cursor = cursor2;
        this.log = log;
        this.sequenceState = n2;
        this.topLevel = bl;
    }

    @Override
    protected Cursor getDelegate() {
        return this.loggedCursor == null ? this.cursor : this.loggedCursor;
    }

    @Override
    public Cursor.Profile profile() {
        return super.profile().union(FIXED_FEATURES).difference(UNFIXED_FEATURES);
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return super.futureProfile().union(FIXED_FEATURES).difference(UNFIXED_FEATURES);
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.loggedCursor != null) {
            this.loggedCursor.addAttribute(volatileCData, volatileCData2);
        } else {
            if (this.itemKind() != 1) {
                throw new XCIIllegalContextItemException(XCIMessages.createXCIMessage("ER_ILLEGAL_CONTEXT_ITEM_FOR_OP", new String[]{"addAttribute", DMUtil.kindSource(this.itemKind())}));
            }
            this.log.addAttribute(this.cursor, volatileCData, volatileCData2);
        }
    }

    @Override
    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (this.loggedCursor != null) {
            if (this.topLevel) {
                this.loggedCursor.sequenceConcat(this.factory().comment(volatileCData, null), this.loggedCursor.profile(), this.loggedCursor.futureProfile(), false, false, false, true);
            } else {
                this.loggedCursor.addComment(area, volatileCData);
            }
        } else {
            this.log.addComment(this.cursor, area, volatileCData);
        }
    }

    @Override
    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (this.loggedCursor != null) {
            if (this.topLevel) {
                this.loggedCursor.sequenceConcat(this.factory().element(volatileCData, xSTypeDefinition, null), this.loggedCursor.profile(), this.loggedCursor.futureProfile(), false, false, false, true);
            } else {
                this.loggedCursor.addElement(area, volatileCData, xSTypeDefinition);
            }
        } else {
            this.log.addElement(this.cursor, area, volatileCData, xSTypeDefinition);
        }
    }

    @Override
    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        if (this.loggedCursor != null) {
            this.loggedCursor.addNamespaceNode(volatileCData, volatileCData2, bl);
        } else {
            if (this.itemKind() != 1) {
                throw new XCIIllegalContextItemException(XCIMessages.createXCIMessage("ER_ILLEGAL_CONTEXT_ITEM_FOR_OP", new String[]{"addNamespaceNode", DMUtil.kindSource(this.itemKind())}));
            }
            this.log.addNamespaceNode(this.cursor, volatileCData, volatileCData2, bl);
        }
    }

    @Override
    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.loggedCursor != null) {
            if (this.topLevel) {
                this.loggedCursor.sequenceConcat(this.factory().processingInstruction(volatileCData, volatileCData2, null), this.loggedCursor.profile(), this.loggedCursor.futureProfile(), false, false, false, true);
            } else {
                this.loggedCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
            }
        } else {
            this.log.addProcessingInstruction(this.cursor, area, volatileCData, volatileCData2);
        }
    }

    @Override
    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (this.loggedCursor != null) {
            if (this.topLevel) {
                this.loggedCursor.sequenceConcat(this.factory().text(volatileCData, null), this.loggedCursor.profile(), this.loggedCursor.futureProfile(), false, false, false, true);
            } else {
                this.loggedCursor.addText(area, volatileCData);
            }
        } else {
            this.log.addText(this.cursor, area, volatileCData);
        }
    }

    @Override
    public void setItemValue(VolatileCData volatileCData) {
        if (this.loggedCursor != null) {
            this.loggedCursor.setItemValue(volatileCData);
        } else {
            this.log.setItemValue(this.cursor, volatileCData);
        }
    }

    @Override
    public boolean openMutation(Cursor.Area area) {
        if (this.loggedCursor != null) {
            return this.loggedCursor.openMutation(area);
        }
        return true;
    }

    @Override
    public void closeMutation() {
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        assert (nodeTest == null) : "TO_NODE_TEST is not supported";
        switch (this.sequenceState) {
            case 1: 
            case 4: {
                if (this.loggedCursor.toChildren(null)) {
                    this.sequenceState = 2;
                    this.topLevel = true;
                    return true;
                }
                return false;
            }
            case 2: 
            case 6: {
                if (this.loggedCursor.toChildren(null)) {
                    this.topLevel = false;
                    return true;
                }
                return false;
            }
            case 0: 
            case 3: 
            case 5: {
                Cursor cursor2 = this.log.getChangedFirstChild(this.cursor);
                if (cursor2 != null) {
                    this.sequenceState = 1;
                    this.loggedCursor = cursor2.fork(false);
                    return true;
                }
                return this.cursor.toChildren(null);
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean toNext() {
        switch (this.sequenceState) {
            case 5: 
            case 6: {
                return false;
            }
            case 0: {
                return this.cursor.toNext();
            }
            case 2: {
                return this.loggedCursor.toNext();
            }
            case 1: {
                if (this.loggedCursor.toNext()) {
                    return true;
                }
                if (this.cursor.toChildren(null)) {
                    this.sequenceState = 3;
                    this.loggedCursor.release();
                    this.loggedCursor = null;
                    return true;
                }
                return false;
            }
            case 3: {
                Cursor cursor2 = this.log.getChangedFollowing(this.cursor);
                if (cursor2 != null) {
                    this.sequenceState = 4;
                    this.loggedCursor = cursor2.fork(false);
                    return true;
                }
                return this.cursor.toNext();
            }
            case 4: {
                if (this.loggedCursor.toNext()) {
                    return true;
                }
                if (this.cursor.toNext()) {
                    this.sequenceState = 3;
                    this.loggedCursor.release();
                    this.loggedCursor = null;
                    return true;
                }
                return false;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        return super.toAttributes(nodeTest);
    }

    @Override
    public boolean toNamespaceDecls() {
        return super.toNamespaceDecls();
    }

    @Override
    public boolean toParent() {
        switch (this.sequenceState) {
            case 0: 
            case 5: {
                if (this.cursor.toParent()) {
                    this.sequenceState = 5;
                    return true;
                }
                return false;
            }
            case 2: {
                this.loggedCursor.toParent();
                this.sequenceState = 6;
                return true;
            }
            case 1: {
                this.loggedCursor.release();
                this.loggedCursor = null;
                this.sequenceState = 5;
                return true;
            }
            case 3: {
                if (this.cursor.toParent()) {
                    this.sequenceState = 5;
                    return true;
                }
                return false;
            }
            case 4: {
                this.cursor.toParent();
                this.loggedCursor.release();
                this.loggedCursor = null;
                this.sequenceState = 5;
                return true;
            }
            case 6: {
                if (this.loggedCursor.toParent()) {
                    return true;
                }
                Cursor cursor2 = this.log.getChangedFollowing(this.cursor);
                if (cursor2 != null && cursor2.itemIsSameNode(this.loggedCursor)) {
                    this.cursor.toParent();
                }
                this.loggedCursor.release();
                this.loggedCursor = null;
                this.sequenceState = 5;
                return true;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean toPrevious() {
        switch (this.sequenceState) {
            case 5: 
            case 6: {
                return false;
            }
            case 0: {
                return this.cursor.toPrevious();
            }
            case 2: {
                return this.loggedCursor.toPrevious();
            }
            case 1: {
                return this.loggedCursor.toPrevious();
            }
            case 3: {
                if (this.cursor.toPrevious()) {
                    Cursor cursor2 = this.log.getChangedFollowing(this.cursor);
                    if (cursor2 != null) {
                        this.loggedCursor = cursor2.fork(true);
                        while (this.loggedCursor.toNext()) {
                        }
                        this.sequenceState = 4;
                        return true;
                    }
                    return true;
                }
                if (this.cursor.toParent()) {
                    Cursor cursor3 = this.log.getChangedFirstChild(this.cursor);
                    if (cursor3 != null) {
                        this.loggedCursor = cursor3.fork(false);
                        while (this.loggedCursor.toNext()) {
                        }
                        this.sequenceState = 1;
                        return true;
                    }
                    this.cursor.toChildren(null);
                }
                return false;
            }
            case 4: {
                if (this.loggedCursor.toPrevious()) {
                    return true;
                }
                if (this.cursor.toPrevious()) {
                    Cursor cursor4 = this.log.getChangedFollowing(this.cursor);
                    if (cursor4 != null) {
                        this.loggedCursor = cursor4.fork(true);
                        while (this.loggedCursor.toNext()) {
                        }
                        this.sequenceState = 4;
                        return true;
                    }
                    return true;
                }
                if (this.cursor.toParent()) {
                    Cursor cursor5 = this.log.getChangedFirstChild(this.cursor);
                    if (cursor5 != null) {
                        this.loggedCursor = cursor5.fork(true);
                        while (this.loggedCursor.toNext()) {
                        }
                        this.sequenceState = 1;
                        return true;
                    }
                    this.cursor.toChildren(null);
                }
                return false;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean toSelf() {
        switch (this.sequenceState) {
            case 0: 
            case 3: {
                this.sequenceState = 5;
                return true;
            }
            case 1: 
            case 2: 
            case 4: {
                this.sequenceState = 6;
                return true;
            }
            case 5: 
            case 6: {
                return true;
            }
        }
        throw new AssertionError();
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (Cursor.Profile.NONE == profile2 || profile2.disjoint(FIXED_FEATURES) && this.log.isEmpty()) {
            return this.getDelegate().fork(bl, profile, profile2);
        }
        return new MinimalMutationFixer(this.cursor.fork(false, profile.difference(FIXED_FEATURES), profile2.difference(FIXED_FEATURES)), this.log, this.sequenceState, this.topLevel);
    }

    @Override
    public void release() {
        if (this.loggedCursor != null) {
            this.loggedCursor.release();
        }
        this.log.release();
        super.release();
    }

    @Override
    public boolean contextIsSingleton() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SIZE"}));
    }

    @Override
    public long contextPosition() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.POSITION"}));
    }

    @Override
    public long contextSize() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SIZE"}));
    }

    @Override
    public boolean toIdrefs(VolatileCData volatileCData) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_IDREFS"}));
    }

    @Override
    public boolean toIds(VolatileCData volatileCData) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_IDS"}));
    }

    @Override
    public boolean toPosition(long l) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_POSITION"}));
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SERIALIZE"}));
    }

    @Override
    public boolean toFollowingSiblings(NodeTest nodeTest) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_FOLLOWING_SIBLINGS"}));
    }

    @Override
    public boolean toPrecedingSiblings(NodeTest nodeTest) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_PRECEDING_SIBLINGS"}));
    }
}

