/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.DMUtil;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;

class Log {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final short FIRST_CHILD_CHANGED = 1;
    private static final short FOLLOWING_CHANGED = 2;
    private static final short ATTRIBUTE_ADDED = 3;
    private static final short NSNODE_ADDED = 4;
    private static final int CHUNK_SIZE = 6;
    private static final int CHUNK_MASK = 63;
    protected final Long2IntHashMap changes = new Long2IntHashMap(1024);
    protected final int[][] nextChanges;
    protected final short[][] changesType = new short[1024][];
    protected final Cursor[][] subtrees = new Cursor[1024][];
    protected int changesCount;
    protected final CursorFactory cursorFactory;
    protected final RequestInfo requestInfo;

    Log(Cursor.Profile profile, CursorFactory cursorFactory) {
        this.nextChanges = new int[1024][];
        this.checkInitChunk();
        this.requestInfo = new RequestInfo(profile.union(Cursor.Profile.RANDOM_UPDATE));
        this.cursorFactory = cursorFactory;
    }

    public boolean isEmpty() {
        return this.changesCount == 0;
    }

    public Cursor getChangedFirstChild(Cursor cursor2) {
        int n2 = this.changes.get(cursor2.itemNodeIdentity());
        if (n2 == Integer.MAX_VALUE) {
            return null;
        }
        do {
            if (this.changesType[Log.chunk(n2)][Log.index(n2)] != 1) continue;
            return this.subtrees[Log.chunk(n2)][Log.index(n2)];
        } while ((n2 = this.nextChanges[Log.chunk(n2)][Log.index(n2)]) != 0);
        return null;
    }

    public Cursor getChangedFollowing(Cursor cursor2) {
        int n2 = this.changes.get(cursor2.itemNodeIdentity());
        if (n2 == Integer.MAX_VALUE) {
            return null;
        }
        do {
            if (this.changesType[Log.chunk(n2)][Log.index(n2)] != 2) continue;
            return this.subtrees[Log.chunk(n2)][Log.index(n2)];
        } while ((n2 = this.nextChanges[Log.chunk(n2)][Log.index(n2)]) != 0);
        return null;
    }

    public void addElement(Cursor cursor2, Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        Cursor cursor3 = this.cursorFactory.element(volatileCData, xSTypeDefinition, this.requestInfo);
        this.addNode(cursor2, area, cursor3);
    }

    public void addProcessingInstruction(Cursor cursor2, Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        Cursor cursor3 = this.cursorFactory.processingInstruction(volatileCData, volatileCData2, this.requestInfo);
        this.addNode(cursor2, area, cursor3);
    }

    public void addText(Cursor cursor2, Cursor.Area area, VolatileCData volatileCData) {
        Cursor cursor3 = this.cursorFactory.text(volatileCData, this.requestInfo);
        this.addNode(cursor2, area, cursor3);
    }

    public void addComment(Cursor cursor2, Cursor.Area area, VolatileCData volatileCData) {
        Cursor cursor3 = this.cursorFactory.comment(volatileCData, this.requestInfo);
        this.addNode(cursor2, area, cursor3);
    }

    public void addAttribute(Cursor cursor2, VolatileCData volatileCData, VolatileCData volatileCData2) {
        Cursor cursor3;
        this.subtrees[Log.chunk((int)this.changesCount)][Log.index((int)this.changesCount)] = cursor3 = this.cursorFactory.attribute(volatileCData, volatileCData2, this.requestInfo);
        this.changesType[Log.chunk((int)this.changesCount)][Log.index((int)this.changesCount)] = 3;
        this.recordLastChange(cursor2);
    }

    public void addNamespaceNode(Cursor cursor2, VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        Cursor cursor3;
        this.subtrees[Log.chunk((int)this.changesCount)][Log.index((int)this.changesCount)] = cursor3 = this.cursorFactory.namespace(volatileCData, volatileCData2, this.requestInfo);
        this.changesType[Log.chunk((int)this.changesCount)][Log.index((int)this.changesCount)] = 4;
        this.recordLastChange(cursor2);
    }

    public void setItemValue(Cursor cursor2, VolatileCData volatileCData) {
    }

    public void release() {
        for (int i = this.changesCount - 1; i >= 0; --i) {
            Cursor cursor2 = this.subtrees[Log.chunk(i)][Log.index(i)];
            if (cursor2 == null) continue;
            cursor2.release();
        }
    }

    private void addNode(Cursor cursor2, Cursor.Area area, Cursor cursor3) {
        this.subtrees[Log.chunk((int)this.changesCount)][Log.index((int)this.changesCount)] = cursor3;
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                this.changesType[Log.chunk((int)this.changesCount)][Log.index((int)this.changesCount)] = 1;
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                this.changesType[Log.chunk((int)this.changesCount)][Log.index((int)this.changesCount)] = 2;
                break;
            }
            default: {
                throw new XCIDynamicErrorException("ER_ILLEGAL_MUTATION_RELATIVE_TO_AREA", new String[]{DMUtil.kindSource(cursor2.itemKind())});
            }
        }
        this.recordLastChange(cursor2);
    }

    private void recordLastChange(Cursor cursor2) {
        int n2 = this.changes.get(cursor2.itemNodeIdentity());
        this.changes.put(cursor2.itemNodeIdentity(), this.changesCount);
        this.nextChanges[Log.chunk((int)this.changesCount)][Log.index((int)this.changesCount)] = n2;
        ++this.changesCount;
        this.checkInitChunk();
    }

    private void checkInitChunk() {
        int n2 = Log.chunk(this.changesCount);
        if (this.nextChanges[n2] == null) {
            this.nextChanges[n2] = new int[63];
            this.changesType[n2] = new short[63];
            this.subtrees[n2] = new Cursor[63];
        }
    }

    private static final int chunk(int n2) {
        return n2 >>> 6;
    }

    private static final int index(int n2) {
        return n2 & 0x3F;
    }

    private final class Long2IntHashMap {
        static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
        public static final int NULL = Integer.MAX_VALUE;
        private long[] table;
        private int headerSize;
        private int size;
        private int[] values;

        public Long2IntHashMap(int n2) {
            this.table = new long[n2 << 1];
            this.values = new int[n2];
            this.size = this.headerSize = n2 * 3 / 2;
        }

        public int get(long l) {
            if (l == 0L) {
                return Integer.MAX_VALUE;
            }
            int n2 = (int)(l % (long)(this.headerSize >> 1) << 1);
            long l2;
            while ((l2 = this.table[n2]) != 0L) {
                if (l2 == l) {
                    return this.values[n2 >> 1];
                }
                n2 = (int)this.table[n2 + 1];
            }
            return 0;
        }

        public void put(long l, int n2) {
            if (l == 0L) {
                throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_INVALID_KEY_VALUE", new String[]{"0"}));
            }
            int n3 = (int)(l % (long)(this.headerSize >> 1) << 1);
            if (this.table[n3] == 0L || this.table[n3] == l) {
                this.table[n3] = l;
                this.values[n3 >> 1] = n2;
            } else {
                if (this.size >= this.table.length) {
                    long[] lArray = new long[this.table.length * 2];
                    System.arraycopy(this.table, 0, lArray, 0, this.table.length);
                    this.table = lArray;
                    int[] nArray = new int[this.values.length * 2];
                    System.arraycopy(this.values, 0, nArray, 0, this.values.length);
                    this.values = nArray;
                }
                this.table[this.size] = l;
                this.table[this.size + 1] = this.table[n3 + 1];
                this.table[n3 + 1] = this.size;
                this.values[this.size >> 1] = n2;
                this.size += 2;
            }
        }
    }
}

