/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.encoding;

import com.ibm.xml.xci.dp.util.encoding.CharConversionError;
import com.ibm.xml.xci.dp.util.encoding.EncodingSupport;
import java.io.IOException;
import java.io.InputStream;

public final class UTF8EncodingSupport
implements EncodingSupport {
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};
    private static final EncodingSupport fgSingleton = new UTF8EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public boolean isASCIITransparent() {
        return true;
    }

    public boolean isSingleByte() {
        return false;
    }

    public static void normalizeCharsToBytes(char[] cArray, int n2, int n3, byte[][] byArray, int[] nArray, int[] nArray2, boolean[] blArray) {
        char c;
        byte[] byArray2 = byArray[0];
        int n4 = nArray[0];
        int n5 = byArray2.length;
        boolean bl = blArray[0];
        int n6 = nArray2[0];
        if (n6 != -1) {
            if (n2 == n3) {
                CharConversionError.missingSecondHalfOfSurrogatePair();
            }
            nArray2[0] = -1;
            if ((c = cArray[n2++]) >= '\udc00' && c < '\ue000') {
                n6 = 65536 + (n6 - 55296 << 10) + (c - 56320);
            } else {
                CharConversionError.invalidSecondHalfOfSurrogatePair();
            }
            if (n4 + 4 > n5) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
                n5 <<= 1;
            }
            byArray2[n4++] = (byte)(0xF0 | n6 >> 18);
            byArray2[n4++] = (byte)(0x80 | 0x3F & n6 >> 12);
            byArray2[n4++] = (byte)(0x80 | 0x3F & n6 >> 6);
            byArray2[n4++] = (byte)(0x80 | 0x3F & n6);
        }
        while (n2 < n3) {
            n6 = cArray[n2++];
            if (bl) {
                bl = false;
                if (n6 == 10) continue;
            }
            if (n6 < 128) {
                if (n6 == 13) {
                    n6 = 10;
                    bl = true;
                }
                if (n4 == n5) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n5 <<= 1;
                }
                byArray2[n4++] = (byte)n6;
                continue;
            }
            if (n6 < 2048) {
                if (n4 + 2 > n5) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n5 <<= 1;
                }
                byArray2[n4++] = (byte)(0xC0 | n6 >> 6);
                byArray2[n4++] = (byte)(0x80 | 0x3F & n6);
                continue;
            }
            if (n6 < 55296) {
                if (n4 + 3 > n5) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n5 <<= 1;
                }
                byArray2[n4++] = (byte)(0xE0 | n6 >> 12);
                byArray2[n4++] = (byte)(0x80 | 0x3F & n6 >> 6);
                byArray2[n4++] = (byte)(0x80 | 0x3F & n6);
                continue;
            }
            if (n6 < 56320) {
                if (n2 == n3) {
                    nArray2[0] = n6;
                    break;
                }
                if ((c = cArray[n2++]) >= '\udc00' && c < '\ue000') {
                    n6 = 65536 + (n6 - 55296 << 10) + (c - 56320);
                } else {
                    CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                if (n4 + 4 > n5) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n5 <<= 1;
                }
                byArray2[n4++] = (byte)(0xF0 | n6 >> 18);
                byArray2[n4++] = (byte)(0x80 | 0x3F & n6 >> 12);
                byArray2[n4++] = (byte)(0x80 | 0x3F & n6 >> 6);
                byArray2[n4++] = (byte)(0x80 | 0x3F & n6);
                continue;
            }
            if (n6 < 57344) {
                CharConversionError.invalidFirstHalfOfSurrogatePair();
                continue;
            }
            if (n4 + 3 > n5) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
                n5 <<= 1;
            }
            byArray2[n4++] = (byte)(0xE0 | n6 >> 12);
            byArray2[n4++] = (byte)(0x80 | 0x3F & n6 >> 6);
            byArray2[n4++] = (byte)(0x80 | 0x3F & n6);
        }
        nArray[0] = n4;
        blArray[0] = bl;
    }

    public void convertCharsToBytes(char[] cArray, int n2, int n3, byte[][] byArray, int[] nArray) {
        int n4;
        char[] cArray2 = cArray;
        int n5 = n3;
        int n6 = n2;
        byte[] byArray2 = byArray[0];
        int n7 = byArray2.length;
        int n8 = nArray[0];
        int n9 = n7 - n8;
        int n10 = n5 - n6 <= n9 ? n5 : n6 + n9;
        while (n6 < n10) {
            if ((n4 = cArray2[n6++]) < 128) {
                byArray2[n8++] = (byte)n4;
                continue;
            }
            --n6;
            break;
        }
        if (n6 == n5) {
            nArray[0] = n8;
            return;
        }
        while (n6 < n5) {
            if ((n4 = cArray2[n6++]) < 128) {
                if (n8 == n7) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n7 <<= 1;
                }
                byArray2[n8++] = (byte)n4;
                continue;
            }
            if (n4 < 2048) {
                if (n8 + 2 > n7) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n7 <<= 1;
                }
                byArray2[n8++] = (byte)(0xC0 | n4 >> 6);
                byArray2[n8++] = (byte)(0x80 | 0x3F & n4);
                continue;
            }
            if (n4 < 55296) {
                if (n8 + 3 > n7) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n7 <<= 1;
                }
                byArray2[n8++] = (byte)(0xE0 | n4 >> 12);
                byArray2[n8++] = (byte)(0x80 | 0x3F & n4 >> 6);
                byArray2[n8++] = (byte)(0x80 | 0x3F & n4);
                continue;
            }
            if (n4 < 56320) {
                char c;
                if (n6 == n5) {
                    CharConversionError.missingSecondHalfOfSurrogatePair();
                }
                if ((c = cArray2[n6++]) >= '\udc00' && c < '\ue000') {
                    n4 = 65536 + (n4 - 55296 << 10) + (c - 56320);
                } else {
                    CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                if (n8 + 4 > n7) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n7 <<= 1;
                }
                byArray2[n8++] = (byte)(0xF0 | n4 >> 18);
                byArray2[n8++] = (byte)(0x80 | 0x3F & n4 >> 12);
                byArray2[n8++] = (byte)(0x80 | 0x3F & n4 >> 6);
                byArray2[n8++] = (byte)(0x80 | 0x3F & n4);
                continue;
            }
            if (n4 < 57344) {
                CharConversionError.invalidFirstHalfOfSurrogatePair();
                continue;
            }
            if (n8 + 3 > n7) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
                n7 <<= 1;
            }
            byArray2[n8++] = (byte)(0xE0 | n4 >> 12);
            byArray2[n8++] = (byte)(0x80 | 0x3F & n4 >> 6);
            byArray2[n8++] = (byte)(0x80 | 0x3F & n4);
        }
        nArray[0] = n8;
    }

    public int encodeCharacter(int n2, byte[][] byArray, int n3) {
        byte[] byArray2 = byArray[0];
        int n4 = byArray2.length;
        if (n2 < 128) {
            if (n3 == n4) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n3++] = (byte)n2;
        } else if (n2 < 2048) {
            if (n3 + 2 > n4) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n3++] = (byte)(0xC0 | n2 >> 6);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n2);
        } else if (n2 < 65536) {
            if (n3 + 3 > n4) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n3++] = (byte)(0xE0 | n2 >> 12);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n2 >> 6);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n2);
        } else {
            if (n3 + 4 > n4) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n3++] = (byte)(0xF0 | n2 >> 18);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n2 >> 12);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n2 >> 6);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n2);
        }
        return n3;
    }

    public int normalizeLineBreaks(byte[] byArray, int n2, int n3, boolean[] blArray) {
        int n4;
        byte[] byArray2 = byArray;
        int n5 = n2;
        int n6 = n3;
        boolean bl = blArray[0];
        if (!bl && n5 < n6) {
            while ((n4 = byArray2[n5]) != 13 && ++n5 < n6) {
            }
            if (n5 == n6) {
                return n5;
            }
            bl = true;
            byArray2[n5++] = 10;
        }
        int n7 = n5;
        while (n7 < n6) {
            n4 = byArray2[n7++];
            if (bl) {
                bl = false;
                if (n4 == 10) continue;
            }
            if (n4 == 13) {
                n4 = 10;
                bl = true;
            }
            byArray2[n5++] = n4;
        }
        blArray[0] = bl;
        return n5;
    }

    public void readCharacters(InputStream inputStream, char[][] cArray, int[] nArray, boolean[] blArray, byte[] byArray, boolean bl) {
        int n2 = 0;
        try {
            int n3;
            boolean bl2 = false;
            int n4 = n3 = bl ? UTF8EncodingSupport.checkUTF8BOM(inputStream, byArray) : 0;
            if (n3 < 0) {
                n3 += 3;
                bl2 = true;
            }
            do {
                int n5;
                if ((n2 = n3 - (n5 = blArray != null ? this.normalizeBytesToChars(byArray, 0, n3, cArray, nArray, blArray) : this.convertBytesToCharsPartial(byArray, 0, n3 += n2, cArray, nArray))) <= 0) continue;
                int n6 = 0;
                do {
                    byArray[n6++] = byArray[n5++];
                } while (n6 < n2);
            } while (!bl2 && (n3 = inputStream.read(byArray, n2, byArray.length - n2)) >= 0);
            if (n2 != 0) {
                CharConversionError.partialMultiPartCharacterSequence();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static int checkUTF8BOM(InputStream inputStream, byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = inputStream.read();
        if (n3 == 239) {
            n3 = inputStream.read();
            if (n3 == 187) {
                n3 = inputStream.read();
                if (n3 == 191) {
                    return 0;
                }
                byArray[n2++] = -17;
                byArray[n2++] = -69;
                if (n3 != -1) {
                    byArray[n2++] = (byte)n3;
                    return n2;
                }
            } else {
                byArray[n2++] = -17;
                if (n3 != -1) {
                    byArray[n2++] = (byte)n3;
                    return n2;
                }
            }
        } else if (n3 != -1) {
            byArray[n2++] = (byte)n3;
            return n2;
        }
        return n2 - 3;
    }

    public int lengthAsCharacters(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = byArray;
        int n4 = n2;
        int n5 = n3;
        int n6 = 0;
        block6: while (n4 < n5) {
            int n7 = byArray2[n4++];
            ++n6;
            if (n7 >= 0) continue;
            switch (fgMultiByteLength[(n7 &= 0xFF) >> 3]) {
                default: {
                    this.charConversionFailure(1, n7, 0, 0, 0);
                    continue block6;
                }
                case 1: {
                    continue block6;
                }
                case 2: {
                    ++n4;
                    continue block6;
                }
                case 3: {
                    n4 += 2;
                    continue block6;
                }
                case 4: 
            }
            n4 += 3;
        }
        return n6;
    }

    public void convertBytesToChars(byte[] byArray, int n2, int n3, char[][] cArray, int[] nArray) {
        int n4 = this.convertBytesToCharsPartial(byArray, n2, n3, cArray, nArray);
        if (n4 != n3) {
            CharConversionError.partialMultiPartCharacterSequence();
        }
    }

    private int convertBytesToCharsPartial(byte[] byArray, int n2, int n3, char[][] cArray, int[] nArray) {
        int n4;
        byte[] byArray2 = byArray;
        int n5 = n3;
        int n6 = n2;
        char[] cArray2 = cArray[0];
        int n7 = cArray2.length;
        int n8 = nArray[0];
        int n9 = n7 - n8;
        int n10 = n5 - n6 <= n9 ? n5 : n6 + n9;
        while (n6 < n10) {
            if ((n4 = byArray2[n6++]) >= 0) {
                cArray2[n8++] = (char)n4;
                continue;
            }
            --n6;
            break;
        }
        if (n6 == n5) {
            nArray[0] = n8;
            return n6;
        }
        while (n6 < n5) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            block15: {
                do {
                    if (n8 == n7) {
                        cArray2 = UTF8EncodingSupport.resize(cArray2);
                        cArray[0] = cArray2;
                        n7 <<= 1;
                    }
                    if ((n15 = byArray2[n6++]) < 0) break block15;
                    cArray2[n8++] = (char)n15;
                } while (n6 != n5);
                nArray[0] = n8;
                return n6;
            }
            n4 = fgMultiByteLength[(n15 &= 0xFF) >> 3];
            if (n4 == 0) {
                this.charConversionFailure(1, n15, 0, 0, 0);
            }
            if (n6 - 1 + n4 > n5) {
                nArray[0] = n8;
                return n6 - 1;
            }
            int n16 = n15 & fgFirstByteValueMask[n4];
            if ((0xC0 & (n14 = byArray2[n6++] & 0xFF)) != 128) {
                this.charConversionFailure(2, n15, n14, 0, 0);
            }
            if (n4 == 2) {
                n16 = (n16 << 6) + (0x3F & n14);
                cArray2[n8++] = (char)n16;
                continue;
            }
            if ((0xC0 & (n13 = byArray2[n6++] & 0xFF)) != 128) {
                this.charConversionFailure(3, n15, n14, n13, 0);
            }
            if (n4 == 3) {
                n16 = (n16 << 12) + ((0x3F & n14) << 6) + (0x3F & n13);
                cArray2[n8++] = (char)n16;
                continue;
            }
            if ((0xC0 & (n12 = byArray2[n6++] & 0xFF)) != 128) {
                this.charConversionFailure(4, n15, n14, n13, n12);
            }
            if ((n11 = (n16 << 8) + ((0x30 & n14) << 2)) > 1024 || n11 == 0) {
                CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n17 = n11 - 64;
            int n18 = 55296 + n17 + ((0xF & n14) << 2) + ((0x30 & n13) >> 4);
            int n19 = 56320 + ((0xF & n13) << 6) + (0x3F & n12);
            cArray2[n8++] = (char)n18;
            if (n8 == n7) {
                cArray2 = UTF8EncodingSupport.resize(cArray2);
                cArray[0] = cArray2;
                n7 <<= 1;
            }
            cArray2[n8++] = (char)n19;
        }
        nArray[0] = n8;
        return n6;
    }

    public int decodeCharacter(byte[] byArray, int n2, int n3, int[] nArray) {
        if (n2 < n3) {
            int n4;
            if ((n4 = byArray[n2++]) >= 0) {
                if (nArray != null) {
                    nArray[0] = 1;
                }
                return n4;
            }
            int n5 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
            if (n5 > 0) {
                int n6;
                int n7;
                int n8;
                if (nArray != null) {
                    nArray[0] = n5;
                }
                if (n2 - 1 + n5 > n3) {
                    CharConversionError.insufficientInputToDecodeCharacter();
                }
                int n9 = n4 & fgFirstByteValueMask[n5];
                if ((0xC0 & (n8 = byArray[n2++] & 0xFF)) != 128) {
                    this.charConversionFailure(2, n4, n8, 0, 0);
                }
                if (n5 == 2) {
                    n9 = (n9 << 6) + (0x3F & n8);
                    return n9;
                }
                if ((0xC0 & (n7 = byArray[n2++] & 0xFF)) != 128) {
                    this.charConversionFailure(3, n4, n8, n7, 0);
                }
                if (n5 == 3) {
                    n9 = (n9 << 12) + ((0x3F & n8) << 6) + (0x3F & n7);
                    return n9;
                }
                if ((0xC0 & (n6 = byArray[n2++] & 0xFF)) != 128) {
                    this.charConversionFailure(4, n4, n8, n7, n6);
                }
                n9 = (n9 << 18) + ((0x3F & n8) << 12) + ((0x3F & n7) << 6) + (0x3F & n6);
                return n9;
            }
            this.charConversionFailure(1, n4, 0, 0, 0);
            return -1;
        }
        CharConversionError.insufficientInputToDecodeCharacter();
        return -1;
    }

    private UTF8EncodingSupport() {
    }

    private static byte[] resize(byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 << 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    private static char[] resize(char[] cArray) {
        int n2 = cArray.length;
        char[] cArray2 = new char[n2 << 1];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return cArray2;
    }

    private void charConversionFailure(int n2, int n3, int n4, int n5, int n6) {
        CharConversionError.invalidUTF8CharacterEncoding(n2, n3, n4, n5, n6);
    }

    private int normalizeBytesToChars(byte[] byArray, int n2, int n3, char[][] cArray, int[] nArray, boolean[] blArray) {
        int n4;
        byte[] byArray2 = byArray;
        int n5 = n2;
        int n6 = n3;
        char[] cArray2 = cArray[0];
        int n7 = nArray[0];
        int n8 = cArray2.length;
        int n9 = n8 - n7;
        boolean bl = blArray[0];
        int n10 = n6 - n5 <= n9 ? n6 : n5 + n9;
        while (n5 < n10) {
            n4 = byArray2[n5++];
            if (!bl) {
                if (n4 >= 0) {
                    if (n4 != 13) {
                        cArray2[n7++] = (char)n4;
                        continue;
                    }
                    bl = true;
                    cArray2[n7++] = 10;
                    continue;
                }
                --n5;
                break;
            }
            bl = false;
            if (n4 == 10) continue;
            if (n4 >= 0) {
                if (n4 == 13) {
                    n4 = 10;
                    bl = true;
                }
                cArray2[n7++] = (char)n4;
                continue;
            }
            --n5;
            break;
        }
        if (n5 == n6) {
            nArray[0] = n7;
            blArray[0] = bl;
            return n5;
        }
        while (n5 < n6) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            block22: {
                do {
                    if (n7 == n8) {
                        cArray2 = UTF8EncodingSupport.resize(cArray2);
                        cArray[0] = cArray2;
                        n8 <<= 1;
                    }
                    if ((n15 = byArray2[n5++]) < 0) break block22;
                    if (bl) {
                        bl = false;
                        if (n15 == 10) continue;
                    }
                    if (n15 == 13) {
                        n15 = 10;
                        bl = true;
                    }
                    cArray2[n7++] = (char)n15;
                } while (n5 != n6);
                nArray[0] = n7;
                blArray[0] = bl;
                return n5;
            }
            n4 = fgMultiByteLength[(n15 &= 0xFF) >> 3];
            if (n4 == 0) {
                this.charConversionFailure(1, n15, 0, 0, 0);
            }
            if (n5 - 1 + n4 > n6) {
                --n5;
                break;
            }
            int n16 = n15 & fgFirstByteValueMask[n4];
            if ((0xC0 & (n14 = byArray2[n5++] & 0xFF)) != 128) {
                this.charConversionFailure(2, n15, n14, 0, 0);
            }
            if (n4 == 2) {
                n16 = (n16 << 6) + (0x3F & n14);
                cArray2[n7++] = (char)n16;
                continue;
            }
            if ((0xC0 & (n13 = byArray2[n5++] & 0xFF)) != 128) {
                this.charConversionFailure(3, n15, n14, n13, 0);
            }
            if (n4 == 3) {
                if ((n16 = (n16 << 12) + ((0x3F & n14) << 6) + (0x3F & n13)) >= 55296 && n16 < 57344) {
                    this.charConversionFailure(1, n15, n14, n13, 0);
                }
                cArray2[n7++] = (char)n16;
                continue;
            }
            if ((0xC0 & (n12 = byArray2[n5++] & 0xFF)) != 128) {
                this.charConversionFailure(4, n15, n14, n13, n12);
            }
            if ((n11 = (n16 << 8) + ((0x30 & n14) << 2)) > 1024 || n11 == 0) {
                CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n17 = n11 - 64;
            int n18 = 55296 + n17 + ((0xF & n14) << 2) + ((0x30 & n13) >> 4);
            int n19 = 56320 + ((0xF & n13) << 6) + (0x3F & n12);
            cArray2[n7++] = (char)n18;
            if (n7 == n8) {
                cArray2 = UTF8EncodingSupport.resize(cArray2);
                cArray[0] = cArray2;
                n8 <<= 1;
            }
            cArray2[n7++] = (char)n19;
        }
        nArray[0] = n7;
        blArray[0] = bl;
        return n5;
    }
}

