/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.copy;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.NamespaceContextHelper;
import com.ibm.xml.xci.dp.util.SinkCursor;
import com.ibm.xml.xci.dp.util.copy.CopierDelegate;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Copier {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile SOURCE_FEATURES = Cursor.Profile.MINIMAL_STREAMING_NAVIGATION;
    public static final Cursor.Profile TARGET_FEATURES = Cursor.Profile.MINIMAL_STREAMING_MUTATION;
    public static final int NODE_COPIED = 0;
    public static final int SUBTREE_COPIED = 1;
    public static final int FOLLOWING_COPIED = 2;
    public static final int SEQUENCE_COPIED = 4;
    public static final int OPTION_RELEASE_SOURCE = 1;
    public static final int OPTION_PRESERVE_PSVI = 2;
    public static final int OPTION_DISCARD_NS_DECLS = 4;
    public static final int OPTION_DISCARD_DEFAULT_ATTRIBUTE = 8;
    public static final int OPTION_RELEASE_TARGET = 16;
    public static final int OPTION_STRING_VALUE = 32;
    public static final int OPTION_TYPED_VALUE = 64;
    private static final Logger logger = LoggerUtil.getLogger(Copier.class);
    private final boolean preservePSVI;
    private final boolean preserveDefaultAttribute;
    private final Cursor.CopyDataOptions dataCopy;
    protected final boolean discardNSDecls;

    public static void materialize(Cursor cursor2) {
        if (cursor2 != null) {
            Copier.copy(cursor2, new SinkCursor(cursor2.factory()), Cursor.Area.FIRST_CHILD);
        }
    }

    public static void copy(Cursor cursor2, Cursor cursor3) {
        Copier.copy(cursor2, cursor3, Cursor.Area.FIRST_CHILD);
    }

    public static void copy(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        Copier.copy(cursor2, cursor3, area, 17);
    }

    public static void copy(Cursor cursor2, Cursor cursor3, Cursor.Area area, int n2) {
        Copier.copy(cursor2, cursor3, area, n2, null);
    }

    public static void copy(Cursor cursor2, Cursor cursor3, Cursor.Area area, int n2, ItemCopier itemCopier) {
        if (cursor2 != null) {
            assert (SOURCE_FEATURES.containedIn(cursor2.profile())) : "Insufficient source features for copy!";
            assert (cursor3 != null) : "Cannot copy into empty target sequence, only document and element parents!";
            assert (TARGET_FEATURES.containedIn(cursor3.profile())) : "Insufficient target features for copy!";
            if (cursor2.itemKind() == 9 && !cursor2.toChildren(null)) {
                return;
            }
            boolean bl = cursor3.openMutation(Cursor.Area.SUBTREE);
            Copier copier = itemCopier == null ? new Copier(n2) : new CopierDelegate(n2, itemCopier);
            copier.copySequence2Content(cursor2, cursor3, area);
            if (bl) {
                cursor3.closeMutation();
            }
            if ((n2 & 1) != 0) {
                cursor2.release();
            }
            if ((n2 & 0x10) != 0) {
                cursor3.release();
            }
        }
    }

    public static Cursor.Profile sourceProfile(ItemCopier itemCopier) {
        if (itemCopier != null) {
            return itemCopier.sourceProfile();
        }
        return SOURCE_FEATURES;
    }

    public static Cursor.Profile targetProfile(Cursor.Area area, ItemCopier itemCopier) {
        if (itemCopier != null) {
            return itemCopier.targetProfile(area);
        }
        return TARGET_FEATURES;
    }

    protected Copier(int n2) {
        this.preservePSVI = (n2 & 2) != 0;
        this.preserveDefaultAttribute = (n2 & 8) == 0;
        boolean bl = this.discardNSDecls = (n2 & 4) != 0;
        this.dataCopy = (n2 & 0x20) != 0 && (n2 & 0x40) != 0 ? Cursor.CopyDataOptions.ALL : ((n2 & 0x20) != 0 ? Cursor.CopyDataOptions.LEXICAL : ((n2 & 0x40) != 0 ? Cursor.CopyDataOptions.TYPE : Cursor.CopyDataOptions.ALL));
    }

    protected int copySequence2Content(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        int n2 = this.copyNode(cursor2, cursor3, area);
        if (n2 == 2) {
            return 2;
        }
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                cursor3.toChildren(null);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                cursor3 = cursor3.fork(false, cursor3.profile(), cursor3.futureProfile());
                cursor3.toNext();
                break;
            }
            case LAST_CHILD: {
                cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                cursor3.toChildren(null);
                while (cursor3.toNext()) {
                }
                break;
            }
            case ATTRIBUTE: {
                if (this.preservePSVI) {
                    Cursor cursor4 = cursor3.fork(true);
                    cursor4.toAttributes(null);
                    cursor4.setItemPSVI(cursor2.itemXSPSVInfo());
                    cursor4.release();
                }
                cursor3 = cursor3.fork(false, cursor3.profile(), cursor3.futureProfile());
                break;
            }
            case NAMESPACE_DECLS: {
                cursor3 = cursor3.fork(false, cursor3.profile(), cursor3.futureProfile());
                break;
            }
            default: {
                assert (false) : "Impossible WHERE parameter to copySequence2Content: " + area.toString();
                break;
            }
        }
        if (this.preservePSVI && cursor2.itemKind() == 1) {
            cursor3.setItemPSVI(cursor2.itemXSPSVInfo());
        }
        if (n2 == 0 && cursor2.itemKind() == 1) {
            n2 = this.copyContents(cursor2, cursor3);
        }
        if (n2 == 2) {
            return 2;
        }
        if (n2 != 4) {
            while (cursor2.toNext()) {
                n2 = this.copyNode(cursor2, cursor3, Cursor.Area.FOLLOWING_SIBLING);
                cursor3.toNext();
                if (this.preservePSVI && (cursor2.itemKind() == 1 || cursor2.itemKind() == 2)) {
                    cursor3.setItemPSVI(cursor2.itemXSPSVInfo());
                }
                if (n2 == 0 && cursor2.itemKind() == 1) {
                    n2 = this.copyContents(cursor2, cursor3);
                }
                if (n2 != 2) continue;
                return 2;
            }
        }
        cursor3.release();
        return 1;
    }

    protected int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        switch (cursor2.itemKind()) {
            case 2: {
                Cursor.ItemValueOrigin itemValueOrigin = cursor2.itemAttributeValueOrigin();
                if (!this.preserveDefaultAttribute && itemValueOrigin != Cursor.ItemValueOrigin.UNKNOWN && itemValueOrigin != Cursor.ItemValueOrigin.SPECIFIED) break;
                if (this.dataCopy == Cursor.CopyDataOptions.LEXICAL) {
                    XSTypeDefinition xSTypeDefinition = cursor2.itemXSType();
                    if (xSTypeDefinition instanceof XSSimpleTypeDefinition && ((XSSimpleTypeDefinition)xSTypeDefinition).getBuiltInKind() == 19) {
                        cursor3.addAttribute(cursor2.itemName(), cursor2.itemTypedValue());
                        break;
                    }
                    cursor3.addAttribute(cursor2.itemName(), cursor2.itemStringValueAsChars());
                    break;
                }
                if (this.dataCopy == Cursor.CopyDataOptions.TYPE) {
                    cursor3.addAttribute(cursor2.itemName(), cursor2.itemTypedValue().stripOriginalLexicalValue(false));
                    break;
                }
                CData cData = cursor2.itemTypedValue().constant(false);
                cursor3.addAttribute(cursor2.itemName(), cData);
                break;
            }
            case 1: {
                cursor3.addElement(area, cursor2.itemName(), cursor2.itemXSType());
                break;
            }
            case 3: {
                cursor3.addText(area, cursor2.itemStringValueAsChars());
                break;
            }
            case 8: {
                cursor3.addComment(area, cursor2.itemStringValueAsChars());
                break;
            }
            case 7: {
                cursor3.addProcessingInstruction(area, cursor2.itemName(), cursor2.itemStringValueAsChars());
                break;
            }
            case 4: {
                VolatileCData volatileCData = cursor2.itemName();
                String string2 = !volatileCData.isEmptySequence() ? volatileCData.getQNameLocalPart(1) : null;
                CData cData = cursor2.factory().data((CharSequence)(string2 != null ? string2 : ""), null, false);
                cursor3.addNamespaceNode(cData, cursor2.itemStringValue(), true);
                break;
            }
            case 9: {
                break;
            }
            default: {
                assert (false) : "Invalid focus kind:" + cursor2.itemKind();
                break;
            }
        }
        return 0;
    }

    protected int copyContents(Cursor cursor2, Cursor cursor3) {
        int n2;
        Cursor cursor4;
        Cursor cursor5;
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        if (bl && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "copyContents", "About to copy the contents from source node=" + cursor2.toString());
        }
        if ((cursor5 = cursor2.fork(true)).toNamespaceDecls() && !this.discardNSDecls) {
            do {
                this.copyNode(cursor5, cursor3, Cursor.Area.FOLLOWING_SIBLING);
            } while (cursor5.toNext());
        }
        cursor5.release();
        if (this.discardNSDecls) {
            Copier.fixupNamespace(cursor2, cursor3);
        }
        if ((cursor4 = cursor2.fork(true)).toAttributes(null)) {
            do {
                this.copyNode(cursor4, cursor3, Cursor.Area.FOLLOWING_SIBLING);
                if (!this.discardNSDecls) continue;
                Copier.fixupNamespace(cursor4, cursor3);
            } while (cursor4.toNext());
        }
        cursor4.release();
        if (TypeHelper.isSimple(cursor2.itemXSType())) {
            if (this.dataCopy == Cursor.CopyDataOptions.LEXICAL) {
                Chars chars = cursor2.itemStringValueAsChars();
                if (chars.length() != 0) {
                    cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                    cursor3.toChildren(null);
                    cursor3.addText(Cursor.Area.FIRST_CHILD, chars.constant(false));
                    cursor3.release();
                }
            } else if (this.dataCopy == Cursor.CopyDataOptions.TYPE) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                if (!volatileCData.isEmptySequence()) {
                    cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                    cursor3.toChildren(null);
                    cursor3.addText(Cursor.Area.FIRST_CHILD, volatileCData.stripOriginalLexicalValue(false));
                    cursor3.release();
                }
            } else {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                if (!volatileCData.isEmptySequence()) {
                    cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                    cursor3.toChildren(null);
                    cursor3.addText(Cursor.Area.FIRST_CHILD, volatileCData.constant(false));
                    cursor3.release();
                }
            }
            n2 = 1;
        } else {
            Cursor cursor6 = cursor2.fork(true);
            n2 = cursor6.toChildren(null) ? this.copySequence2Content(cursor6, cursor3, Cursor.Area.FIRST_CHILD) : 1;
            cursor6.release();
        }
        return n2;
    }

    public static void fixupNamespace(Cursor cursor2, Cursor cursor3) {
        VolatileCData volatileCData = cursor2.itemName();
        String string2 = volatileCData.getQNamePrefix(1);
        if (string2 != null && string2.length() > 0) {
            CharSequence charSequence;
            Cursor cursor4 = cursor3.fork(true);
            boolean bl = false;
            while (cursor4.toParent()) {
                if (cursor4.itemKind() != 1 || (charSequence = cursor4.itemName().getQNamePrefix(1)) == null || !((String)charSequence).equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                charSequence = new StringCData(string2, TypeRegistry.XSSTRING);
                StringCData stringCData = new StringCData(NamespaceContextHelper.getNamespaceURI(cursor2, string2), TypeRegistry.XSSTRING);
                cursor3.addNamespaceNode((VolatileCData)charSequence, stringCData, false);
            }
        }
    }
}

