/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;

public class XCIXpathGenerator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static Cursor.Profile myProfile = Cursor.Profile.RANDOM_ACCESS.union(Cursor.Profile.RANDOM_ACCESS).union(Cursor.Profile.TO_NODE_TEST);

    public static void main(String[] stringArray) throws FileNotFoundException {
        SessionContext sessionContext = new SessionContext();
        FileInputStream fileInputStream = new FileInputStream("../xci/testsrc/com/ibm/xml/xq/dm/test/catalog1.xml");
        Cursor cursor2 = sessionContext.document(new StreamSource(fileInputStream), new RequestInfo(myProfile));
        if (cursor2.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("catalog"), TypeRegistry.XSQNAME, false))) && cursor2.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("Item"), TypeRegistry.XSQNAME, false)))) {
            do {
                Cursor cursor3 = cursor2.fork(false, myProfile, myProfile);
                cursor3.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("name"), TypeRegistry.XSQNAME, false)));
                cursor3.toChildren(null);
                Cursor cursor4 = cursor2.fork(false, myProfile, myProfile);
                cursor4.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("productNumber"), TypeRegistry.XSQNAME, false)));
                cursor4.toChildren(null);
                Cursor cursor5 = cursor2.fork(false, myProfile, myProfile);
                cursor5.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("price"), TypeRegistry.XSQNAME, false)));
                cursor5.toChildren(null);
                System.out.println(XCIXpathGenerator.nodeToXPath(cursor3) + " has value " + cursor3.itemTypedValue().getString(1) + "\n" + XCIXpathGenerator.nodeToXPath(cursor4) + " has value " + cursor4.itemTypedValue().getString(1) + "\n" + XCIXpathGenerator.nodeToXPath(cursor5) + " has value " + cursor5.itemTypedValue().getString(1));
                cursor3.release();
                cursor4.release();
                cursor5.release();
            } while (cursor2.toNext());
        }
        cursor2.release();
    }

    public static String nodeToXPath(Cursor cursor2) {
        StringBuilder stringBuilder = XCIXpathGenerator.nodeToXpath(cursor2, new StringBuilder());
        if (stringBuilder.length() == 0) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    private static StringBuilder nodeToXpath(Cursor cursor2, StringBuilder stringBuilder) {
        Cursor cursor3;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if ((cursor3 = XCIXpathGenerator.getAxisCursor(cursor2, Axis.PARENT)) != null) {
            XCIXpathGenerator.nodeToXpath(cursor3, stringBuilder);
            cursor3.release();
        } else if (cursor2.itemKind() != 9 && stringBuilder.length() != 0 && stringBuilder.charAt(0) == '/') {
            stringBuilder.deleteCharAt(0);
        }
        switch (cursor2.itemKind()) {
            case 0: {
                throw new IllegalArgumentException(XCIMessages.createXCIMessage("ER_XPATH_FOR_NON_NODE", new String[]{cursor2.toString(), cursor2.itemXSType().getName()}));
            }
            case 9: {
                break;
            }
            case 3: {
                stringBuilder.append("/text()[");
                stringBuilder.append(XCIXpathGenerator.sibindex(cursor2));
                stringBuilder.append("]");
                break;
            }
            case 8: {
                stringBuilder.append("/comment()[");
                stringBuilder.append(XCIXpathGenerator.sibindex(cursor2));
                stringBuilder.append("]");
                break;
            }
            case 1: {
                QName qName = cursor2.itemName().getQName(1, null);
                if ("".equals(qName.getNamespaceURI())) {
                    stringBuilder.append("/").append(qName.getLocalPart()).append('[');
                } else {
                    stringBuilder.append("/*[local-name()='");
                    stringBuilder.append(qName.getLocalPart());
                    stringBuilder.append("' and namespace-uri()='");
                    stringBuilder.append(qName.getNamespaceURI());
                    stringBuilder.append("'][");
                }
                stringBuilder.append(XCIXpathGenerator.sibindex(cursor2));
                stringBuilder.append("]");
                break;
            }
            case 2: {
                QName qName = cursor2.itemName().getQName(1, null);
                if ("".equals(qName.getNamespaceURI())) {
                    stringBuilder.append("/@").append(qName.getLocalPart());
                    break;
                }
                stringBuilder.append("/@*[local-name()='");
                stringBuilder.append(qName.getLocalPart());
                stringBuilder.append("' and namespace-uri()='");
                stringBuilder.append(qName.getNamespaceURI());
                stringBuilder.append("']");
                break;
            }
            case 4: {
                QName qName = cursor2.itemName().getQName(1, null);
                stringBuilder.append("/namespace::");
                stringBuilder.append(qName.getPrefix());
                break;
            }
            case 7: {
                QName qName = cursor2.itemName().getQName(1, null);
                stringBuilder.append("processing-instruction(");
                String string2 = qName.getPrefix();
                if (string2 != null && string2.length() > 0) {
                    stringBuilder.append(string2).append(':');
                }
                stringBuilder.append(qName.getLocalPart());
                stringBuilder.append(")[");
                stringBuilder.append(XCIXpathGenerator.sibindex(cursor2));
                stringBuilder.append("]");
            }
        }
        return stringBuilder;
    }

    private static int sibindex(Cursor cursor2) {
        VolatileCData volatileCData = cursor2.itemName();
        QName qName = volatileCData == null ? null : volatileCData.getQName(1, null);
        int n2 = 1;
        short s = cursor2.itemKind();
        Cursor cursor3 = XCIXpathGenerator.getAxisCursor(cursor2, Axis.PRECEDINGSIBLING);
        if (cursor3 != null) {
            do {
                VolatileCData volatileCData2;
                QName qName2;
                QName qName3 = qName2 = (volatileCData2 = cursor3.itemName()) == null || volatileCData2.isEmptySequence() ? null : volatileCData2.getQName(1, null);
                if (cursor3.itemKind() != s || (qName2 != null || qName != null) && (qName2 == null || !qName2.equals(qName))) continue;
                ++n2;
            } while (cursor3.toNext());
            cursor3.release();
        }
        return n2;
    }

    private static Cursor getAxisCursor(Cursor cursor2, Axis axis) {
        SessionContext sessionContext = cursor2.factory().getSessionContext();
        Executable executable = sessionContext.getPreparer().prepare(axis, null, null, -1);
        Cursor cursor3 = executable.execute(cursor2, null, Cursor.Profile.SEQUENCE, null);
        return cursor3;
    }
}

