/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.errors.XCIIllegalContextItemException;
import com.ibm.xml.xci.errors.XCIIllegalMutationException;
import com.ibm.xml.xci.errors.XCIIllegalStateException;
import com.ibm.xml.xci.exec.SourceLocation;
import com.ibm.xml.xci.res.XCIMessages;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.Location;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.Node;

public class XCIErrorHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static XCIIllegalContextItemException createBadContextItemException(short s) {
        return new XCIIllegalContextItemException(XCIMessages.createXCIMessage("ER_ILLEGAL_CONTEXT_ITEM", new String[]{XCIErrorHelper.getNodeKindString(s)}));
    }

    public static XCIIllegalContextItemException createBadContextItemException(String string2, short s) {
        return new XCIIllegalContextItemException(XCIMessages.createXCIMessage("ER_ILLEGAL_CONTEXT_ITEM_FOR_OP", new String[]{string2, XCIErrorHelper.getNodeKindString(s)}));
    }

    public static XCIIllegalArgumentException createBadArgumentException(String string2) {
        return new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_ILLEGAL_ARGS_WITHOUT_VALUE", new String[]{string2}));
    }

    public static XCIIllegalArgumentException createBadArgumentException(String string2, String string3) {
        return new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_ILLEGAL_ARGS", new String[]{string3, string2}));
    }

    public static XCIDynamicErrorException createInternalException(Exception exception) {
        return new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ADAPTER_INTERNAL_ERR", new String[]{exception.getMessage()}), exception);
    }

    public static XCIDynamicErrorException createInternalException(String string2) {
        return new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ADAPTER_INTERNAL_ERR", new String[]{string2}));
    }

    public static XCIDynamicErrorException createBadQNameException(String string2) {
        return new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_NONAMESPACEINCONTEXT", new String[]{string2}));
    }

    public static XCIIllegalMutationException createBadMutationCombination(short s) {
        return new XCIIllegalMutationException(XCIMessages.createXCIMessage("ER_ILLEGAL_MUTATION_RELATIVE_TO_AREA", new String[]{XCIErrorHelper.getNodeKindString(s)}));
    }

    public static XCIIllegalMutationException createBadMutationCombination(short s, short s2) {
        return new XCIIllegalMutationException(XCIMessages.createXCIMessage("ER_ILLEGAL_ADD_NODE_RELATIVE_TO_AREA", new String[]{XCIErrorHelper.getNodeKindString(s), XCIErrorHelper.getNodeKindString(s2)}));
    }

    public static XCIIllegalStateException createIllegalStateException(String string2) {
        return new XCIIllegalStateException(XCIMessages.createXCIMessage("ER_ILLEGAL_STATE_OPEN_MUTATION", new String[]{string2}));
    }

    public static DOMException createDOMException(short s) {
        return new DOMException(s, XCIMessages.createXCIMessage(XCIErrorHelper.DOMId2String(s), null));
    }

    public static String DOMId2String(short s) {
        switch (s) {
            case 2: {
                return "ER_DOMSTRING_SIZE";
            }
            case 3: {
                return "ER_HIERARCHY_REQUEST";
            }
            case 1: {
                return "ER_INDEX_SIZE";
            }
            case 10: {
                return "ER_INUSE_ATTRIBUTE";
            }
            case 15: {
                return "ER_INVALID_ACCESS";
            }
            case 5: {
                return "ER_INVALID_CHARACTER";
            }
            case 13: {
                return "ER_INVALID_MODIFICATION";
            }
            case 11: {
                return "ER_INVALID_STATE";
            }
            case 14: {
                return "ER_NAMESPACE";
            }
            case 8: {
                return "ER_NOT_FOUND";
            }
            case 9: {
                return "ER_NOT_SUPPORTED";
            }
            case 6: {
                return "ER_NO_DATA_ALLOWED";
            }
            case 7: {
                return "ER_NO_MODIFICATION_ALLOWED";
            }
            case 12: {
                return "ER_SYNTAX";
            }
            case 16: {
                return "ER_VALIDATION";
            }
            case 4: {
                return "ER_WRONG_DOCUMENT";
            }
            case 17: {
                return "ER_TYPE_MISMATCH";
            }
        }
        return "ER_NOT_SUPPORTED";
    }

    public static boolean addElementOrTextCheck(Cursor.Area area, short s) {
        switch (s) {
            case 3: 
            case 7: 
            case 8: {
                return area == Cursor.Area.FOLLOWING_SIBLING;
            }
            case 9: {
                return area == Cursor.Area.FIRST_CHILD || area == Cursor.Area.LAST_CHILD;
            }
            case 1: {
                return area == Cursor.Area.FIRST_CHILD || area == Cursor.Area.LAST_CHILD || area == Cursor.Area.FOLLOWING_SIBLING;
            }
        }
        return false;
    }

    public static boolean removeSubtreeCheck(Cursor.Area area, short s) {
        switch (s) {
            case 3: 
            case 7: 
            case 8: {
                return area == Cursor.Area.FOLLOWING_SIBLING || area == Cursor.Area.SELF;
            }
            case 9: {
                return area == Cursor.Area.FIRST_CHILD || area == Cursor.Area.LAST_CHILD;
            }
            case 1: {
                return area == Cursor.Area.FIRST_CHILD || area == Cursor.Area.LAST_CHILD || area == Cursor.Area.FOLLOWING_SIBLING || area == Cursor.Area.SELF;
            }
        }
        return false;
    }

    public static boolean checkDisallowedKind(short s, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            if (s != sArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllowedKind(short s, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            if (s != sArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllowedArea(Cursor.Area area, Cursor.Area[] areaArray) {
        for (int i = 0; i < areaArray.length; ++i) {
            if (area != areaArray[i]) continue;
            return true;
        }
        return false;
    }

    public static String getNodeKindString(short s) {
        switch (s) {
            case 9: {
                return "DOCUMENT_KIND";
            }
            case 1: {
                return "ELEMENT_KIND";
            }
            case 2: {
                return "ATTRIBUTE_KIND";
            }
            case 4: {
                return "NAMESPACE_DECL_KIND";
            }
            case 8: {
                return "COMMENT_KIND";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION_KIND";
            }
            case 3: {
                return "TEXT_KIND";
            }
        }
        return "";
    }

    public static SourceLocation locationTransformer(Location location) {
        return new SourceLocation(location.getSystemId(), location.getPublicId(), -1, -1, location.getLineNumber(), location.getColumnNumber());
    }

    public static boolean pushInstanceException(SessionContext sessionContext, Exception exception, short s) {
        return sessionContext.getErrorHandler().handleError(new XCIErrorImpl(exception, s));
    }

    public static String getStackTrace(int n2) {
        StackTraceElement[] stackTraceElementArray = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] run() {
                return Thread.currentThread().getStackTrace();
            }
        });
        int n3 = stackTraceElementArray.length <= n2 + 3 ? stackTraceElementArray.length - 3 : n2;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (int i = 6; i < n3 + 3; ++i) {
                stringBuilder.append(stackTraceElementArray[i].toString());
                stringBuilder.append(" ; \n  ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static final class XCIErrorLocator
    implements DOMLocator {
        public int byteOffset = -1;
        public int columnNumber = -1;
        public int lineNumber = -1;
        public Node relatedNode = null;
        public String URI = null;
        public int utf16Offset = -1;

        public XCIErrorLocator(SourceLocation sourceLocation) {
            this.columnNumber = sourceLocation.getEndColumn();
            this.lineNumber = sourceLocation.getEndLine();
            this.URI = sourceLocation.getSystemId();
        }

        public int getByteOffset() {
            return this.byteOffset;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public Node getRelatedNode() {
            return this.relatedNode;
        }

        public String getUri() {
            return this.URI;
        }

        public int getUtf16Offset() {
            return this.utf16Offset;
        }
    }

    public static final class XCIErrorImpl
    implements DOMError {
        public DOMLocator locator = null;
        public Exception exception = null;
        public String relatedDataType = null;
        public Object relatedData = null;
        public short severity;
        public String message = null;

        public XCIErrorImpl(Exception exception, short s) {
            this(exception, s, null, null);
        }

        public XCIErrorImpl(Exception exception, short s, Object object2, String string2) {
            this.exception = exception;
            this.severity = s;
            this.relatedData = object2;
            this.relatedDataType = string2;
            this.buildLocator();
        }

        private void buildLocator() {
            if (this.exception == null || !(this.exception instanceof XCIDynamicErrorException)) {
                return;
            }
            SourceLocation sourceLocation = ((XCIDynamicErrorException)this.exception).getLocation();
            if (sourceLocation != null) {
                this.locator = new XCIErrorLocator(sourceLocation);
            }
        }

        public DOMLocator getLocation() {
            return this.locator;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getRelatedData() {
            return this.relatedData;
        }

        public Object getRelatedException() {
            return this.exception;
        }

        public short getSeverity() {
            return this.severity;
        }

        public String getType() {
            return this.relatedDataType;
        }
    }
}

