/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.dp.util.SingletonListCursor;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonListReversedCursor
extends SingletonListCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    private SingletonListReversedCursor(List<Cursor> list) {
        super(list);
    }

    private SingletonListReversedCursor(Cursor cursor2, boolean bl) {
        super(cursor2, bl);
        this.position = this.list.size();
    }

    @Override
    public boolean toPosition(long l) {
        if (this.state == SingletonListCursor.State.other) {
            return super.toPosition(l);
        }
        assert ((long)this.position < Integer.MAX_VALUE) : "Cannot handle positions beyond int range.";
        if (l >= 1L && l <= (long)this.list.size()) {
            this.position = (int)((long)this.list.size() - (l - 1L)) + 1;
            assert (((Cursor)this.list.get(this.position - 1)).contextIsSingleton()) : "SingletonList can only contain singletons.";
            return true;
        }
        return false;
    }

    @Override
    public boolean toNext() {
        if (this.state == SingletonListCursor.State.other) {
            return super.toNext();
        }
        if (this.position > 1) {
            --this.position;
            assert (((Cursor)this.list.get(this.position - 1)).contextIsSingleton()) : "SingletonList can only contain singletons.";
            return true;
        }
        return false;
    }

    @Override
    protected int getSequenceContextPosition() {
        int n2 = this.list.size() - this.position + 1;
        assert (n2 > 0);
        return n2;
    }

    @Override
    protected SingletonListCursor dupThis(List<Cursor> list) {
        return new SingletonListReversedCursor(list);
    }

    @Override
    public boolean toPrevious() {
        if (this.state == SingletonListCursor.State.other) {
            return super.toPrevious();
        }
        if (this.position < this.list.size()) {
            ++this.position;
            assert (((Cursor)this.list.get(this.position - 1)).contextIsSingleton()) : "SingletonList can only contain singletons.";
            return true;
        }
        return false;
    }
}

