/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.EmptyCData;
import com.ibm.xml.xci.internal.util.FlattenedMapEntryIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceContextHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile ITEM_NAMESPACE_CONTEXT_PROFILE = Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_PARENT);

    public static Iterator<String> getInScopeNamespaces(Cursor cursor2) {
        HashMap<String, String> hashMap = NamespaceContextHelper.inscopeNamespaces(cursor2);
        return new FlattenedMapEntryIterator<String>(hashMap.entrySet().iterator());
    }

    public static String getNamespaceURI(Cursor cursor2, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (string2.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string2.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        cursor2 = cursor2.fork(true, ITEM_NAMESPACE_CONTEXT_PROFILE, ITEM_NAMESPACE_CONTEXT_PROFILE);
        cursor2.toSelf();
        if (cursor2.itemKind() != 1) {
            cursor2.toParent();
        }
        if (cursor2.itemKind() != 1) {
            return null;
        }
        String string3 = null;
        boolean bl = true;
        boolean bl2 = "".equals(string2);
        do {
            if (cursor2.toNamespaceDecls()) {
                do {
                    VolatileCData volatileCData;
                    if (((volatileCData = cursor2.itemName()) != null || !bl2) && !volatileCData.getQNameLocalPart(1).equals(string2)) continue;
                    string3 = cursor2.itemTypedValue().getString(1);
                    bl = false;
                    break;
                } while (cursor2.toNext());
                cursor2.toParent();
            }
            if (string3 != null || cursor2.itemKind() != 1 || !string2.equals(cursor2.itemName().getQNamePrefix(1))) continue;
            string3 = cursor2.itemName().getQNameNamespaceURI(1);
        } while ((string3 == null || bl) && cursor2.toParent());
        cursor2.release();
        return string3;
    }

    public static String getPrefix(Cursor cursor2, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string2)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
            return "xmlns";
        }
        if (cursor2.itemKind() != 1) {
            cursor2.toParent();
        }
        if (cursor2.itemKind() != 1) {
            return null;
        }
        String string3 = null;
        boolean bl = true;
        do {
            if (cursor2.toNamespaceDecls()) {
                do {
                    if (!string2.equals(cursor2.itemTypedValue().getString(1))) continue;
                    string3 = cursor2.itemName() == null ? cursor2.itemTypedValue().getString(1) : null;
                    break;
                } while (cursor2.toNext());
                cursor2.toParent();
            }
            if (string3 != null || !string2.equals(cursor2.itemTypedValue().getString(1))) continue;
            string3 = cursor2.itemName().getQNameLocalPart(1);
        } while ((string3 == null || bl) && cursor2.toParent());
        cursor2.release();
        return string3;
    }

    public static Iterator<String> getPrefixes(Cursor cursor2, String string2) {
        HashMap<String, String> hashMap = NamespaceContextHelper.inscopeNamespaces(cursor2);
        return hashMap.keySet().iterator();
    }

    public static ExtendedNamespaceContext constant(Cursor cursor2, boolean bl) {
        return new ConstantNamespaceContext(NamespaceContextHelper.inscopeNamespaces(cursor2));
    }

    private static final HashMap<String, String> inscopeNamespaces(Cursor cursor2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(){

            @Override
            public final String put(String string2, String string3) {
                String string4 = super.put(string2, string3);
                if (string4 != null) {
                    super.put(string2, string4);
                }
                return null;
            }
        };
        cursor2 = cursor2.fork(true, ITEM_NAMESPACE_CONTEXT_PROFILE, ITEM_NAMESPACE_CONTEXT_PROFILE);
        do {
            String string2;
            CharSequence charSequence;
            if (cursor2.itemKind() != 1) continue;
            if (cursor2.toNamespaceDecls()) {
                do {
                    string2 = (charSequence = cursor2.itemName()) instanceof EmptyCData ? "" : charSequence.getQNameLocalPart(1);
                    String string3 = cursor2.itemTypedValue().getString(1);
                    hashMap.put(string2, string3);
                } while (cursor2.toNext());
                cursor2.toParent();
            }
            if (cursor2.itemName().getQNameNamespaceURI(1) == null) continue;
            charSequence = cursor2.itemName().getQNamePrefix(1);
            string2 = cursor2.itemName().getQNameNamespaceURI(1);
            hashMap.put((String)charSequence, string2);
        } while (cursor2.toParent());
        cursor2.release();
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstantNamespaceContext
    implements ExtendedNamespaceContext {
        protected final Map<String, String> namespaces;

        ConstantNamespaceContext(Map<String, String> map2) {
            this.namespaces = map2;
        }

        @Override
        public ExtendedNamespaceContext constantENS(boolean bl) {
            return this;
        }

        @Override
        public Iterator<String> getInScopeNamespaces() {
            return new FlattenedMapEntryIterator<String>(this.namespaces.entrySet().iterator());
        }

        @Override
        public String getNamespaceURI(String string2) {
            return this.namespaces.get(string2);
        }

        @Override
        public String getPrefix(String string2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> getPrefixes(String string2) {
            throw new UnsupportedOperationException();
        }
    }
}

