/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.serializer.HiddenOptions;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForkReleaseTracker<E> {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\n\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final boolean JUSTCHECKEVERYTHINGANDSTOPIFSOMETHINGSWRONG = false;
    public static final String DEBUG_FORK_RELEASE_OPTION = "forkdebug";
    public static final boolean _DEBUG_FORK_RELEASE = HiddenOptions.optionValueIs("forkdebug", "on");
    public static final String _DEBUG_FORK_RELEASE_TRACKING_OPTION = "forktrace";
    public static final boolean _DEBUG_FORK_RELEASE_TRACKING = HiddenOptions.optionValueIs("forktrace", "on");
    public static final String _WATCHFOR_INSTANCE_OPTION = "forkwatchfor";
    public static final long _WATCHFOR_INSTANCE = HiddenOptions.getLongValue("forkwatchfor", -1L);
    public static final String TRACKRELEASESTACKS_OPTION = "forktrackback";
    public static final boolean TRACKRELEASESTACKS = HiddenOptions.optionValueIs("forktrackback", "on");
    public static final String EXITONFORKRELEASEERROR_OPTION = "forkexitiferror";
    public static final boolean EXITONFORKRELEASEERROR = HiddenOptions.optionValueIs("forkexitiferror", "on");
    public static final String RECORDANDREPORTFORKUSAGE_OPTION = "forkreport";
    public static final boolean RECORDANDREPORTFORKUSAGE = HiddenOptions.optionValueIs("forkreport", "on");
    public long _DEBUG_INSTANCE_COUNTER = 0L;
    public long _DEBUG_RELEASE_COUNTER = 0L;
    public long cursorCreationCount = 0L;
    public Vector<E> _heldCursors;
    public HashMap<String, CallRecord> forkCalls = new HashMap();
    public static ForkReleaseTracker<Cursor> forkReleaseTracker;
    public static final String RECORDANDREPORTFORKUSAGEFORMATOPTION = "reportFormat";
    public static final String RECORDANDREPORTFORKUSAGEFORMAT;
    static final boolean wikiTableFormat;
    static final boolean htmlTableFormat;
    static final boolean csvTableFormat;
    static final String REPORTPREFIX = "cursors";
    static final String REPORTSUFIX;

    public void _WATCHFOR(long l, String string2) {
        if (_DEBUG_FORK_RELEASE && l == _WATCHFOR_INSTANCE) {
            System.err.println("DBG: Cursor Convenient breakpoint: " + string2 + " instance " + _WATCHFOR_INSTANCE);
        }
    }

    public void _CLEAR_COUNTS(boolean bl) {
        if (bl) {
            this._DEBUG_INSTANCE_COUNTER = 0L;
            this._DEBUG_RELEASE_COUNTER = 0L;
        }
        if (null != this._heldCursors) {
            this._heldCursors.clear();
            this._heldCursors = null;
        }
    }

    public synchronized long _DEBUG_NEXT_INSTANCE() {
        return ++this._DEBUG_INSTANCE_COUNTER;
    }

    public synchronized void _DEBUG_RELEASE_INSTANCE() {
        ++this._DEBUG_RELEASE_COUNTER;
    }

    public long DEBUG_REPORT_TOTAL_INSTANCES() {
        return this._DEBUG_INSTANCE_COUNTER;
    }

    public long DEBUG_REPORT_IMBALANCE() {
        return this._DEBUG_INSTANCE_COUNTER - this._DEBUG_RELEASE_COUNTER;
    }

    static boolean createForkReleaseTracker() {
        forkReleaseTracker = new ForkReleaseTracker();
        return true;
    }

    public StackTraceElement[] recordCursorCreation(E e, long l) {
        if (_DEBUG_FORK_RELEASE) {
            this._WATCHFOR(l, "fork");
            if (_DEBUG_FORK_RELEASE_TRACKING) {
                System.err.println("DBG: " + e.getClass().getSimpleName() + " " + l + " ++");
            }
            if (TRACKRELEASESTACKS) {
                if (null == this._heldCursors) {
                    this._heldCursors = new Vector();
                }
                this._heldCursors.add(e);
                return AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

                    @Override
                    public StackTraceElement[] run() {
                        return Thread.currentThread().getStackTrace();
                    }
                });
            }
            ++ForkReleaseTracker.forkReleaseTracker.cursorCreationCount;
        }
        return null;
    }

    public StackTraceElement[] checkAndRecordRelease(boolean bl, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, long l, E e) {
        if (_DEBUG_FORK_RELEASE) {
            if (_DEBUG_FORK_RELEASE_TRACKING) {
                System.err.println("DBG: " + e.getClass().getSimpleName() + " " + l + " --");
            }
            this._WATCHFOR(l, "rel");
            if (bl) {
                System.err.println("DBG: " + e.getClass().getSimpleName() + " RELEASE ERROR! " + e.getClass().getSimpleName() + " reports double release of instance " + l);
                if (TRACKRELEASESTACKS && stackTraceElementArray != null) {
                    System.err.println(" ORIGINAL ");
                    this.printStackTraceElements(System.err, stackTraceElementArray);
                    System.err.println(" AND ");
                } else {
                    System.err.println("NO TRACE ON ORIGINAL RELEASE, BUT THIS RELEASE IS AT:");
                }
                StackTraceElement[] stackTraceElementArray3 = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

                    @Override
                    public StackTraceElement[] run() {
                        return Thread.currentThread().getStackTrace();
                    }
                });
                this.printStackTraceElements(System.err, stackTraceElementArray3);
                if (stackTraceElementArray2 != null) {
                    System.err.println(" AND WHERE IT WAS CREATED ");
                    this.printStackTraceElements(System.err, stackTraceElementArray2);
                } else {
                    System.err.println(" NO CREATION TRACE FOR " + e.getClass().getName());
                }
                if (EXITONFORKRELEASEERROR) {
                    System.exit(-1);
                }
            }
            if (TRACKRELEASESTACKS) {
                for (int i = this._heldCursors.size() - 1; i >= 0; --i) {
                    if (this._heldCursors.get(i) != e) continue;
                    this._heldCursors.remove(i);
                    break;
                }
                return AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

                    @Override
                    public StackTraceElement[] run() {
                        return Thread.currentThread().getStackTrace();
                    }
                });
            }
            this._DEBUG_RELEASE_INSTANCE();
        }
        return null;
    }

    public void printStackTraceElements(PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            printStream.print("  at ");
            printStream.print(stackTraceElement.getClassName());
            printStream.print('.');
            printStream.print(stackTraceElement.getMethodName());
            printStream.print('(');
            printStream.print(stackTraceElement.getFileName());
            printStream.print(':');
            printStream.print(stackTraceElement.getLineNumber());
            printStream.print(')');
            printStream.println(')');
        }
    }

    public void printStackTraceElements(StackTraceElement[] stackTraceElementArray) {
        this.printStackTraceElements(System.out, stackTraceElementArray);
    }

    public boolean checkDoubleRelease(boolean bl, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, long l) {
        if (_DEBUG_FORK_RELEASE && bl) {
            System.err.println("DBG: " + this.getClass().getSimpleName() + " RESOURCE ERROR! Forking previously released cursor " + l);
            if (stackTraceElementArray != null) {
                System.err.println("PREVIOUSLY RELEASED AT: ");
                this.printStackTraceElements(System.err, stackTraceElementArray);
            }
            System.err.println("TRYING TO FORK FROM: ");
            Exception exception = new Exception("Fork from Released Error");
            exception.printStackTrace();
            if (stackTraceElementArray2 != null) {
                System.err.println("CREATED AT: ");
                this.printStackTraceElements(System.err, stackTraceElementArray2);
            }
            if (EXITONFORKRELEASEERROR) {
                System.exit(-1);
            }
            return false;
        }
        return true;
    }

    protected CallRecord recordCursorCreationTrace(E e) {
        StackTraceElement[] stackTraceElementArray = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] run() {
                return Thread.currentThread().getStackTrace();
            }
        });
        boolean bl = false;
        String string2 = null;
        StackTraceElement stackTraceElement = null;
        CallRecord callRecord = null;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            String string3;
            String string4;
            StackTraceElement stackTraceElement2 = stackTraceElementArray[i];
            long l = stackTraceElement2.getLineNumber();
            if (l < 0L) continue;
            String string5 = stackTraceElement2.getMethodName();
            String string6 = stackTraceElement2.getClassName();
            int n2 = string6.lastIndexOf(46);
            String string7 = string4 = n2 > 0 ? string6.substring(n2 + 1) : string6;
            if (string4.equals("AbstractCursor") || string4.equals("ForkReleaseTracker") || string4.equals("ForkReleaseInstanceTracker") || string6.contains("com.ibm.xltxe.rnm1.fcg.") || string4.equals("Thread")) continue;
            String string8 = string4 + ":" + l;
            if (bl) continue;
            if (string5.equals("serialize") || string4.equals("Translet") && string5.equals("doEvaluate(") || string4.equals("CursorFactory") && string5.equals("document") || !string4.equals("Instruction") && string4.contains("Instruction") && !string5.contains("evaluate") || string4.contains("XDMSequenceWriterStream") || string4.contains("XSLTModule_")) {
                bl = true;
                string3 = string8 + " created " + e.getClass().getSimpleName() + " ";
                callRecord = this.forkCalls.get(string3);
                if (callRecord == null) {
                    callRecord = new CallRecord(stackTraceElement2, 1L, e.getClass());
                    this.forkCalls.put(string3, callRecord);
                    break;
                }
                ++callRecord.numberCalls;
                break;
            }
            if (string2 != null) continue;
            string2 = string3 = string8 + " created " + e.getClass().getSimpleName() + " ";
            stackTraceElement = stackTraceElement2;
        }
        if (!bl) {
            callRecord = this.forkCalls.get(string2);
            if (callRecord == null) {
                callRecord = new CallRecord(stackTraceElement, 1L, e.getClass());
                this.forkCalls.put(string2, callRecord);
            } else {
                ++callRecord.numberCalls;
            }
        }
        return callRecord;
    }

    public void printForkReport2() {
        String string2 = (String)HiddenOptions.getSpecificDebugOptOnTheFly("com.ibm.xltxe.rnm1.xylem.debugopt", "javeDestDir");
        if (string2 == null) {
            string2 = ".";
        }
        try {
            int n2;
            TreeSet<TableRow> treeSet;
            Object object2;
            System.out.println("Start fork report generation");
            System.out.flush();
            int n3 = 0;
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().startsWith(ForkReleaseTracker.REPORTPREFIX) && (file.getName().endsWith(".wiki") || file.getName().endsWith(".html") || file.getName().endsWith(".csv"));
                }
            };
            File file = new File(string2);
            if (file.exists()) {
                object2 = file.listFiles(fileFilter);
                int n4 = 0;
                for (int i = 0; i < ((File[])object2).length; ++i) {
                    File file2 = object2[i];
                    String string3 = file2.getName();
                    treeSet = string3.substring(REPORTPREFIX.length(), string3.indexOf("."));
                    try {
                        n2 = Integer.valueOf((String)((Object)treeSet));
                        if (n2 <= n4) continue;
                        n4 = n2;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                n3 = n4 + 1;
            } else {
                System.err.println("Can't print report because dir does not exist: " + string2);
            }
            object2 = new File(string2 + File.separator + REPORTPREFIX + n3 + REPORTSUFIX);
            PrintWriter printWriter = new PrintWriter(new FileWriter((File)object2));
            String string4 = (String)HiddenOptions.getSpecificDebugOptOnTheFly("com.ibm.xltxe.rnm1.xylem.debugopt", "fcgtracedepth");
            int n5 = null != string4 ? Integer.valueOf(string4) : 4;
            int n6 = 5;
            if (wikiTableFormat) {
                printWriter.println("h2. Sorted by Closest Generating Instruction");
                printWriter.println();
                printWriter.println("This table is sorted by the closest found instruction in that stack that generated the runtime code responsible for the cursor creation.  Note that negative releases are not taken into account for the active cursors total at the end of the table.");
                printWriter.println();
            }
            treeSet = this.prepareForkReport2(string2, n5, n6);
            n2 = this.getTableWidth(treeSet);
            String[] stringArray = new String[n2];
            int n7 = 0;
            stringArray[n7++] = "CALL POINT";
            stringArray[n7++] = "Line No.";
            stringArray[n7++] = "Type Created";
            stringArray[n7++] = "TIMES";
            stringArray[n7++] = "Active";
            stringArray[n7++] = "Closest Generating Instruction";
            for (int i = n7; i < stringArray.length; ++i) {
                stringArray[i] = "TraceBack" + (i - n7);
            }
            this.printForkReport2(stringArray, treeSet, printWriter, n5);
            if (wikiTableFormat) {
                printWriter.println();
                printWriter.println();
                printWriter.println("h2. Sorted by Cursor class created/forked");
                printWriter.println();
                printWriter.println("This table is sorted by the Cursor classes that were created at runtime.  Note that negative releases are not taken into account for the active cursors total at the end of the table.");
                printWriter.println();
                n6 = 2;
                treeSet = this.prepareForkReport2(string2, n5, n6);
                this.printForkReport2(stringArray, treeSet, printWriter, n5);
            }
            printWriter.close();
            System.out.println("Fork report generation complete: " + object2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private TreeSet<TableRow> prepareForkReport2(String string2, int n2, int n3) {
        HashMap<String, CallRecord> hashMap = this.forkCalls;
        TreeSet<TableRow> treeSet = new TreeSet<TableRow>();
        int n4 = 0;
        int n5 = 0;
        Iterator<String> iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String[] stringArray = new String[8 + n2];
            int n6 = 0;
            String string3 = iterator.next();
            CallRecord callRecord = hashMap.get(string3);
            long l = callRecord.numberCalls;
            long l2 = callRecord.activeInstanceCount;
            String string4 = callRecord.stackTraceElement.getFileName();
            long l3 = callRecord.stackTraceElement.getLineNumber();
            String string5 = callRecord.stackTraceElement.getClassName();
            int n7 = string5.lastIndexOf(46);
            String string6 = n7 > 0 ? string5.substring(n7 + 1) : string5;
            stringArray[n6++] = string6;
            stringArray[n6++] = String.valueOf(l3);
            stringArray[n6++] = callRecord.classCreated.getSimpleName();
            n4 = (int)((long)n4 + l);
            stringArray[n6++] = Long.toString(l);
            if (l2 > 0L) {
                n5 = (int)((long)n5 + l2);
            }
            stringArray[n6++] = Long.toString(l2);
            assert (string4 != null);
            assert (l3 != -1L);
            File file = new File(string2 + File.separatorChar + string4);
            if (file.exists()) {
                try {
                    String string7;
                    FileReader fileReader = new FileReader(file);
                    LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
                    long l4 = 0L;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    boolean bl = false;
                    while ((string7 = lineNumberReader.readLine()) != null) {
                        if (++l4 != l3) continue;
                        int n8 = string7.indexOf("/*");
                        int n9 = string7.indexOf("*/");
                        String string8 = n8 > -1 && n9 > 0 ? string7.substring(n8 + 2, n9) : "";
                        StringTokenizer stringTokenizer = new StringTokenizer(string8, ",");
                        while (stringTokenizer.hasMoreElements()) {
                            String string9 = stringTokenizer.nextToken();
                            arrayList.add(string9.trim());
                            if (bl || !string9.contains("Instruction")) continue;
                            bl = true;
                            stringArray[n6++] = string9.trim();
                        }
                        break block4;
                    }
                    lineNumberReader.close();
                    if (!bl) {
                        stringArray[n6++] = "(Instr Not Found)";
                    }
                    for (String string10 : arrayList) {
                        stringArray[n6++] = string10;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    System.exit(-1);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.exit(-1);
                }
            }
            treeSet.add(new TableRow(stringArray, n3));
        }
        return treeSet;
    }

    private void printForkReport2(String[] stringArray, TreeSet<TableRow> treeSet, PrintWriter printWriter, int n2) {
        Object object2;
        String string2 = wikiTableFormat ? "||" : "";
        String string3 = wikiTableFormat ? "||" : "";
        String string4 = wikiTableFormat ? "||" : ",";
        String string5 = wikiTableFormat ? "|" : "";
        String string6 = wikiTableFormat ? "|" : "";
        String string7 = wikiTableFormat ? "|" : ",";
        int n3 = this.getTableWidth(treeSet);
        printWriter.print(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = stringArray[i];
            if (object2 != null) {
                printWriter.print((String)object2);
            } else {
                printWriter.print("  ");
            }
            printWriter.print(string4);
        }
        printWriter.println(string3);
        Integer[] integerArray = new Integer[n3];
        object2 = treeSet.iterator();
        while (object2.hasNext()) {
            String[] stringArray2 = ((TableRow)object2.next()).row;
            n3 = stringArray2.length;
            printWriter.print(string5);
            for (int i = 0; i < stringArray2.length; ++i) {
                String string8 = stringArray2[i];
                if (string8 != null) {
                    printWriter.print(string8);
                } else {
                    printWriter.print(" ");
                }
                printWriter.print(string7);
                if (i != 3 && i != 4) continue;
                if (integerArray[i] == null) {
                    integerArray[i] = 0;
                    continue;
                }
                int n4 = Integer.valueOf(string8);
                if (n4 <= 0) continue;
                Integer[] integerArray2 = integerArray;
                int n5 = i;
                Integer.valueOf(integerArray2[n5] + n4);
            }
            printWriter.println(string6);
        }
        printWriter.print(string5);
        printWriter.print("TOTAL");
        printWriter.print(string7);
        for (int i = 1; i < n3; ++i) {
            if (integerArray[i] != null) {
                printWriter.print(integerArray[i]);
            } else {
                printWriter.print(" ");
            }
            printWriter.print(string7);
        }
        printWriter.println(string6);
    }

    private int getTableWidth(TreeSet<TableRow> treeSet) {
        int n2;
        block0: {
            n2 = 0;
            Iterator<TableRow> iterator = treeSet.iterator();
            if (!iterator.hasNext()) break block0;
            String[] stringArray = iterator.next().row;
            n2 = stringArray.length;
        }
        return n2;
    }

    static {
        assert (ForkReleaseTracker.createForkReleaseTracker());
        RECORDANDREPORTFORKUSAGEFORMAT = HiddenOptions.getStringValue(RECORDANDREPORTFORKUSAGEFORMATOPTION);
        wikiTableFormat = null == RECORDANDREPORTFORKUSAGEFORMAT ? false : RECORDANDREPORTFORKUSAGEFORMAT.equals("wiki");
        htmlTableFormat = null == RECORDANDREPORTFORKUSAGEFORMAT ? false : RECORDANDREPORTFORKUSAGEFORMAT.equals("html");
        csvTableFormat = null == RECORDANDREPORTFORKUSAGEFORMAT ? true : RECORDANDREPORTFORKUSAGEFORMAT.equals("csv");
        REPORTSUFIX = "." + (RECORDANDREPORTFORKUSAGEFORMAT == null ? "csv" : RECORDANDREPORTFORKUSAGEFORMAT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TableRow
    implements Comparable<TableRow> {
        final String[] row;
        final int sortKeyStart;

        public TableRow(String[] stringArray, int n2) {
            this.row = stringArray;
            this.sortKeyStart = n2;
        }

        @Override
        public int compareTo(TableRow tableRow) {
            int n2;
            String string2;
            String string3;
            int n3;
            for (n3 = this.sortKeyStart; n3 < this.row.length; ++n3) {
                string3 = TableRow.getKey(this, n3);
                n2 = string3.compareTo(string2 = TableRow.getKey(tableRow, n3));
                if (n2 == 0) continue;
                return n2;
            }
            for (n3 = 0; n3 < this.sortKeyStart; ++n3) {
                string3 = TableRow.getKey(this, n3);
                n2 = string3.compareTo(string2 = TableRow.getKey(tableRow, n3));
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }

        static String getKey(TableRow tableRow, int n2) {
            String string2 = tableRow.row[n2];
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CallRecord {
        final StackTraceElement stackTraceElement;
        final Class<?> classCreated;
        long numberCalls;
        long activeInstanceCount = 0L;

        public CallRecord(StackTraceElement stackTraceElement, long l, Class<?> clazz) {
            this.stackTraceElement = stackTraceElement;
            this.numberCalls = l;
            this.classCreated = clazz;
        }
    }
}

