/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;

public class DMUtil {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile ALLOWS_EFFECTIVE_BOOLEAN_VALUE = Cursor.Profile.SIZE;

    public static boolean test(Cursor cursor2, Cursor cursor3) {
        switch (cursor2.itemKind()) {
            case 1: {
                return cursor3.itemKind() == 1 && cursor3.itemName().equals(cursor2.itemName());
            }
            case 2: {
                return cursor3.itemKind() == 2 && cursor3.itemName().equals(cursor2.itemName());
            }
        }
        return cursor3.itemKind() == cursor2.itemKind();
    }

    public static Cursor sortDocumentOrder(Cursor cursor2, Cursor.Profile profile, boolean bl) {
        if (cursor2.contextIsOrdered(bl)) {
            return cursor2.factory().proxy(cursor2, profile, false, null, null);
        }
        profile = profile.union(Cursor.Profile.IS_BEFORE_NODE);
        boolean bl2 = profile.containedIn(cursor2.profile());
        return null;
    }

    public static String featuresSource(Cursor.Profile profile, boolean bl) {
        return profile.toString();
    }

    public static String featuresDifference(Cursor.Profile profile, Cursor.Profile profile2) {
        return "[(" + profile.toString() + ")-(" + profile2.toString() + ")]";
    }

    public static String areaSource(Cursor.Area area) {
        return area.toString();
    }

    public static String kindSource(short s) {
        try {
            return Cursor.KINDS[s];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "Invalid kind node";
        }
    }

    public static String stateSource(int n2) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class States {
            int f;
            StringBuilder b;
            final /* synthetic */ int val$state;

            States(int n2) {
                this.val$state = n2;
                this.f = this.val$state;
                this.b = new StringBuilder();
            }

            void x(int n2, String string2) {
                if ((n2 & this.f) == n2) {
                    this.f &= ~n2;
                    this.b.append(this.b.length() == 0 ? "" : "|");
                    this.b.append(string2);
                }
            }

            public String toString() {
                return "STATE_{" + this.b + "}";
            }
        }
        States states = new States(n2);
        states.x(6831, "ALL_RESOLVED");
        states.x(160, "ALL_PRECEDING_RESOLVED");
        states.x(32, "ANCESTORS_RESOLVED");
        states.x(6159, "SUBTREE_RESOLVED");
        states.x(3, "ATTRIBUTES_RESOLVED");
        states.x(512, "FOLLOWING_RESOLVED");
        states.x(12, "CHILDREN_RESOLVED");
        states.x(6144, "NAMESPACE_NODES_RESOLVED");
        states.x(2048, "FIRST_NAMESPACE_NODES_RESOLVED");
        states.x(4096, "LAST_NAMESPACE_NODES_RESOLVED");
        states.x(65536, "DIRTY");
        states.x(524288, "SUBTREE_DIRTY");
        states.x(0x100000, "STATE_MUT_MAP_QUEUED");
        states.x(32768, "UNQUALIFIED");
        states.x(16384, "OBJECT");
        states.x(8192, "READONLY");
        states.x(32, "PARENT_RESOLVED");
        states.x(128, "PREVIOUS_RESOLVED");
        states.x(512, "NEXT_RESOLVED");
        states.x(8, "LAST_CHILD_RESOLVED");
        states.x(4, "FIRST_CHILD_RESOLVED");
        states.x(2, "LAST_ATTRIBUTE_RESOLVED");
        states.x(1, "FIRST_ATTRIBUTE_RESOLVED");
        return states.toString();
    }

    public static String prettyPrint(Cursor cursor2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DMUtil.kindSource(cursor2.itemKind()));
        if (cursor2.itemName() != null && !cursor2.itemName().isEmptySequence()) {
            stringBuilder.append(' ').append(cursor2.itemName().getString(1));
        }
        if (cursor2.itemStringValue() != null && !cursor2.itemStringValue().isEmptySequence()) {
            stringBuilder.append(" {").append(cursor2.itemStringValue().getString(1)).append('}');
        }
        if (cursor2.itemXSType() != null) {
            stringBuilder.append(" of type ").append(cursor2.itemXSType().getName());
        }
        return stringBuilder.toString();
    }
}

