/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.type;

import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSModelGroup;
import com.ibm.xml.xml4j.api.s1.xs.XSObjectList;
import com.ibm.xml.xml4j.api.s1.xs.XSParticle;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.xs.XSComplexTypeDecl;
import org.w3c.dom.TypeInfo;

public class TypeHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isOpen(XSComplexTypeDefinition xSComplexTypeDefinition) {
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSComplexTypeDefinition;
        if (xSComplexTypeDecl.getAttrGrp() != null && xSComplexTypeDecl.getAttributeWildcard() != null) {
            return true;
        }
        switch (xSComplexTypeDefinition.getContentType()) {
            case 2: 
            case 3: {
                return TypeHelper.isOpen(xSComplexTypeDefinition.getParticle());
            }
        }
        return false;
    }

    private static boolean isOpen(XSParticle xSParticle) {
        switch (xSParticle.getTerm().getType()) {
            case 2: {
                return false;
            }
            case 7: {
                XSModelGroup xSModelGroup = (XSModelGroup)xSParticle.getTerm();
                XSObjectList xSObjectList = xSModelGroup.getParticles();
                for (int i = 0; i < xSObjectList.getLength(); ++i) {
                    if (!TypeHelper.isOpen((XSParticle)xSObjectList.item(i))) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isAtomic(XSTypeDefinition xSTypeDefinition) {
        return xSTypeDefinition.getTypeCategory() == 16 && ((XSSimpleTypeDefinition)xSTypeDefinition).getVariety() == 1;
    }

    public static boolean isAtomic(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return xSSimpleTypeDefinition.getVariety() == 1;
    }

    public static boolean isList(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return xSSimpleTypeDefinition.getVariety() == 2;
    }

    public static boolean isSimple(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition == null) {
            return false;
        }
        if (xSTypeDefinition.getTypeCategory() == 16) {
            return true;
        }
        return ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() == 1;
    }

    public static boolean isSimple(XSComplexTypeDefinition xSComplexTypeDefinition) {
        return xSComplexTypeDefinition.getContentType() == 1;
    }

    public static boolean isMixed(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition.getTypeCategory() == 16) {
            return false;
        }
        return ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() == 3;
    }

    public static boolean isEqual(XSSimpleTypeDefinition xSSimpleTypeDefinition, XSSimpleTypeDefinition xSSimpleTypeDefinition2) {
        if (xSSimpleTypeDefinition == null || xSSimpleTypeDefinition2 == null) {
            return false;
        }
        boolean bl = xSSimpleTypeDefinition2.getAnonymous();
        if (!xSSimpleTypeDefinition.getAnonymous()) {
            return !bl && xSSimpleTypeDefinition.getName() == xSSimpleTypeDefinition2.getName() && xSSimpleTypeDefinition.getNamespace() == xSSimpleTypeDefinition2.getNamespace();
        }
        if (bl) {
            TypeInfo typeInfo = (TypeInfo)((Object)xSSimpleTypeDefinition);
            TypeInfo typeInfo2 = (TypeInfo)((Object)xSSimpleTypeDefinition2);
            if (typeInfo.getTypeName().equals(typeInfo2.getTypeName())) {
                String string2 = typeInfo.getTypeName();
                String string3 = typeInfo2.getTypeName();
                if (string2 != null) {
                    return string3 != null && string2.equals(string3);
                }
                return string3 == null;
            }
        }
        return false;
    }

    public static boolean isEqualToBuiltInType(XSSimpleTypeDefinition xSSimpleTypeDefinition, XSSimpleTypeDefinition xSSimpleTypeDefinition2) {
        assert (xSSimpleTypeDefinition2 != null);
        if (xSSimpleTypeDefinition == xSSimpleTypeDefinition2) {
            return true;
        }
        if (xSSimpleTypeDefinition == null) {
            return false;
        }
        if (xSSimpleTypeDefinition.getAnonymous()) {
            return false;
        }
        return xSSimpleTypeDefinition.getName() == xSSimpleTypeDefinition2.getName() && xSSimpleTypeDefinition.getNamespace() == xSSimpleTypeDefinition2.getNamespace();
    }
}

