/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.mediator;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.BoolStack;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.wrappers.StripWhitespaceFilter;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingCursorMediatorStripSpace
extends StreamingCursorMediator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected StripWhitespaceFilter.PrioritizedNameTestList m_stripTests;
    protected StripWhitespaceFilter.PrioritizedNameTestList m_preserveTests;
    private boolean m_isXMLSpacePreserve = false;
    private BoolStack m_XMLSpaceStack = new BoolStack();
    protected boolean m_shouldStripWS = false;
    protected BoolStack m_shouldStripWhitespaceStack = new BoolStack();
    private static final String XMLNS = "http://www.w3.org/XML/1998/namespace";

    public StreamingCursorMediatorStripSpace(Cursor cursor2, Cursor.Profile profile) {
        this(cursor2, profile, null, null);
    }

    public StreamingCursorMediatorStripSpace(Cursor cursor2, Cursor.Profile profile, StripWhitespaceFilter.PrioritizedNameTestList prioritizedNameTestList, StripWhitespaceFilter.PrioritizedNameTestList prioritizedNameTestList2) {
        super(cursor2, profile);
        this.m_stripTests = prioritizedNameTestList;
        this.m_preserveTests = prioritizedNameTestList2;
    }

    public StreamingCursorMediatorStripSpace(Cursor cursor2, Cursor.Profile profile, Map<String, Object> map2) {
        super(cursor2, profile);
        this.m_stripTests = (StripWhitespaceFilter.PrioritizedNameTestList)map2.get("http://www.ibm.com/xmlns/prod/xcij/strip-space");
        this.m_preserveTests = (StripWhitespaceFilter.PrioritizedNameTestList)map2.get("http://www.ibm.com/xmlns/prod/xcij/preserve-space");
    }

    protected void pushXMLSpace(boolean bl) {
        this.m_isXMLSpacePreserve = bl;
        this.m_XMLSpaceStack.push(bl);
    }

    protected void popXMLSpace() {
        this.m_isXMLSpacePreserve = this.m_XMLSpaceStack.popAndTop();
    }

    protected boolean peekXMLSpace() {
        if (this.m_XMLSpaceStack.isEmpty()) {
            return false;
        }
        return this.m_XMLSpaceStack.peek();
    }

    protected void pushStripSpace(boolean bl) {
        this.m_shouldStripWS = bl;
        this.m_shouldStripWhitespaceStack.push(bl);
    }

    protected void popStripSpace() {
        this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
    }

    protected boolean peekStripSpace() {
        if (this.m_shouldStripWhitespaceStack.isEmpty()) {
            return false;
        }
        return this.m_shouldStripWhitespaceStack.peek();
    }

    @Override
    public final void visitSubtree(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        if (dOMCachedNode instanceof DOMCachedContainer && !(dOMCachedNode instanceof DOMCachedSimple)) {
            DOMCachedNode dOMCachedNode2;
            if (dOMCachedNode instanceof DOMCachedElement) {
                this.updateStripWhitespaceStack(dOMCachedNode);
            }
            DOMCachedContainer dOMCachedContainer = (DOMCachedContainer)dOMCachedNode;
            if (bl || (n2 & 0x1800) != 6144) {
                this.visitNamespaceNodes(dOMCachedContainer, n2, bl);
                n2 = dOMCachedContainer.getState();
            }
            if (bl || (n2 & 3) != 3) {
                this.visitAttributes(dOMCachedContainer, n2, bl);
                n2 = dOMCachedContainer.getState();
            }
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2 = bl ? null : dOMCachedContainer.getBuiltFirstChild();
            if (bl || dOMCachedNode2 == null && (n2 & 4) != 4) {
                if (this.buildChildren(dOMCachedContainer, null)) {
                    dOMCachedNode2 = dOMCachedContainer.getBuiltFirstChild();
                    bl = true;
                }
                n2 |= 4;
            }
            while (dOMCachedNode2 != null) {
                DOMCachedNode dOMCachedNode4;
                int n3 = dOMCachedNode2.getState();
                if (bl || (n3 & 0x180F) != 6159) {
                    this.visitSubtree(dOMCachedNode2, n3, bl);
                    n3 = dOMCachedNode2.getState();
                }
                if ((dOMCachedNode4 = dOMCachedNode2.getBuiltFollowingSibling()) == null && (n3 & 0x200) != 512) {
                    if (this.buildNext(dOMCachedNode2)) {
                        dOMCachedNode4 = dOMCachedNode2.getBuiltFollowingSibling();
                        bl = true;
                    }
                    dOMCachedNode2.setState(n3 | 0x200);
                }
                dOMCachedNode2 = dOMCachedNode4;
            }
            if (dOMCachedNode instanceof DOMCachedElement) {
                this.popXMLSpace();
                this.popStripSpace();
            }
        }
        dOMCachedNode.setState(n2 | 0x180F);
    }

    @Override
    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        Cursor cursor2;
        Cursor cursor3;
        assert (nodeTest == null) : "Only null build test supported!";
        int n2 = dOMCachedNode.getState();
        if ((n2 & 0x1800) != 6144) {
            this.visitNamespaceNodes(dOMCachedNode, n2, (n2 & 0x800) != 2048);
            n2 = dOMCachedNode.getState();
        }
        if ((n2 & 3) != 3) {
            this.visitAttributes(dOMCachedNode, n2, (n2 & 1) != 1);
        }
        if ((cursor3 = (cursor2 = ((StreamingCursorMediator.XCIData)((Object)dOMCachedNode.getUserData())).getXCI()).fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION)).toChildren(null)) {
            if (cursor3.itemKind() == 3) {
                VolatileCData volatileCData = cursor3.itemTypedValue();
                if (!this.getShouldStripWhitespace() || !volatileCData.isSpace()) {
                    ((StreamingCursorMediator.XCIData)((Object)MiscHelpers.makeTextNode(volatileCData, dOMCachedNode.getCache(), dOMCachedNode, null).getUserData())).setXCI(cursor3);
                    return true;
                }
                if (cursor3.toNext()) {
                    ((StreamingCursorMediator.XCIData)((Object)this.makeNode(cursor3, dOMCachedNode.getCache(), dOMCachedNode, null).getUserData())).setXCI(cursor3);
                    return true;
                }
            } else {
                ((StreamingCursorMediator.XCIData)((Object)this.makeNode(cursor3, dOMCachedNode.getCache(), dOMCachedNode, null).getUserData())).setXCI(cursor3);
                return true;
            }
        }
        cursor3.release();
        return false;
    }

    @Override
    protected void visitAttributes(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        if (dOMCachedNode.itemKind() == 1) {
            Object object2;
            boolean bl2 = false;
            DOMCachedElement dOMCachedElement = (DOMCachedElement)dOMCachedNode;
            Object object3 = object2 = bl ? null : dOMCachedElement.getBuiltFirstAttribute();
            if ((bl || object2 == null && (n2 & 1) != 1) && this.buildAttributes(dOMCachedElement, null)) {
                object2 = dOMCachedElement.getBuiltFirstAttribute();
                bl = true;
            }
            while (object2 != null) {
                Object object4;
                if (!bl2 && (object4 = ((DOMCachedAttribute)object2).itemName()).getQNameLocalPart(1).equals("space") && object4.getQNameNamespaceURI(1).equals(XMLNS)) {
                    bl2 = true;
                    if (((Object)((AbstractCursor)object2).itemStringValueAsChars()).toString().equals("preserve")) {
                        this.m_XMLSpaceStack.push(true);
                    } else {
                        this.m_XMLSpaceStack.push(false);
                    }
                }
                Object object5 = object4 = bl ? null : ((DOMCachedAttribute)object2).getBuiltFollowingAttribute();
                if (object4 == null) {
                    int n3 = ((DOMCachedNode)object2).getState();
                    if (bl || (n3 & 0x200) != 512) {
                        if (this.buildNext((DOMCachedNode)object2)) {
                            object4 = ((DOMCachedAttribute)object2).getBuiltFollowingAttribute();
                            bl = true;
                        } else {
                            object4 = null;
                        }
                        ((DOMCachedNode)object2).setState(n3 | 0x200);
                    }
                }
                object2 = object4;
            }
            if (!bl2) {
                this.m_XMLSpaceStack.push(this.m_isXMLSpacePreserve);
            }
        }
        dOMCachedNode.setState(n2 | 3);
    }

    private boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS && !this.m_isXMLSpacePreserve;
    }

    private void updateStripWhitespaceStack(DOMCachedNode dOMCachedNode) {
        if (!(dOMCachedNode instanceof DOMCachedElement)) {
            return;
        }
        XSTypeDefinition xSTypeDefinition = dOMCachedNode.itemXSType();
        if (xSTypeDefinition != null && xSTypeDefinition instanceof XSComplexTypeDefinition && ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() == 2) {
            this.pushStripSpace(true);
            return;
        }
        StripWhitespaceFilter.PrioritizedNameTestList prioritizedNameTestList = this.m_stripTests.findNextMatch(dOMCachedNode);
        if (prioritizedNameTestList == null) {
            this.pushStripSpace(false);
            return;
        }
        StripWhitespaceFilter.PrioritizedNameTestList prioritizedNameTestList2 = this.m_preserveTests.findNextMatch(dOMCachedNode);
        if (prioritizedNameTestList2 == null) {
            this.pushStripSpace(true);
            return;
        }
        if (prioritizedNameTestList2._importance_and_priority > prioritizedNameTestList._importance_and_priority) {
            this.pushStripSpace(false);
            return;
        }
        if (prioritizedNameTestList2._importance_and_priority == prioritizedNameTestList._importance_and_priority) {
            StripWhitespaceFilter.PrioritizedNameTestList prioritizedNameTestList3 = prioritizedNameTestList;
            for (prioritizedNameTestList = prioritizedNameTestList.findNextMatch(dOMCachedNode); prioritizedNameTestList != null && prioritizedNameTestList._importance_and_priority == prioritizedNameTestList3._importance_and_priority; prioritizedNameTestList = prioritizedNameTestList.findNextMatch(dOMCachedNode)) {
                if (prioritizedNameTestList._declarationOrder <= prioritizedNameTestList3._declarationOrder) continue;
                prioritizedNameTestList3 = prioritizedNameTestList;
            }
            StripWhitespaceFilter.PrioritizedNameTestList prioritizedNameTestList4 = prioritizedNameTestList2;
            for (prioritizedNameTestList2 = prioritizedNameTestList2.findNextMatch(dOMCachedNode); prioritizedNameTestList2 != null && prioritizedNameTestList2._importance_and_priority == prioritizedNameTestList4._importance_and_priority; prioritizedNameTestList2 = prioritizedNameTestList2.findNextMatch(dOMCachedNode)) {
                if (prioritizedNameTestList2._declarationOrder <= prioritizedNameTestList4._declarationOrder) continue;
                prioritizedNameTestList4 = prioritizedNameTestList2;
            }
            if (prioritizedNameTestList4._declarationOrder > prioritizedNameTestList3._declarationOrder) {
                this.pushStripSpace(false);
                return;
            }
        }
        this.pushStripSpace(true);
    }

    @Override
    protected boolean doBuildNext(DOMCachedNode dOMCachedNode) {
        Cursor cursor2 = ((StreamingCursorMediator.XCIData)((Object)dOMCachedNode.getUserData())).getXCI();
        while (cursor2.toNext()) {
            if (cursor2.itemKind() == 3) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                if (this.getShouldStripWhitespace() && volatileCData.isSpace()) continue;
                ((StreamingCursorMediator.XCIData)((Object)MiscHelpers.makeTextNode(volatileCData, dOMCachedNode.getCache(), dOMCachedNode.getCachedParent(), dOMCachedNode).getUserData())).setXCI(cursor2);
                return true;
            }
            ((StreamingCursorMediator.XCIData)((Object)this.makeNode(cursor2, dOMCachedNode.getCache(), dOMCachedNode.getCachedParent(), dOMCachedNode).getUserData())).setXCI(cursor2);
            return true;
        }
        cursor2.release();
        if (cursor2 == this.source) {
            // empty if block
        }
        return false;
    }

    public StripWhitespaceFilter.PrioritizedNameTestList getStripSpaceRules() {
        return this.m_stripTests;
    }

    public StripWhitespaceFilter.PrioritizedNameTestList getPreserveSpaceRules() {
        return this.m_preserveTests;
    }
}

