/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.mediator;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocument;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.UserData;
import com.ibm.xml.xci.dp.cache.dom.UserDataFactory;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.NoMediator;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIUnsupportedOperationException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.util.SimpleKindTest;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import java.util.logging.Logger;

public class StreamingCursorMediator
extends NoMediator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Cursor source;
    private static final Logger logger = LoggerUtil.getLogger(StreamingCursorMediator.class);

    public StreamingCursorMediator(Cursor cursor2, Cursor.Profile profile) {
        super(cursor2.factory());
        Cursor.Profile profile2 = cursor2.profile();
        this.source = cursor2;
        if (!Cursor.Profile.MINIMAL_STREAMING_NAVIGATION.containedIn(profile2)) {
            throw new XCIUnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.MINIMAL_STREAMING_NAVIGATION"}));
        }
    }

    protected boolean doBuildNext(DOMCachedNode dOMCachedNode) {
        Cursor cursor2 = ((XCIData)((Object)dOMCachedNode.getUserData())).getXCI();
        if (cursor2.toNext()) {
            ((XCIData)((Object)this.makeNode(cursor2, dOMCachedNode.getCache(), dOMCachedNode.getCachedParent(), dOMCachedNode).getUserData())).setXCI(cursor2);
            return true;
        }
        cursor2.release();
        if (cursor2 == this.source) {
            // empty if block
        }
        return false;
    }

    public UserDataFactory getUserDataFactory(int n2) {
        if (n2 == 0) {
            return XCIOriginalNodeDataImpl.FACTORY;
        }
        return new UserDataFactory(){

            public UserData create() {
                return new XCIAllData();
            }
        };
    }

    public DOMCachedNode buildFirstTopItem(CacheManager cacheManager, String string2, String string3) {
        DOMCachedNode dOMCachedNode;
        this.documentID = cacheManager.documentIdentify();
        switch (this.source.itemKind()) {
            case 2: {
                dOMCachedNode = cacheManager.makeCachedAttribute(this.source.itemName(), this.source.itemTypedValue(), (AttributePSVI)this.source.itemXSPSVInfo(), this.source.itemXSAttributeDeclaration(), null);
                ((DOMCachedAttribute)dOMCachedNode).itemValueOrigin = this.source.itemAttributeValueOrigin();
                break;
            }
            case 4: {
                dOMCachedNode = cacheManager.makeCachedNamespaceNode(this.source.itemName(), this.source.itemTypedValue(), null);
                break;
            }
            case 1: {
                dOMCachedNode = cacheManager.makeCachedElement(this.source.itemName(), this.source.itemXSType(), (ElementPSVI)this.source.itemXSPSVInfo(), this.source.itemXSElementDeclaration(), this.source.itemNilled(), null, null);
                break;
            }
            case 3: {
                dOMCachedNode = cacheManager.makeCachedText(this.source.itemTypedValue(), false, this.source.itemIsAtomic(), null, null);
                break;
            }
            case 8: {
                dOMCachedNode = cacheManager.makeCachedComment(this.source.itemTypedValue(), null, null);
                break;
            }
            case 7: {
                dOMCachedNode = cacheManager.makeCachedPI(this.source.itemName(), this.source.itemTypedValue(), null, null);
                break;
            }
            case 9: {
                dOMCachedNode = cacheManager.makeCachedDocument(string2, string3);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadContextItemException("buildFirstTopItem", this.source.itemKind());
            }
        }
        ((XCIData)((Object)dOMCachedNode.getUserData())).setXCI(this.source);
        if (cacheManager.isWrapper()) {
            return dOMCachedNode;
        }
        if (cacheManager.isValidateLoading()) {
            Boolean bl = (Boolean)cacheManager.factory().getSessionContext().getOption("http://www.ibm.com/xml/xci/bo/bo-bc-mode");
            if (bl != null && bl.booleanValue()) {
                DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedFirstChild(SimpleKindTest.ELEMENT);
                if (dOMCachedNode2 == null) {
                    dOMCachedNode.validate(56);
                } else {
                    dOMCachedNode2.validate(56, null, dOMCachedNode2.itemXSType(), null);
                }
            } else {
                dOMCachedNode.validate(56);
            }
        } else if (cacheManager.isEagerLoading()) {
            this.visitSubtree(dOMCachedNode, dOMCachedNode.getState(), true);
        }
        return dOMCachedNode;
    }

    public DOMCachedNode buildNextTopItem(CacheManager cacheManager, String string2, String string3) {
        if (this.source == null || !this.source.toNext()) {
            this.source = null;
            return null;
        }
        return this.buildFirstTopItem(cacheManager, string2, string3);
    }

    public boolean buildNamespaceNodes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        assert (nodeTest == null) : "Only null build test supported!";
        Cursor cursor2 = ((XCIData)((Object)dOMCachedElement.getUserData())).getXCI();
        Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        if (cursor3.toNamespaceDecls()) {
            ((XCIData)((Object)this.makeNode(cursor3, dOMCachedElement.getCache(), dOMCachedElement, null).getUserData())).setXCI(cursor3);
            return true;
        }
        cursor3.release();
        return false;
    }

    public boolean buildAttributes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        Cursor cursor2;
        Cursor cursor3;
        assert (nodeTest == null) : "Only null build test supported!";
        int n2 = dOMCachedElement.getState();
        if ((n2 & 0x1800) != 6144) {
            this.visitNamespaceNodes(dOMCachedElement, n2, (n2 & 0x800) != 2048);
        }
        if ((cursor3 = (cursor2 = ((XCIData)((Object)dOMCachedElement.getUserData())).getXCI()).fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION)).toAttributes(null)) {
            ((XCIData)((Object)this.makeNode(cursor3, dOMCachedElement.getCache(), dOMCachedElement, null).getUserData())).setXCI(cursor3);
            return true;
        }
        cursor3.release();
        return false;
    }

    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        Cursor cursor2;
        Cursor cursor3;
        assert (nodeTest == null) : "Only null build test supported!";
        int n2 = dOMCachedNode.getState();
        if ((n2 & 0x1800) != 6144) {
            this.visitNamespaceNodes(dOMCachedNode, n2, (n2 & 0x800) != 2048);
            n2 = dOMCachedNode.getState();
        }
        if ((n2 & 3) != 3) {
            this.visitAttributes(dOMCachedNode, n2, (n2 & 1) != 1);
        }
        if ((cursor3 = (cursor2 = ((XCIData)((Object)dOMCachedNode.getUserData())).getXCI()).fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION)).toChildren(null)) {
            ((XCIData)((Object)this.makeNode(cursor3, dOMCachedNode.getCache(), dOMCachedNode, null).getUserData())).setXCI(cursor3);
            return true;
        }
        cursor3.release();
        return false;
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        int n2 = dOMCachedNode.getState();
        if ((n2 & 0x180F) != 6159) {
            this.visitSubtree(dOMCachedNode, n2, (n2 & 0x800) != 2048);
        }
        return this.doBuildNext(dOMCachedNode);
    }

    public boolean buildPrevious(DOMCachedNode dOMCachedNode) {
        return false;
    }

    public boolean buildPosition(DOMCachedNode dOMCachedNode, long l) {
        assert (false);
        return false;
    }

    public boolean buildParent(DOMCachedNode dOMCachedNode) {
        return dOMCachedNode.getBuiltParent() != null;
    }

    public boolean buildIds(DOMCachedDocument dOMCachedDocument, CData cData) {
        return false;
    }

    public void release() {
        if (this.source != null) {
            this.source.release();
        }
    }

    protected DOMCachedNode makeNode(Cursor cursor2, CacheManager cacheManager, DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        return MiscHelpers.makeNode(cursor2, cacheManager, dOMCachedNode, dOMCachedNode2);
    }

    protected void visitAttributes(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        if (dOMCachedNode.itemKind() == 1) {
            DOMCachedAttribute dOMCachedAttribute;
            DOMCachedElement dOMCachedElement = (DOMCachedElement)dOMCachedNode;
            DOMCachedAttribute dOMCachedAttribute2 = dOMCachedAttribute = bl ? null : dOMCachedElement.getBuiltFirstAttribute();
            if ((bl || dOMCachedAttribute == null && (n2 & 1) != 1) && this.buildAttributes(dOMCachedElement, null)) {
                dOMCachedAttribute = dOMCachedElement.getBuiltFirstAttribute();
                bl = true;
            }
            while (dOMCachedAttribute != null) {
                DOMCachedAttribute dOMCachedAttribute3;
                DOMCachedAttribute dOMCachedAttribute4 = dOMCachedAttribute3 = bl ? null : dOMCachedAttribute.getBuiltFollowingAttribute();
                if (dOMCachedAttribute3 == null) {
                    int n3 = dOMCachedAttribute.getState();
                    if (bl || (n3 & 0x200) != 512) {
                        if (this.buildNext(dOMCachedAttribute)) {
                            dOMCachedAttribute3 = dOMCachedAttribute.getBuiltFollowingAttribute();
                            bl = true;
                        } else {
                            dOMCachedAttribute3 = null;
                        }
                        dOMCachedAttribute.setState(n3 | 0x200);
                    }
                }
                dOMCachedAttribute = dOMCachedAttribute3;
            }
        }
        dOMCachedNode.setState(n2 | 3);
    }

    protected final void visitNamespaceNodes(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        if (dOMCachedNode instanceof DOMCachedElement) {
            DOMCachedNamespace dOMCachedNamespace;
            DOMCachedElement dOMCachedElement = (DOMCachedElement)dOMCachedNode;
            DOMCachedNamespace dOMCachedNamespace2 = dOMCachedNamespace = bl ? null : dOMCachedElement.getBuiltFirstNamespace();
            if ((bl || dOMCachedNamespace == null && (n2 & 0x800) != 2048) && this.buildNamespaceNodes(dOMCachedElement, null)) {
                dOMCachedNamespace = dOMCachedElement.getBuiltFirstNamespace();
                bl = true;
            }
            while (dOMCachedNamespace != null) {
                DOMCachedNamespace dOMCachedNamespace3;
                DOMCachedNamespace dOMCachedNamespace4 = dOMCachedNamespace3 = bl ? null : dOMCachedNamespace.getBuiltFollowingNamespaceNode();
                if (dOMCachedNamespace3 == null) {
                    int n3 = dOMCachedNamespace.getState();
                    if (bl || (n3 & 0x200) != 512) {
                        if (this.buildNext(dOMCachedNamespace)) {
                            dOMCachedNamespace3 = dOMCachedNamespace.getBuiltFollowingNamespaceNode();
                            bl = true;
                        } else {
                            dOMCachedNamespace3 = null;
                        }
                        dOMCachedNamespace.setState(n3 | 0x200);
                    }
                }
                dOMCachedNamespace = dOMCachedNamespace3;
            }
        }
        dOMCachedNode.setState(n2 | 0x1800);
    }

    public void visitSubtree(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        if (dOMCachedNode instanceof DOMCachedContainer && !(dOMCachedNode instanceof DOMCachedSimple)) {
            DOMCachedNode dOMCachedNode2;
            DOMCachedContainer dOMCachedContainer = (DOMCachedContainer)dOMCachedNode;
            if (bl || (n2 & 0x1800) != 6144) {
                this.visitNamespaceNodes(dOMCachedContainer, n2, bl);
                n2 = dOMCachedContainer.getState();
            }
            if (bl || (n2 & 3) != 3) {
                this.visitAttributes(dOMCachedContainer, n2, bl);
                n2 = dOMCachedContainer.getState();
            }
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2 = bl ? null : dOMCachedContainer.getBuiltFirstChild();
            if (bl || dOMCachedNode2 == null && (n2 & 4) != 4) {
                if (this.buildChildren(dOMCachedContainer, null)) {
                    dOMCachedNode2 = dOMCachedContainer.getBuiltFirstChild();
                    bl = true;
                }
                n2 |= 4;
            }
            while (dOMCachedNode2 != null) {
                DOMCachedNode dOMCachedNode4;
                int n3 = dOMCachedNode2.getState();
                if (bl || (n3 & 0x180F) != 6159) {
                    this.visitSubtree(dOMCachedNode2, n3, bl);
                    n3 = dOMCachedNode2.getState();
                }
                if ((dOMCachedNode4 = dOMCachedNode2.getBuiltFollowingSibling()) == null && (n3 & 0x200) != 512) {
                    if (this.buildNext(dOMCachedNode2)) {
                        dOMCachedNode4 = dOMCachedNode2.getBuiltFollowingSibling();
                        bl = true;
                    }
                    dOMCachedNode2.setState(n3 | 0x200);
                }
                dOMCachedNode2 = dOMCachedNode4;
            }
        }
        dOMCachedNode.setState(n2 | 0x180F);
    }

    public Cursor focus() {
        return this.source;
    }

    protected static class XCIAllData
    extends UserData.AllData
    implements XCIData {
        Cursor xci;

        protected XCIAllData() {
        }

        public Cursor getXCI() {
            return this.xci;
        }

        public void setXCI(Cursor cursor2) {
            this.xci = cursor2;
        }
    }

    public static class XCIOriginalNodeDataImpl
    extends XCIDataImpl {
        public static UserDataFactory FACTORY = new UserDataFactory(){

            public UserData create() {
                return new XCIOriginalNodeDataImpl();
            }
        };
        DOMCachedNode originalNode;
        protected Object mediatorData;

        public DOMCachedNode getOriginalNode() {
            return this.originalNode;
        }

        public void setOriginalNode(DOMCachedNode dOMCachedNode) {
            this.originalNode = dOMCachedNode;
        }

        public Object getMediatorData() {
            return this.mediatorData;
        }

        public void setMediatorData(Object object2) {
            this.mediatorData = object2;
        }
    }

    public static class XCIDataImpl
    extends UserData
    implements XCIData {
        public static UserDataFactory FACTORY = new UserDataFactory(){

            public UserData create() {
                return new XCIDataImpl();
            }
        };
        Cursor xci;

        public Cursor getXCI() {
            return this.xci;
        }

        public void setXCI(Cursor cursor2) {
            this.xci = cursor2;
        }
    }

    public static interface XCIData {
        public Cursor getXCI();

        public void setXCI(Cursor var1);
    }
}

