/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.mediator;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocument;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.UserData;
import com.ibm.xml.xci.dp.cache.dom.UserDataFactory;
import com.ibm.xml.xci.dp.cache.dom.mediator.Mediator;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.util.copy.NoItemCopier;
import com.ibm.xml.xci.dp.util.copy.SerializerCDataDelegate;
import com.ibm.xml.xci.serializer.AddContentInterface;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NoMediator
implements Mediator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private CursorFactory factory;
    private static final Logger logger = LoggerUtil.getLogger(NoMediator.class);
    protected long documentID;

    public NoMediator(CursorFactory cursorFactory) {
        this.factory = cursorFactory;
        this.documentID = -1L;
    }

    public CursorFactory factory() {
        return this.factory;
    }

    public void setFactory(CursorFactory cursorFactory) {
        this.factory = cursorFactory;
    }

    public UserDataFactory getUserDataFactory(int n2) {
        return UserDataFactory.getFactory(n2);
    }

    public void processParameters(Map map2) {
    }

    public DOMCachedNode buildFirstTopItem(CacheManager cacheManager, String string2, String string3) {
        this.documentID = cacheManager.documentIdentify();
        return cacheManager.makeCachedDocument(string2, string3);
    }

    public boolean buildAttributes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        DOMCachedContainer dOMCachedContainer = dOMCachedElement.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedElement.getCache().mediator(dOMCachedContainer) != this) {
            this.logAndFFDC("buildAttributes", dOMCachedElement);
        }
        return false;
    }

    public boolean buildNamespaceNodes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        DOMCachedContainer dOMCachedContainer = dOMCachedElement.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedElement.getCache().mediator(dOMCachedContainer) != this) {
            this.logAndFFDC("buildNamespaceNodes", dOMCachedElement);
        }
        return false;
    }

    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        DOMCachedContainer dOMCachedContainer = dOMCachedNode.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedNode.getCache().mediator(dOMCachedContainer) != this) {
            this.logAndFFDC("buildChildren", dOMCachedNode);
        }
        return false;
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        DOMCachedContainer dOMCachedContainer = dOMCachedNode.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedNode.getCache().mediator(dOMCachedContainer) != this) {
            this.logAndFFDC("buildNext", dOMCachedNode);
        }
        return false;
    }

    public boolean buildPrevious(DOMCachedNode dOMCachedNode) {
        return false;
    }

    public boolean buildPosition(DOMCachedNode dOMCachedNode, long l) {
        return false;
    }

    public boolean buildParent(DOMCachedNode dOMCachedNode) {
        DOMCachedContainer dOMCachedContainer = dOMCachedNode.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedNode.getCache().mediator(dOMCachedContainer) != this) {
            this.logAndFFDC("buildParent", dOMCachedNode);
        }
        return false;
    }

    public boolean buildId(DOMCachedDocument dOMCachedDocument, CData cData) {
        return false;
    }

    public VolatileCData serialize(Cursor cursor2, Map map2) {
        Cursor cursor3 = cursor2.fork(false, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST), Cursor.Profile.MINIMAL_STREAMING_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST));
        if (this.fastSerializationCompatible(map2, cursor2)) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "serialize", "about to make a SerializerCDataDelegate with the general item copier!");
            }
            return new SerializerCDataDelegate(cursor3, map2, new GeneralItemCopier());
        }
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
        if (dOMCachedNode.getCache().getItemCopier() != null) {
            SerializerCDataDelegate serializerCDataDelegate = new SerializerCDataDelegate(cursor3, map2, dOMCachedNode.getCache().getItemCopier());
            dOMCachedNode.getCache().setItemCopier(null);
            return serializerCDataDelegate;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "serialize", "about to make a SerializedCData fallback.");
        }
        return new SerializedCData(cursor3, map2);
    }

    public ItemCopier getItemCopier(DOMCachedNode dOMCachedNode) {
        return NoItemCopier.SINGLETON;
    }

    public void release() {
    }

    public boolean lazyMediator() {
        return false;
    }

    public void reportMutation(DOMCachedNode dOMCachedNode) {
    }

    public long documentID() {
        return this.documentID;
    }

    protected boolean fastSerializationCompatible(Map map2, Cursor cursor2) {
        if (!(cursor2.unwrap() instanceof DOMCachedNode)) {
            return false;
        }
        boolean bl = ((DOMCachedNode)cursor2.unwrap()).getCache().getAttemptFastSerialization();
        if (bl && map2 != null && map2.size() > 0) {
            Object v = map2.get("{http://ibm.com/xml/xci/serializer}fast-ser");
            if (v != null) {
                return (Boolean)v != false;
            }
            int n2 = map2.size();
            if (n2 > 2) {
                return false;
            }
            for (String string2 : map2.keySet()) {
                String string3;
                if ("omit-xml-declaration".equals(string2) || "encoding".equals(string2) && (string3 = (String)map2.get(string2)) != null && string3.equalsIgnoreCase("UTF-8")) continue;
                return false;
            }
            return true;
        }
        return bl;
    }

    public Cursor focus() {
        return null;
    }

    public boolean fastSerializationEnabled() {
        return false;
    }

    private void logAndFFDC(String string2, DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), string2, "calling " + string2 + " for node: " + dOMCachedNode.toStringLazy() + "\nCache manager = " + dOMCachedNode.getCache() + " | Mediator (default) = " + dOMCachedNode.getCache().mediator() + " | Mediator (for node) = " + dOMCachedNode.getCache().mediator(dOMCachedNode));
        }
        FFDCUtil.log(XCIErrorHelper.createInternalException("Called " + string2 + " from NoMediator - should not happen!"), this);
    }

    protected class GeneralItemCopier
    implements ItemCopier {
        protected GeneralItemCopier() {
        }

        public int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
            short s = cursor2.itemKind();
            if (s != 4 && s != 2) {
                Object object2;
                DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
                UserData userData = dOMCachedNode.getUserData();
                if (userData == null) {
                    return 3;
                }
                if (dOMCachedNode.isDirty()) {
                    return 3;
                }
                DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedParent();
                if (dOMCachedNode2 != null && !dOMCachedNode2.isSubtreeDirty() && (object2 = dOMCachedNode2.getUserData()) != null) {
                    int n2;
                    if (((UserData)object2).getOriginalNode() != null) {
                        dOMCachedNode2 = ((UserData)object2).getOriginalNode();
                        object2 = dOMCachedNode2.getUserData();
                    }
                    if ((n2 = ((UserData)object2).addSubtreeContent(dOMCachedNode2, area, (AddContentInterface)((Object)cursor3))) != 3) {
                        return n2;
                    }
                }
                if ((object2 = userData.getOriginalNode()) == null) {
                    dOMCachedNode.getCachedFollowingSibling();
                    return userData.addContent(area, (AddContentInterface)((Object)cursor3));
                }
                ((DOMCachedNode)object2).getCachedFollowingSibling();
                return ((DOMCachedNode)object2).getUserData().addContent(area, (AddContentInterface)((Object)cursor3));
            }
            return 3;
        }

        public Cursor.Profile sourceProfile() {
            return Copier.SOURCE_FEATURES;
        }

        public Cursor.Profile targetProfile(Cursor.Area area) {
            return Copier.TARGET_FEATURES;
        }
    }
}

