/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.mediator;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.NoMediator;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopiedCacheMediator
extends NoMediator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final CacheManager originalManager;
    protected final CacheManager copiedManager;
    protected final Map<DOMCachedNode, DOMCachedNode> copiedNodes;
    protected final List<CopiedCacheCursor> cursorsWithOriginal;
    private static final Logger logger = LoggerUtil.getLogger(CopiedCacheMediator.class);

    public CopiedCacheMediator(CacheManager cacheManager, CacheManager cacheManager2) {
        super(cacheManager.factory());
        this.originalManager = cacheManager;
        this.copiedManager = cacheManager2;
        this.copiedNodes = new IdentityHashMap<DOMCachedNode, DOMCachedNode>();
        this.cursorsWithOriginal = new LinkedList<CopiedCacheCursor>();
    }

    public final DOMCachedNode getCopiedNode(DOMCachedNode dOMCachedNode) {
        if (dOMCachedNode.getCache() != this.originalManager && this.originalManager.isCopy()) {
            dOMCachedNode = this.originalManager.getCopiedNode(dOMCachedNode);
        }
        return this.copiedNodes.get(dOMCachedNode);
    }

    public final void setCopiedNode(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        assert (dOMCachedNode.getCache() == this.originalManager);
        this.copiedNodes.put(dOMCachedNode, dOMCachedNode2);
    }

    public void registerCopiedCursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
        this.cursorsWithOriginal.add(copiedCacheCursor);
    }

    public void unregisterCopiedCursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
        this.cursorsWithOriginal.remove(copiedCacheCursor);
    }

    public void nodeAboutToChange(DOMCachedNode dOMCachedNode, Cursor.Area.ImmediateAreas immediateAreas) {
        DOMCachedNode dOMCachedNode2;
        if (this.copiedNodes == null) {
            return;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "nodeAboutToChange", "Entering nodeAboutToChange");
        }
        if (dOMCachedNode.isCopy()) {
            this.copySubtreeLazy(dOMCachedNode);
            return;
        }
        DOMCachedNode dOMCachedNode3 = this.getCopiedNode(dOMCachedNode);
        if (dOMCachedNode3 == null) {
            if (dOMCachedNode.itemKind() == 2) {
                dOMCachedNode2 = this.getCopiedNode(dOMCachedNode.getCachedParent());
                if (dOMCachedNode2 != null && LazyLoadingHelper.isAttributesBuilt(dOMCachedNode2.getState())) {
                    return;
                }
            } else {
                for (DOMCachedContainer dOMCachedContainer = dOMCachedNode.getCachedParent(); dOMCachedContainer != null; dOMCachedContainer = dOMCachedContainer.getCachedParent()) {
                    dOMCachedNode2 = this.getCopiedNode(dOMCachedContainer);
                    if (dOMCachedNode2 == null) continue;
                    if (!LazyLoadingHelper.isChildrenResolved(dOMCachedNode2.getState())) break;
                    return;
                }
            }
        }
        switch (immediateAreas) {
            case FIRST_CHILD: {
                if (dOMCachedNode3 != null && LazyLoadingHelper.isFirstChildBuilt(dOMCachedNode3.getState())) break;
                if (dOMCachedNode.getCachedFirstChild() == null) {
                    dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode);
                    dOMCachedNode3.setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode3.getState()));
                    break;
                }
                dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode.getCachedFirstChild());
                break;
            }
            case LAST_CHILD: {
                if (dOMCachedNode3 != null && LazyLoadingHelper.isLastChildBuilt(dOMCachedNode3.getState())) break;
                dOMCachedNode2 = dOMCachedNode.getCachedLastChild();
                if (dOMCachedNode2 == null) {
                    dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode);
                    dOMCachedNode3.setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode3.getState()));
                    break;
                }
                dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode2);
                dOMCachedNode3.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode3.getState()));
                if (dOMCachedNode3.getCachedParent() == null) break;
                dOMCachedNode3.getCachedParent().setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode3.getCachedParent().getState()));
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                if (dOMCachedNode3 != null && LazyLoadingHelper.isFollowingBuilt(dOMCachedNode3.getState())) break;
                if (dOMCachedNode.getCachedFollowingSibling() == null) {
                    dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode);
                    dOMCachedNode3.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode3.getState()));
                    if (dOMCachedNode3.getCachedParent() == null) break;
                    dOMCachedNode3.getCachedParent().setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode3.getCachedParent().getState()));
                    break;
                }
                dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode.getCachedFollowingSibling());
                break;
            }
            case ATTRIBUTE: {
                if (dOMCachedNode3 != null && LazyLoadingHelper.isLastAttributeBuilt(dOMCachedNode3.getState())) break;
                dOMCachedNode2 = dOMCachedNode.getCachedLastAttribute();
                if (dOMCachedNode2 == null) {
                    dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode);
                    dOMCachedNode3.setState(LazyLoadingHelper.markAttributesResolved(dOMCachedNode3.getState()));
                    break;
                }
                dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode.getCachedLastAttribute());
                dOMCachedNode3.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode3.getState()));
                dOMCachedNode3.getCachedParent().setState(LazyLoadingHelper.markAttributesResolved(dOMCachedNode3.getCachedParent().getState()));
                break;
            }
            default: {
                if (dOMCachedNode3 != null) break;
                dOMCachedNode3 = this.copyToOriginalNode(dOMCachedNode);
            }
        }
        MiscHelpers.setDirty(dOMCachedNode3);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "nodeAboutToChange", "Exiting nodeAboutToChange.  Original=" + dOMCachedNode.toStringLazy() + "\n Copy=" + this.getCopiedNode(dOMCachedNode));
        }
    }

    private final void copySubtreeLazy(DOMCachedNode dOMCachedNode) {
        for (DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.getBuiltFirstNamespace(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getBuiltFollowingNamespaceNode()) {
            if (dOMCachedNamespace.isCopy()) continue;
            this.copyToOriginalNode(dOMCachedNamespace);
        }
        for (DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.getBuiltFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getBuiltFollowingAttribute()) {
            if (dOMCachedAttribute.isCopy()) continue;
            this.copyToOriginalNode(dOMCachedAttribute);
        }
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.getBuiltFirstChild();
        while (dOMCachedNode2 != null) {
            this.copySubtreeLazy(dOMCachedNode2);
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getBuiltFollowingSibling();
            if (!dOMCachedNode2.isCopy()) {
                this.copyToOriginalNode(dOMCachedNode2);
            }
            dOMCachedNode2 = dOMCachedNode3;
        }
    }

    public final DOMCachedNode copyToOriginalNode(DOMCachedNode dOMCachedNode) {
        Object object2;
        if (dOMCachedNode == null) {
            return null;
        }
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        String string2 = null;
        DOMCachedNode dOMCachedNode2 = this.copiedManager.getCopiedNode(dOMCachedNode);
        if (bl && logger.isLoggable(Level.FINEST)) {
            string2 = XCIErrorHelper.getStackTrace(15);
            object2 = dOMCachedNode2 == null ? null : dOMCachedNode2.toStringLazy();
            logger.logp(Level.FINEST, logger.getName(), "copyToOriginalNode", "original node=" + dOMCachedNode.toStringLazy() + " | nodeCopy=" + (String)object2 + "\nStack trace=" + string2);
        }
        if (dOMCachedNode2 == null) {
            DOMCachedContainer dOMCachedContainer;
            Object object3 = object2 = dOMCachedNode.getBuiltPrecedingSibling() == null ? null : this.copyToOriginalNode(dOMCachedNode.getBuiltPrecedingSibling());
            if (bl && logger.isLoggable(Level.FINEST)) {
                if (object2 == null) {
                    logger.logp(Level.FINEST, logger.getName(), "copyToOriginalNode", "precedingCopy = null \nStack trace=" + string2);
                } else {
                    logger.logp(Level.FINEST, logger.getName(), "copyToOriginalNode", "preceding =" + ((DOMCachedNode)object2).toStringLazy() + "\nStack trace=" + string2);
                }
            }
            DOMCachedNode dOMCachedNode3 = dOMCachedContainer = object2 == null ? this.copyToOriginalNode(dOMCachedNode.getBuiltParent()) : ((DOMCachedNode)object2).getBuiltParent();
            if (bl && logger.isLoggable(Level.FINEST)) {
                if (dOMCachedContainer == null) {
                    logger.logp(Level.FINEST, logger.getName(), "copyToOriginalNode", "parentCopy = null \nStack trace=" + string2);
                } else {
                    logger.logp(Level.FINEST, logger.getName(), "copyToOriginalNode", "parentCopy =" + dOMCachedContainer.toStringLazy() + "\nStack trace=" + string2);
                }
            }
            if (object2 == null) {
                if (dOMCachedContainer != null) {
                    if (dOMCachedNode.itemKind() == 4) {
                        if (bl && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "erasing first namespace decl");
                        }
                        ((DOMCachedElement)dOMCachedContainer).setBuiltFirstNamespace(null);
                    } else if (dOMCachedNode.itemKind() == 2) {
                        if (bl && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "erasing first attribute");
                        }
                        ((DOMCachedElement)dOMCachedContainer).setBuiltFirstAttribute(null);
                    } else {
                        if (bl && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "erasing first child");
                        }
                        dOMCachedContainer.setBuiltFirstChild(null);
                    }
                }
            } else {
                logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "erasing following sibling");
                ((DOMCachedNode)object2).setBuiltFollowingSibling(null);
            }
            CacheManager cacheManager = dOMCachedContainer == null ? this.copiedManager : dOMCachedContainer.getCache();
            dOMCachedNode2 = MiscHelpers.makeNode(dOMCachedNode, cacheManager, dOMCachedContainer, (DOMCachedNode)object2);
            this.copiedManager.setCopiedNode(dOMCachedNode, dOMCachedNode2);
            if (dOMCachedNode2.getUserData() == null) {
                if (bl && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "nodeCopy didn't have an user data, so creating a copied user data for it +and setting the mediator to: + " + dOMCachedContainer.getMediatorData());
                }
                dOMCachedNode2.setUserData(this.copiedManager.createUserData());
                dOMCachedNode2.setMediatorData(dOMCachedContainer.getMediatorData());
            }
            dOMCachedNode2.setOriginalNode(dOMCachedNode);
            if (!(dOMCachedNode2.getMediatorData() instanceof CopiedCacheMediator)) {
                if (bl && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "nodeCopy had a mediator set which was NOT a copied mediator. It was " + dOMCachedNode2.getMediatorData());
                }
                dOMCachedNode2.setMediatorData(this);
            }
            if (dOMCachedContainer != null) {
                dOMCachedContainer.setState(LazyLoadingHelper.markFirstChildResolved(dOMCachedContainer.getState()));
            }
            if (object2 != null) {
                ((DOMCachedNode)object2).setState(LazyLoadingHelper.markFollowingResolved(((DOMCachedNode)object2).getState()));
            }
            for (int i = this.cursorsWithOriginal.size() - 1; i >= 0; --i) {
                this.cursorsWithOriginal.get(i).notifyCopy(dOMCachedNode, dOMCachedNode2);
            }
            dOMCachedNode2.setDirty();
        }
        if (bl && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "original node=" + dOMCachedNode + " | nodeCopy=" + dOMCachedNode2);
        }
        return dOMCachedNode2;
    }

    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.getOriginalNode().getCachedFirstChild();
        ((DOMCachedContainer)dOMCachedNode).setBuiltFirstChild(dOMCachedNode2);
        return dOMCachedNode2 != null;
    }

    public boolean buildAttributes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        DOMCachedAttribute dOMCachedAttribute = ((DOMCachedElement)dOMCachedElement.getOriginalNode()).getCachedFirstAttribute();
        dOMCachedElement.setBuiltFirstAttribute(dOMCachedAttribute);
        dOMCachedElement.setBuiltLastAttribute(dOMCachedAttribute);
        return dOMCachedAttribute != null;
    }

    public boolean buildNamespaceNodes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        DOMCachedNamespace dOMCachedNamespace = ((DOMCachedElement)dOMCachedElement.getOriginalNode()).getCachedFirstNamespaceNode();
        dOMCachedElement.setBuiltFirstNamespace(dOMCachedNamespace);
        dOMCachedElement.setBuiltLastNamespace(dOMCachedNamespace);
        return dOMCachedNamespace != null;
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "buildNext", "calling buildNext for node: " + dOMCachedNode.toStringLazy() + "\nCache manager = " + dOMCachedNode.getCache() + " | Mediator (default) = " + dOMCachedNode.getCache().mediator() + " | Mediator (for node) = " + dOMCachedNode.getMediatorData());
        }
        switch (dOMCachedNode.itemKind()) {
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                DOMCachedNode dOMCachedNode2 = dOMCachedNode.getOriginalNode().getCachedFollowingSibling();
                dOMCachedNode.setBuiltFollowingSibling(dOMCachedNode2);
                return dOMCachedNode2 != null;
            }
            case 2: {
                DOMCachedAttribute dOMCachedAttribute = ((DOMCachedAttribute)dOMCachedNode.getOriginalNode()).getCachedFollowingAttribute();
                if (dOMCachedAttribute == dOMCachedNode) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, logger.getName(), "buildNext", "tried to set a cycle for the attribute :  " + dOMCachedNode.toStringLazy());
                    }
                    return false;
                }
                dOMCachedNode.setBuiltFollowingSibling(dOMCachedAttribute);
                return dOMCachedAttribute != null;
            }
            case 4: {
                DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNamespace)dOMCachedNode.getOriginalNode()).getCachedFollowingNamespaceNode();
                dOMCachedNode.setBuiltFollowingSibling(dOMCachedNamespace);
                return dOMCachedNamespace != null;
            }
        }
        return false;
    }

    public ItemCopier getItemCopier(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "getItemCopier", "requesting a new itemCopier for mediator: " + this.originalManager.mediator() + " | originalNode: " + dOMCachedNode.getOriginalNode() + " | itemCopier: " + this.originalManager.mediator().getItemCopier(dOMCachedNode.getOriginalNode()));
        }
        return new CopiedItemCopier(this.originalManager.mediator().getItemCopier(dOMCachedNode.getOriginalNode()));
    }

    public Cursor focus() {
        return this.originalManager.mediator().focus();
    }

    protected class CopiedItemCopier
    extends NoMediator.GeneralItemCopier
    implements ItemCopier {
        ItemCopier originalItemCopier;

        CopiedItemCopier(ItemCopier itemCopier) {
            super(CopiedCacheMediator.this);
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CopiedItemCopier", "made a new Copied Item Copier with originalItemCopier=" + itemCopier);
            }
            this.originalItemCopier = itemCopier;
        }

        public int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
            Object object2;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                object2 = null;
                if (cursor2.unwrap() instanceof DOMCachedNode) {
                    DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
                    object2 = dOMCachedNode.toStringLazy();
                }
                logger.logp(Level.FINER, logger.getName(), "copyNode", "source =" + (String)object2);
            }
            object2 = (CopiedCacheCursor)cursor2;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "copyNode", "source manager =" + ((DOMCachedNode)((CacheCursor)object2).getDelegate()).getCache() + "\n copiedManager = " + CopiedCacheMediator.this.copiedManager);
            }
            return super.copyNode(cursor2, cursor3, area);
        }

        public Cursor.Profile sourceProfile() {
            return Copier.SOURCE_FEATURES;
        }

        public Cursor.Profile targetProfile(Cursor.Area area) {
            return Copier.TARGET_FEATURES;
        }
    }
}

