/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.helpers;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedComment;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedPI;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.DMUtil;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscHelpers {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(MiscHelpers.class);

    public static void setDirty(DOMCachedNode dOMCachedNode) {
        dOMCachedNode.setState(BitMaskHelper.stateSet(dOMCachedNode.getState(), 65536));
        for (DOMCachedContainer dOMCachedContainer = dOMCachedNode.getBuiltParent(); dOMCachedContainer != null && !BitMaskHelper.stateContains(dOMCachedContainer.getState(), 524288); dOMCachedContainer = dOMCachedContainer.getBuiltParent()) {
            dOMCachedContainer.setState(BitMaskHelper.stateSet(dOMCachedContainer.getState(), 65536));
            if (dOMCachedNode == dOMCachedContainer) {
                return;
            }
            dOMCachedContainer.setState(BitMaskHelper.stateSet(dOMCachedContainer.getState(), 524288));
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "setDirty", "Finished setting the dirty state on node=" + dOMCachedNode.toStringLazy() + "\nStack trace= " + XCIErrorHelper.getStackTrace(10));
        }
    }

    public static void visitAttributes(DOMCachedNode dOMCachedNode) {
        if (LazyLoadingHelper.isAttributesBuilt(dOMCachedNode.getState())) {
            return;
        }
        if (!LazyLoadingHelper.isFirstAttributeBuilt(dOMCachedNode.getState())) {
            dOMCachedNode.getCachedFirstAttribute();
        }
        for (DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.getBuiltLastAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
        }
    }

    public static void visitNamespaceNodes(DOMCachedNode dOMCachedNode) {
        for (DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
        }
    }

    public static void visitChildren(DOMCachedNode dOMCachedNode) {
        DOMCachedNode dOMCachedNode2;
        if (!LazyLoadingHelper.isFirstChildBuilt(dOMCachedNode.getState())) {
            dOMCachedNode2 = dOMCachedNode.getBuiltFirstChild();
            if (dOMCachedNode2 == null) {
                dOMCachedNode2 = dOMCachedNode.getCachedFirstChild();
            }
            while (dOMCachedNode2 != null) {
                dOMCachedNode2 = dOMCachedNode2.getCachedPrecedingSibling();
            }
        }
        if (!LazyLoadingHelper.isLastChildBuilt(dOMCachedNode.getState())) {
            for (dOMCachedNode2 = dOMCachedNode.getBuiltLastChild(); dOMCachedNode2 != null; dOMCachedNode2 = dOMCachedNode2.getCachedFollowingSibling()) {
            }
        }
        dOMCachedNode.setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode.getState()));
    }

    public static void visitSubtree(DOMCachedNode dOMCachedNode) {
        if (!BitMaskHelper.stateContains(dOMCachedNode.getState(), 6159)) {
            MiscHelpers.visitNamespaceNodes(dOMCachedNode);
            MiscHelpers.visitAttributes(dOMCachedNode);
            for (DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedFirstChild(); dOMCachedNode2 != null; dOMCachedNode2 = dOMCachedNode2.getCachedFollowingSibling()) {
                dOMCachedNode2.visitSubtree();
            }
            BitMaskHelper.stateSet(dOMCachedNode.getState(), 6159);
        }
    }

    public static void updateEntireSubtree(DOMCachedNode dOMCachedNode, CacheManager cacheManager) {
        DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.getCachedFirstNamespaceNode();
        while (dOMCachedNamespace != null) {
            DOMCachedNamespace dOMCachedNamespace2 = dOMCachedNamespace.getCachedFollowingNamespaceNode();
            dOMCachedNamespace.setCacheManager(cacheManager);
            dOMCachedNamespace = dOMCachedNamespace2;
        }
        DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.getCachedFirstAttribute();
        while (dOMCachedAttribute != null) {
            DOMCachedAttribute dOMCachedAttribute2 = dOMCachedAttribute.getCachedFollowingAttribute();
            MiscHelpers.updateAttribute(dOMCachedAttribute, cacheManager);
            dOMCachedAttribute = dOMCachedAttribute2;
        }
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedFirstChild();
        while (dOMCachedNode2 != null) {
            MiscHelpers.updateEntireSubtree(dOMCachedNode2, cacheManager);
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getCachedFollowingSibling();
            dOMCachedNode2.setCacheManager(cacheManager);
            dOMCachedNode2 = dOMCachedNode3;
        }
    }

    public static void updateLazySubtree(DOMCachedNode dOMCachedNode, CacheManager cacheManager) {
        for (DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.getBuiltFirstNamespace(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getBuiltFollowingNamespaceNode()) {
            dOMCachedNamespace.setCacheManager(cacheManager);
        }
        for (DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.getBuiltFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getBuiltFollowingAttribute()) {
            MiscHelpers.updateAttribute(dOMCachedAttribute, cacheManager);
        }
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.getBuiltFirstChild();
        while (dOMCachedNode2 != null) {
            MiscHelpers.updateLazySubtree(dOMCachedNode2, cacheManager);
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getBuiltFollowingSibling();
            dOMCachedNode2.setCacheManager(cacheManager);
            dOMCachedNode2 = dOMCachedNode3;
        }
    }

    public static void updateAttribute(DOMCachedAttribute dOMCachedAttribute, CacheManager cacheManager) {
        if (dOMCachedAttribute.isId()) {
            dOMCachedAttribute.getCache().removeID(dOMCachedAttribute);
            cacheManager.addID(dOMCachedAttribute);
        } else if (dOMCachedAttribute.itemIsIDREFS()) {
            dOMCachedAttribute.getCache().removeIDREF(dOMCachedAttribute);
            cacheManager.addIDREF(dOMCachedAttribute);
        }
        dOMCachedAttribute.setCacheManager(cacheManager);
    }

    public static boolean isPreservedNamespaceDecls(Map<String, Object> map2) {
        return MiscHelpers.getBoolean("preserve-param-decl", map2, false);
    }

    public static boolean isEagerLoading(Map<String, Object> map2) {
        return MiscHelpers.getBoolean("eager-loading", map2, false);
    }

    public static boolean isValidLoading(Map<String, Object> map2) {
        return MiscHelpers.getBoolean("valid-loading", map2, false);
    }

    public static boolean isSchemaSpecialization(Map<String, Object> map2) {
        return MiscHelpers.getBoolean("schema-specialized", map2, false);
    }

    public static DOMCachedNode makeNode(Cursor cursor2, CacheManager cacheManager, DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        DOMCachedNode dOMCachedNode3;
        boolean bl = false;
        switch (cursor2.itemKind()) {
            case 9: {
                if (bl) {
                    System.out.println("[NEW] Document cache node: " + cursor2.itemName());
                }
                dOMCachedNode3 = cacheManager.nodeFactory().makeCachedDocument(cacheManager, null, null);
                break;
            }
            case 2: {
                if (bl) {
                    System.out.println("[NEW] Attribute cache node: " + cursor2.itemName() + "=" + cursor2.itemTypedValue());
                }
                DOMCachedAttribute dOMCachedAttribute = cacheManager.nodeFactory().makeCachedAttribute(cacheManager, cursor2.itemName(), cursor2.itemTypedValue(), (AttributePSVI)cursor2.itemXSPSVInfo(), cursor2.itemXSAttributeDeclaration(), (DOMCachedElement)dOMCachedNode);
                dOMCachedAttribute.itemValueOrigin = cursor2.itemAttributeValueOrigin();
                dOMCachedAttribute.setState(6159);
                dOMCachedNode3 = dOMCachedAttribute;
                break;
            }
            case 1: {
                if (bl) {
                    System.out.println("[NEW] Element cache node: " + cursor2.itemName());
                }
                dOMCachedNode3 = cacheManager.nodeFactory().makeCachedElement(cacheManager, cursor2.itemName(), cursor2.itemXSType(), (ElementPSVI)cursor2.itemXSPSVInfo(), cursor2.itemXSElementDeclaration(), cursor2.itemNilled(), (DOMCachedContainer)dOMCachedNode, dOMCachedNode2);
                break;
            }
            case 3: {
                if (bl) {
                    System.out.println("[NEW] Text cache node:  " + cursor2.itemTypedValue());
                }
                VolatileCData volatileCData = cursor2 instanceof AbstractCursor ? ((AbstractCursor)cursor2).itemValue() : cursor2.itemTypedValue();
                DOMCachedText dOMCachedText = cacheManager.nodeFactory().makeCachedText(cacheManager, volatileCData, false, cursor2.itemIsAtomic(), (DOMCachedContainer)dOMCachedNode, dOMCachedNode2);
                dOMCachedText.setState(6159);
                dOMCachedNode3 = dOMCachedText;
                break;
            }
            case 8: {
                if (bl) {
                    System.out.println("[NEW] Comment cache node: " + cursor2.itemTypedValue());
                }
                DOMCachedComment dOMCachedComment = cacheManager.makeCachedComment(cursor2.itemTypedValue(), (DOMCachedContainer)dOMCachedNode, dOMCachedNode2);
                dOMCachedComment.setState(6159);
                dOMCachedNode3 = dOMCachedComment;
                break;
            }
            case 7: {
                if (bl) {
                    System.out.println("[NEW] Processing instruction cache node: " + cursor2.itemName());
                }
                DOMCachedPI dOMCachedPI = cacheManager.makeCachedPI(cursor2.itemName(), cursor2.itemTypedValue(), (DOMCachedContainer)dOMCachedNode, dOMCachedNode2);
                dOMCachedPI.setState(6159);
                dOMCachedNode3 = dOMCachedPI;
                break;
            }
            case 4: {
                if (bl) {
                    System.out.println("[NEW] Document cache node: " + cursor2.itemName());
                }
                DOMCachedNamespace dOMCachedNamespace = cacheManager.makeCachedNamespaceNode(cursor2.itemName(), cursor2.itemTypedValue(), (DOMCachedElement)dOMCachedNode);
                dOMCachedNamespace.setState(6159);
                dOMCachedNode3 = dOMCachedNamespace;
                break;
            }
            default: {
                assert (false) : "Impossible child node: " + DMUtil.kindSource(cursor2.itemKind());
                dOMCachedNode3 = null;
            }
        }
        return dOMCachedNode3;
    }

    public static DOMCachedNode makeTextNode(VolatileCData volatileCData, CacheManager cacheManager, DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        boolean bl = false;
        if (bl) {
            System.out.println("[NEW] Text cache node:  " + volatileCData.toString());
        }
        DOMCachedText dOMCachedText = cacheManager.nodeFactory().makeCachedText(cacheManager, volatileCData, false, false, (DOMCachedContainer)dOMCachedNode, dOMCachedNode2);
        dOMCachedText.setState(6159);
        return dOMCachedText;
    }

    public static boolean getBoolean(String string2, Map<String, Object> map2, boolean bl) {
        Object object2;
        if (map2 != null && (object2 = map2.get(string2)) != null && object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        return bl;
    }

    public static boolean verifyMutation(short s, short s2, Cursor.Area area) {
        if (area != Cursor.Area.FOLLOWING_SIBLING && area != Cursor.Area.FIRST_CHILD && area != Cursor.Area.LAST_CHILD && area != Cursor.Area.ATTRIBUTES && area != Cursor.Area.NAMESPACE_DECLS) {
            throw XCIErrorHelper.createBadArgumentException("where", area.toString());
        }
        switch (s2) {
            case 9: {
                if (area != Cursor.Area.FIRST_CHILD && area != Cursor.Area.LAST_CHILD) {
                    throw XCIErrorHelper.createBadMutationCombination(s2);
                }
                if (s != 2 && s != 4 && s != 9) break;
                throw XCIErrorHelper.createBadMutationCombination(s, s2);
            }
            case 3: 
            case 7: 
            case 8: {
                if (area != Cursor.Area.FOLLOWING_SIBLING) {
                    throw XCIErrorHelper.createBadMutationCombination(s2);
                }
                if (s != 2 && s != 4 && s != 9) break;
                throw XCIErrorHelper.createBadMutationCombination(s, s2);
            }
            case 1: {
                if (!(area == Cursor.Area.NAMESPACE_DECLS ? s != 4 : (area == Cursor.Area.ATTRIBUTES ? s != 2 : s == 2 || s == 4 || s == 9))) break;
                throw XCIErrorHelper.createBadMutationCombination(s, s2);
            }
            case 2: 
            case 4: {
                throw XCIErrorHelper.createBadContextItemException(s);
            }
        }
        return true;
    }

    public static boolean materializeDocument(Cursor cursor2) {
        return CacheManager.materializeDocument(cursor2);
    }

    public static boolean materializeDocument(Cursor cursor2, Executable executable) {
        return CacheManager.materializeDocument(cursor2, executable);
    }
}

