/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedComment;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedPI;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.dom.EmptyNodeList;
import com.ibm.xml.xci.dp.cache.dom.UserData;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.CopiedCacheMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.BaseURIHelper;
import com.ibm.xml.xci.dp.util.DMUtil;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.util.fixers.MoveFixer;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.values.NamespaceDeclQNameCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DOMCachedNode
extends AbstractCursor
implements NodeTest,
Node,
ItemCopier {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Cursor.Profile FROZEN_CACHE_NODE_PROFILE = Cursor.Profile.FROZEN.union(Cursor.Profile.SET_VALUE.union(Cursor.Profile.REMOVE_ATTRIBUTE.union(Cursor.Profile.REMOVE_SUBTREE.union(Cursor.Profile.IS_DEEP_EQUAL_TO))));
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedNode.class);
    protected CacheManager cache;
    protected DOMCachedContainer parent;
    protected DOMCachedNode following;
    protected DOMCachedNode preceding;
    protected int state;
    protected UserData data;
    private int nodeID = -1;
    protected String subtreeID;
    private String baseURI = null;

    protected DOMCachedNode(CacheManager cacheManager) {
        super(cacheManager.factory(), false);
        this.cache = cacheManager;
        this.data = this.cache.createUserData();
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedNode", "creating a new DOMCachedNode: " + this.toStringLazy() + "\nCache manager = " + this.getCache() + " | Mediator (default) = " + this.getCache().mediator() + " | Mediator (for node) = " + this.getMediatorData());
        }
    }

    protected DOMCachedNode(CacheManager cacheManager, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        this(cacheManager);
        if (dOMCachedContainer != null) {
            this.parent = dOMCachedContainer;
            if (dOMCachedNode == null) {
                dOMCachedContainer.addBuiltFirstChild(this);
                if (this.data != null && dOMCachedContainer.getUserData() != null) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, logger.getName(), "DOMCachedNode", "setting a mediator data as the same as parent: " + dOMCachedContainer.getUserData().toString());
                    }
                    this.setMediatorData(dOMCachedContainer.getMediatorData());
                }
            } else {
                assert (dOMCachedContainer == dOMCachedNode.getBuiltParent()) : "Cannot have siblings with different parents!";
                dOMCachedContainer.addBuiltNextChild(this, dOMCachedNode);
                if (this.data != null && dOMCachedNode.getUserData() != null) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, logger.getName(), "DOMCachedNode", "setting a mediator data as the same as preceding sibling: " + dOMCachedNode.getUserData().toString());
                    }
                    this.setMediatorData(dOMCachedNode.getMediatorData());
                }
            }
        }
        this.cache.registerNode(this);
    }

    protected boolean isAncestor(DOMCachedNode dOMCachedNode) {
        return dOMCachedNode == this || this.parent != null && this.parent.isAncestor(dOMCachedNode);
    }

    public final CacheManager getCache() {
        return this.cache;
    }

    public final boolean isCopy() {
        if (this.data != null) {
            return this.data.getOriginalNode() != null;
        }
        return false;
    }

    public int getCacheNodeKind() {
        return this.itemKind();
    }

    public abstract boolean satisfies(NodeTest var1);

    public DOMCachedNode getCachedRoot() {
        return this.getBuiltRoot();
    }

    public DOMCachedNode getBuiltRoot() {
        return this.cache.getBuiltRootNode();
    }

    public final DOMCachedContainer getBuiltParent() {
        return this.parent;
    }

    public final DOMCachedContainer getCachedParent() {
        return this.parent;
    }

    public abstract DOMCachedAttribute getCachedFirstAttribute();

    public abstract DOMCachedAttribute getCachedLastAttribute();

    public abstract DOMCachedAttribute getCachedNamedAttribute(NodeTest var1);

    public DOMCachedNamespace getCachedNamedNamespace(NodeTest nodeTest) {
        return null;
    }

    public DOMCachedNamespace getCachedNamedNamespace(String string2, String string3) {
        return null;
    }

    protected DOMCachedAttribute getBuiltNamedAttribute(NodeTest nodeTest) {
        return null;
    }

    public DOMCachedNamespace getCachedFirstNamespaceNode() {
        return null;
    }

    @Override
    public Cursor itemCopy(Cursor.Profile profile, Map<String, Object> map2) {
        Cursor cursor2;
        boolean bl = MiscHelpers.getBoolean("copy-on-write", map2, false);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "itemCopy", "CopyOnwrite= " + bl + ", of node=" + this.toStringLazy());
        }
        Cursor cursor3 = cursor2 = bl ? this.cache.copy(this, profile, true, map2) : super.itemCopy(profile, map2);
        assert (cursor2 instanceof CacheCursor);
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
        if (!bl) {
            dOMCachedNode.state = LazyLoadingHelper.markAllResolved(dOMCachedNode.state);
            if (dOMCachedNode.getUserData() == null) {
                if (this.data != null) {
                    dOMCachedNode.setUserData(this.data);
                } else {
                    dOMCachedNode.setUserData(new StreamingCursorMediator.XCIOriginalNodeDataImpl());
                }
            }
            dOMCachedNode.getUserData().setOriginalNode(this);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            try {
                DOMCachedNode dOMCachedNode2 = (DOMCachedNode)cursor2.unwrap();
                logger.logp(Level.FINER, logger.getName(), "itemCopy", "Copied item= " + dOMCachedNode2.toStringLazy());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return cursor2;
    }

    public DOMCachedNamespace getCachedLastNamespaceNode() {
        return null;
    }

    public abstract DOMCachedNode getCachedFirstChild();

    public DOMCachedNode getCachedFirstChild(NodeTest nodeTest) {
        return null;
    }

    public abstract DOMCachedNode getCachedLastChild();

    public DOMCachedNode getCachedFollowingSibling() {
        if (this.following == null && !LazyLoadingHelper.isFollowingBuilt(this.state)) {
            this.cache.mediator(this).buildNext(this);
            this.state = LazyLoadingHelper.markFollowingResolved(this.state);
        }
        return this.following;
    }

    public DOMCachedNode getCachedFollowingSibling(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getCachedFollowingSibling();
        }
        for (DOMCachedNode dOMCachedNode = this.getCachedFollowingSibling(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling()) {
            if (!dOMCachedNode.satisfies(nodeTest)) continue;
            return dOMCachedNode;
        }
        return null;
    }

    public final DOMCachedNode getBuiltFollowingSibling() {
        return this.following;
    }

    public void setBuiltFollowingSibling(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            String string2 = dOMCachedNode == null ? "" : dOMCachedNode.toStringLazy();
            logger.logp(Level.FINEST, logger.getName(), "setBuiltFollowingSibling", "this = " + this.toStringLazy() + "node passed in = " + string2 + "\nStack trace=" + XCIErrorHelper.getStackTrace(15));
        }
        this.following = dOMCachedNode;
    }

    public DOMCachedNode getBuiltFollowingSibling(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getBuiltFollowingSibling();
        }
        for (DOMCachedNode dOMCachedNode = this.getBuiltFollowingSibling(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling()) {
            if (!dOMCachedNode.satisfies(nodeTest)) continue;
            return dOMCachedNode;
        }
        return null;
    }

    public DOMCachedNode getCachedPrecedingSibling() {
        return this.getBuiltPrecedingSibling();
    }

    public DOMCachedNode getCachedPrecedingSibling(NodeTest nodeTest) {
        return this.getBuiltPrecedingSibling(nodeTest);
    }

    protected DOMCachedNode getBuiltPrecedingSibling(NodeTest nodeTest) {
        DOMCachedNode dOMCachedNode = this.preceding;
        while (dOMCachedNode != null) {
            if (nodeTest == null || dOMCachedNode.satisfies(nodeTest)) {
                return dOMCachedNode;
            }
            dOMCachedNode = dOMCachedNode.preceding;
        }
        return null;
    }

    public final DOMCachedNode getBuiltPrecedingSibling() {
        return this.preceding;
    }

    public DOMCachedAttribute getBuiltFirstAttribute() {
        return null;
    }

    public DOMCachedAttribute getBuiltLastAttribute() {
        return null;
    }

    public DOMCachedNamespace getBuiltFirstNamespace() {
        return null;
    }

    public DOMCachedNamespace getBuiltLastNamespace() {
        return null;
    }

    public DOMCachedNode getBuiltFirstChild() {
        return null;
    }

    public DOMCachedNode getBuiltFirstChild(NodeTest nodeTest) {
        return null;
    }

    public DOMCachedNode getBuiltLastChild() {
        return null;
    }

    public final void visitAttributes() {
        MiscHelpers.visitAttributes(this);
    }

    public final void visitNamespaceNodes() {
        MiscHelpers.visitNamespaceNodes(this);
    }

    public final void visitChildren() {
        MiscHelpers.visitChildren(this);
    }

    public final void visitSubtree() {
        MiscHelpers.visitSubtree(this);
    }

    public final Map getDOMUserData() {
        return this.data.getDOMUserData();
    }

    public final void setDOMUserData(Map map2) {
        this.data.setDOMUserData(map2);
    }

    public final void setMediatorData(Object object2) {
        this.data.setMediatorData(object2);
    }

    public final Object getMediatorData() {
        if (this.getUserData() != null) {
            return this.getUserData().getMediatorData();
        }
        return null;
    }

    public final DOMCachedNode getOriginalNode() {
        return this.data.getOriginalNode();
    }

    public final void setOriginalNode(DOMCachedNode dOMCachedNode) {
        this.data.setOriginalNode(dOMCachedNode);
    }

    public final UserData getUserData() {
        return this.data;
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n2) {
        this.state = n2;
    }

    public final void dereference() {
        this.cache.unreferenced(this);
    }

    public final DOMCachedNode reference() {
        this.cache.referenced(this);
        return this;
    }

    public void unlink() {
        this.unlink(true);
    }

    public void unlink(boolean bl) {
        if (this.parent != null) {
            if (this.parent.builtFirstChild == this) {
                this.parent.builtFirstChild = this.following;
            }
            if (this.parent.builtLastChild == this) {
                this.parent.builtLastChild = this.preceding;
            }
        }
        if (this.preceding != null) {
            this.preceding.following = this.following;
        }
        if (this.following != null) {
            this.following.preceding = this.preceding;
        }
        if (bl) {
            this.checkAdjacent(this.preceding, this.following);
        }
        this.parent = null;
        this.preceding = null;
        this.following = null;
    }

    public void updateCacheLazy(CacheManager cacheManager) {
        MiscHelpers.updateLazySubtree(this, cacheManager);
        if (this.cache.copies != null) {
            List<CacheManager> list = this.cache.copies;
            if (cacheManager.copies == null) {
                cacheManager.copies = new ArrayList<CacheManager>(list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                cacheManager.copies.add(list.get(i));
            }
        }
        if (this.cache.getAttemptFastSerialization()) {
            cacheManager.setAttemptFastSerialization(true);
        }
        this.setCacheManager(cacheManager);
    }

    public void updateCacheEntire(CacheManager cacheManager) {
        MiscHelpers.updateEntireSubtree(this, cacheManager);
        if (this instanceof DOMCachedAttribute) {
            MiscHelpers.updateAttribute((DOMCachedAttribute)this, cacheManager);
        }
        if (this.cache.copies != null) {
            List<CacheManager> list = this.cache.copies;
            if (cacheManager.copies == null) {
                cacheManager.copies = new ArrayList<CacheManager>(list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                cacheManager.copies.add(list.get(i));
            }
        }
        if (this.cache.getAttemptFastSerialization()) {
            cacheManager.setAttemptFastSerialization(true);
        }
        this.cache = cacheManager;
        this.cache.rootNode = this;
    }

    public int depth() {
        return this.parent == null ? 0 : 1 + this.parent.depth();
    }

    public boolean isDirty() {
        return BitMaskHelper.stateContains(this.state, 65536);
    }

    public boolean isSubtreeDirty() {
        return BitMaskHelper.stateContains(this.state, 524288);
    }

    public boolean isMutationMapQueued() {
        return BitMaskHelper.stateContains(this.state, 0x100000);
    }

    public boolean isParentChainMutationMapQueue(boolean bl) {
        if (this.parent == null) {
            return this.isMutationMapQueued();
        }
        if (!bl && this.isMutationMapQueued()) {
            return true;
        }
        if (this.parent.isParentChainMutationMapQueue(false)) {
            this.setState(BitMaskHelper.stateSet(this.getState(), 0x100000));
            return true;
        }
        return false;
    }

    public DOMCachedElement addCachedElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        DOMCachedElement dOMCachedElement;
        if (xSTypeDefinition == null) {
            xSTypeDefinition = TypeRegistry.XSANYTYPE;
        }
        this.cache.ensureStateResolved(this, area);
        this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                dOMCachedElement = this.cache.makeCachedElement(volatileCData, xSTypeDefinition, null, null, false, (DOMCachedContainer)this, null);
                break;
            }
            case LAST_CHILD: {
                dOMCachedElement = this.cache.makeCachedElement(volatileCData, xSTypeDefinition, null, null, false, (DOMCachedContainer)this, this.getBuiltLastChild());
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedElement = this.cache.makeCachedElement(volatileCData, xSTypeDefinition, null, null, false, this.getBuiltParent(), this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        dOMCachedElement.state = LazyLoadingHelper.markAllResolved();
        this.setDirty(dOMCachedElement);
        return dOMCachedElement;
    }

    protected DOMCachedNode removeCachedSubtree(Cursor.Area area) {
        DOMCachedNode dOMCachedNode;
        this.cache.ensureStateResolved(this, area);
        if (area.immediateArea() == Cursor.Area.ImmediateAreas.SELF || area.immediateArea() == Cursor.Area.ImmediateAreas.IMMEDIATE_FOLLOWING) {
            this.cache.notifyNodeAboutToChangeToCopies(this.parent, Cursor.Area.ImmediateAreas.LAST_CHILD);
        } else {
            this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        }
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                dOMCachedNode = this.getBuiltFirstChild();
                if (dOMCachedNode == null) break;
                if (!LazyLoadingHelper.isSubtreeBuilt(dOMCachedNode.state)) {
                    dOMCachedNode.visitChildren();
                }
                if (!LazyLoadingHelper.isFollowingBuilt(dOMCachedNode.state)) {
                    dOMCachedNode.getCachedFollowingSibling();
                }
                ((DOMCachedContainer)this).unlinkChild(dOMCachedNode);
                break;
            }
            case LAST_CHILD: {
                dOMCachedNode = this.getBuiltLastChild();
                ((DOMCachedContainer)this).unlinkChild(dOMCachedNode);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedNode = this.getBuiltFollowingSibling();
                if (dOMCachedNode == null) break;
                dOMCachedNode.getCachedFollowingSibling();
                this.getBuiltParent().unlinkChild(dOMCachedNode);
                break;
            }
            case SELF: {
                if (this.getBuiltParent() != null) {
                    dOMCachedNode = this;
                    dOMCachedNode.getCachedFollowingSibling();
                    this.getBuiltParent().unlinkChild(dOMCachedNode);
                    break;
                }
                dOMCachedNode = null;
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        if (dOMCachedNode != null) {
            dOMCachedNode.updateCacheLazy(this.cache.getNewInstance());
            dOMCachedNode.cache.rootNode = dOMCachedNode;
        }
        return dOMCachedNode;
    }

    @Override
    public Cursor.Profile profile() {
        return FROZEN_CACHE_NODE_PROFILE;
    }

    @Override
    public final Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public final Cursor.Profile futureProfile() {
        return this.cache.featuresLimit(this);
    }

    @Override
    public abstract short itemKind();

    @Override
    public boolean itemIsAtomic() {
        return false;
    }

    @Override
    public boolean itemIsID() {
        return false;
    }

    @Override
    public VolatileCData itemName() {
        return this.factory.data(TypeRegistry.XSQNAME);
    }

    @Override
    public abstract VolatileCData itemValue();

    @Override
    public abstract Chars itemSValue();

    public CharSequence getString(VolatileCData volatileCData) {
        if (volatileCData.getSize() == 1) {
            return volatileCData;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = volatileCData.getSize();
        for (int i = 1; i <= n2; ++i) {
            if (i != 1) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(volatileCData);
        }
        return stringBuilder;
    }

    @Override
    public abstract void setItemValue(VolatileCData var1);

    @Override
    public void setItemName(VolatileCData volatileCData) {
        throw XCIErrorHelper.createBadContextItemException("setItemName", this.itemKind());
    }

    @Override
    public void setItemPSVI(ItemPSVI itemPSVI) {
        throw XCIErrorHelper.createBadContextItemException("setItemPSVI", this.itemKind());
    }

    @Override
    public void setItemXSType(XSTypeDefinition xSTypeDefinition) {
        throw XCIErrorHelper.createBadContextItemException("setItemXSType", this.itemKind());
    }

    protected void checkSetItemName(VolatileCData volatileCData) {
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("name", "null");
        }
        try {
            volatileCData.getQNameNamespaceURI(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            throw XCIErrorHelper.createBadArgumentException("name", volatileCData.toString());
        }
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext() {
        return this.itemNamespaceContext(false);
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        return null;
    }

    @Override
    public boolean toSelf() {
        return true;
    }

    @Override
    public void release() {
        this.cache.free(this);
        super.release();
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return this.cache.fork(this, profile, bl, profile2);
    }

    @Override
    public long contextPosition() {
        if (this.parent != null) {
            return 1L;
        }
        long l = 0L;
        DOMCachedNode dOMCachedNode = this;
        while (dOMCachedNode != null) {
            ++l;
            dOMCachedNode = dOMCachedNode.preceding;
        }
        return l;
    }

    @Override
    public long contextSize() {
        if (this.parent != null) {
            return 1L;
        }
        long l = this.contextPosition();
        DOMCachedNode dOMCachedNode = this.following;
        while (dOMCachedNode != null) {
            ++l;
            dOMCachedNode = dOMCachedNode.following;
        }
        return l;
    }

    @Override
    public boolean itemIsSameDocument(Cursor cursor2) {
        if (!((cursor2 = cursor2.unwrap()) instanceof DOMCachedNode)) {
            return false;
        }
        return this.getBuiltRoot() == ((DOMCachedNode)cursor2).getBuiltRoot();
    }

    @Override
    public final boolean itemIsSameNode(Cursor cursor2) {
        return this == cursor2.unwrap();
    }

    @Override
    public boolean contextIsSingleton() {
        return this.parent != null || this.preceding == null && this.following == null;
    }

    @Override
    public Object exportAs(String string2, boolean bl) {
        if ("expdom2".equals(string2) || "expdom1".equals(string2)) {
            return bl ? this : this.reference();
        }
        return super.exportAs(string2, bl);
    }

    @Override
    public Class<?> exportAsClass(String string2) {
        if ("expdom2".equals(string2) || "expdom1".equals(string2)) {
            return Node.class;
        }
        return super.exportAsClass(string2);
    }

    @Override
    public boolean openMutation(Cursor.Area area) {
        return this.cache.openMutation(this, area);
    }

    @Override
    public void closeMutation() {
        this.cache.closeMutation(this);
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        throw XCIErrorHelper.createBadContextItemException("addAttribute", this.itemKind());
    }

    @Override
    public boolean removeAttribute(VolatileCData volatileCData) {
        throw XCIErrorHelper.createBadContextItemException("removeAttribute", this.itemKind());
    }

    @Override
    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        short s = this.itemKind();
        short[] sArray = new short[]{2, 4};
        Cursor.Area[] areaArray = new Cursor.Area[]{Cursor.Area.FIRST_CHILD, Cursor.Area.LAST_CHILD, Cursor.Area.FOLLOWING_SIBLING};
        if (XCIErrorHelper.checkDisallowedKind(s, sArray)) {
            throw XCIErrorHelper.createBadContextItemException("addElement", s);
        }
        if (!XCIErrorHelper.checkAllowedArea(area, areaArray)) {
            throw XCIErrorHelper.createBadArgumentException("where", area.toString());
        }
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("value", "null");
        }
        try {
            volatileCData.getQNameNamespaceURI(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            throw XCIErrorHelper.createBadArgumentException("name", volatileCData.toString());
        }
        if (!XCIErrorHelper.addElementOrTextCheck(area, s)) {
            throw XCIErrorHelper.createBadMutationCombination(s);
        }
        this.addCachedElement(area, volatileCData, xSTypeDefinition);
    }

    @Override
    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        short s = this.itemKind();
        short[] sArray = new short[]{2, 4};
        Cursor.Area[] areaArray = new Cursor.Area[]{Cursor.Area.FIRST_CHILD, Cursor.Area.LAST_CHILD, Cursor.Area.FOLLOWING_SIBLING};
        if (XCIErrorHelper.checkDisallowedKind(s, sArray)) {
            throw XCIErrorHelper.createBadContextItemException("addText", s);
        }
        if (!XCIErrorHelper.checkAllowedArea(area, areaArray)) {
            throw XCIErrorHelper.createBadArgumentException("where", area.toString());
        }
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("value", "null");
        }
        if (!XCIErrorHelper.addElementOrTextCheck(area, s)) {
            throw XCIErrorHelper.createBadMutationCombination(s);
        }
        this.cache.ensureStateResolved(this, area);
        this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        DOMCachedNode dOMCachedNode = null;
        boolean bl = false;
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                if (this.checkAdjacent(this.getBuiltFirstChild(), volatileCData, false)) {
                    bl = true;
                    dOMCachedNode = this.getBuiltFirstChild();
                    break;
                }
                dOMCachedNode = this.cache.makeCachedText(volatileCData, false, false, (DOMCachedContainer)this, null);
                break;
            }
            case LAST_CHILD: {
                if (this.checkAdjacent(this.getBuiltLastChild(), volatileCData, true)) {
                    bl = true;
                    dOMCachedNode = this.getBuiltLastChild();
                    break;
                }
                dOMCachedNode = this.cache.makeCachedText(volatileCData, false, false, (DOMCachedContainer)this, this.getBuiltLastChild());
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                if (this.checkAdjacent(this, volatileCData, true)) {
                    bl = true;
                    dOMCachedNode = this;
                    break;
                }
                if (this.checkAdjacent(this.following, volatileCData, false)) {
                    bl = true;
                    dOMCachedNode = this;
                    break;
                }
                dOMCachedNode = this.cache.makeCachedText(volatileCData, false, false, this.getBuiltParent(), this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        if (!bl) {
            dOMCachedNode.state = LazyLoadingHelper.markAllResolved();
        }
        this.setDirty(dOMCachedNode);
    }

    protected boolean checkAdjacent(DOMCachedNode dOMCachedNode, VolatileCData volatileCData, boolean bl) {
        if (dOMCachedNode == null) {
            return false;
        }
        if (dOMCachedNode instanceof DOMCachedText) {
            DOMCachedText dOMCachedText = (DOMCachedText)dOMCachedNode;
            String string2 = bl ? dOMCachedText.getData().concat(volatileCData.toString()) : volatileCData.toString().concat(dOMCachedText.getData());
            dOMCachedText.setData(string2);
            return true;
        }
        return false;
    }

    protected boolean checkAdjacent(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (dOMCachedNode != null && dOMCachedNode2 != null && dOMCachedNode instanceof DOMCachedText && dOMCachedNode2 instanceof DOMCachedText) {
            this.checkAdjacent(dOMCachedNode, dOMCachedNode2.itemValue(), true);
            dOMCachedNode.setDirty();
            dOMCachedNode2.unlink(false);
            if (!LazyLoadingHelper.isFollowingBuilt(dOMCachedNode2.state)) {
                dOMCachedNode.state = BitMaskHelper.stateUnset(dOMCachedNode.state, 512);
                Cursor cursor2 = ((StreamingCursorMediator.XCIData)((Object)dOMCachedNode2.getUserData())).getXCI();
                ((StreamingCursorMediator.XCIData)((Object)dOMCachedNode.getUserData())).setXCI(cursor2);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        DOMCachedComment dOMCachedComment;
        this.cache.ensureStateResolved(this, area);
        this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                dOMCachedComment = this.cache.makeCachedComment(volatileCData, (DOMCachedContainer)this, null);
                break;
            }
            case LAST_CHILD: {
                dOMCachedComment = this.cache.makeCachedComment(volatileCData, (DOMCachedContainer)this, this.getBuiltLastChild());
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedComment = this.cache.makeCachedComment(volatileCData, this.getBuiltParent(), this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        dOMCachedComment.state = LazyLoadingHelper.markAllResolved();
        this.setDirty(dOMCachedComment);
    }

    @Override
    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        DOMCachedPI dOMCachedPI;
        this.cache.ensureStateResolved(this, area);
        this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                dOMCachedPI = this.cache.makeCachedPI(volatileCData, volatileCData2, (DOMCachedContainer)this, null);
                break;
            }
            case LAST_CHILD: {
                dOMCachedPI = this.cache.makeCachedPI(volatileCData, volatileCData2, (DOMCachedContainer)this, this.getBuiltLastChild());
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedPI = this.cache.makeCachedPI(volatileCData, volatileCData2, this.getBuiltParent(), this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        dOMCachedPI.state = LazyLoadingHelper.markAllResolved();
        this.setDirty(dOMCachedPI);
    }

    @Override
    public void addCopy(Cursor.Area area, Cursor cursor2) {
        MiscHelpers.verifyMutation(cursor2.itemKind(), this.itemKind(), area);
        Cursor cursor3 = this.fork(false, Copier.TARGET_FEATURES, Copier.TARGET_FEATURES);
        Copier.copy(cursor2, cursor3, area);
    }

    @Override
    public boolean removeSubtree(Cursor.Area area) {
        short s = this.itemKind();
        short[] sArray = new short[]{2, 4};
        Cursor.Area[] areaArray = new Cursor.Area[]{Cursor.Area.FIRST_CHILD, Cursor.Area.LAST_CHILD, Cursor.Area.FOLLOWING_SIBLING, Cursor.Area.SELF};
        if (XCIErrorHelper.checkDisallowedKind(s, sArray)) {
            throw XCIErrorHelper.createBadContextItemException("removeSubtree", s);
        }
        if (area == null) {
            throw XCIErrorHelper.createBadArgumentException("where", "null");
        }
        if (!XCIErrorHelper.checkAllowedArea(area, areaArray)) {
            throw XCIErrorHelper.createBadArgumentException("where", area.toString());
        }
        if (!XCIErrorHelper.removeSubtreeCheck(area, s)) {
            return false;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeSubtree", "area=" + area.toString() + " from node=" + this.toStringLazy());
        }
        return this.removeCachedSubtree(area) != null;
    }

    @Override
    public void move(Cursor.Area area, Cursor cursor2) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "move", "moving node=" + cursor2 + " into area=" + area.toString());
        }
        if (cursor2.unwrap() instanceof DOMCachedNode) {
            if (this == cursor2.unwrap() && LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                logger.logp(Level.WARNING, logger.getName(), "move", "introducing a direct cycle into the data model through node= " + this.toStringLazy());
            }
            MiscHelpers.verifyMutation(cursor2.itemKind(), this.itemKind(), area);
            this.cache.ensureStateResolved(this, area);
            this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
            List<DOMCachedNode> list = this.processSequenceList(area, cursor2);
            this.moveSequence(area, list);
            list.clear();
            this.setDirty(this);
            return;
        }
        MoveFixer.move(this, area, cursor2);
    }

    protected void moveSequence(Cursor.Area area, List<DOMCachedNode> list) {
        DOMCachedContainer dOMCachedContainer = null;
        if (this instanceof DOMCachedContainer) {
            dOMCachedContainer = (DOMCachedContainer)this;
        }
        switch (area.immediateArea()) {
            case LAST_CHILD: {
                dOMCachedContainer.addBuiltLastChild(list);
                break;
            }
            case FIRST_CHILD: {
                dOMCachedContainer.addBuiltFirstChild(list);
                break;
            }
            case NAMESPACE_DECLS: {
                ((DOMCachedElement)dOMCachedContainer).addBuiltNamespace(list);
                break;
            }
            case ATTRIBUTE: {
                ((DOMCachedElement)dOMCachedContainer).addBuiltAttribute(list);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                this.parent.addBuiltNextChild(list, this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
    }

    public List<DOMCachedNode> processSequenceList(Cursor.Area area, Cursor cursor2) {
        int n2;
        Object object2;
        DOMCachedNode dOMCachedNode;
        ArrayList<DOMCachedNode> arrayList = new ArrayList<DOMCachedNode>();
        switch (area.immediateArea()) {
            case IMMEDIATE_FOLLOWING: {
                dOMCachedNode = this.parent;
                break;
            }
            default: {
                dOMCachedNode = this;
            }
        }
        cursor2 = cursor2.fork(false, Cursor.Profile.MINIMAL_NAVIGATION, Cursor.Profile.MINIMAL_NAVIGATION);
        do {
            DOMCachedNode dOMCachedNode2 = (DOMCachedNode)cursor2.unwrap();
            dOMCachedNode2.getCache().notifyNodeAboutToChangeToCopies(dOMCachedNode2, Cursor.Area.ImmediateAreas.SELF);
            if (dOMCachedNode2.itemKind() == 1 && dOMCachedNode2.isCopy()) {
                DOMCachedElement dOMCachedElement = (DOMCachedElement)dOMCachedNode2;
                if (dOMCachedElement.nsContext != null) {
                    object2 = dOMCachedElement.getInScopeNamespacesList();
                    n2 = object2.size();
                    for (int i = 0; i < n2; i += 2) {
                        NamespaceDeclQNameCData namespaceDeclQNameCData = new NamespaceDeclQNameCData(object2.get(i));
                        StringCData stringCData = new StringCData((CharSequence)object2.get(i + 1), TypeRegistry.XSSTRING);
                        DOMCachedNamespace dOMCachedNamespace = dOMCachedElement.getCache().makeCachedNamespaceNode(namespaceDeclQNameCData, stringCData, dOMCachedElement);
                        dOMCachedNamespace.state = LazyLoadingHelper.markAllResolved();
                        dOMCachedElement.getCache().setCopiedNode(dOMCachedNamespace, dOMCachedNamespace);
                        dOMCachedNamespace.setOriginalNode(dOMCachedNamespace);
                    }
                }
            }
            arrayList.add(dOMCachedNode2);
            this.setDirty(dOMCachedNode2);
        } while (cursor2.toNext());
        cursor2.release();
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (DOMCachedNode)arrayList.get(i);
            ((DOMCachedNode)object2).unlink();
            if (((DOMCachedNode)object2).cache != this.cache) {
                ((DOMCachedNode)object2).updateCacheLazy(this.cache);
            }
            ((DOMCachedNode)object2).preceding = i == 0 ? null : (DOMCachedNode)arrayList.get(i - 1);
            ((DOMCachedNode)object2).following = i + 1 >= arrayList.size() ? null : (DOMCachedNode)arrayList.get(i + 1);
            n2 = ((DOMCachedNode)object2).getState();
            ((DOMCachedNode)object2).setState(n2 | 0x80 | 0x200);
            if (this.checkAdjacent(((DOMCachedNode)object2).preceding, (DOMCachedNode)object2)) {
                arrayList.remove(i);
                --i;
            }
            if (((DOMCachedNode)object2).parent != null) {
                this.setDirty(((DOMCachedNode)object2).parent);
            }
            ((DOMCachedNode)object2).parent = (DOMCachedContainer)dOMCachedNode;
            this.setDirty((DOMCachedNode)object2);
            if (dOMCachedNode == null) continue;
            this.setDirty(dOMCachedNode);
        }
        return arrayList;
    }

    protected void setDirty(DOMCachedNode dOMCachedNode) {
        MiscHelpers.setDirty(dOMCachedNode);
    }

    public void setDirty() {
        this.setDirty(this);
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        Cursor cursor2 = this.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        VolatileCData volatileCData = this.cache.serialize(cursor2, map2);
        cursor2.release();
        return volatileCData;
    }

    @Override
    public boolean itemIsBeforeNode(Cursor cursor2) {
        DOMCachedNode dOMCachedNode = this;
        if (!this.itemIsSameDocument(cursor2)) {
            return this.factory().getSessionContext().documentIsBefore(this.itemDocumentIdentity(), cursor2.itemDocumentIdentity());
        }
        DOMCachedNode dOMCachedNode2 = (DOMCachedNode)cursor2.unwrap();
        if (!this.itemSameOriginalDocument(dOMCachedNode2)) {
            return this.slowItemIsBeforeNode(dOMCachedNode2);
        }
        if (dOMCachedNode == dOMCachedNode2) {
            return false;
        }
        if (dOMCachedNode.subtreeID == null && dOMCachedNode2.subtreeID == null) {
            return dOMCachedNode.nodeID < dOMCachedNode2.nodeID;
        }
        if (dOMCachedNode.subtreeID != null && dOMCachedNode2.subtreeID != null) {
            return this.compareSubtreeIDs(dOMCachedNode.subtreeID, dOMCachedNode2.subtreeID);
        }
        if (dOMCachedNode.subtreeID != null) {
            return this.compareSubtreeWithNodeID(dOMCachedNode.subtreeID, dOMCachedNode2.nodeID);
        }
        return !this.compareSubtreeWithNodeID(dOMCachedNode2.subtreeID, dOMCachedNode.nodeID);
    }

    private int getNextInt(String string2, int n2) {
        int n3 = 0;
        int n4 = string2.length();
        char c = string2.charAt(n2);
        while (c != '.') {
            n3 = n3 * 10 + (c - 48);
            if (++n2 >= n4) break;
            c = string2.charAt(n2);
        }
        return n3;
    }

    protected boolean compareSubtreeIDs(String string2, String string3) {
        int n2 = -2;
        int n3 = -2;
        int n4 = -1;
        int n5 = -1;
        do {
            if ((n2 = this.getNextInt(string2, n4 + 1)) != (n3 = this.getNextInt(string3, n5 + 1))) {
                return n2 < n3;
            }
            n4 = string2.indexOf(46, n4 + 1);
            n5 = string3.indexOf(46, n5 + 1);
        } while (n4 != -1 && n5 != -1);
        return n4 == -1;
    }

    protected boolean compareSubtreeWithNodeID(String string2, int n2) {
        int n3 = this.getNextInt(string2, 0);
        return n3 < n2;
    }

    public boolean slowItemIsBeforeNode(DOMCachedNode dOMCachedNode) {
        int n2;
        DOMCachedNode dOMCachedNode2 = this;
        int n3 = this.depth();
        if (n3 < (n2 = dOMCachedNode.depth())) {
            do {
                dOMCachedNode = dOMCachedNode.parent;
            } while (n3 < --n2);
            if (dOMCachedNode2 == dOMCachedNode) {
                return true;
            }
        } else {
            while (n3 > n2) {
                dOMCachedNode2 = dOMCachedNode2.parent;
                --n3;
            }
            if (dOMCachedNode2 == dOMCachedNode) {
                return false;
            }
        }
        assert (n2 == n3 && dOMCachedNode2 != dOMCachedNode) : "comparison balancing messed up!?";
        while (dOMCachedNode2.parent != null && dOMCachedNode2.parent != dOMCachedNode.parent) {
            assert (dOMCachedNode.parent != null) : "comparison balancing messed up!?";
            dOMCachedNode2 = dOMCachedNode2.parent;
            dOMCachedNode = dOMCachedNode.parent;
        }
        if (dOMCachedNode2.parent == null) {
            assert (dOMCachedNode.parent == null) : "comparison balancing messed up!?";
            return dOMCachedNode.hashCode() - dOMCachedNode2.hashCode() < 0;
        }
        if (dOMCachedNode2.itemKind() == 2) {
            if (dOMCachedNode.itemKind() == 2) {
                for (DOMCachedAttribute dOMCachedAttribute = ((DOMCachedElement)dOMCachedNode2.parent).getBuiltFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getBuiltFollowingAttribute()) {
                    if (dOMCachedAttribute == dOMCachedNode2) {
                        return true;
                    }
                    if (dOMCachedAttribute != dOMCachedNode) continue;
                    return false;
                }
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CHILD_NOT_FOUND", new String[]{"attribute"}));
            }
            return dOMCachedNode.itemKind() != 4;
        }
        if (dOMCachedNode2.itemKind() == 4) {
            if (dOMCachedNode.itemKind() == 4) {
                for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedElement)dOMCachedNode2.parent).getBuiltFirstNamespace(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getBuiltFollowingNamespaceNode()) {
                    if (dOMCachedNamespace == dOMCachedNode2) {
                        return true;
                    }
                    if (dOMCachedNamespace != dOMCachedNode) continue;
                    return false;
                }
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CHILD_NOT_FOUND", new String[]{"namespace"}));
            }
            return true;
        }
        if (dOMCachedNode.itemKind() == 2 || dOMCachedNode.itemKind() == 4) {
            return false;
        }
        for (DOMCachedNode dOMCachedNode3 = dOMCachedNode2.parent.getBuiltFirstChild(); dOMCachedNode3 != null; dOMCachedNode3 = dOMCachedNode3.getBuiltFollowingSibling()) {
            if (dOMCachedNode3 == dOMCachedNode2) {
                return true;
            }
            if (dOMCachedNode3 != dOMCachedNode) continue;
            return false;
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CHILD_NOT_FOUND", new String[]{"element child"}));
    }

    protected boolean itemSameOriginalDocument(DOMCachedNode dOMCachedNode) {
        return this.cache.mediator(this, false).documentID() == dOMCachedNode.cache.mediator(dOMCachedNode, false).documentID();
    }

    @Override
    public abstract boolean test(Cursor var1);

    @Override
    public boolean allowsAttribute(VolatileCData volatileCData) {
        return false;
    }

    @Override
    public boolean allowsNamespace(VolatileCData volatileCData) {
        return false;
    }

    @Override
    public boolean allowsComment() {
        return false;
    }

    @Override
    public boolean allowsDocument() {
        return false;
    }

    @Override
    public boolean allowsElement(VolatileCData volatileCData) {
        return false;
    }

    @Override
    public boolean allowsProcessingInstruction(String string2) {
        return false;
    }

    @Override
    public boolean allowsText() {
        return false;
    }

    @Override
    public NameTest theNameTest() {
        return null;
    }

    @Override
    public abstract String getNodeName();

    @Override
    public abstract String getNodeValue();

    @Override
    public void setNodeValue(String string2) throws DOMException {
    }

    @Override
    public abstract short getNodeType();

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return EmptyNodeList.INSTANCE;
    }

    @Override
    public Node getFirstChild() {
        return this.getCachedFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.getCachedLastChild();
    }

    @Override
    public final Node getPreviousSibling() {
        return this.getCachedPrecedingSibling();
    }

    @Override
    public final Node getNextSibling() {
        return this.getCachedFollowingSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        if (this.itemKind() == 9) {
            return null;
        }
        return this.cache.getCachedDocument();
    }

    @Override
    public Node insertBefore(Node node2, Node node3) throws DOMException {
        throw XCIErrorHelper.createDOMException((short)9);
    }

    @Override
    public Node replaceChild(Node node2, Node node3) throws DOMException {
        throw XCIErrorHelper.createDOMException((short)3);
    }

    @Override
    public Node removeChild(Node node2) throws DOMException {
        throw XCIErrorHelper.createDOMException((short)3);
    }

    @Override
    public Node appendChild(Node node2) throws DOMException {
        throw XCIErrorHelper.createDOMException((short)3);
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node cloneNode(boolean bl) {
        return null;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String string2, String string3) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String string2) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public short compareDocumentPosition(Node node2) throws DOMException {
        if (this == node2) {
            return 0;
        }
        if (node2 == null || !(node2 instanceof DOMCachedNode)) {
            throw XCIErrorHelper.createDOMException((short)9);
        }
        DOMCachedNode dOMCachedNode = (DOMCachedNode)node2;
        if (!this.itemIsSameDocument(dOMCachedNode)) {
            if (this.factory().getSessionContext().documentIsBefore(this.itemDocumentIdentity(), dOMCachedNode.itemDocumentIdentity())) {
                return 37;
            }
            return 35;
        }
        if (this.itemIsBeforeNode(dOMCachedNode)) {
            DOMCachedContainer dOMCachedContainer = dOMCachedNode.parent;
            while (dOMCachedContainer != null) {
                if (dOMCachedContainer == this) {
                    return 20;
                }
                dOMCachedContainer = dOMCachedContainer.parent;
            }
            if (this.getFirstChild() == dOMCachedNode) {
                return 20;
            }
            return 4;
        }
        DOMCachedContainer dOMCachedContainer = this.parent;
        while (dOMCachedContainer != null) {
            if (dOMCachedContainer == dOMCachedNode) {
                return 10;
            }
            dOMCachedContainer = dOMCachedContainer.parent;
        }
        if (dOMCachedNode.getFirstChild() == this) {
            return 10;
        }
        return 2;
    }

    @Override
    public boolean isSameNode(Node node2) {
        return node2 == this;
    }

    @Override
    public boolean isEqualNode(Node node2) {
        if (node2 == null) {
            return false;
        }
        if (this.isSameNode(node2)) {
            return true;
        }
        this.normalize();
        node2.normalize();
        if (this.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!this.checkEquality(this.getNodeName(), node2.getNodeName())) {
            return false;
        }
        if (!this.checkEquality(this.getLocalName(), node2.getLocalName())) {
            return false;
        }
        if (!this.checkEquality(this.getNamespaceURI(), node2.getNamespaceURI())) {
            return false;
        }
        if (!this.checkEquality(this.getPrefix(), node2.getPrefix())) {
            return false;
        }
        if (!this.checkEquality(this.getNodeValue(), node2.getNodeValue())) {
            return false;
        }
        if (!this.checkEquality(this.getAttributes(), node2.getAttributes())) {
            return false;
        }
        NodeList nodeList = this.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList == null || nodeList2 == null) {
            if (nodeList != null || nodeList2 != null) {
                return false;
            }
        } else {
            if (nodeList.getLength() != nodeList2.getLength()) {
                return false;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).isEqualNode(nodeList2.item(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkEquality(NamedNodeMap namedNodeMap, NamedNodeMap namedNodeMap2) {
        if (namedNodeMap == null || namedNodeMap2 == null) {
            if (namedNodeMap != null || namedNodeMap2 != null) {
                return false;
            }
        } else {
            if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
                return false;
            }
            int n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node2 = namedNodeMap.item(0);
                boolean bl = false;
                for (int j = 0; j < n2; ++j) {
                    if (!node2.isEqualNode(namedNodeMap2.item(j))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkEquality(String string2, String string3) {
        if (string2 != null) {
            return string2.equals(string3);
        }
        return string3 == null;
    }

    @Override
    public String getBaseURI() {
        String string2 = this.itemBaseURI();
        return string2 == null ? null : string2;
    }

    @Override
    public boolean isDefaultNamespace(String string2) {
        return string2.equals(this.lookupNamespaceURI(null));
    }

    @Override
    public String lookupNamespaceURI(String string2) {
        return this.parent == null ? null : this.parent.lookupNamespaceURI(string2);
    }

    @Override
    public String lookupPrefix(String string2) {
        return this.parent == null ? null : this.parent.lookupPrefix(string2);
    }

    @Override
    public String getTextContent() throws DOMException {
        return StringChars.toString(this.itemStringValueAsChars());
    }

    @Override
    public void setTextContent(String string2) throws DOMException {
    }

    @Override
    public Object getUserData(String string2) {
        if (this.data.getDOMUserData() == null) {
            return null;
        }
        DataAndHandler dataAndHandler = (DataAndHandler)this.data.getDOMUserData().get(string2);
        if (dataAndHandler == null) {
            return null;
        }
        return dataAndHandler.data;
    }

    @Override
    public Object setUserData(String string2, Object object2, UserDataHandler userDataHandler) {
        Object object3 = this.getUserData(string2);
        HashMap<String, DataAndHandler> hashMap = this.data.getDOMUserData();
        if (hashMap == null) {
            hashMap = new HashMap<String, DataAndHandler>();
            this.data.setDOMUserData(hashMap);
        }
        hashMap.put(string2, new DataAndHandler(object2, userDataHandler));
        return object3;
    }

    public void setUserData(UserData userData) {
        this.data = userData;
    }

    @Override
    public Object getFeature(String string2, String string3) {
        return null;
    }

    @Override
    public int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        if (this.cache.getItemCopier() != null) {
            return this.cache.getItemCopier().copyNode(cursor2, cursor3, area);
        }
        return 0;
    }

    @Override
    public Cursor.Profile sourceProfile() {
        if (this.cache.getItemCopier() != null) {
            return this.cache.getItemCopier().sourceProfile();
        }
        return Copier.SOURCE_FEATURES;
    }

    @Override
    public Cursor.Profile targetProfile(Cursor.Area area) {
        if (this.cache.getItemCopier() != null) {
            return this.cache.getItemCopier().sourceProfile();
        }
        return Copier.TARGET_FEATURES;
    }

    public abstract DOMCachedAttribute getCachedNamedAttribute(String var1, String var2);

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof Cursor) {
            return this == ((Cursor)object2).unwrap();
        }
        return false;
    }

    public void printXQuery(Writer writer) {
        try {
            this.getBuiltRoot().printXQuery(writer, "", true);
            StringBuilder stringBuilder = new StringBuilder();
            DOMCachedNode dOMCachedNode = this;
            while (dOMCachedNode != null) {
                stringBuilder.insert(0, dOMCachedNode.sequenceLocator());
                dOMCachedNode = dOMCachedNode.parent;
            }
            writer.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected abstract void printXQuery(Writer var1, String var2, boolean var3) throws IOException;

    String sequenceLocator() {
        switch (this.itemKind()) {
            case 9: {
                return "";
            }
            case 2: {
                return "/@" + this.itemName();
            }
        }
        int n2 = 0;
        for (DOMCachedNode dOMCachedNode = this; dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltPrecedingSibling()) {
            if (!this.test(dOMCachedNode)) continue;
            ++n2;
        }
        switch (this.itemKind()) {
            case 1: {
                return "/" + this.itemName().toString() + "[" + n2 + "]";
            }
            case 3: {
                return "/text()[" + n2 + "]";
            }
            case 7: {
                return "/processing-instruction(" + this.itemName().getString(1) + ")[" + n2 + "]";
            }
            case 8: {
                return "/comment()[" + n2 + "]";
            }
        }
        return "?";
    }

    public String toStringLazy() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.printXQuery(stringWriter, "", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringWriter.write(" | nodeID=" + this.nodeID + " | subtreeID=" + this.subtreeID);
        return stringWriter.toString();
    }

    public String toString() {
        return this.toStringLazy();
    }

    protected String printState() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  (: state:" + DMUtil.stateSource(this.state));
        stringBuilder.append(" :)");
        return stringBuilder.toString();
    }

    protected String printUserData() {
        if (this.getUserData() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" (: user data:" + this.getUserData().toString());
            stringBuilder.append(" :)");
            return stringBuilder.toString();
        }
        return null;
    }

    public void setCacheManager(CacheManager cacheManager) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "setCacheManager", "setting the new cache manager{ " + cacheManager.toString() + "} into node " + this.toStringLazy());
        }
        if (this.data != null) {
            if (this.data.getMediatorData() == null) {
                if (this.cache.mediator() instanceof CopiedCacheMediator || this.cache.mediator() instanceof StreamingCursorMediator) {
                    this.data.setMediatorData(this.cache.mediator());
                } else if (cacheManager.mediator() instanceof StreamingCursorMediator) {
                    this.data.setMediatorData(cacheManager.mediator());
                } else {
                    Cursor cursor2 = this.cache.mediator().focus();
                    if (cursor2 != null) {
                        this.data.setMediatorData(new StreamingCursorMediator(cursor2, cursor2.profile()));
                    }
                }
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "setCacheManager", "Changed user data:" + this.data.toString());
            }
        }
        this.cache = cacheManager;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    @Override
    public long itemNodeIdentity() {
        return this.nodeID;
    }

    public void setNodeID(int n2) {
        this.nodeID = n2;
    }

    public void buildSubtreeID() {
        if (this.subtreeID == null) {
            this.subtreeID = Integer.toString(this.nodeID);
            if (this.itemKind() == 1) {
                DOMCachedElement dOMCachedElement = (DOMCachedElement)this;
                for (DOMCachedNode dOMCachedNode = dOMCachedElement.getBuiltFirstNamespace(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling()) {
                    this.cache.registerNode(dOMCachedNode);
                }
                for (DOMCachedNode dOMCachedNode = dOMCachedElement.getBuiltFirstAttribute(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling()) {
                    this.cache.registerNode(dOMCachedNode);
                }
            }
        }
    }

    public void resetSubtreeID() {
        this.subtreeID = null;
    }

    public String getSubtreeID() {
        return this.subtreeID;
    }

    public void addChildID(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 2);
        stringBuilder.append(string2);
        stringBuilder.append('.');
        stringBuilder.append(0);
        this.subtreeID = stringBuilder.toString();
    }

    public void addSiblingID(String string2) {
        int n2 = string2.lastIndexOf(46);
        int n3 = this.getNextInt(string2, n2 + 1);
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 1);
        if (n2 != -1) {
            stringBuilder.append(string2.substring(0, n2 + 1));
        }
        stringBuilder.append(n3 + 1);
        this.subtreeID = stringBuilder.toString();
    }

    @Override
    public long itemDocumentIdentity() {
        return this.cache.documentIdentify();
    }

    @Override
    public void setItemBaseURI(String string2) {
        this.baseURI = string2;
    }

    @Override
    public String itemBaseUri() {
        return this.itemBaseURI();
    }

    @Override
    public String itemBaseURI() {
        if (this.baseURI == null) {
            this.baseURI = BaseURIHelper.computeBaseURI(this);
            if (this.baseURI != null) {
                return this.baseURI;
            }
            this.baseURI = this.parent == null ? null : this.parent.itemBaseURI();
        }
        return this.baseURI;
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return false;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return true;
    }

    class DataAndHandler {
        final Object data;
        final UserDataHandler handler;

        DataAndHandler(Object object2, UserDataHandler userDataHandler) {
            this.data = object2;
            this.handler = userDataHandler;
        }
    }
}

