/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class DOMCachedNamespace
extends DOMCachedSimple
implements Attr {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedNamespace.class);
    protected VolatileCData name;

    public DOMCachedNamespace(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, DOMCachedElement dOMCachedElement) {
        super(cacheManager, volatileCData2, null, null);
        this.name = volatileCData;
        if (dOMCachedElement != null) {
            dOMCachedElement.addBuiltNamespace(this);
        }
        if (this.parent != null) {
            if (this.preceding == null) {
                if (this.getUserData() != null && this.parent.getUserData() != null) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, logger.getName(), "DOMCachedNamespace", "setting a mediator data as the same as parent: " + this.parent.getUserData().toString());
                    }
                    this.setMediatorData(this.parent.getMediatorData());
                }
            } else if (this.getUserData() != null && this.preceding.getUserData() != null) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "DOMCachedNamespace", "setting a mediator data as the same as preceding sibling: " + this.preceding.getUserData().toString());
                }
                this.setMediatorData(this.preceding.getMediatorData());
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedNamespace", "creating a new DOMCachedNamespace: " + this.toStringLazy() + "\nCache manager = " + this.getCache() + " | Mediator (default) = " + this.getCache().mediator() + " | Mediator (for node) = " + this.getMediatorData());
        }
    }

    public DOMCachedNamespace getCachedFollowingNamespaceNode() {
        if (this.following == null && !LazyLoadingHelper.isFollowingBuilt(this.state)) {
            if (!this.cache.mediator(this).buildNext(this)) {
                this.parent.state = LazyLoadingHelper.markNamespacesResolved(this.parent.state);
            }
            this.state = LazyLoadingHelper.markFollowingResolved(this.state);
        }
        return (DOMCachedNamespace)this.following;
    }

    public DOMCachedNamespace getCachedPrecedingNamespaceNode() {
        return this.getBuiltPrecedingNamespaceNode();
    }

    public DOMCachedNamespace getCachedPrecedingNamespaceNode(NodeTest nodeTest) {
        return this.getBuiltPrecedingNamespaceNode(nodeTest);
    }

    public DOMCachedNamespace getBuiltFollowingNamespaceNode() {
        return (DOMCachedNamespace)this.following;
    }

    public DOMCachedNamespace getBuiltPrecedingNamespaceNode() {
        return (DOMCachedNamespace)this.preceding;
    }

    public DOMCachedNamespace getBuiltPrecedingNamespaceNode(NodeTest nodeTest) {
        return (DOMCachedNamespace)this.getBuiltPrecedingSibling(nodeTest);
    }

    public boolean satisfies(NodeTest nodeTest) {
        return nodeTest == null || nodeTest.allowsAttribute(this.itemName());
    }

    public DOMCachedNode getCachedFollowingSibling() {
        return null;
    }

    public DOMCachedNode getCachedPrecedingSibling() {
        return null;
    }

    public short itemKind() {
        return 4;
    }

    public VolatileCData itemName() {
        return this.name;
    }

    public void setItemName(VolatileCData volatileCData) {
        this.checkSetItemName(volatileCData);
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
        this.name = volatileCData;
        this.setDirty(this);
    }

    public VolatileCData serialize(Map map2) {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"serialize", DOMCachedNamespace.class.getName()}));
    }

    public boolean test(Cursor cursor2) {
        return cursor2.itemKind() == 2 && this.name.equals(cursor2.itemName());
    }

    public boolean allowsNamespace(VolatileCData volatileCData) {
        return this.name.equals(volatileCData);
    }

    public NameTest theNameTest() {
        return SimpleNameTest.name(this.itemName());
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public short getNodeType() {
        return 2;
    }

    public Node getParentNode() {
        return null;
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/xmlns/";
    }

    public String getPrefix() {
        return "xmlns";
    }

    public void setPrefix(String string2) throws DOMException {
    }

    public String getLocalName() {
        return this.name.getQNameLocalPart(1);
    }

    public String getName() {
        String string2 = this.name.getQNamePrefix(1);
        return (string2 == null || string2.length() == 0 ? "" : string2 + ":") + this.name.getQNameLocalPart(1);
    }

    public boolean getSpecified() {
        return true;
    }

    public String getValue() {
        return this.data == null ? "" : this.data.toString();
    }

    public void setValue(String string2) throws DOMException {
        this.setItemValue(this.factory.data((CharSequence)string2, TypeRegistry.XSSTRING, false));
    }

    public Element getOwnerElement() {
        if (this.parent == null) {
            return null;
        }
        assert (this.parent.itemKind() == 1) : "Attribute has  no parent?";
        return (Element)((Object)this.parent);
    }

    public boolean isId() {
        return this.itemIsID();
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    protected void printXQuery(Writer writer, String string2, boolean bl) throws IOException {
        if (this.data != null) {
            writer.write(string2 + this.printState() + " namespace " + this.name + " { " + CharsBase.toEncodedString(this.data) + " }\n");
        } else {
            writer.write(string2 + this.printState() + " namespace " + this.name + " { nulldata }\n");
        }
    }

    public String itemBaseURI() {
        return null;
    }

    public void setItemBaseURI(String string2) {
    }
}

