/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.UserData;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.helpers.NSListIterator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.CommonJAXPQNames;
import com.ibm.xml.xci.dp.util.StringCDataBuilder;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.BaseCDataWithChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.errors.XCIIllegalContextItemException;
import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.serializer.HiddenOptions;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMCachedElement
extends DOMCachedContainer
implements Element,
NamedNodeMap,
ExtendedNamespaceContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private CData name;
    protected XSTypeDefinition xstype;
    protected DOMCachedAttribute builtFirstAttribute;
    protected DOMCachedAttribute builtLastAttribute;
    protected DOMCachedNamespace builtFirstNamespace;
    protected DOMCachedNamespace builtLastNamespace;
    protected ElementPSVI xspsvi;
    protected XSElementDeclaration xsElemDecl;
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedElement.class);
    protected ElementNSContext nsContext;
    public static final String DOCACHEXDMITEM_OPTION = "doCacheXDMTyping";
    public static final boolean doCacheXDMTyping = HiddenOptions.optionValueIs("doCacheXDMTyping", "on");

    public DOMCachedElement(CacheManager cacheManager) {
        super(cacheManager);
    }

    protected DOMCachedElement(CacheManager cacheManager, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, ElementPSVI elementPSVI, boolean bl, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        this(cacheManager, volatileCData, xSTypeDefinition, elementPSVI, null, bl, dOMCachedContainer, dOMCachedNode);
    }

    protected DOMCachedElement(CacheManager cacheManager, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, ElementPSVI elementPSVI, XSElementDeclaration xSElementDeclaration, boolean bl, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        super(cacheManager, dOMCachedContainer, dOMCachedNode);
        this.name = volatileCData.constant(true);
        this.xstype = xSTypeDefinition;
        this.xsElemDecl = xSElementDeclaration;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedElement", "creating a new DOMCachedElement with name=" + this.name.getString(1));
        }
        if (elementPSVI != null) {
            this.setItemPSVI(elementPSVI);
        }
        if (bl) {
            this.state = BitMaskHelper.stateSet(this.state, 262144);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedElement", "creating a new DOMCachedElement: " + this.toStringLazy() + "\nCache manager = " + this.getCache() + " | Mediator (default) = " + this.getCache().mediator() + " | Mediator (for node) = " + this.getMediatorData());
        }
    }

    protected void addBuiltAttribute(DOMCachedAttribute dOMCachedAttribute) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "addBuiltAttribute", "name=" + dOMCachedAttribute.itemName().getString(1) + " | " + "value=" + dOMCachedAttribute.itemStringValue().getString(1) + "\nStack trace= " + XCIErrorHelper.getStackTrace(15));
        }
        dOMCachedAttribute.parent = this;
        if (this.builtFirstAttribute == null) {
            this.builtFirstAttribute = dOMCachedAttribute;
            this.builtLastAttribute = dOMCachedAttribute;
            if (!LazyLoadingHelper.isAttributesBuilt(this.state)) {
                dOMCachedAttribute.state = BitMaskHelper.stateUnset(dOMCachedAttribute.state, 512);
                if (this.getUserData() instanceof StreamingCursorMediator.XCIData) {
                    Cursor cursor2 = ((StreamingCursorMediator.XCIData)((Object)this.getUserData())).getXCI();
                    ((StreamingCursorMediator.XCIData)((Object)dOMCachedAttribute.getUserData())).setXCI(cursor2);
                }
                this.state = BitMaskHelper.stateSet(this.state, 1);
            }
        } else {
            if (dOMCachedAttribute == this.builtLastAttribute || dOMCachedAttribute == this.builtFirstAttribute) {
                return;
            }
            dOMCachedAttribute.preceding = this.builtLastAttribute;
            this.builtLastAttribute.following = dOMCachedAttribute;
            dOMCachedAttribute.following = null;
            this.builtLastAttribute = dOMCachedAttribute;
            int n2 = dOMCachedAttribute.preceding.state;
            if (!BitMaskHelper.stateContains(n2, 512)) {
                if (dOMCachedAttribute.getUserData() == null) {
                    UserData userData = this.getUserData();
                    dOMCachedAttribute.setUserData(userData);
                } else if (this.getUserData() instanceof StreamingCursorMediator.XCIData) {
                    Cursor cursor3 = ((StreamingCursorMediator.XCIData)((Object)this.getUserData())).getXCI();
                    ((StreamingCursorMediator.XCIData)((Object)dOMCachedAttribute.getUserData())).setXCI(cursor3);
                }
                dOMCachedAttribute.state = BitMaskHelper.stateUnset(dOMCachedAttribute.state, 512);
            }
        }
        if (dOMCachedAttribute.cache != this.cache) {
            if (dOMCachedAttribute.isID) {
                dOMCachedAttribute.cache.removeID(dOMCachedAttribute);
                this.cache.addID(dOMCachedAttribute);
            } else if (dOMCachedAttribute.isIDREF) {
                dOMCachedAttribute.cache.removeIDREF(dOMCachedAttribute);
                this.cache.addIDREF(dOMCachedAttribute);
            }
            dOMCachedAttribute.cache = this.cache;
        }
        if (dOMCachedAttribute.name.getQName(1, null).equals(CommonJAXPQNames.XSI_NIL)) {
            this.updateXsiValue(dOMCachedAttribute.data);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addBuiltAttribute", "Added a built attribute=" + dOMCachedAttribute.toStringLazy() + " | into parent=" + this.toStringLazy());
        }
    }

    protected void addBuiltAttribute(List<DOMCachedNode> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addBuiltAttribute((DOMCachedAttribute)list.get(i));
        }
        list.clear();
    }

    protected void addBuiltNamespace(List<DOMCachedNode> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addBuiltNamespace((DOMCachedNamespace)list.get(i));
        }
        list.clear();
    }

    private void updateXsiValue(VolatileCData volatileCData) {
        this.state = volatileCData.toString().toLowerCase(Locale.ENGLISH).equals("true") ? BitMaskHelper.stateSet(this.state, 262144) : BitMaskHelper.stateUnset(this.state, 262144);
    }

    public void addBuiltNamespace(DOMCachedNamespace dOMCachedNamespace) {
        dOMCachedNamespace.parent = this;
        if (this.builtFirstNamespace == null) {
            this.builtFirstNamespace = dOMCachedNamespace;
            this.builtLastNamespace = dOMCachedNamespace;
            if (!LazyLoadingHelper.isNamespacesBuilt(this.state)) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "addBuitNamespace", "adding built namespace = " + dOMCachedNamespace.toStringLazy());
                }
                dOMCachedNamespace.state = BitMaskHelper.stateUnset(dOMCachedNamespace.state, 512);
                if (this.getUserData() instanceof StreamingCursorMediator.XCIData) {
                    Cursor cursor2 = ((StreamingCursorMediator.XCIData)((Object)this.getUserData())).getXCI();
                    ((StreamingCursorMediator.XCIData)((Object)dOMCachedNamespace.getUserData())).setXCI(cursor2);
                }
                this.state = BitMaskHelper.stateSet(this.state, 2048);
            }
        } else {
            dOMCachedNamespace.preceding = this.builtLastNamespace;
            this.builtLastNamespace.following = dOMCachedNamespace;
            dOMCachedNamespace.following = null;
            this.builtLastNamespace = dOMCachedNamespace;
            int n2 = dOMCachedNamespace.preceding.state;
            if (!BitMaskHelper.stateContains(n2, 512)) {
                if (dOMCachedNamespace.getUserData() == null) {
                    UserData userData = this.getUserData();
                    dOMCachedNamespace.setUserData(userData);
                } else if (this.getUserData() instanceof StreamingCursorMediator.XCIData) {
                    Cursor cursor3 = ((StreamingCursorMediator.XCIData)((Object)this.getUserData())).getXCI();
                    ((StreamingCursorMediator.XCIData)((Object)dOMCachedNamespace.getUserData())).setXCI(cursor3);
                }
                dOMCachedNamespace.state = BitMaskHelper.stateUnset(dOMCachedNamespace.state, 512);
            }
        }
        dOMCachedNamespace.cache = this.cache;
    }

    public void addBuiltAttribute(VolatileCData volatileCData, CData cData) {
        this.addBuiltAttribute(this.cache.makeCachedAttribute(volatileCData, cData, null, null, this));
    }

    public DOMCachedAttribute getCachedAttribute(VolatileCData volatileCData) {
        if (LazyLoadingHelper.isAttributesBuilt(this.state)) {
            return this.getBuiltAttribute(volatileCData);
        }
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (!dOMCachedAttribute.itemName().equals(volatileCData)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    public DOMCachedAttribute getBuiltAttribute(VolatileCData volatileCData) {
        DOMCachedAttribute dOMCachedAttribute = this.builtFirstAttribute;
        while (dOMCachedAttribute != null) {
            if (dOMCachedAttribute.itemName().equals(volatileCData)) {
                return dOMCachedAttribute;
            }
            dOMCachedAttribute = (DOMCachedAttribute)dOMCachedAttribute.following;
        }
        return null;
    }

    @Override
    protected DOMCachedAttribute getBuiltNamedAttribute(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getBuiltFirstAttribute();
        }
        if (!nodeTest.allowsAttribute(null)) {
            return null;
        }
        DOMCachedAttribute dOMCachedAttribute = this.builtFirstAttribute;
        while (dOMCachedAttribute != null) {
            if (nodeTest.test(dOMCachedAttribute)) {
                return dOMCachedAttribute;
            }
            dOMCachedAttribute = (DOMCachedAttribute)dOMCachedAttribute.following;
        }
        return null;
    }

    @Override
    public DOMCachedAttribute getCachedFirstAttribute() {
        if (this.builtFirstAttribute == null && !LazyLoadingHelper.isFirstAttributeBuilt(this.state)) {
            if (!this.cache.mediator(this).buildAttributes(this, null)) {
                this.state = LazyLoadingHelper.markAttributesResolved(this.state);
            }
            this.state = LazyLoadingHelper.markFirstAttributeResolved(this.state);
        }
        return this.builtFirstAttribute;
    }

    @Override
    public DOMCachedAttribute getCachedNamedAttribute(NodeTest nodeTest) {
        if (LazyLoadingHelper.isAttributesBuilt(this.state)) {
            return this.getBuiltNamedAttribute(nodeTest);
        }
        if (nodeTest == null) {
            return this.getCachedFirstAttribute();
        }
        if (!nodeTest.allowsAttribute(null)) {
            return null;
        }
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (!nodeTest.test(dOMCachedAttribute)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    @Override
    public DOMCachedNamespace getCachedNamedNamespace(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getCachedFirstNamespaceNode();
        }
        for (DOMCachedNamespace dOMCachedNamespace = this.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
            if (!nodeTest.test(dOMCachedNamespace)) continue;
            return dOMCachedNamespace;
        }
        return null;
    }

    @Override
    public DOMCachedAttribute getCachedLastAttribute() {
        if (this.builtLastAttribute == null && !LazyLoadingHelper.isLastAttributeBuilt(this.state)) {
            this.visitAttributes();
        }
        return this.builtLastAttribute;
    }

    @Override
    public DOMCachedNamespace getCachedFirstNamespaceNode() {
        if (this.builtFirstNamespace == null && !LazyLoadingHelper.isFirstNamespaceBuilt(this.state)) {
            if (!this.cache.mediator(this).buildNamespaceNodes(this, null)) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "getCachedFirstNamespaceNode", "going to set namespace resolved !!!");
                }
                this.state = LazyLoadingHelper.markNamespacesResolved(this.state);
            }
            this.state = LazyLoadingHelper.markFirstNamespaceResolved(this.state);
        }
        return this.builtFirstNamespace;
    }

    @Override
    public DOMCachedNamespace getCachedLastNamespaceNode() {
        this.visitNamespaceNodes();
        return this.builtFirstNamespace;
    }

    @Override
    public final DOMCachedAttribute getBuiltFirstAttribute() {
        return this.builtFirstAttribute;
    }

    public void setBuiltFirstAttribute(DOMCachedAttribute dOMCachedAttribute) {
        this.builtFirstAttribute = dOMCachedAttribute;
    }

    @Override
    public final DOMCachedAttribute getBuiltLastAttribute() {
        return this.builtLastAttribute;
    }

    public void setBuiltLastAttribute(DOMCachedAttribute dOMCachedAttribute) {
        this.builtLastAttribute = dOMCachedAttribute;
    }

    @Override
    public boolean satisfies(NodeTest nodeTest) {
        return nodeTest == null || nodeTest.allowsElement(this.itemName());
    }

    @Override
    public DOMCachedNamespace getBuiltFirstNamespace() {
        return this.builtFirstNamespace;
    }

    public void setBuiltFirstNamespace(DOMCachedNamespace dOMCachedNamespace) {
        this.builtFirstNamespace = dOMCachedNamespace;
    }

    @Override
    public DOMCachedNamespace getBuiltLastNamespace() {
        return this.builtLastNamespace;
    }

    public void setBuiltLastNamespace(DOMCachedNamespace dOMCachedNamespace) {
        this.builtLastNamespace = dOMCachedNamespace;
    }

    @Override
    public final short itemKind() {
        return 1;
    }

    @Override
    public final VolatileCData itemName() {
        return this.name;
    }

    @Override
    public XSTypeDefinition itemXSType() {
        XSTypeDefinition xSTypeDefinition;
        if (doCacheXDMTyping) {
            if (this.xspsvi != null) {
                ElementPSVI elementPSVI = this.xspsvi;
                short s = elementPSVI.getValidity();
                short s2 = elementPSVI.getValidationAttempted();
                XSTypeDefinition xSTypeDefinition2 = elementPSVI.getTypeDefinition();
                xSTypeDefinition = s == 1 || s2 == 1 ? TypeRegistry.XSANYTYPE : (s == 2 && s2 == 2 ? xSTypeDefinition2 : (null != this.xstype ? (this.xstype == TypeRegistry.XSANYTYPE ? TypeRegistry.XSUNTYPED : this.xstype) : TypeRegistry.XSUNTYPED));
            } else {
                xSTypeDefinition = this.xstype != null ? this.xstype : TypeRegistry.XSUNTYPED;
            }
        } else {
            xSTypeDefinition = this.xstype;
        }
        return xSTypeDefinition;
    }

    @Override
    public void setItemXSType(XSTypeDefinition xSTypeDefinition) {
        this.xstype = xSTypeDefinition;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setItemXSType", "setting the item value on an element");
        }
    }

    @Override
    public ItemPSVI itemXSPSVInfo() {
        return this.xspsvi;
    }

    @Override
    public VolatileCData itemValue() {
        Object object2;
        VolatileCData volatileCData = null;
        ItemPSVI itemPSVI = this.itemXSPSVInfo();
        if (itemPSVI != null) {
            if (TypeHelper.isSimple(this.itemXSType())) {
                object2 = this.getCachedFirstChild();
                volatileCData = this.createCData(itemPSVI, object2 == null ? null : StringChars.toString(this.getCachedFirstChild().itemStringValueAsChars()));
            } else {
                if (((XSComplexTypeDefinition)this.itemXSType()).getContentType() == 2) {
                    throw new XCIIllegalContextItemException("ER_ELEMCONTENT_VALUE", new String[0]);
                }
                return new StoredCharsCData(this.itemStringValueAsChars(), TypeRegistry.XSUNTYPEDATOMIC);
            }
        }
        if (volatileCData == null) {
            if (TypeHelper.isSimple(this.itemXSType())) {
                object2 = this.getCachedFirstChild();
                VolatileCData volatileCData2 = volatileCData = object2 == null ? this.cache.EMPTY_STRING : ((DOMCachedNode)object2).itemValue();
                if (volatileCData.getXSTypeDefinition() == TypeRegistry.XSUNTYPEDATOMIC) {
                    CharSequence charSequence = this.getString(volatileCData);
                    XSSimpleTypeDefinition xSSimpleTypeDefinition = this.getSimpleType(charSequence);
                    volatileCData = xSSimpleTypeDefinition.getBuiltInKind() != 19 ? new BaseCDataWithChars(xSSimpleTypeDefinition, charSequence) : this.factory.data(charSequence, xSSimpleTypeDefinition, this.itemNamespaceContext(), false);
                }
            } else if (!this.itemNilled()) {
                object2 = new StringCDataBuilder(TypeRegistry.XSUNTYPEDATOMIC);
                this.string((StringCDataBuilder)object2, this);
                volatileCData = ((StringCDataBuilder)object2).toCData();
            } else {
                volatileCData = this.factory.data(TypeRegistry.XSUNTYPEDATOMIC);
            }
        }
        return volatileCData;
    }

    @Override
    public Chars itemSValue() {
        Object object2;
        Object object3;
        if (this.itemXSType() != null && TypeHelper.isSimple(this.itemXSType()) && (object3 = this.getCachedFirstChild()) != null && (object2 = ((DOMCachedNode)object3).itemSValue()) != null) {
            return object2;
        }
        object3 = null;
        object2 = this.itemXSPSVInfo();
        if (object2 != null) {
            object3 = object2.getSchemaNormalizedValue();
        }
        if (object3 == null) {
            return this.string(this);
        }
        return new StringChars((String)object3);
    }

    private XSSimpleTypeDefinition getSimpleType(CharSequence charSequence) {
        XSSimpleTypeDefinition xSSimpleTypeDefinition = null;
        if (this.xstype instanceof XSSimpleTypeDefinition) {
            xSSimpleTypeDefinition = (XSSimpleTypeDefinition)this.xstype;
        } else if (((XSComplexTypeDefinition)this.xstype).getContentType() == 1) {
            XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)this.xstype;
            xSSimpleTypeDefinition = xSComplexTypeDefinition.getSimpleType();
        }
        assert (xSSimpleTypeDefinition != null) : "Element type was not simple: " + this.xstype.toString();
        if (xSSimpleTypeDefinition.getVariety() == 3) {
            xSSimpleTypeDefinition = this.processUnion(xSSimpleTypeDefinition, charSequence);
        }
        if (xSSimpleTypeDefinition == TypeRegistry.XSANYSIMPLETYPE) {
            return TypeRegistry.XSUNTYPEDATOMIC;
        }
        return xSSimpleTypeDefinition;
    }

    private XSSimpleTypeDefinition processUnion(XSSimpleTypeDefinition xSSimpleTypeDefinition, CharSequence charSequence) {
        try {
            CastUtilities.validate(((Object)charSequence).toString(), xSSimpleTypeDefinition);
            return CastUtilities.validatedInfos.get().memberType;
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            return null;
        }
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        return this;
    }

    @Override
    public boolean itemNilled() {
        return BitMaskHelper.stateContains(this.state, 262144);
    }

    @Override
    public void setItemValue(VolatileCData volatileCData) {
        XSTypeDefinition xSTypeDefinition;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setItemValue", "setting the item value on an element");
        }
        if ((xSTypeDefinition = this.itemXSType()) != null && xSTypeDefinition.getTypeCategory() == 16) {
            DOMCachedNode dOMCachedNode = this.getCachedFirstChild();
            if (dOMCachedNode == null) {
                this.addText(Cursor.Area.FIRST_CHILD, volatileCData);
            } else {
                assert (dOMCachedNode.itemKind() == 3) : "Simply typed element must contain only a single text child!?";
                dOMCachedNode.setItemValue(volatileCData);
            }
        } else {
            throw XCIErrorHelper.createBadContextItemException("setItemValue", this.itemKind());
        }
    }

    @Override
    public void setItemName(VolatileCData volatileCData) {
        this.checkSetItemName(volatileCData);
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
        this.name = volatileCData.constant(true);
        this.setDirty(this);
    }

    @Override
    public void setItemPSVI(ItemPSVI itemPSVI) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setItemPSVI", "setting PSVI on an element");
        }
        if (itemPSVI != null && !(itemPSVI instanceof ElementPSVI)) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_PSVI_WRONG_INSTANCE", new String[]{"elements", "ElementPSVI"}));
        }
        this.xspsvi = (ElementPSVI)itemPSVI;
        if (this.xspsvi != null) {
            this.xsElemDecl = this.xspsvi.getElementDeclaration();
            this.xstype = itemPSVI.getTypeDefinition();
        }
    }

    @Override
    public XSElementDeclaration itemXSElementDeclaration() {
        return this.xsElemDecl;
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("name", "null");
        }
        if (volatileCData2 == null) {
            throw XCIErrorHelper.createBadArgumentException("value", "null");
        }
        try {
            volatileCData.getQNameNamespaceURI(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            throw XCIErrorHelper.createBadArgumentException("name", volatileCData.toString());
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addAttribute", "name=" + volatileCData.getString(1) + " | " + "value=" + volatileCData2.getString(1));
        }
        if (!LazyLoadingHelper.isLastAttributeBuilt(this.state)) {
            MiscHelpers.visitAttributes(this);
        }
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.ATTRIBUTE);
        DOMCachedAttribute dOMCachedAttribute = this.cache.makeCachedAttribute(volatileCData, volatileCData2, null, null, this);
        dOMCachedAttribute.state = LazyLoadingHelper.markAllResolved();
        if (volatileCData.getQName(1, null).equals(CommonJAXPQNames.XSI_NIL)) {
            this.updateXsiValue(volatileCData2);
        }
        this.setDirty(this);
    }

    @Override
    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        if (!LazyLoadingHelper.isLastNamespaceBuilt(this.state)) {
            MiscHelpers.visitNamespaceNodes(this);
        }
        QName qName = new QName("", volatileCData == null ? "" : volatileCData.toString(), "");
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.NAMESPACE_DECLS);
        boolean bl2 = true;
        for (DOMCachedNamespace dOMCachedNamespace = this.builtFirstNamespace; dOMCachedNamespace != null; dOMCachedNamespace = (DOMCachedNamespace)dOMCachedNamespace.getBuiltFollowingSibling()) {
            if (!dOMCachedNamespace.name.getQNameLocalPart(1).equals(qName.getLocalPart())) continue;
            dOMCachedNamespace.data = volatileCData2.constant(true);
            bl2 = false;
            break;
        }
        if (bl2) {
            DOMCachedNamespace dOMCachedNamespace = this.cache.makeCachedNamespaceNode(this.factory.data(qName, TypeRegistry.XSQNAME, false), volatileCData2, this);
            dOMCachedNamespace.state = LazyLoadingHelper.markAllResolved();
        }
        this.setDirty(this);
    }

    @Override
    public boolean removeAttribute(VolatileCData volatileCData) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "removeAttribute", "\n name of attribute=" + volatileCData.getString(1) + "\n parent node=" + this.toStringLazy());
        }
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("name", "null");
        }
        try {
            volatileCData.getQNameNamespaceURI(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            throw XCIErrorHelper.createBadArgumentException("name", volatileCData.toString());
        }
        DOMCachedAttribute dOMCachedAttribute = this.getCachedAttribute(volatileCData);
        if (dOMCachedAttribute != null) {
            this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.ATTRIBUTE);
            if (dOMCachedAttribute == this.builtFirstAttribute) {
                this.builtFirstAttribute = dOMCachedAttribute.getCachedFollowingAttribute();
                if (this.builtFirstAttribute == null) {
                    this.builtLastAttribute = null;
                }
            } else if (dOMCachedAttribute == this.builtLastAttribute) {
                this.builtLastAttribute = dOMCachedAttribute.getBuiltPrecedingAttribute();
            }
            dOMCachedAttribute.unlink();
            dOMCachedAttribute.updateCacheEntire(this.cache.getNewInstance());
            if (volatileCData.getQName(1, null).equals(CommonJAXPQNames.XSI_NIL)) {
                this.state = BitMaskHelper.stateUnset(this.state, 262144);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean test(Cursor cursor2) {
        return cursor2.itemKind() == 1 && this.name.equals(cursor2.itemName());
    }

    @Override
    public boolean allowsElement(VolatileCData volatileCData) {
        return this.name.equals(volatileCData);
    }

    @Override
    public NameTest theNameTest() {
        return SimpleNameTest.name(this.itemName());
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public boolean hasAttributes() {
        return this.getCachedFirstAttribute() != null;
    }

    @Override
    public String getNamespaceURI() {
        if (BitMaskHelper.stateContains(this.state, 32768)) {
            return null;
        }
        String string2 = this.name.getQNameNamespaceURI(1);
        return "".equals(string2) ? null : string2;
    }

    @Override
    public String getPrefix() {
        if (BitMaskHelper.stateContains(this.state, 32768)) {
            return null;
        }
        String string2 = this.name.getQNamePrefix(1);
        return "".equals(string2) ? null : string2;
    }

    @Override
    public void setPrefix(String string2) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return BitMaskHelper.stateContains(this.state, 32768) ? null : this.name.getQNameLocalPart(1);
    }

    @Override
    public NamedNodeMap getAttributes() {
        DOMCachedSimple dOMCachedSimple;
        ArrayList<DOMCachedSimple> arrayList = new ArrayList<DOMCachedSimple>();
        for (dOMCachedSimple = this.getCachedFirstNamespaceNode(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedNamespace)dOMCachedSimple).getCachedFollowingNamespaceNode()) {
            arrayList.add(dOMCachedSimple);
        }
        for (dOMCachedSimple = this.getCachedFirstAttribute(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedAttribute)dOMCachedSimple).getCachedFollowingAttribute()) {
            arrayList.add(dOMCachedSimple);
        }
        return new AttrList(arrayList);
    }

    @Override
    public String getAttribute(String string2) {
        return this.getAttributeNS(null, string2);
    }

    @Override
    public String getAttributeNS(String string2, String string3) {
        Attr attr2 = this.getAttributeNodeNS(string2, string3);
        return attr2 == null ? null : attr2.getValue();
    }

    @Override
    public Attr getAttributeNode(String string2) {
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (!dOMCachedAttribute.getNodeName().equals(string2)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    @Override
    public Attr getAttributeNodeNS(String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            CData cData = dOMCachedAttribute.name;
            if (!cData.getQNameNamespaceURI(1).equals(string2) || !cData.getQNameLocalPart(1).equals(string3)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String string2) {
        return new DOMCachedContainer.ElementDescendants(null, string2);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string2, String string3) {
        return new DOMCachedContainer.ElementDescendants(string2, string3);
    }

    @Override
    public String getTagName() {
        String string2 = this.getPrefix();
        return (string2 == null || string2.length() == 0 ? "" : string2 + ":") + this.name.getQNameLocalPart(1);
    }

    @Override
    public boolean hasAttribute(String string2) {
        return this.getAttributeNode(string2) != null;
    }

    @Override
    public boolean hasAttributeNS(String string2, String string3) {
        return this.getAttributeNodeNS(string2, string3) != null;
    }

    @Override
    public void removeAttribute(String string2) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(null, string2);
        if (dOMCachedAttribute == null) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        this.removeCachedAttribute(dOMCachedAttribute);
    }

    @Override
    public void removeAttributeNS(String string2, String string3) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(string2, string3);
        if (dOMCachedAttribute == null) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        this.removeCachedAttribute(dOMCachedAttribute);
    }

    @Override
    public Attr removeAttributeNode(Attr attr2) throws DOMException {
        if (!(attr2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)3);
        }
        this.removeCachedAttribute((DOMCachedAttribute)attr2);
        return attr2;
    }

    @Override
    public void setAttribute(String string2, String string3) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(null, string2);
        if (dOMCachedAttribute == null) {
            dOMCachedAttribute = (DOMCachedAttribute)this.getOwnerDocument().createAttribute(string2);
        }
        dOMCachedAttribute.setValue(string3);
    }

    @Override
    public void setAttributeNS(String string2, String string3, String string4) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(string2, string3);
        if (dOMCachedAttribute == null) {
            dOMCachedAttribute = (DOMCachedAttribute)this.getOwnerDocument().createAttributeNS(string2, string3);
        }
        dOMCachedAttribute.setValue(string4);
    }

    @Override
    public Attr setAttributeNode(Attr attr2) throws DOMException {
        if (!(attr2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)attr2;
        if (dOMCachedAttribute.parent != null) {
            throw XCIErrorHelper.createDOMException((short)10);
        }
        if (dOMCachedAttribute.getOwnerDocument() != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        DOMCachedAttribute dOMCachedAttribute2 = this.getCachedNamedAttribute(null, attr2.getName());
        if (dOMCachedAttribute2 == null) {
            this.addCachedAttribute(dOMCachedAttribute);
        } else {
            this.replaceCachedAttribute(dOMCachedAttribute2, dOMCachedAttribute);
        }
        return dOMCachedAttribute2;
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr2) throws DOMException {
        if (!(attr2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)attr2;
        if (dOMCachedAttribute.parent != null) {
            throw XCIErrorHelper.createDOMException((short)10);
        }
        if (dOMCachedAttribute.getOwnerDocument() != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        DOMCachedAttribute dOMCachedAttribute2 = this.getCachedNamedAttribute(attr2.getNamespaceURI(), attr2.getLocalName());
        if (dOMCachedAttribute2 == null) {
            this.addCachedAttribute(dOMCachedAttribute);
        } else {
            this.replaceCachedAttribute(dOMCachedAttribute2, dOMCachedAttribute);
        }
        return dOMCachedAttribute2;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"getSchemaTypeInfo", DOMCachedElement.class.getName()}));
    }

    @Override
    public void setIdAttribute(String string2, boolean bl) throws DOMException {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"setIdAttribute", DOMCachedElement.class.getName()}));
    }

    @Override
    public void setIdAttributeNode(Attr attr2, boolean bl) throws DOMException {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"setIdAttributeNode", DOMCachedElement.class.getName()}));
    }

    @Override
    public void setIdAttributeNS(String string2, String string3, boolean bl) throws DOMException {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"setIdAttributeNS", DOMCachedElement.class.getName()}));
    }

    @Override
    public int getLength() {
        DOMCachedSimple dOMCachedSimple;
        int n2 = 0;
        for (dOMCachedSimple = this.getCachedFirstNamespaceNode(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedNamespace)dOMCachedSimple).getCachedFollowingNamespaceNode()) {
            ++n2;
        }
        for (dOMCachedSimple = this.getCachedFirstAttribute(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedAttribute)dOMCachedSimple).getCachedFollowingAttribute()) {
            ++n2;
        }
        return n2;
    }

    @Override
    public Node getNamedItem(String string2) {
        return this.getNamedItemNS("", string2);
    }

    @Override
    public Node getNamedItemNS(String string2, String string3) throws DOMException {
        DOMCachedSimple dOMCachedSimple = this.getCachedNamedNamespace(string2, string3);
        if (dOMCachedSimple == null) {
            dOMCachedSimple = this.getCachedNamedAttribute(string2, string3);
        }
        return dOMCachedSimple;
    }

    @Override
    public Node item(int n2) {
        DOMCachedSimple dOMCachedSimple;
        for (dOMCachedSimple = this.getCachedFirstNamespaceNode(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedNamespace)dOMCachedSimple).getCachedFollowingNamespaceNode()) {
            if (n2-- != 0) continue;
            return dOMCachedSimple;
        }
        for (dOMCachedSimple = this.getCachedFirstAttribute(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedAttribute)dOMCachedSimple).getCachedFollowingAttribute()) {
            if (n2-- != 0) continue;
            return dOMCachedSimple;
        }
        return null;
    }

    @Override
    public Node removeNamedItem(String string2) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(null, string2);
        if (dOMCachedAttribute == null) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        this.removeCachedAttribute(dOMCachedAttribute);
        return dOMCachedAttribute;
    }

    @Override
    public Node removeNamedItemNS(String string2, String string3) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(string2, string3);
        if (dOMCachedAttribute == null) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        this.removeCachedAttribute(dOMCachedAttribute);
        return dOMCachedAttribute;
    }

    @Override
    public Node setNamedItem(Node node2) throws DOMException {
        if (!(node2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)3);
        }
        DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)node2;
        if (dOMCachedAttribute.parent != null) {
            throw XCIErrorHelper.createDOMException((short)10);
        }
        DOMCachedAttribute dOMCachedAttribute2 = this.getCachedNamedAttribute(null, node2.getNodeName());
        if (dOMCachedAttribute2 == null) {
            this.addCachedAttribute(dOMCachedAttribute);
        } else {
            this.replaceCachedAttribute(dOMCachedAttribute2, dOMCachedAttribute);
        }
        return dOMCachedAttribute2;
    }

    @Override
    public Node setNamedItemNS(Node node2) throws DOMException {
        Document document2 = node2.getOwnerDocument();
        if (document2 != null && document2 != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        if (!(node2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)3);
        }
        DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)node2;
        if (dOMCachedAttribute.parent != null) {
            throw new DOMException(10, "XXDOM0011");
        }
        DOMCachedAttribute dOMCachedAttribute2 = this.getCachedNamedAttribute(dOMCachedAttribute.getNamespaceURI(), dOMCachedAttribute.getLocalName());
        if (dOMCachedAttribute2 == null) {
            this.addCachedAttribute(dOMCachedAttribute);
        } else {
            this.replaceCachedAttribute(dOMCachedAttribute2, dOMCachedAttribute);
        }
        return dOMCachedAttribute2;
    }

    protected void replaceCachedAttribute(DOMCachedAttribute dOMCachedAttribute, DOMCachedAttribute dOMCachedAttribute2) {
        dOMCachedAttribute.setState(dOMCachedAttribute2.getState());
        dOMCachedAttribute.setState(dOMCachedAttribute.getState() | 0);
        dOMCachedAttribute2.parent = this;
        dOMCachedAttribute.parent = null;
        if (dOMCachedAttribute.preceding != null) {
            dOMCachedAttribute.preceding.following = dOMCachedAttribute2;
        }
        dOMCachedAttribute2.preceding = dOMCachedAttribute.preceding;
        dOMCachedAttribute.preceding = null;
        if (dOMCachedAttribute.following != null) {
            dOMCachedAttribute.following.preceding = dOMCachedAttribute2;
        }
        dOMCachedAttribute2.following = dOMCachedAttribute.following;
        dOMCachedAttribute.following = null;
    }

    protected void removeCachedAttribute(DOMCachedAttribute dOMCachedAttribute) {
        assert (dOMCachedAttribute.parent == this) : "Can only remove attribute that are already owned by this element.";
        dOMCachedAttribute.parent = null;
        if (dOMCachedAttribute.preceding != null) {
            if (BitMaskHelper.stateContains(dOMCachedAttribute.preceding.state, 128)) {
                BitMaskHelper.stateSet(dOMCachedAttribute.state, 128);
            }
            dOMCachedAttribute.preceding.following = dOMCachedAttribute.following;
        }
        if (dOMCachedAttribute.following != null) {
            if (BitMaskHelper.stateContains(dOMCachedAttribute.following.state, 512)) {
                BitMaskHelper.stateSet(dOMCachedAttribute.state, 512);
            }
            dOMCachedAttribute.following.preceding = dOMCachedAttribute.preceding;
        }
        dOMCachedAttribute.preceding = null;
        dOMCachedAttribute.following = null;
    }

    public void addCachedAttribute(DOMCachedAttribute dOMCachedAttribute) {
        DOMCachedAttribute dOMCachedAttribute2 = dOMCachedAttribute;
        dOMCachedAttribute2.parent = this;
        if (this.builtFirstAttribute == null) {
            this.builtFirstAttribute = dOMCachedAttribute2;
            this.builtLastAttribute = dOMCachedAttribute2;
            BitMaskHelper.stateSet(this.state, 1);
        } else {
            if (dOMCachedAttribute == this.builtLastAttribute || dOMCachedAttribute == this.builtFirstAttribute) {
                return;
            }
            dOMCachedAttribute2.preceding = this.builtLastAttribute;
            this.builtLastAttribute.following = dOMCachedAttribute2;
            this.builtLastAttribute = dOMCachedAttribute2;
            BitMaskHelper.stateSet(dOMCachedAttribute2.preceding.state, 512);
        }
        BitMaskHelper.stateSet(dOMCachedAttribute2.state, 160);
        dOMCachedAttribute.cache = this.cache;
    }

    @Override
    public DOMCachedAttribute getCachedNamedAttribute(String string2, String string3) throws DOMException {
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (string2 != dOMCachedAttribute.getNamespaceURI() && (string2 == null || !string2.equals(dOMCachedAttribute.getNamespaceURI())) || !string3.equals(dOMCachedAttribute.getLocalName())) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    @Override
    public DOMCachedNamespace getCachedNamedNamespace(String string2, String string3) throws DOMException {
        for (DOMCachedNamespace dOMCachedNamespace = this.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
            if (string2 != dOMCachedNamespace.getNamespaceURI() && (string2 == null || !string2.equals(dOMCachedNamespace.getNamespaceURI())) || !string3.equals(dOMCachedNamespace.getLocalName())) continue;
            return dOMCachedNamespace;
        }
        return null;
    }

    @Override
    public Iterator<String> getInScopeNamespaces() {
        return new NSListIterator<String>(this.getInScopeNamespacesList());
    }

    @Override
    public String lookupNamespaceURI(String string2) {
        return this.getNamespaceURI(string2);
    }

    @Override
    public String getNamespaceURI(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (string2.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string2.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.unguardedGetNamespaceURI(string2);
    }

    @Override
    public String lookupPrefix(String string2) {
        return this.getPrefix(string2);
    }

    @Override
    public String getPrefix(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string2)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
            return "xmlns";
        }
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        String string3 = null;
        String string4 = null;
        for (DOMCachedContainer dOMCachedContainer = this; dOMCachedContainer != null && ((DOMCachedNode)dOMCachedContainer).itemKind() == 1; dOMCachedContainer = dOMCachedContainer.getBuiltParent()) {
            if (((DOMCachedNode)dOMCachedContainer).getNamespaceURI() != null) {
                string3 = this.getPrefix();
            }
            if ((string4 = this.getNamespaceURI()) != null && string4.equals(string2)) {
                return string3 == null ? "" : string3;
            }
            for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNode)dOMCachedContainer).getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                string3 = dOMCachedNamespace.itemName().getQNameLocalPart(1);
                string4 = dOMCachedNamespace.itemTypedValue().toString();
                if (string4 == null || !string4.equals(string2)) continue;
                return string3;
            }
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ("http://www.w3.org/XML/1998/namespace".equals(string2)) {
            arrayList.add("xml");
        } else if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
            arrayList.add("xmlns");
        } else {
            String string3 = null;
            String string4 = null;
            for (DOMCachedContainer dOMCachedContainer = this; dOMCachedContainer != null && ((DOMCachedNode)dOMCachedContainer).itemKind() == 1; dOMCachedContainer = dOMCachedContainer.getBuiltParent()) {
                if (((DOMCachedNode)dOMCachedContainer).getNamespaceURI() != null) {
                    string3 = this.getPrefix();
                }
                if ((string4 = this.getNamespaceURI()) != null && string4.equals(string2)) {
                    String string5 = string3 = string3 == null ? "" : string3;
                    if (!arrayList.contains(string3)) {
                        arrayList.add(string3);
                    }
                }
                for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNode)dOMCachedContainer).getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                    string3 = dOMCachedNamespace.itemName().getQNameLocalPart(1);
                    string4 = dOMCachedNamespace.itemTypedValue().toString();
                    if (string4 == null || !string4.equals(string2) || arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
            }
        }
        return arrayList.iterator();
    }

    public ExtendedNamespaceContext constant(boolean bl) {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"constant", DOMCachedElement.class.getName()}));
    }

    private final String unguardedGetNamespaceURI(String string2) {
        String string3;
        if (this.parent.itemKind() == 1 && (string3 = ((DOMCachedElement)this.parent).unguardedGetNamespaceURI(string2)) != null) {
            return string3;
        }
        boolean bl = "".equals(string2);
        for (DOMCachedNamespace dOMCachedNamespace = this.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
            if ((dOMCachedNamespace.itemName() != null || !bl) && !dOMCachedNamespace.itemName().getQNameLocalPart(1).equals(string2)) continue;
            return dOMCachedNamespace.itemTypedValue().getString(1);
        }
        if (string2.equals(this.itemName().getQNamePrefix(1))) {
            return this.itemName().getQNameNamespaceURI(1);
        }
        return null;
    }

    private final String unguardedGetPrefix(String string2) {
        Object object2;
        if (this.parent.itemKind() == 1 && (object2 = ((DOMCachedElement)this.parent).getPrefix(string2)) != null) {
            return object2;
        }
        for (object2 = this.getCachedFirstNamespaceNode(); object2 != null; object2 = ((DOMCachedNamespace)object2).getCachedFollowingNamespaceNode()) {
            if (!string2.equals(((AbstractCursor)object2).itemTypedValue().getString(1))) continue;
            return ((DOMCachedNamespace)object2).itemName() == null ? ((AbstractCursor)object2).itemTypedValue().getString(1) : null;
        }
        return null;
    }

    protected CData string(DOMCachedNode dOMCachedNode) {
        StringCDataBuilder stringCDataBuilder = new StringCDataBuilder(TypeRegistry.XSSTRING);
        this.string(stringCDataBuilder, dOMCachedNode);
        return stringCDataBuilder.toCData();
    }

    private void string(StringCDataBuilder stringCDataBuilder, DOMCachedNode dOMCachedNode) {
        switch (dOMCachedNode.itemKind()) {
            case 3: {
                stringCDataBuilder.append(dOMCachedNode.itemTypedValue().constant(true));
                break;
            }
            case 1: 
            case 9: {
                for (DOMCachedNode dOMCachedNode2 = ((DOMCachedContainer)dOMCachedNode).getCachedFirstChild(); dOMCachedNode2 != null; dOMCachedNode2 = dOMCachedNode2.getCachedFollowingSibling()) {
                    this.string(stringCDataBuilder, dOMCachedNode2);
                }
                break;
            }
        }
    }

    @Override
    protected void printXQuery(Writer writer, String string2, boolean bl) throws IOException {
        writer.write(string2 + " element " + this.name + this.printState() + this.printUserData());
        if (bl) {
            DOMCachedNode dOMCachedNode;
            writer.write(" {\n");
            for (dOMCachedNode = this.getBuiltFirstNamespace(); dOMCachedNode != null; dOMCachedNode = ((DOMCachedNamespace)dOMCachedNode).getBuiltFollowingNamespaceNode()) {
                ((DOMCachedNamespace)dOMCachedNode).printXQuery(writer, string2 + "\t", true);
            }
            for (dOMCachedNode = this.getBuiltFirstAttribute(); dOMCachedNode != null; dOMCachedNode = ((DOMCachedAttribute)dOMCachedNode).getBuiltFollowingAttribute()) {
                ((DOMCachedAttribute)dOMCachedNode).printXQuery(writer, string2 + "\t", true);
            }
            for (dOMCachedNode = this.getBuiltFirstChild(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling()) {
                dOMCachedNode.printXQuery(writer, string2 + "\t", false);
            }
            writer.write(string2 + "}\n");
        }
    }

    public List<String> getInScopeNamespacesList() {
        if (this.nsContext == null) {
            this.nsContext = new ElementNSContext();
        }
        return this.nsContext.getNSList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ElementNSContext {
        private List<String> nsList = new ArrayList<String>();
        private int listVersion;

        public ElementNSContext() {
            this.updateNSList();
        }

        public boolean isUpToDate() {
            return this.listVersion == DOMCachedElement.this.cache.getNamespaceVersion();
        }

        public List<String> getNSList() {
            if (!this.isUpToDate()) {
                this.nsList.clear();
                this.updateNSList();
            }
            return this.nsList;
        }

        private void updateNSList() {
            DOMCachedNode dOMCachedNode;
            this.listVersion = DOMCachedElement.this.cache.getNamespaceVersion();
            String string2 = null;
            String string3 = null;
            for (dOMCachedNode = DOMCachedElement.this.getCachedFirstNamespaceNode(); dOMCachedNode != null; dOMCachedNode = ((DOMCachedNamespace)dOMCachedNode).getCachedFollowingNamespaceNode()) {
                VolatileCData volatileCData = ((DOMCachedNamespace)dOMCachedNode).itemName();
                string2 = volatileCData.getSize() == 0 ? "" : volatileCData.getQNameLocalPart(1);
                string3 = dOMCachedNode.itemStringValue().toString();
                this.nsList.add(string2);
                this.nsList.add(string3);
            }
            dOMCachedNode = DOMCachedElement.this.getBuiltParent();
            if (dOMCachedNode != null && dOMCachedNode.itemKind() == 1) {
                int n2 = this.nsList.size();
                boolean bl = false;
                List<String> list = ((DOMCachedElement)dOMCachedNode).getInScopeNamespacesList();
                int n3 = list.size();
                int n4 = 0;
                while (n4 + 1 < n3) {
                    string2 = list.get(n4);
                    string3 = list.get(n4 + 1);
                    for (int i = 0; i < n2; i += 2) {
                        if (!this.nsList.get(i).equals(string2)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.nsList.add(string2);
                        this.nsList.add(string3);
                    }
                    bl = false;
                    n4 += 2;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttrList
    implements NamedNodeMap {
        private List<DOMCachedSimple> attrList;
        private int length;

        public AttrList(List<DOMCachedSimple> list) {
            this.attrList = list;
            this.length = list.size();
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public Node getNamedItem(String string2) {
            return this.getNamedItemNS("", string2);
        }

        @Override
        public Node getNamedItemNS(String string2, String string3) throws DOMException {
            for (int i = 0; i < this.length; ++i) {
                DOMCachedSimple dOMCachedSimple = this.attrList.get(i);
                if (string2 != dOMCachedSimple.getNamespaceURI() && (string2 == null || !string2.equals(dOMCachedSimple.getNamespaceURI())) || !string3.equals(dOMCachedSimple.getLocalName())) continue;
                return dOMCachedSimple;
            }
            return null;
        }

        @Override
        public Node item(int n2) {
            if (n2 > this.length - 1 || n2 < 0) {
                return null;
            }
            return this.attrList.get(n2);
        }

        @Override
        public Node removeNamedItem(String string2) throws DOMException {
            return this.removeNamedItemNS("", string2);
        }

        @Override
        public Node removeNamedItemNS(String string2, String string3) throws DOMException {
            int n2 = this.findNode(string2, string3);
            Node node2 = null;
            if (n2 != -1) {
                node2 = this.attrList.get(n2);
                this.attrList.remove(n2);
            }
            return node2;
        }

        private int findNode(String string2, String string3) {
            for (int i = 0; i < this.length; ++i) {
                DOMCachedSimple dOMCachedSimple = this.attrList.get(i);
                if (string2 != dOMCachedSimple.getNamespaceURI() && (string2 == null || !string2.equals(dOMCachedSimple.getNamespaceURI())) || !string3.equals(dOMCachedSimple.getLocalName())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Node setNamedItem(Node node2) throws DOMException {
            return this.setNamedItem(node2, false);
        }

        @Override
        public Node setNamedItemNS(Node node2) throws DOMException {
            return this.setNamedItem(node2, true);
        }

        private Node setNamedItem(Node node2, boolean bl) {
            String string2;
            if (!(node2 instanceof DOMCachedSimple)) {
                return null;
            }
            String string3 = bl ? node2.getNamespaceURI() : "";
            int n2 = this.findNode(string3, string2 = node2.getLocalName());
            if (n2 == -1) {
                this.attrList.add((DOMCachedSimple)node2);
                return null;
            }
            Node node3 = this.attrList.get(n2);
            this.attrList.set(n2, (DOMCachedSimple)node2);
            return node3;
        }
    }
}

