/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.misc.Stack;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DOMCachedContainer
extends DOMCachedNode {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DOMCachedNode builtFirstChild;
    protected DOMCachedNode builtLastChild;
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedContainer.class);

    protected DOMCachedContainer(CacheManager cacheManager) {
        super(cacheManager);
    }

    protected DOMCachedContainer(CacheManager cacheManager, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        super(cacheManager, dOMCachedContainer, dOMCachedNode);
    }

    public void unlinkChild(DOMCachedNode dOMCachedNode) {
        if (dOMCachedNode == null) {
            return;
        }
        if (dOMCachedNode == this.builtFirstChild) {
            this.builtFirstChild = dOMCachedNode.following;
            if (this.builtFirstChild == null) {
                this.builtLastChild = null;
            }
        } else if (dOMCachedNode == this.builtLastChild) {
            this.builtLastChild = dOMCachedNode.preceding;
            if (this.builtLastChild == null) {
                this.builtFirstChild = null;
            }
        }
        dOMCachedNode.unlink();
    }

    private final void importNode(DOMCachedNode dOMCachedNode) {
        if (!LazyLoadingHelper.isSubtreeBuilt(dOMCachedNode.getState())) {
            dOMCachedNode.visitSubtree();
        }
        CacheManager cacheManager = dOMCachedNode.getCache();
        Stack<DOMCachedNode> stack = new Stack<DOMCachedNode>(30);
        stack.push(dOMCachedNode);
        while (!stack.isEmpty()) {
            DOMCachedNode dOMCachedNode2 = (DOMCachedNode)stack.pop();
            if (dOMCachedNode2.itemIsID()) {
                cacheManager.removeID((DOMCachedAttribute)dOMCachedNode2);
                this.cache.addID((DOMCachedAttribute)dOMCachedNode2);
            } else if (dOMCachedNode2.itemIsIDREFS()) {
                cacheManager.removeIDREF((DOMCachedAttribute)dOMCachedNode2);
                this.cache.addIDREF((DOMCachedAttribute)dOMCachedNode2);
            }
            dOMCachedNode2.cache = this.cache;
            if (dOMCachedNode2.itemKind() != 1) continue;
            DOMCachedElement dOMCachedElement = (DOMCachedElement)dOMCachedNode2;
            DOMCachedNode dOMCachedNode3 = dOMCachedElement.builtFirstNamespace;
            while (dOMCachedNode3 != null) {
                stack.push(dOMCachedNode3);
                dOMCachedNode3 = dOMCachedNode3.following;
            }
            dOMCachedNode3 = dOMCachedElement.builtFirstAttribute;
            while (dOMCachedNode3 != null) {
                stack.push(dOMCachedNode3);
                dOMCachedNode3 = dOMCachedNode3.following;
            }
            dOMCachedNode3 = dOMCachedElement.builtFirstChild;
            while (dOMCachedNode3 != null) {
                stack.push(dOMCachedNode3);
                dOMCachedNode3 = dOMCachedNode3.following;
            }
        }
    }

    public final void addBuiltFirstChild(List<DOMCachedNode> list) {
        if (this.builtFirstChild == null) {
            this.builtFirstChild = list.get(0);
            this.builtLastChild = list.get(list.size() - 1);
        } else {
            this.builtFirstChild.preceding = list.get(list.size() - 1);
            list.get((int)(list.size() - 1)).following = this.builtFirstChild;
            this.checkAdjacent(list.get(list.size() - 1), this.builtFirstChild);
            this.builtFirstChild = list.get(0);
        }
        if (this.indexed()) {
            this.state &= 0xFFFDFFFF;
        }
    }

    public final void addBuiltFirstChild(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addBuiltFirstChild", "adding first child to node");
        }
        if (this.builtFirstChild == null) {
            this.builtFirstChild = dOMCachedNode;
            this.builtLastChild = dOMCachedNode;
        } else {
            this.builtFirstChild.preceding = dOMCachedNode;
            dOMCachedNode.following = this.builtFirstChild;
            this.builtFirstChild = dOMCachedNode;
        }
        if (this.indexed()) {
            this.state &= 0xFFFDFFFF;
        }
        if (dOMCachedNode.cache != this.cache) {
            this.importNode(dOMCachedNode);
        }
    }

    public void addBuiltFirstChildText(VolatileCData volatileCData, boolean bl) {
        this.addBuiltFirstChild(this.cache.makeCachedText(volatileCData, bl, false, this, null));
    }

    public void addBuiltLastChild(List<DOMCachedNode> list) {
        if (this.builtLastChild == null) {
            this.addBuiltFirstChild(list);
        } else {
            this.addBuiltNextChild(list, this.builtLastChild);
        }
    }

    public void addBuiltLastChild(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addBuiltLastChild", "node=" + dOMCachedNode);
        }
        if (this.builtLastChild == null) {
            this.addBuiltFirstChild(dOMCachedNode);
        } else {
            this.addBuiltNextChild(dOMCachedNode, this.builtLastChild);
        }
    }

    public void addBuiltNextChild(List<DOMCachedNode> list, DOMCachedNode dOMCachedNode) {
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.following;
        if (dOMCachedNode2 == null) {
            assert (this.builtLastChild == dOMCachedNode) : "Indicated last sibling is not last for this parent?!?";
            this.builtLastChild.following = list.get(0);
            list.get((int)0).preceding = this.builtLastChild;
            this.builtLastChild = list.get(list.size() - 1);
        } else {
            dOMCachedNode.following = list.get(0);
            list.get((int)(list.size() - 1)).following = dOMCachedNode2;
            list.get((int)0).preceding = dOMCachedNode;
            dOMCachedNode2.preceding = list.get(list.size() - 1);
        }
        this.checkAdjacent(dOMCachedNode, list.get(0));
        this.checkAdjacent(list.get(list.size() - 1), dOMCachedNode2);
        if (this.indexed()) {
            this.state &= 0xFFFDFFFF;
        }
    }

    public void addBuiltNextChild(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        DOMCachedNode dOMCachedNode3 = dOMCachedNode2.following;
        if (dOMCachedNode3 == null) {
            assert (this.builtLastChild == dOMCachedNode2) : "Indicated last sibling is not last for this parent?!?";
            this.builtLastChild.following = dOMCachedNode;
            dOMCachedNode.preceding = this.builtLastChild;
            this.builtLastChild = dOMCachedNode;
        } else {
            dOMCachedNode2.following = dOMCachedNode;
            dOMCachedNode.following = dOMCachedNode3;
            dOMCachedNode.preceding = dOMCachedNode2;
            dOMCachedNode3.preceding = dOMCachedNode;
        }
        if (this.indexed()) {
            this.state &= 0xFFFDFFFF;
        }
        if (dOMCachedNode.cache != this.cache) {
            this.importNode(dOMCachedNode);
        }
    }

    public void addCachedFirstChild(DOMCachedNode dOMCachedNode) {
        assert (dOMCachedNode.getBuiltParent() == this);
        assert (dOMCachedNode.getBuiltPrecedingSibling() == null);
        assert (dOMCachedNode.getBuiltFollowingSibling() == null);
        DOMCachedNode dOMCachedNode2 = LazyLoadingHelper.isFirstChildBuilt(this.state) ? this.getBuiltFirstChild() : this.getCachedFirstChild();
        this.addBuiltFirstChild(dOMCachedNode);
        if (dOMCachedNode2 == null) {
            this.state = LazyLoadingHelper.markFirstChildResolved(this.state);
            dOMCachedNode.state = LazyLoadingHelper.markPrecedingParentResolved(dOMCachedNode.state);
        } else {
            dOMCachedNode2.state = LazyLoadingHelper.markPrecedingResolved(dOMCachedNode2.state);
            dOMCachedNode.state = LazyLoadingHelper.markPrecedingFollowingParentResolved(dOMCachedNode.state);
        }
    }

    public void addCachedLastChild(DOMCachedNode dOMCachedNode) {
        if (this.builtLastChild == null) {
            this.addCachedFirstChild(dOMCachedNode);
        } else {
            this.addCachedNextChild(dOMCachedNode, this.builtLastChild);
        }
    }

    public void addCachedNextChild(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getBuiltFollowingSibling();
        this.addBuiltNextChild(dOMCachedNode, dOMCachedNode2);
        dOMCachedNode.state = dOMCachedNode3 == null ? LazyLoadingHelper.markPrecedingParentResolved(dOMCachedNode.state) : LazyLoadingHelper.markPrecedingFollowingParentResolved(dOMCachedNode.state);
    }

    @Override
    public final DOMCachedNode getBuiltFirstChild(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getBuiltFirstChild();
        }
        DOMCachedNode dOMCachedNode = this.builtFirstChild;
        while (dOMCachedNode != null) {
            if (dOMCachedNode.satisfies(nodeTest)) {
                return dOMCachedNode;
            }
            dOMCachedNode = dOMCachedNode.following;
        }
        return null;
    }

    @Override
    public final DOMCachedNode getCachedFirstChild(NodeTest nodeTest) {
        if (LazyLoadingHelper.isChildrenResolved(this.state)) {
            return this.getBuiltFirstChild(nodeTest);
        }
        if (nodeTest == null) {
            return this.getCachedFirstChild();
        }
        for (DOMCachedNode dOMCachedNode = this.getCachedFirstChild(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling()) {
            if (!dOMCachedNode.satisfies(nodeTest)) continue;
            return dOMCachedNode;
        }
        return null;
    }

    public DOMCachedNode getBuiltChildAt(long l) {
        DOMCachedNode dOMCachedNode = this.builtFirstChild;
        while (dOMCachedNode != null) {
            if (--l == 0L) {
                return dOMCachedNode;
            }
            dOMCachedNode = dOMCachedNode.following;
        }
        return null;
    }

    public DOMCachedNode getCachedChildAt(long l) {
        if (LazyLoadingHelper.isChildrenResolved(this.state)) {
            return this.getBuiltChildAt(l);
        }
        for (DOMCachedNode dOMCachedNode = this.getCachedFirstChild(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling()) {
            if (--l != 0L) continue;
            return dOMCachedNode;
        }
        return null;
    }

    protected final boolean indexed() {
        return false;
    }

    protected final boolean isValidChildIndex() {
        return (this.state & 0x20000) != 0;
    }

    @Override
    public final DOMCachedNode getCachedFirstChild() {
        if (this.builtFirstChild == null && !LazyLoadingHelper.isFirstChildBuilt(this.state)) {
            this.state = this.cache.mediator(this).buildChildren(this, null) ? LazyLoadingHelper.markFirstChildResolved(this.state) : LazyLoadingHelper.markChildrenResolved(this.state);
        }
        return this.builtFirstChild;
    }

    @Override
    public final DOMCachedNode getBuiltFirstChild() {
        return this.builtFirstChild;
    }

    public void setBuiltFirstChild(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            String string2 = dOMCachedNode == null ? "" : dOMCachedNode.toStringLazy();
            logger.logp(Level.FINEST, logger.getName(), "setBuiltFirstChild", "this = " + this.toStringLazy() + "node passed in = " + string2 + "\nStack trace=" + XCIErrorHelper.getStackTrace(15));
        }
        this.builtFirstChild = dOMCachedNode;
    }

    @Override
    public final DOMCachedNode getCachedLastChild() {
        if (this.builtLastChild == null && !LazyLoadingHelper.isLastChildBuilt(this.state)) {
            this.visitChildren();
        }
        return this.builtLastChild;
    }

    @Override
    public final DOMCachedNode getBuiltLastChild() {
        return this.builtLastChild;
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return new Children();
    }

    @Override
    public Node insertBefore(Node node2, Node node3) throws DOMException {
        DOMCachedNode dOMCachedNode;
        DOMCachedNode dOMCachedNode2;
        if (node3 == null) {
            this.appendChild(node2);
        }
        if (node3.getParentNode() != this) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        if (node2.getOwnerDocument() != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        for (dOMCachedNode2 = this.parent; dOMCachedNode2 != null; dOMCachedNode2 = dOMCachedNode2.getBuiltParent()) {
            if (this.parent != node2) continue;
            throw XCIErrorHelper.createDOMException((short)3);
        }
        dOMCachedNode2 = (DOMCachedNode)node3;
        DOMCachedNode dOMCachedNode3 = (DOMCachedNode)node2;
        assert (dOMCachedNode3.getCache() == dOMCachedNode2.getCache()) : "Cache inconsistency!";
        if (dOMCachedNode3.getBuiltParent() != null) {
            dOMCachedNode3.unlink();
        }
        if ((dOMCachedNode = dOMCachedNode2.getCachedPrecedingSibling()) == null) {
            this.addCachedFirstChild(dOMCachedNode3);
        } else {
            this.addCachedNextChild(dOMCachedNode3, dOMCachedNode);
        }
        return dOMCachedNode3;
    }

    @Override
    public Node replaceChild(Node node2, Node node3) throws DOMException {
        DOMCachedNode dOMCachedNode;
        if (node3.getParentNode() != this) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        if (node2.getOwnerDocument() != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        for (dOMCachedNode = this.parent; dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltParent()) {
            if (this.parent != node2) continue;
            throw XCIErrorHelper.createDOMException((short)3);
        }
        dOMCachedNode = (DOMCachedNode)node2;
        DOMCachedNode dOMCachedNode2 = (DOMCachedNode)node3;
        assert (dOMCachedNode.cache == dOMCachedNode2.cache) : "Cache inconsistency!";
        if (dOMCachedNode.parent != null) {
            dOMCachedNode.unlink();
        }
        dOMCachedNode.parent = this;
        dOMCachedNode.following = dOMCachedNode2.following;
        dOMCachedNode.preceding = dOMCachedNode2.preceding;
        dOMCachedNode2.unlink();
        return dOMCachedNode2;
    }

    @Override
    public Node removeChild(Node node2) throws DOMException {
        if (node2.getParentNode() != this) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        ((DOMCachedNode)node2).unlink();
        ((DOMCachedNode)node2).updateCacheEntire(this.cache.getNewInstance());
        return node2;
    }

    @Override
    public Node appendChild(Node node2) throws DOMException {
        DOMCachedNode dOMCachedNode;
        for (dOMCachedNode = this.parent; dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltParent()) {
            if (this.parent != node2) continue;
            throw XCIErrorHelper.createDOMException((short)3);
        }
        dOMCachedNode = (DOMCachedNode)node2;
        if (dOMCachedNode.parent != null) {
            dOMCachedNode.unlink();
        }
        dOMCachedNode.parent = this;
        DOMCachedNode dOMCachedNode2 = this.getCachedLastChild();
        if (dOMCachedNode2 == null) {
            this.addCachedFirstChild(dOMCachedNode);
        } else {
            this.addCachedNextChild(dOMCachedNode, dOMCachedNode2);
        }
        return dOMCachedNode;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getCachedFirstChild() != null;
    }

    class ElementDescendants
    extends Children {
        CacheCursor descendantWalker;

        ElementDescendants() {
            this.descendantWalker = null;
        }

        ElementDescendants(String string2, String string3) {
            super(string2, string3);
            this.descendantWalker = null;
        }

        protected DOMCachedNode next() {
            if (this.done) {
                return null;
            }
            DOMCachedNode dOMCachedNode = null;
            if (this.descendantWalker == null) {
                this.descendantWalker = DOMCachedContainer.this.cache.popCacheCursor(DOMCachedContainer.this, Cursor.Profile.RANDOM_ACCESS, false);
                dOMCachedNode = this.descendantWalker.toDescendants(null) ? this.descendantWalker.contextNode : null;
            } else {
                DOMCachedNode dOMCachedNode2 = dOMCachedNode = this.descendantWalker.toNext() ? this.descendantWalker.contextNode : null;
            }
            if (this.alsoNonElements && dOMCachedNode != null) {
                this.list.add(dOMCachedNode);
                return dOMCachedNode;
            }
            while (dOMCachedNode != null) {
                if (dOMCachedNode.itemKind() == 1) {
                    QName qName = dOMCachedNode.itemName().getQName(1, null);
                    if ((this.namespaceURI == null || this.namespaceURI.equals(qName.getNamespaceURI())) && (this.localPart == null || this.localPart.equals(qName.getLocalPart()))) {
                        this.list.add(dOMCachedNode);
                        return dOMCachedNode;
                    }
                }
                dOMCachedNode = this.descendantWalker.toNext() ? this.descendantWalker.contextNode : null;
            }
            this.done = true;
            return null;
        }
    }

    class Children
    implements NodeList {
        final boolean alsoNonElements;
        final String namespaceURI;
        final String localPart;
        final List<DOMCachedNode> list;
        boolean done;

        Children() {
            this.alsoNonElements = true;
            this.namespaceURI = null;
            this.localPart = null;
            this.list = new LinkedList<DOMCachedNode>();
        }

        Children(String string2, String string3) {
            this.alsoNonElements = false;
            this.namespaceURI = "*".equals(string2) ? null : string2;
            this.localPart = "*".equals(string3) ? null : string3;
            this.list = new LinkedList<DOMCachedNode>();
        }

        public int getLength() {
            if (!this.done) {
                while (this.next() != null) {
                }
            }
            assert (this.done) : "Could not get length!";
            return this.list.size();
        }

        public Node item(int n2) {
            if (n2 < 0) {
                return null;
            }
            if (!this.done) {
                for (int i = this.list.size(); i <= n2; ++i) {
                    DOMCachedNode dOMCachedNode = this.next();
                    if (dOMCachedNode != null) continue;
                    return null;
                }
            }
            if (n2 < this.list.size()) {
                return this.list.get(n2);
            }
            return null;
        }

        protected DOMCachedNode next() {
            DOMCachedNode dOMCachedNode;
            if (this.done) {
                return null;
            }
            DOMCachedNode dOMCachedNode2 = dOMCachedNode = this.list.isEmpty() ? DOMCachedContainer.this.getCachedFirstChild() : this.list.get(this.list.size() - 1).getCachedFollowingSibling();
            if (this.alsoNonElements && dOMCachedNode != null) {
                this.list.add(dOMCachedNode);
                return dOMCachedNode;
            }
            while (dOMCachedNode != null) {
                if (dOMCachedNode.itemKind() == 1) {
                    QName qName = dOMCachedNode.itemName().getQName(1, null);
                    if ((this.namespaceURI == null || this.namespaceURI.equals(qName.getNamespaceURI())) && (this.localPart == null || this.localPart.equals(qName.getLocalPart()))) {
                        this.list.add(dOMCachedNode);
                        return dOMCachedNode;
                    }
                }
                dOMCachedNode = dOMCachedNode.getCachedFollowingSibling();
            }
            this.done = true;
            return null;
        }
    }
}

