/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.CommonJAXPQNames;
import com.ibm.xml.xci.dp.util.id.IDHelper;
import com.ibm.xml.xci.dp.values.BaseCDataWithChars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class DOMCachedAttribute
extends DOMCachedSimple
implements Attr {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CData name;
    protected boolean isID;
    protected boolean isIDREF;
    protected AttributePSVI xspsvi;
    protected XSAttributeDeclaration xsAttrDecl;
    protected XSTypeDefinition xstype;
    public Cursor.ItemValueOrigin itemValueOrigin;
    protected Node textChild;
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedAttribute.class);

    public DOMCachedAttribute(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, AttributePSVI attributePSVI, DOMCachedElement dOMCachedElement) {
        this(cacheManager, volatileCData, volatileCData2, attributePSVI, null, dOMCachedElement);
    }

    public DOMCachedAttribute(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, AttributePSVI attributePSVI, XSAttributeDeclaration xSAttributeDeclaration, DOMCachedElement dOMCachedElement) {
        super(cacheManager, volatileCData2, null, null);
        this.name = volatileCData.constant(true);
        this.xsAttrDecl = xSAttributeDeclaration;
        this.itemValueOrigin = Cursor.ItemValueOrigin.SPECIFIED;
        if (attributePSVI != null) {
            this.setItemPSVI(attributePSVI);
        }
        this.isID = IDHelper.isAttributeID(volatileCData, volatileCData2.getXSTypeDefinition());
        this.isIDREF = IDHelper.isIDREF(volatileCData2.getXSTypeDefinition());
        if (dOMCachedElement != null) {
            dOMCachedElement.addBuiltAttribute(this);
        }
        if (this.parent != null) {
            if (this.preceding == null) {
                if (this.getUserData() != null && this.parent.getUserData() != null) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, logger.getName(), "DOMCachedAttribute", "setting a mediator data as the same as parent: " + this.parent.getUserData().toString());
                    }
                    this.setMediatorData(this.parent.getMediatorData());
                }
            } else if (this.getUserData() != null && this.preceding.getUserData() != null) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "DOMCachedAttribute", "setting a mediator data as the same as preceding sibling: " + this.preceding.getUserData().toString());
                }
                this.setMediatorData(this.preceding.getMediatorData());
            }
        }
        if (this.isID) {
            cacheManager.addID(this);
        } else if (this.isIDREF) {
            cacheManager.addIDREF(this);
        }
        this.cache.registerNode(this);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedAttribute", "creating a new DOMCachedAttribute: " + this.toStringLazy() + "\nCache manager = " + this.getCache() + " | Mediator (default) = " + this.getCache().mediator() + " | Mediator (for node) = " + this.getMediatorData());
        }
        if (this.xstype == null && this.data != null) {
            this.xstype = this.data.getXSTypeDefinition();
        }
    }

    public DOMCachedAttribute getCachedFollowingAttribute() {
        if (this.following == null && !LazyLoadingHelper.isFollowingBuilt(this.state)) {
            if (!this.cache.mediator(this).buildNext(this)) {
                this.parent.state = LazyLoadingHelper.markLastAttrResolved(this.parent.state);
                this.parent.state = LazyLoadingHelper.markAttributesResolved(this.parent.state);
            }
            this.state = LazyLoadingHelper.markFollowingResolved(this.state);
        }
        return (DOMCachedAttribute)this.following;
    }

    public DOMCachedAttribute getCachedPrecedingAttribute() {
        return this.getBuiltPrecedingAttribute();
    }

    public DOMCachedAttribute getCachedPrecedingAttribute(NodeTest nodeTest) {
        return this.getBuiltPrecedingAttribute(nodeTest);
    }

    public DOMCachedAttribute getBuiltFollowingAttribute() {
        return (DOMCachedAttribute)this.following;
    }

    public DOMCachedAttribute getBuiltPrecedingAttribute() {
        return (DOMCachedAttribute)this.preceding;
    }

    public DOMCachedAttribute getBuiltPrecedingAttribute(NodeTest nodeTest) {
        if (nodeTest == null) {
            return (DOMCachedAttribute)this.getBuiltPrecedingSibling();
        }
        for (DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)this.getBuiltPrecedingSibling(); dOMCachedAttribute != null; dOMCachedAttribute = (DOMCachedAttribute)dOMCachedAttribute.getBuiltPrecedingSibling()) {
            if (!dOMCachedAttribute.satisfies(nodeTest)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    public boolean satisfies(NodeTest nodeTest) {
        return nodeTest == null || nodeTest.allowsAttribute(this.name);
    }

    public final DOMCachedNode getCachedFollowingSibling() {
        return null;
    }

    public final DOMCachedNode getCachedPrecedingSibling() {
        return null;
    }

    public final short itemKind() {
        return 2;
    }

    public final VolatileCData itemName() {
        return this.name;
    }

    public XSTypeDefinition itemXSType() {
        XSTypeDefinition xSTypeDefinition;
        if (DOMCachedElement.doCacheXDMTyping) {
            ItemPSVI itemPSVI = this.itemXSPSVInfo();
            if (itemPSVI != null) {
                short s = itemPSVI.getValidity();
                short s2 = itemPSVI.getValidationAttempted();
                XSTypeDefinition xSTypeDefinition2 = itemPSVI.getTypeDefinition();
                xSTypeDefinition = s == 1 || s2 == 1 ? TypeRegistry.XSANYSIMPLETYPE : (s == 2 && s2 == 2 ? xSTypeDefinition2 : (this.xstype != null ? (this.xstype == TypeRegistry.XSANYSIMPLETYPE ? TypeRegistry.XSUNTYPEDATOMIC : this.xstype) : TypeRegistry.XSUNTYPEDATOMIC));
            } else {
                xSTypeDefinition = this.xstype != null ? (this.xstype == TypeRegistry.XSANYSIMPLETYPE ? TypeRegistry.XSUNTYPEDATOMIC : this.xstype) : TypeRegistry.XSUNTYPEDATOMIC;
            }
        } else {
            if (this.xstype != null) {
                return this.xstype;
            }
            ItemPSVI itemPSVI = this.itemXSPSVInfo();
            if (itemPSVI != null) {
                return itemPSVI.getTypeDefinition();
            }
            return super.itemXSType();
        }
        return xSTypeDefinition;
    }

    public VolatileCData itemTypedValue() {
        VolatileCData volatileCData = super.itemTypedValue();
        return volatileCData;
    }

    public ItemPSVI itemXSPSVInfo() {
        return this.xspsvi;
    }

    public boolean itemIsID() {
        return this.isID;
    }

    public boolean itemIsIDREFS() {
        return this.isIDREF;
    }

    public void setItemValue(VolatileCData volatileCData) {
        if (this.name.getQName(1, null).equals(CommonJAXPQNames.XSI_NIL)) {
            this.changeXsiValue(volatileCData);
        }
        if (this.isID) {
            this.cache.removeID(this);
        } else if (this.isIDREF) {
            this.cache.removeIDREF(this);
        }
        super.setItemValue(volatileCData);
        this.xstype = volatileCData.getXSTypeDefinition();
        if (this.isID) {
            this.cache.addID(this);
        } else if (this.isIDREF) {
            this.cache.addIDREF(this);
        }
    }

    private void changeXsiValue(VolatileCData volatileCData) {
        this.parent.state = volatileCData.toString().toLowerCase(Locale.ENGLISH).equals("true") ? BitMaskHelper.stateSet(this.parent.state, 262144) : BitMaskHelper.stateUnset(this.parent.state, 262144);
    }

    public void setItemName(VolatileCData volatileCData) {
        this.checkSetItemName(volatileCData);
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
        this.name = volatileCData.constant(true);
        this.setDirty(this);
    }

    public void setItemPSVI(ItemPSVI itemPSVI) {
        if (itemPSVI != null && !(itemPSVI instanceof AttributePSVI)) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_PSVI_WRONG_INSTANCE", new String[]{"attributes", "AttributePSVI"}));
        }
        this.xspsvi = (AttributePSVI)itemPSVI;
        if (this.xspsvi != null) {
            this.xsAttrDecl = this.xspsvi.getAttributeDeclaration();
            this.itemValueOrigin = this.xspsvi.getIsSchemaSpecified() ? Cursor.ItemValueOrigin.XSDDEFAULTED : Cursor.ItemValueOrigin.SPECIFIED;
            boolean bl = this.isID;
            boolean bl2 = this.isIDREF;
            XSTypeDefinition xSTypeDefinition = this.xspsvi.getTypeDefinition();
            if (xSTypeDefinition != null) {
                this.isID = IDHelper.isAttributeID(this.name, xSTypeDefinition);
                this.isIDREF = IDHelper.isIDREF(xSTypeDefinition);
            }
            if (bl != this.isID) {
                if (this.isID) {
                    this.cache.addID(this);
                } else {
                    this.cache.removeID(this);
                }
            }
            if (bl2 != this.isIDREF) {
                if (this.isIDREF) {
                    this.cache.addIDREF(this);
                } else {
                    this.cache.removeIDREF(this);
                }
            }
            this.retypeData();
        } else {
            this.isID = false;
            this.isIDREF = false;
        }
    }

    private void retypeData() {
        if (DOMCachedElement.doCacheXDMTyping && this.data != null) {
            this.data = new BaseCDataWithChars((XSSimpleTypeDefinition)this.itemXSType(), this.data.getOriginalLexicalValue() != null ? this.data.getOriginalLexicalValue() : this.sequenceConstructSimpleContent(" ", true, false));
        }
    }

    public XSAttributeDeclaration itemXSAttributeDeclaration() {
        return this.xsAttrDecl;
    }

    public void setItemXSType(XSTypeDefinition xSTypeDefinition) {
        this.xstype = xSTypeDefinition;
        if (this.xstype != this.data.getXSTypeDefinition()) {
            this.retypeData();
        }
    }

    public VolatileCData serialize(Map map2) {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"serialize", DOMCachedAttribute.class.getName()}));
    }

    public boolean test(Cursor cursor2) {
        return cursor2.itemKind() == 2 && this.name.equals(cursor2.itemName());
    }

    public boolean allowsAttribute(VolatileCData volatileCData) {
        return this.name.equals(volatileCData);
    }

    public NameTest theNameTest() {
        return SimpleNameTest.name(this.itemName());
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public short getNodeType() {
        return 2;
    }

    public DOMCachedNode getParentNode() {
        return null;
    }

    public String getNamespaceURI() {
        return BitMaskHelper.stateContains(this.state, 32768) ? null : this.name.getQNameNamespaceURI(1);
    }

    public String getPrefix() {
        return BitMaskHelper.stateContains(this.state, 32768) ? null : this.name.getQNamePrefix(1);
    }

    public void setPrefix(String string2) throws DOMException {
    }

    public String getLocalName() {
        return BitMaskHelper.stateContains(this.state, 32768) ? null : this.name.getQNameLocalPart(1);
    }

    public String getName() {
        String string2 = this.name.getQNamePrefix(1);
        return (string2 == null || string2.length() == 0 ? "" : string2 + ":") + this.name.getQNameLocalPart(1);
    }

    public boolean getSpecified() {
        return true;
    }

    public String getValue() {
        return this.data == null ? "" : this.data.toString();
    }

    public void setValue(String string2) throws DOMException {
        this.setItemValue(this.factory.data((CharSequence)string2, TypeRegistry.XSSTRING, false));
    }

    public Element getOwnerElement() {
        if (this.parent == null) {
            return null;
        }
        assert (this.parent.itemKind() == 1) : "Attribute has  no parent?";
        return (Element)((Object)this.parent);
    }

    public boolean isId() {
        return this.itemIsID();
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    protected void printXQuery(Writer writer, String string2, boolean bl) throws IOException {
        if (this.data != null) {
            writer.write(string2 + this.printState() + " attribute " + this.name + " { " + CharsBase.toEncodedString(this.data) + " }\n");
        } else {
            writer.write(string2 + this.printState() + " attribute " + this.name + " { nulldata }\n");
        }
    }

    public Cursor.ItemValueOrigin itemAttributeValueOrigin() {
        return this.itemValueOrigin;
    }

    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        if (bl) {
            return this.parent == null ? null : this.parent.itemNamespaceContext();
        }
        return null;
    }

    public String itemBaseURI() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.itemBaseURI();
    }

    public void setItemBaseURI(String string2) {
    }

    public boolean hasChildNodes() {
        return true;
    }

    public final Node getFirstChild() {
        if (this.textChild == null) {
            this.textChild = new DOMCachedText(this.cache, this.data, false, false, null, null);
        }
        return this.textChild;
    }

    public final Node getLastChild() {
        if (this.textChild == null) {
            this.textChild = new DOMCachedText(this.cache, this.data, false, false, null, null);
        }
        return this.textChild;
    }

    public NodeList getChildNodes() {
        return new AttrChild();
    }

    class AttrChild
    implements NodeList {
        public int getLength() {
            return 1;
        }

        public Node item(int n2) {
            if (n2 < 0 || n2 >= this.getLength()) {
                return null;
            }
            if (DOMCachedAttribute.this.textChild == null) {
                DOMCachedAttribute.this.textChild = new DOMCachedText(DOMCachedAttribute.this.cache, DOMCachedAttribute.this.data, false, false, null, null);
            }
            return DOMCachedAttribute.this.textChild;
        }
    }
}

