/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopiedCacheCursor
extends CacheCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile PROFILE_LIMIT = Cursor.Profile.DATA_MODEL.union(Cursor.Profile.TO_NODE_TEST);
    private static final Logger logger = LoggerUtil.getLogger(CopiedCacheCursor.class);
    protected boolean isOriginalNode;
    protected final CacheManager copiedManager;

    protected CopiedCacheCursor(CacheManager cacheManager, DOMCachedNode dOMCachedNode, boolean bl) {
        super(dOMCachedNode, bl);
        this.copiedManager = cacheManager;
        this.setToCopyMode();
    }

    protected CopiedCacheCursor(CopiedCacheCursor copiedCacheCursor, Cursor.Profile profile, boolean bl) {
        super(copiedCacheCursor, profile, bl);
        this.isOriginalNode = copiedCacheCursor.isOriginalNode;
        this.copiedManager = copiedCacheCursor.copiedManager;
    }

    public void notifyCopy(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (this.contextNode == dOMCachedNode) {
            this.contextNode = dOMCachedNode2;
            this.setToCopyMode();
        }
    }

    private final void setToOriginalMode() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setToOriginalMode", "context node=" + this.contextNode.toStringLazy() + "\nCopiedManager=" + this.copiedManager.toString() + "\ncontext node's manager=" + this.contextNode.getCache());
        }
        this.isOriginalNode = true;
        this.copiedManager.registerCopiedCursorWithOriginal(this);
    }

    private final void setToCopyMode() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setToCopyMode", "context node=" + this.contextNode.toStringLazy() + "\nCopiedManager=" + this.copiedManager.toString() + "\ncontext node's manager=" + this.contextNode.getCache());
        }
        this.isOriginalNode = false;
        this.copiedManager.unregisterCopiedCursorWithOriginal(this);
    }

    private final void copyTo(Cursor.Area area) {
        if (this.isOriginalNode) {
            this.contextNode = this.copiedManager.copyToOriginalNode(this.contextNode);
            this.setToCopyMode();
        }
        DOMCachedNode dOMCachedNode = this.contextNode.getOriginalNode();
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedFirstChild();
                if (dOMCachedNode2 == null || dOMCachedNode2.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedNode2);
                break;
            }
            case LAST_CHILD: {
                DOMCachedNode dOMCachedNode3 = dOMCachedNode.getCachedLastChild();
                if (dOMCachedNode3 == null || dOMCachedNode3.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedNode3);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                DOMCachedNode dOMCachedNode4 = dOMCachedNode.getCachedFollowingSibling();
                if (dOMCachedNode4 == null || dOMCachedNode4.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedNode4);
                break;
            }
        }
    }

    public Cursor.Profile profile() {
        return PROFILE_LIMIT;
    }

    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    public Cursor.Profile futureProfile() {
        return PROFILE_LIMIT;
    }

    public boolean toAttributes(NodeTest nodeTest) {
        if (this.isOriginalNode) {
            return super.toAttributes(nodeTest);
        }
        if (super.toAttributes(nodeTest)) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toChildren(NodeTest nodeTest) {
        if (this.isOriginalNode) {
            return super.toChildren(nodeTest);
        }
        if (super.toChildren(nodeTest)) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toParent() {
        DOMCachedNode dOMCachedNode;
        DOMCachedNode dOMCachedNode2 = this.contextNode.getCachedParent();
        if (dOMCachedNode2 == null) {
            return false;
        }
        if (this.isOriginalNode && (dOMCachedNode = this.copiedManager.getCopiedNode(dOMCachedNode2)) != null) {
            dOMCachedNode2 = dOMCachedNode;
            this.setToCopyMode();
        }
        this.replaceContextNodeAndState(dOMCachedNode2, (short)0);
        this.sequenceTest = null;
        this.idrefsOrIdsCDATA = null;
        return true;
    }

    public boolean toFollowingSiblings(NodeTest nodeTest) {
        if (this.isOriginalNode) {
            return super.toFollowingSiblings(nodeTest);
        }
        if (super.toFollowingSiblings(nodeTest)) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toNamespaceDecls() {
        if (this.isOriginalNode) {
            return super.toNamespaceDecls();
        }
        if (super.toNamespaceDecls()) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toNext() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "toNext", "context node=" + this.contextNode.toStringLazy() + "\nCopiedManager=" + this.copiedManager.toString() + "\ncontext node's manager=" + this.contextNode.getCache() + "\ncontext node's mediator data=" + this.contextNode.getMediatorData());
        }
        if (this.isOriginalNode) {
            return super.toNext();
        }
        if (super.toNext()) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toPrevious() {
        if (!this.isOriginalNode) {
            return super.toPrevious();
        }
        if (super.toPrevious()) {
            DOMCachedNode dOMCachedNode = this.copiedManager.getCopiedNode(this.contextNode);
            if (dOMCachedNode != null) {
                this.contextNode = dOMCachedNode;
                this.setToCopyMode();
            }
            return true;
        }
        return false;
    }

    public boolean toRoot() {
        DOMCachedNode dOMCachedNode = this.copiedManager.rootNode;
        if (this.isOriginalNode) {
            this.setToCopyMode();
        }
        this.replaceContextNodeAndState(dOMCachedNode, (short)0);
        this.sequenceTest = null;
        this.idrefsOrIdsCDATA = null;
        return true;
    }

    public boolean toPosition(long l) {
        block6: {
            long l2;
            block5: {
                if (this.sequenceState == 0) {
                    return l == 1L;
                }
                if (l < 1L) {
                    return false;
                }
                l2 = this.contextPosition() - l;
                if (l2 <= 0L) break block5;
                while (l2 > 0L) {
                    this.toPrevious();
                    --l2;
                }
                break block6;
            }
            if (l2 >= 0L) break block6;
            DOMCachedNode dOMCachedNode = this.contextNode;
            while (l2 < 0L) {
                if (!this.toNext()) {
                    this.contextNode = dOMCachedNode;
                    return false;
                }
                ++l2;
            }
        }
        return true;
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return new CopiedCacheCursor(this, profile, bl);
    }

    public void release() {
        assert (null == this.forkReleaseInstanceTracker || this.forkReleaseInstanceTracker.checkAndRecordRelease(false, this));
        if (this.isOriginalNode) {
            this.copiedManager.unregisterCopiedCursorWithOriginal(this);
        }
        super.release();
    }

    public Object exportAs(String string2, boolean bl) {
        if (this.isOriginalNode) {
            this.contextNode = this.copiedManager.copyToOriginalNode(this.contextNode);
            this.setToCopyMode();
        }
        return super.exportAs(string2, bl);
    }

    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        this.copyTo(area);
        super.addElement(area, volatileCData, xSTypeDefinition);
    }

    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.copyTo(Cursor.Area.SELF);
        super.addAttribute(volatileCData, volatileCData2);
    }

    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        this.copyTo(area);
        super.addComment(area, volatileCData);
    }

    public void addCopy(Cursor.Area area, Cursor cursor2) {
        this.copyTo(area);
        super.addCopy(area, cursor2);
    }

    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        this.copyTo(Cursor.Area.SELF);
        super.addNamespaceNode(volatileCData, volatileCData2, bl);
    }

    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.copyTo(area);
        super.addProcessingInstruction(area, volatileCData, volatileCData2);
    }

    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        this.copyTo(area);
        super.addText(area, volatileCData);
    }

    public void move(Cursor.Area area, Cursor cursor2) {
        this.copyTo(area);
        super.move(area, cursor2);
    }

    public boolean removeAttribute(VolatileCData volatileCData) {
        this.copyTo(Cursor.Area.SELF);
        return super.removeAttribute(volatileCData);
    }

    public boolean removeSubtree(Cursor.Area area) {
        this.copyTo(area);
        return super.removeSubtree(area);
    }

    public void setItemName(VolatileCData volatileCData) {
        this.copyTo(Cursor.Area.SELF);
        super.setItemName(volatileCData);
    }

    public void setItemValue(VolatileCData volatileCData) {
        this.copyTo(Cursor.Area.LAST_CHILD);
        super.setItemValue(volatileCData);
    }
}

