/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.internal.util.SortHelper;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSObject;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheNodeSequence
extends CacheCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int BUCKET_SIZE = 20;
    private DOMCachedNode[] nodes;
    private int index;
    private int length;

    public CacheNodeSequence(DOMCachedNode[] dOMCachedNodeArray, int n2, int n3) {
        super(dOMCachedNodeArray[0], false);
        this.nodes = dOMCachedNodeArray;
        this.length = n2;
        this.index = n3;
    }

    public CacheNodeSequence setValues(DOMCachedNode[] dOMCachedNodeArray, int n2, int n3) {
        this.nodes = dOMCachedNodeArray;
        this.length = n2;
        this.index = n3;
        this.replaceContextNode(dOMCachedNodeArray[n3]);
        return this;
    }

    @Override
    public boolean toPrevious() {
        if (this.isDeadSequence()) {
            if (this.index - 1 < 0) {
                return false;
            }
            --this.index;
            return true;
        }
        return super.toPrevious();
    }

    @Override
    public boolean toNext() {
        if (this.isDeadSequence()) {
            if (this.index + 1 >= this.length) {
                return false;
            }
            ++this.index;
            return true;
        }
        return super.toNext();
    }

    @Override
    public boolean hasNext() {
        if (this.isDeadSequence()) {
            return this.index + 1 < this.length;
        }
        return super.hasNext();
    }

    @Override
    public long contextSize() {
        if (this.isDeadSequence()) {
            return this.length;
        }
        return super.contextSize();
    }

    @Override
    public long contextPosition() {
        if (this.isDeadSequence()) {
            return this.index + 1;
        }
        return super.contextPosition();
    }

    @Override
    public boolean toPosition(long l) {
        if (this.isDeadSequence()) {
            if (l < 1L || l > (long)this.length) {
                return false;
            }
            this.index = (int)l - 1;
            return true;
        }
        return super.toPosition(l);
    }

    @Override
    public final Cursor getDelegate() {
        if (this.isDeadSequence()) {
            return this.nodes[this.index];
        }
        return super.getDelegate();
    }

    @Override
    public VolatileCData itemTypedValue() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemTypedValue();
    }

    @Override
    public VolatileCData itemName() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemName();
    }

    @Override
    public short itemKind() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemKind();
    }

    @Override
    public VolatileCData itemStringValue() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemStringValue();
    }

    @Override
    public QName itemTypeName() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemTypeName();
    }

    @Override
    public XSTypeDefinition itemXSType() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemXSType();
    }

    @Override
    public XSAttributeDeclaration itemXSAttributeDeclaration() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemXSAttributeDeclaration();
    }

    @Override
    public XSElementDeclaration itemXSElementDeclaration() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemXSElementDeclaration();
    }

    public final void switchToLiveSequence() {
        this.replaceContextNode(this.nodes[this.index]);
        this.nodes = null;
    }

    public final boolean isDeadSequence() {
        return this.nodes != null;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (!this.isDeadSequence()) {
            return super.fork(bl, profile, profile2);
        }
        if (bl) {
            return new CacheCursor(this.nodes[this.index], true);
        }
        return new CacheNodeSequence(this.nodes, this.length, this.index);
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        assert (this != cursor2);
        if (!this.isDeadSequence()) {
            return super.sequenceConcat(cursor2, profile, profile2, bl, bl2, bl3, bl4);
        }
        if (cursor2 == null) {
            Cursor cursor3 = AbstractCursor.ownTheCursor(this, bl, bl3);
            return cursor3;
        }
        if (cursor2.unwrap() instanceof DOMCachedNode) {
            if (cursor2 instanceof CacheNodeSequence) {
                CacheNodeSequence cacheNodeSequence = (CacheNodeSequence)AbstractCursor.ownTheCursor(cursor2, bl2, bl4);
                int n2 = bl ? 1 : this.length;
                cacheNodeSequence.preprendArray(this.nodes, n2, bl2);
                if (bl3) {
                    this.release();
                }
                return cacheNodeSequence;
            }
            Cursor cursor4 = AbstractCursor.ownTheCursor(this, bl, bl3);
            if (cursor4 instanceof CacheNodeSequence) {
                CacheNodeSequence cacheNodeSequence = (CacheNodeSequence)cursor4;
                cursor2 = AbstractCursor.ownTheCursorIfMightMove(cursor2, bl2, bl4);
                int[] nArray = new int[1];
                if (bl) {
                    cacheNodeSequence.length = 1;
                    nArray[0] = 1;
                } else {
                    nArray[0] = cacheNodeSequence.length;
                }
                DOMCachedNode[] dOMCachedNodeArray = CacheNodeSequence.appendSequence(cursor2, cacheNodeSequence.nodes, nArray, bl2);
                AbstractCursor.ownedCleanupIfMightMove(cursor2, bl2, true);
                cacheNodeSequence.setValues(dOMCachedNodeArray, nArray[0], this.index);
                return cacheNodeSequence;
            }
            return super.sequenceConcat(cursor2, profile, profile2, bl, bl2, bl3, bl4);
        }
        return super.sequenceConcat(cursor2, profile, profile2, bl, bl2, bl3, bl4);
    }

    @Override
    public boolean contextIsLive() {
        return !this.isDeadSequence();
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toAttributes(nodeTest);
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toChildren(nodeTest);
    }

    @Override
    public boolean toRoot() {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toRoot();
    }

    @Override
    public boolean toFollowingSiblings(NodeTest nodeTest) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toFollowingSiblings(nodeTest);
    }

    @Override
    public boolean toIdrefs(VolatileCData volatileCData) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toIdrefs(volatileCData);
    }

    @Override
    public boolean toIds(VolatileCData volatileCData) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toIds(volatileCData);
    }

    @Override
    public boolean toNamespaceDecls() {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toNamespaceDecls();
    }

    @Override
    public boolean toParent() {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toParent();
    }

    @Override
    public boolean toPrecedingSiblings(NodeTest nodeTest) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toPrecedingSiblings(nodeTest);
    }

    @Override
    public boolean toSelf() {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toSelf();
    }

    @Override
    public void release() {
        this.nodes = null;
        super.release();
    }

    @Override
    public int validate(int n2) {
        if (this.isDeadSequence()) {
            CacheCursor cacheCursor = new CacheCursor(this.nodes[this.index], false);
            return cacheCursor.validate(n2);
        }
        return super.validate(n2);
    }

    @Override
    public int validate(int n2, Locale locale, XSObject xSObject, Map<String, List<String>> map2) {
        if (this.isDeadSequence()) {
            CacheCursor cacheCursor = new CacheCursor(this.nodes[this.index], false);
            return cacheCursor.validate(n2, locale, xSObject, map2);
        }
        return super.validate(n2, locale, xSObject, map2);
    }

    @Override
    public void addCopy(Cursor.Area area, Cursor cursor2) {
        if (this.isDeadSequence()) {
            CacheCursor cacheCursor = new CacheCursor(this.nodes[this.index], false);
            cacheCursor.addCopy(area, cursor2);
        } else {
            super.addCopy(area, cursor2);
        }
    }

    @Override
    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (this.isDeadSequence()) {
            CacheCursor cacheCursor = new CacheCursor(this.nodes[this.index], false);
            cacheCursor.addElement(area, volatileCData, xSTypeDefinition);
        } else {
            super.addElement(area, volatileCData, xSTypeDefinition);
        }
    }

    private void preprendArray(DOMCachedNode[] dOMCachedNodeArray, int n2, boolean bl) {
        int n3 = dOMCachedNodeArray.length - (n2 + 1);
        int n4 = bl ? 1 : this.length;
        if (n3 >= n4) {
            System.arraycopy(this.nodes, 0, dOMCachedNodeArray, n2, n4);
        } else {
            DOMCachedNode[] dOMCachedNodeArray2 = new DOMCachedNode[dOMCachedNodeArray.length + n4];
            System.arraycopy(dOMCachedNodeArray, 0, dOMCachedNodeArray2, 0, n2);
            System.arraycopy(this.nodes, 0, dOMCachedNodeArray2, n2, n4);
            dOMCachedNodeArray = dOMCachedNodeArray2;
        }
        this.setValues(dOMCachedNodeArray, n4 + n2, 0);
    }

    public static CacheNodeSequence getNewSequence(Cursor cursor2, Cursor cursor3, boolean bl, boolean bl2) {
        DOMCachedNode[] dOMCachedNodeArray = new DOMCachedNode[20];
        int[] nArray = new int[]{0};
        dOMCachedNodeArray = CacheNodeSequence.appendSequence(cursor2, dOMCachedNodeArray, nArray, bl);
        dOMCachedNodeArray = CacheNodeSequence.appendSequence(cursor3, dOMCachedNodeArray, nArray, bl2);
        CacheNodeSequence cacheNodeSequence = new CacheNodeSequence(dOMCachedNodeArray, nArray[0], 0);
        return cacheNodeSequence;
    }

    private static DOMCachedNode[] appendSequence(Cursor cursor2, DOMCachedNode[] dOMCachedNodeArray, int[] nArray, boolean bl) {
        int n2 = nArray[0];
        do {
            if (dOMCachedNodeArray.length == n2) {
                dOMCachedNodeArray = CacheNodeSequence.expandArray(dOMCachedNodeArray);
            }
            dOMCachedNodeArray[n2++] = (DOMCachedNode)cursor2.unwrap();
        } while (!bl && cursor2.toNext());
        nArray[0] = n2;
        return dOMCachedNodeArray;
    }

    public static CacheNodeSequence prependSequence(Cursor cursor2, CacheNodeSequence cacheNodeSequence, boolean bl, boolean bl2) {
        DOMCachedNode[] dOMCachedNodeArray = new DOMCachedNode[20];
        int[] nArray = new int[]{0};
        dOMCachedNodeArray = CacheNodeSequence.appendSequence(cursor2, dOMCachedNodeArray, nArray, bl);
        cacheNodeSequence.preprendArray(dOMCachedNodeArray, nArray[0], bl2);
        return cacheNodeSequence;
    }

    private static DOMCachedNode[] expandArray(DOMCachedNode[] dOMCachedNodeArray) {
        DOMCachedNode[] dOMCachedNodeArray2 = new DOMCachedNode[dOMCachedNodeArray.length + 20];
        System.arraycopy(dOMCachedNodeArray, 0, dOMCachedNodeArray2, 0, dOMCachedNodeArray.length);
        return dOMCachedNodeArray2;
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        Cursor cursor2 = SortHelper.documentOrderSortToSequence(this, true, profile, profile2, bl);
        return cursor2;
    }

    @Override
    public Cursor unwrap() {
        if (this.isDeadSequence()) {
            return this.nodes[this.index];
        }
        return super.unwrap();
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return false;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return true;
    }
}

