/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursorFactory;
import com.ibm.xml.xci.dp.cache.CacheFactory;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheCursorFactory;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCacheNodeFactory;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedComment;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocument;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocumentType;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedPI;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.dom.NoMutationCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.StreamingCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.UserData;
import com.ibm.xml.xci.dp.cache.dom.UserDataFactory;
import com.ibm.xml.xci.dp.cache.dom.helpers.ArrayReferenceCounter;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.CopiedCacheMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.Mediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.NoMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager
implements DOMImplementation {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(CacheManager.class);
    public static final String SDOX_WRAPPER = "SDOX_WRAPPER";
    public static final int STATE_READONLY = 8192;
    public static final int STATE_OBJECT = 16384;
    public static final int STATE_UNQUALIFIED = 32768;
    public static final int STATE_DIRTY = 65536;
    public static final int STATE_VALID_INDEX = 131072;
    public static final int STATE_NILLED = 262144;
    public static final int STATE_SUBTREE_DIRTY = 524288;
    public static final int STATE_MUT_MAP_QUEUED = 0x100000;
    public static final int NEXT_BIT = 20;
    public static final int DOM_USER_DATA_DATA = 1;
    public static final int ORIGINAL_NODE_DATA = 2;
    public static final int MEDIATOR_DATA_DATA = 4;
    public static final CursorFactory DEFAULT_FACTORY = new CacheCursorFactory(new SessionContext());
    public static final Mediator DEFAULT_MEDIATOR = new NoMediator(DEFAULT_FACTORY);
    public static final CacheManager DEFAULT_CACHE_MANAGER = new CacheManager(DEFAULT_MEDIATOR, null, null);
    static final Cursor.Profile DOM_READ_FEATURES = Cursor.Profile.DATA_MODEL;
    static final Cursor.Profile DOM_WRITE_FEATURES = Cursor.Profile.RANDOM_UPDATE;
    public static final Cursor.Profile DOM_FEATURES = DOM_READ_FEATURES.union(DOM_WRITE_FEATURES);
    public final CData EMPTY_STRING;
    private Mediator mediator;
    private boolean switchedMediator;
    private final CursorFactory cursorFactory;
    protected final boolean isPreservedNamespaceDecl;
    protected final boolean isEagerLoading;
    protected final boolean isValidateLoading;
    protected final boolean isWrapper;
    protected boolean attemptFastSerialization;
    private final DOMCacheNodeFactory nodeFactory;
    private UserDataFactory userDataFactory;
    protected DOMCachedNode rootNode;
    private final ArrayReferenceCounter<DOMCachedNode> refCounter;
    private Map<CData, DOMCachedAttribute> id2attribute;
    private Map<CData, List<DOMCachedAttribute>> id2ref;
    private ItemCopier itemCopier;
    protected DocumentInfo myDocumentInfo;
    private final long documentIdentity;
    protected final CopiedCacheMediator copyMediator;
    protected List<CacheManager> copies;
    private boolean mutating;
    private int namespaceVersion = 0;

    public CacheManager() {
        this(DEFAULT_MEDIATOR, null, null);
    }

    public CacheManager(CursorFactory cursorFactory, Map map2) {
        this(cursorFactory, DOMCacheNodeFactory.DEFAULT_NODE_FACTORY, map2);
    }

    public CacheManager(CursorFactory cursorFactory, DOMCacheNodeFactory dOMCacheNodeFactory, Map map2) {
        this(new NoMediator(cursorFactory), dOMCacheNodeFactory, map2);
    }

    public CacheManager(Mediator mediator, DOMCacheNodeFactory dOMCacheNodeFactory, Map map2) {
        this(mediator, dOMCacheNodeFactory, map2, null);
    }

    protected CacheManager(Mediator mediator, DOMCacheNodeFactory dOMCacheNodeFactory, Map map2, CacheManager cacheManager) {
        if (cacheManager != null) {
            this.copyMediator = new CopiedCacheMediator(cacheManager, this);
            this.mediator = this.copyMediator;
            this.myDocumentInfo = cacheManager.myDocumentInfo;
        } else {
            this.mediator = mediator == null ? DEFAULT_MEDIATOR : mediator;
            this.copyMediator = null;
        }
        this.documentIdentity = this.mediator.factory().getSessionContext().obtainUniqueDocumentIdentity();
        this.mediator.processParameters(map2);
        this.cursorFactory = this.mediator.factory();
        this.isWrapper = MiscHelpers.getBoolean(SDOX_WRAPPER, map2, false);
        this.isPreservedNamespaceDecl = MiscHelpers.isPreservedNamespaceDecls(map2);
        this.isEagerLoading = MiscHelpers.isEagerLoading(map2);
        this.isValidateLoading = MiscHelpers.isValidLoading(map2);
        this.attemptFastSerialization = this.mediator.fastSerializationEnabled();
        this.nodeFactory = dOMCacheNodeFactory == null ? DOMCacheNodeFactory.DEFAULT_NODE_FACTORY : dOMCacheNodeFactory;
        this.refCounter = new ArrayReferenceCounter();
        this.setUserDataFactory(this.mediator);
        this.id2attribute = new HashMap<CData, DOMCachedAttribute>();
        this.id2ref = new HashMap<CData, List<DOMCachedAttribute>>();
        this.EMPTY_STRING = CData.EMPTY_STRING;
        this.itemCopier = null;
    }

    public final CursorFactory factory() {
        return this.cursorFactory;
    }

    public Mediator mediator() {
        return this.mediator;
    }

    public Mediator mediator(DOMCachedNode dOMCachedNode) {
        return this.mediator(dOMCachedNode, true);
    }

    public Mediator mediator(DOMCachedNode dOMCachedNode, boolean bl) {
        UserData userData;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "mediator", "calling mediator for node=" + dOMCachedNode.toStringLazy() + "\nCache manager = " + this.toString() + " | Mediator (for node) = " + dOMCachedNode.getMediatorData() + " | setData = " + bl + " | switchedMediator=" + this.switchedMediator);
        }
        if ((userData = dOMCachedNode.getUserData()) != null && userData.getMediatorData() != null) {
            Mediator mediator = (Mediator)userData.getMediatorData();
            if (bl) {
                this.setUserDataFactory(mediator);
                this.switchedMediator = true;
            }
            return mediator;
        }
        if (this.switchedMediator && bl) {
            this.setUserDataFactory(this.mediator);
            this.switchedMediator = false;
        }
        return this.mediator;
    }

    public final DOMCacheNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    public final UserData createUserData() {
        return this.userDataFactory.create();
    }

    public void release() {
    }

    protected CacheManager createCacheManager(Mediator mediator, DOMCacheNodeFactory dOMCacheNodeFactory, CacheManager cacheManager) {
        return new CacheManager(mediator, dOMCacheNodeFactory, null, cacheManager);
    }

    public Cursor copy(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl, Map<String, Object> map2) {
        if (MiscHelpers.getBoolean("copy-on-write", map2, false)) {
            CacheManager cacheManager = this.createCacheManager(null, this.nodeFactory, this);
            if (this.attemptFastSerialization) {
                cacheManager.setAttemptFastSerialization(true);
            }
            if (this.copies == null) {
                this.copies = new ArrayList<CacheManager>();
            }
            this.copies.add(cacheManager);
            DOMCachedNode dOMCachedNode2 = MiscHelpers.makeNode(dOMCachedNode, cacheManager, null, null);
            cacheManager.setCopiedNode(dOMCachedNode, dOMCachedNode2);
            dOMCachedNode2.setOriginalNode(dOMCachedNode);
            if (dOMCachedNode.itemKind() == 1) {
                this.copyNSDecls((DOMCachedElement)dOMCachedNode, (DOMCachedElement)dOMCachedNode2, cacheManager);
            }
            dOMCachedNode2.state = LazyLoadingHelper.markPrecedingFollowingParentResolved(dOMCachedNode2.state);
            cacheManager.rootNode = dOMCachedNode2;
            return new CopiedCacheCursor(cacheManager, cacheManager.rootNode, bl);
        }
        boolean bl2 = dOMCachedNode.itemKind() != 9;
        Cursor cursor2 = dOMCachedNode.fork(bl, Copier.SOURCE_FEATURES, Copier.SOURCE_FEATURES);
        Cursor cursor3 = this.document(new RequestInfo(profile.union(Copier.TARGET_FEATURES)));
        Copier.copy(cursor2, cursor3.fork(bl, Copier.TARGET_FEATURES, Copier.TARGET_FEATURES));
        if (bl2) {
            cursor3.toChildren(null);
        }
        return cursor3;
    }

    protected void copyNSDecls(DOMCachedElement dOMCachedElement, DOMCachedElement dOMCachedElement2, CacheManager cacheManager) {
        if (dOMCachedElement.parent != null && dOMCachedElement.parent.itemKind() == 1) {
            ((DOMCachedElement)dOMCachedElement.parent).getInScopeNamespacesList();
            dOMCachedElement2.nsContext = ((DOMCachedElement)dOMCachedElement.parent).nsContext;
        }
    }

    protected Cursor document(RequestInfo requestInfo) {
        return ((AbstractCursorFactory)this.factory()).document(requestInfo);
    }

    public final DOMCachedNode getCopiedNode(DOMCachedNode dOMCachedNode) {
        return this.copyMediator == null ? null : this.copyMediator.getCopiedNode(dOMCachedNode);
    }

    public final void setCopiedNode(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (this.copyMediator != null) {
            this.copyMediator.setCopiedNode(dOMCachedNode, dOMCachedNode2);
        }
    }

    protected void notifyNodeAboutToChangeToCopies(DOMCachedNode dOMCachedNode, Cursor.Area.ImmediateAreas immediateAreas) {
        DOMCachedNode dOMCachedNode2;
        if (dOMCachedNode == null) {
            return;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "notifyNodeAboutToChangeToCopies", "About to mutate the node=" + dOMCachedNode + " in area=" + immediateAreas.toString() + "\nStack trace= " + XCIErrorHelper.getStackTrace(15));
        }
        this.mediator.reportMutation(dOMCachedNode);
        List<CacheManager> list = this.copies;
        if (dOMCachedNode.getUserData() != null && (dOMCachedNode2 = dOMCachedNode.getUserData().getOriginalNode()) != null) {
            list = dOMCachedNode2.getCache().copies;
        }
        if (list == null) {
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            list.get((int)i).copyMediator.nodeAboutToChange(dOMCachedNode, immediateAreas);
        }
    }

    protected final void registerCopiedCursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
        this.copyMediator.registerCopiedCursorWithOriginal(copiedCacheCursor);
    }

    protected final void unregisterCopiedCursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
        this.copyMediator.unregisterCopiedCursorWithOriginal(copiedCacheCursor);
    }

    public final DOMCachedNode copyToOriginalNode(DOMCachedNode dOMCachedNode) {
        return this.copyMediator.copyToOriginalNode(dOMCachedNode);
    }

    public DOMCachedAttribute getBuiltAttrById(CData cData) {
        return this.id2attribute.get(cData);
    }

    public DOMCachedNode getBuiltId(CData cData, int n2) {
        return this.id2attribute.get(cData.itemAt(n2));
    }

    public DOMCachedAttribute getCachedId(VolatileCData volatileCData, int n2) {
        return this.id2attribute.get(volatileCData.constant(true).itemAt(n2));
    }

    public List<DOMCachedAttribute> getCachedIdRefs(VolatileCData volatileCData, int n2) {
        return this.id2ref.get(volatileCData.constant(true).itemAt(n2));
    }

    Iterator<DOMCachedAttribute> lookupID(CData cData) {
        return new LookupIDIterator(cData);
    }

    public void addID(DOMCachedAttribute dOMCachedAttribute) {
        StringCData stringCData = new StringCData(dOMCachedAttribute.itemTypedValue().toString().trim(), TypeRegistry.XSSTRING);
        this.id2attribute.put(stringCData, dOMCachedAttribute);
    }

    public void addIDREF(DOMCachedAttribute dOMCachedAttribute) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addIDREF", "registering IDREF: " + dOMCachedAttribute);
        }
        String[] stringArray = dOMCachedAttribute.itemTypedValue().constant(true).toString().split("\\s");
        for (int i = 0; i < stringArray.length; ++i) {
            CData cData = dOMCachedAttribute.factory().data((CharSequence)stringArray[i], null, false);
            List<DOMCachedAttribute> list = this.id2ref.get(cData);
            if (list == null) {
                list = new ArrayList<DOMCachedAttribute>();
            }
            list.add(dOMCachedAttribute);
            this.id2ref.put(cData, list);
        }
    }

    public void removeID(DOMCachedAttribute dOMCachedAttribute) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeID", "removing ID=" + dOMCachedAttribute);
        }
        this.id2attribute.remove(dOMCachedAttribute.itemTypedValue());
    }

    public void removeIDREF(DOMCachedAttribute dOMCachedAttribute) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeIDREF", "removing IDREF=" + dOMCachedAttribute);
        }
        this.id2ref.remove(dOMCachedAttribute.itemTypedValue());
    }

    public boolean isPreserveNamespace() {
        return this.isPreservedNamespaceDecl;
    }

    public boolean isEagerLoading() {
        return this.isEagerLoading;
    }

    public boolean isValidateLoading() {
        return this.isValidateLoading;
    }

    public boolean isWrapper() {
        return this.isWrapper;
    }

    public boolean supportOrderedIDLabel() {
        return false;
    }

    public boolean supportIDLabel() {
        return false;
    }

    public final boolean isCopy() {
        return this.copyMediator != null;
    }

    public void referenced(DOMCachedNode dOMCachedNode) {
    }

    public void unreferenced(DOMCachedNode dOMCachedNode) {
    }

    public void addCursor(Cursor cursor2) {
    }

    public void removeCursor(Cursor cursor2) {
    }

    public DOMCachedNode getBuiltRootNode() {
        return this.rootNode;
    }

    public void setRootNode(DOMCachedNode dOMCachedNode) {
        this.rootNode = dOMCachedNode;
    }

    public DOMCachedNode loadCachedFirstTopItem(String string2, String string3) {
        Cursor cursor2;
        this.rootNode = this.mediator.buildFirstTopItem(this, string2, string3);
        UserData userData = this.rootNode.getUserData();
        if (userData != null && (cursor2 = ((StreamingCursorMediator.XCIData)((Object)userData)).getXCI()) != null) {
            this.setDocumentInfo(cursor2.itemDocumentInfo());
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "loadCachedFirstTopItem", "rootNode =" + this.rootNode);
        }
        return this.rootNode;
    }

    public void ensureStateResolved(DOMCachedNode dOMCachedNode, Cursor.Area area) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "ensureStateResolved", "node=" + dOMCachedNode + " | area=" + area);
        }
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                if (LazyLoadingHelper.isFirstChildBuilt(dOMCachedNode.state)) break;
                dOMCachedNode.getCachedFirstChild();
                break;
            }
            case LAST_CHILD: {
                if (LazyLoadingHelper.isChildrenResolved(dOMCachedNode.state)) break;
                MiscHelpers.visitChildren(dOMCachedNode);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                if (LazyLoadingHelper.isFollowingBuilt(dOMCachedNode.state)) break;
                dOMCachedNode.getCachedFollowingSibling();
                break;
            }
            case ATTRIBUTE: {
                if (LazyLoadingHelper.isFirstAttributeBuilt(dOMCachedNode.state)) break;
                dOMCachedNode.getCachedLastAttribute();
                break;
            }
            case NAMESPACE_DECLS: {
                if (LazyLoadingHelper.isFirstNamespaceBuilt(dOMCachedNode.state)) break;
                dOMCachedNode.getCachedLastNamespaceNode();
                break;
            }
            case SELF: {
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
    }

    public DOMCachedDocument getCachedDocument() {
        return (DOMCachedDocument)(this.rootNode instanceof DOMCachedDocument ? this.rootNode : null);
    }

    public Cursor.Profile featuresLimit(DOMCachedNode dOMCachedNode) {
        return CacheCursor.FEATURES_LIMIT;
    }

    public Cursor fork(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl, Cursor.Profile profile2) {
        if (LoggerUtil.isAnyTracingEnabled()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "fork", "forking from CacheManager\n\nStack trace= " + XCIErrorHelper.getStackTrace(15));
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "fork", "forking from CacheManager");
        }
        if (profile.containedIn(dOMCachedNode.profile())) {
            return dOMCachedNode.reference();
        }
        if (dOMCachedNode.cache.isCopy()) {
            return new CopiedCacheCursor(dOMCachedNode.cache, dOMCachedNode, bl);
        }
        if (profile.containedIn(StreamingCacheCursor.PROFILE_LIMIT)) {
            return new StreamingCacheCursor(dOMCachedNode, profile, bl);
        }
        if (profile.containedIn(NoMutationCacheCursor.FEATURES_LIMIT)) {
            return new NoMutationCacheCursor(dOMCachedNode, profile, bl);
        }
        return this.popCacheCursor(dOMCachedNode, profile, bl);
    }

    public final void free(DOMCachedNode dOMCachedNode) {
    }

    public VolatileCData serialize(Cursor cursor2, Map<String, Object> map2) {
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
        String string2 = null;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            if (map2 != null) {
                StringBuilder stringBuilder = new StringBuilder(map2.size());
                Iterator<String> iterator = map2.keySet().iterator();
                stringBuilder.append('{');
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    stringBuilder.append('(');
                    stringBuilder.append(string3);
                    stringBuilder.append(',');
                    stringBuilder.append(map2.get(string3));
                    stringBuilder.append(')');
                }
                stringBuilder.append('}');
                string2 = stringBuilder.toString();
            }
            logger.logp(Level.FINEST, logger.getName(), "serialize", "serializing from CacheManager{" + this.toString() + "},\n for node={" + dOMCachedNode.toStringLazy() + "},\n  with parameters={" + string2 + "}");
        }
        if (this.isCopy()) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "serialize", "serializing a copy from CacheManager, for node=" + dOMCachedNode);
            }
            return new SerializedCData(cursor2, map2, this.mediator().getItemCopier(dOMCachedNode));
        }
        return this.mediator().serialize(cursor2, map2);
    }

    public DOMCachedElement makeCachedElement(VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, ElementPSVI elementPSVI, XSElementDeclaration xSElementDeclaration, boolean bl, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        return this.nodeFactory.makeCachedElement(this, volatileCData, xSTypeDefinition, elementPSVI, xSElementDeclaration, bl, dOMCachedContainer, dOMCachedNode);
    }

    public DOMCachedAttribute makeCachedAttribute(VolatileCData volatileCData, VolatileCData volatileCData2, AttributePSVI attributePSVI, XSAttributeDeclaration xSAttributeDeclaration, DOMCachedElement dOMCachedElement) {
        return this.nodeFactory.makeCachedAttribute(this, volatileCData, volatileCData2, attributePSVI, xSAttributeDeclaration, dOMCachedElement);
    }

    public DOMCachedComment makeCachedComment(VolatileCData volatileCData, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        return this.nodeFactory.makeCachedComment(this, volatileCData, dOMCachedContainer, dOMCachedNode);
    }

    public DOMCachedDocument makeCachedDocument(String string2, String string3) {
        return this.nodeFactory.makeCachedDocument(this, string2, string3);
    }

    public DOMCachedPI makeCachedPI(VolatileCData volatileCData, VolatileCData volatileCData2, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        return this.nodeFactory.makeCachedPI(this, volatileCData, volatileCData2, dOMCachedContainer, dOMCachedNode);
    }

    public DOMCachedText makeCachedText(VolatileCData volatileCData, boolean bl, boolean bl2, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        return this.nodeFactory.makeCachedText(this, volatileCData, bl, bl2, dOMCachedContainer, dOMCachedNode);
    }

    public DOMCachedNamespace makeCachedNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, DOMCachedElement dOMCachedElement) {
        return this.nodeFactory.makeCachedNamespaceNode(this, volatileCData, volatileCData2, dOMCachedElement);
    }

    @Override
    public boolean hasFeature(String string2, String string3) {
        if (string3 == null || string3.length() == 0 || string3.equals("1.0") || string3.equals("2.0")) {
            if ("Core".equals(string2)) {
                return true;
            }
            if ("XML".equals(string2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Document createDocument(String string2, String string3, DocumentType documentType) throws DOMException {
        if (this.rootNode != null) {
            return new CacheManager().createDocument(string2, string3, documentType);
        }
        DOMCachedDocument dOMCachedDocument = this.nodeFactory.makeCachedDocument(this, string2, string3);
        if (!(documentType instanceof DOMCachedDocumentType)) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        dOMCachedDocument.setDocumentType((DOMCachedDocumentType)documentType);
        return dOMCachedDocument;
    }

    @Override
    public DocumentType createDocumentType(String string2, String string3, String string4) throws DOMException {
        return new DOMCachedDocumentType(this, string2, string3, string4);
    }

    @Override
    public Object getFeature(String string2, String string3) {
        return null;
    }

    public DocumentInfo getDocumentInfo() {
        return this.myDocumentInfo;
    }

    public void setDocumentInfo(DocumentInfo documentInfo) {
        this.myDocumentInfo = documentInfo;
        if (this.rootNode != null && documentInfo != null) {
            this.rootNode.setItemBaseURI(documentInfo.getURI());
        }
    }

    public CacheManager getNewInstance() {
        CacheManager cacheManager = new CacheManager(this.mediator, null, null);
        Cursor cursor2 = this.mediator().focus();
        cacheManager.setMediator(new StreamingCursorMediator(cursor2, cursor2.profile()));
        return cacheManager;
    }

    public void registerNode(DOMCachedNode dOMCachedNode) {
        if (dOMCachedNode.preceding != null && dOMCachedNode.preceding.subtreeID != null) {
            dOMCachedNode.addSiblingID(dOMCachedNode.preceding.subtreeID);
        } else if (dOMCachedNode.parent != null && dOMCachedNode.parent.subtreeID != null) {
            DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.parent.getBuiltLastAttribute();
            DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.parent.getBuiltLastNamespace();
            if (dOMCachedAttribute != null && dOMCachedAttribute.subtreeID != null) {
                dOMCachedNode.addSiblingID(dOMCachedAttribute.subtreeID);
            } else if (dOMCachedNamespace != null && dOMCachedNamespace.subtreeID != null) {
                dOMCachedNode.addSiblingID(dOMCachedNamespace.subtreeID);
            } else {
                dOMCachedNode.addChildID(dOMCachedNode.parent.subtreeID);
            }
        }
        if (dOMCachedNode.getNodeID() == -1) {
            dOMCachedNode.setNodeID(this.refCounter.getGlobalID());
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "registerNode", "registered a node with nodeID=" + dOMCachedNode.getNodeID() + " and subtreeID=" + dOMCachedNode.getSubtreeID());
        }
    }

    public boolean openMutation(DOMCachedNode dOMCachedNode, Cursor.Area area) {
        if (area == Cursor.Area.NAMESPACE_DECLS) {
            ++this.namespaceVersion;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "openMutation", "opening a mutation for node: " + dOMCachedNode);
        }
        if (this.mutating) {
            // empty if block
        }
        this.mutating = true;
        return true;
    }

    public void closeMutation(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "closeMutation", "closing mutation for node: " + dOMCachedNode);
        }
        this.mutating = false;
    }

    public boolean isMutating(DOMCachedNode dOMCachedNode, Cursor.Area area) {
        return this.mutating;
    }

    public long documentIdentify() {
        return this.documentIdentity;
    }

    public CacheCursor popCacheCursor(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl) {
        return new CacheCursor(dOMCachedNode, profile, bl);
    }

    public CacheCursor popCacheCursor(CacheCursor cacheCursor, Cursor.Profile profile, boolean bl) {
        return new CacheCursor(cacheCursor, profile, bl);
    }

    public void pushCacheCursor(CacheCursor cacheCursor) {
    }

    public ItemCopier getItemCopier() {
        return this.itemCopier;
    }

    public void setItemCopier(ItemCopier itemCopier) {
        this.itemCopier = itemCopier;
    }

    public int getNamespaceVersion() {
        return this.namespaceVersion;
    }

    public void setMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    private void setUserDataFactory(Mediator mediator) {
        this.userDataFactory = mediator.getUserDataFactory(this.isCopy() ? 2 : 0);
    }

    public static boolean materializeDocument(Cursor cursor2) {
        return CacheManager.materializeDocument(cursor2, null);
    }

    public static boolean materializeDocument(Cursor cursor2, Executable executable) {
        Mediator mediator;
        if (!(cursor2.unwrap() instanceof DOMCachedNode)) {
            return false;
        }
        cursor2.toRoot();
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
        if (executable != null) {
            Map<String, Object> map2 = executable.getProperties();
            boolean bl = CacheManager.processWhitespaceOptions(map2);
            CacheFactory.updateMediator(dOMCachedNode.getCache(), bl, map2);
        }
        if (!((mediator = dOMCachedNode.getCache().mediator(dOMCachedNode)) instanceof StreamingCursorMediator)) {
            return false;
        }
        ((StreamingCursorMediator)mediator).visitSubtree(dOMCachedNode, dOMCachedNode.getState(), (dOMCachedNode.getState() & 4) != 4);
        return true;
    }

    private static boolean processWhitespaceOptions(Map<String, Object> map2) {
        return map2 != null && (map2.get("http://www.ibm.com/xmlns/prod/xcij/strip-space") != null || map2.get("http://www.ibm.com/xmlns/prod/xcij/preserve-space") != null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CacheManager class = ");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("\n");
        stringBuilder.append("Copy Mediator=");
        stringBuilder.append(this.copyMediator);
        stringBuilder.append("\n");
        stringBuilder.append("Regular Mediator=");
        stringBuilder.append(this.mediator);
        return stringBuilder.toString();
    }

    public boolean getAttemptFastSerialization() {
        return this.attemptFastSerialization;
    }

    public void setAttemptFastSerialization(boolean bl) {
        this.attemptFastSerialization = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LookupIDIterator
    implements Iterator<DOMCachedAttribute> {
        final String[] idrefs;
        final boolean[] used;
        int next;

        public LookupIDIterator(CData cData) {
            int n2 = cData.getSize();
            this.idrefs = new String[n2];
            for (int i = 0; i < n2; ++i) {
                this.idrefs[i] = cData.getString(i);
            }
            this.used = new boolean[n2];
            this.next = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.next < 0) {
                boolean bl = false;
                for (int i = 0; i < this.idrefs.length; ++i) {
                    String string2 = this.idrefs[i];
                    if (this.used[i]) continue;
                    if (CacheManager.this.id2attribute.containsKey(string2)) {
                        this.next = i;
                        return true;
                    }
                    bl = true;
                }
                if (bl) {
                    // empty if block
                }
                return false;
            }
            return this.next >= 0;
        }

        @Override
        public DOMCachedAttribute next() {
            if (this.hasNext()) {
                String string2 = this.idrefs[this.next];
                this.used[this.next] = true;
                this.next = -1;
                return (DOMCachedAttribute)CacheManager.this.id2attribute.get(string2);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

