/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.DynamicErrorException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class CacheDocumentBuilder
extends DocumentBuilder {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final CacheManager DEFAULT_IMPLEMENTATION = new CacheManager();
    private final CacheManager implementation;

    CacheDocumentBuilder() {
        this.implementation = DEFAULT_IMPLEMENTATION;
    }

    CacheDocumentBuilder(CacheManager cacheManager) {
        this.implementation = cacheManager;
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        try {
            Reader reader = inputSource.getCharacterStream();
            Cursor cursor2 = reader != null ? this.implementation.factory().document(new StreamSource(reader), new RequestInfo(Cursor.Profile.MINIMAL_STREAMING_NAVIGATION)) : this.implementation.factory().document(new StreamSource(inputSource.getByteStream()), new RequestInfo(Cursor.Profile.MINIMAL_STREAMING_NAVIGATION));
            StreamingCursorMediator streamingCursorMediator = new StreamingCursorMediator(cursor2, CacheManager.DOM_FEATURES);
            CacheManager cacheManager = new CacheManager(streamingCursorMediator, null, null);
            return (Document)((Object)cacheManager.loadCachedFirstTopItem(null, null));
        }
        catch (DynamicErrorException dynamicErrorException) {
            throw XCIErrorHelper.createInternalException(dynamicErrorException);
        }
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return false;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public Document newDocument() {
        return this.getDOMImplementation().createDocument(null, null, null);
    }

    public DOMImplementation getDOMImplementation() {
        return this.implementation;
    }
}

