/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.StaticContext;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheAxisExecutable
implements Executable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected NodeTest fTest;
    private static final Logger logger = LoggerUtil.getLogger(CacheAxisExecutable.class);

    protected CacheAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
        this.fTest = nodeTest;
    }

    protected abstract Cursor toFirst(CacheCursor var1);

    @Override
    public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "execute", "Entering execute, focus=" + cursor2);
        }
        if (cursor2 == null) {
            return null;
        }
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
        CacheCursor cacheCursor = dOMCachedNode.cache.popCacheCursor(dOMCachedNode, profile, false);
        Cursor cursor3 = this.toFirst(cacheCursor);
        if (cursor3 == null) {
            cacheCursor.release();
            return null;
        }
        return cursor3;
    }

    @Override
    public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
        Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        cursor3.copyToResult(result2, null, false, true);
    }

    @Override
    public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "execute", "Entering execute, focus=" + cursor2 + " result=" + cursor3);
        }
        if (cursor3 == null) {
            throw XCIErrorHelper.createBadArgumentException("result", "null");
        }
        Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        if (cursor4 != null) {
            cursor3.addCopy(area, cursor4);
            cursor4.release();
        }
    }

    public static Executable newInstance(Axis axis, NodeTest nodeTest, StaticContext staticContext) {
        switch (axis) {
            case SELF: {
                return new CacheSelfAxisExecutable(nodeTest, staticContext);
            }
            case CHILD: {
                return new CacheChildAxisExecutable(nodeTest, staticContext);
            }
            case PARENT: {
                return new CacheParentAxisExecutable(nodeTest, staticContext);
            }
            case ATTRIBUTE: {
                return new CacheAttributeAxisExecutable(nodeTest, staticContext);
            }
            case DESCENDANT: {
                return new CacheDescendantAxisExecutable(nodeTest, staticContext);
            }
            case DESCENDANTORSELF: {
                return new CacheDescendantOrSelfAxisExecutable(nodeTest, staticContext);
            }
            case FOLLOWINGSIBLING: {
                return new CacheFollowingSiblingAxisExecutable(nodeTest, staticContext);
            }
            case PRECEDINGSIBLING: {
                return new CachePrecedingSiblingAxisExecutable(nodeTest, staticContext);
            }
            case NAMESPACEDECLS: 
            case NAMESPACEWITHINELEMENT: {
                return new CacheNamespaceDeclsAxisExecutable(nodeTest, staticContext);
            }
            case NAMESPACE: {
                return new CacheNamespaceAxisExecutable(nodeTest, staticContext);
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }

    private static class CacheDescendantOrSelfAxisExecutable
    extends CacheAxisExecutable {
        public CacheDescendantOrSelfAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheDescendantOrSelfAxisExecutable.toFirst", "About to start walking the descendant or self axis");
            }
            return cacheCursor.toDescendantsOrSelf(this.fTest) ? cacheCursor : null;
        }
    }

    private static class CacheDescendantAxisExecutable
    extends CacheAxisExecutable {
        public CacheDescendantAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheDescendantAxisExecutable.toFirst", "About to start walking the descendant axis");
            }
            return cacheCursor.toDescendants(this.fTest) ? cacheCursor : null;
        }
    }

    private static class CacheNamespaceAxisExecutable
    extends CacheAxisExecutable {
        public CacheNamespaceAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheNamespaceAxisExecutable.toFirst", "About to start walking the namespace axis");
            }
            return cacheCursor.toNamespaces(this.fTest) ? cacheCursor : null;
        }
    }

    private static class CacheNamespaceDeclsAxisExecutable
    extends CacheAxisExecutable {
        public CacheNamespaceDeclsAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheNamespaceDeclsAxisExecutable.toFirst", "About to start walking the namespace decl axis");
            }
            return cacheCursor.toNamespaceDecls(this.fTest) ? cacheCursor : null;
        }
    }

    private static class CacheAttributeAxisExecutable
    extends CacheAxisExecutable {
        public CacheAttributeAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheAttributeAxisExecutable.toFirst", "About to start walking the attribute axis");
            }
            return cacheCursor.toAttributes(this.fTest) ? cacheCursor : null;
        }
    }

    private static class CachePrecedingSiblingAxisExecutable
    extends CacheAxisExecutable {
        public CachePrecedingSiblingAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CachePrecedingSiblingAxisExecutable.toFirst", "About to start walking the preceding sibling axis");
            }
            return cacheCursor.toPrecedingSiblings(this.fTest) ? cacheCursor : null;
        }
    }

    private static class CacheFollowingSiblingAxisExecutable
    extends CacheAxisExecutable {
        public CacheFollowingSiblingAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheFollowingSiblingAxisExecutable.toFirst", "About to start walking the following sibling axis");
            }
            return cacheCursor.toFollowingSiblings(this.fTest) ? cacheCursor : null;
        }
    }

    private static class CacheParentAxisExecutable
    extends CacheAxisExecutable {
        public CacheParentAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheParentAxisExecutable.toFirst", "About to start walking the parent axis");
            }
            if (cacheCursor.toParent() && (this.fTest == null || this.fTest.test(cacheCursor))) {
                return cacheCursor;
            }
            return null;
        }
    }

    private static class CacheChildAxisExecutable
    extends CacheAxisExecutable {
        public CacheChildAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            return cacheCursor.toChildren(this.fTest) ? cacheCursor : null;
        }
    }

    private static class CacheSelfAxisExecutable
    extends CacheAxisExecutable {
        public CacheSelfAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheCursor cacheCursor) {
            if (cacheCursor.toSelf() && (this.fTest == null || this.fTest.test(cacheCursor))) {
                return cacheCursor;
            }
            return null;
        }
    }
}

