/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.base;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.XCIRegistry;
import com.ibm.xml.xci.adapters.dom.DOMAdapter;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.cache.CacheFactory;
import com.ibm.xml.xci.dp.checkers.FeaturesChecker;
import com.ibm.xml.xci.dp.type.CastTable;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.DMUtil;
import com.ibm.xml.xci.dp.util.EmptyCData;
import com.ibm.xml.xci.dp.util.fixers.MinimalMutationFixer;
import com.ibm.xml.xci.dp.util.fixers.MoveFixer;
import com.ibm.xml.xci.dp.util.fixers.NodeTestFixer;
import com.ibm.xml.xci.dp.util.fixers.RemoveAttributeFixer;
import com.ibm.xml.xci.dp.util.fixers.RemoveSubtreeFixer;
import com.ibm.xml.xci.dp.util.fixers.SelfFixer;
import com.ibm.xml.xci.dp.util.fixers.SizePositionFixer;
import com.ibm.xml.xci.dp.util.fixers.ToFollowingSiblingsFixer;
import com.ibm.xml.xci.dp.util.fixers.ToPositionFixer;
import com.ibm.xml.xci.dp.util.fixers.ToPrecedingSiblingsFixer;
import com.ibm.xml.xci.dp.util.fixers.ToPreviousFixer;
import com.ibm.xml.xci.dp.util.id.IDFixer;
import com.ibm.xml.xci.dp.values.ArrayCData;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.TypedValueHelper;
import com.ibm.xml.xci.dp.values.chars.CharBufferChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.dp.values.chars.CharsString;
import com.ibm.xml.xci.dp.values.chars.CharsetEncodedChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.internal.cast.CastJV2Duration;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.cast.CastJV2XMLGregorianCalendar;
import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.internal.util.trace.TraceFixer;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.internal.values.BigDecimalCData;
import com.ibm.xml.xci.internal.values.BigIntegerCData;
import com.ibm.xml.xci.internal.values.BooleanCData;
import com.ibm.xml.xci.internal.values.ByteCData;
import com.ibm.xml.xci.internal.values.BytesCData;
import com.ibm.xml.xci.internal.values.CursorCData;
import com.ibm.xml.xci.internal.values.DoubleCData;
import com.ibm.xml.xci.internal.values.DurationCData;
import com.ibm.xml.xci.internal.values.FloatCData;
import com.ibm.xml.xci.internal.values.ForeignObjectCData;
import com.ibm.xml.xci.internal.values.HexBinaryCData;
import com.ibm.xml.xci.internal.values.IntCData;
import com.ibm.xml.xci.internal.values.LongCData;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.internal.values.URICData;
import com.ibm.xml.xci.internal.values.XMLGregorianCalendarCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.serializer.Serialize;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.XMLEntityManager;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCursorFactory
implements CursorFactory {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Cursor.Profile SIMPLY_ADDED_FIXED_BITS;
    public static final boolean SAFE_MODE;
    protected boolean safe = SAFE_MODE;
    protected boolean nowrite;
    protected int dataProviderID;
    private final SessionContext sessionContext;
    static final boolean USE_CACHED_CONSTANTS_EXPERIMENT = false;
    static final CData BOOLEAN_TRUE;
    static final CData BOOLEAN_FALSE;
    static final CData[] FLOATING_CONSTS;
    static final CData[] DOUBLE_CONSTS;
    private static Cursor.Profile REQUIRE_CACHE_FIXER_BITS;
    private static Cursor.Profile DESTRUCTIVE_FIXERS_BITS;

    protected AbstractCursorFactory(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        if (sessionContext == null) {
            XCIRegistry xCIRegistry = XCIRegistry.getInstance();
            this.dataProviderID = xCIRegistry.getDataProviderID(this.getClass().getName());
        } else {
            this.dataProviderID = sessionContext.getDataProviderID(this.getClass().getName());
        }
    }

    protected boolean isDOMCacheRequired(Cursor.Profile profile, Cursor.Profile profile2) {
        if (profile2.containedIn(profile)) {
            return false;
        }
        return !profile2.containedIn(profile.union(SIMPLY_ADDED_FIXED_BITS));
    }

    public Cursor document(RequestInfo requestInfo) {
        return CacheFactory.make(this, requestInfo);
    }

    @Override
    public Cursor document(Source source, RequestInfo requestInfo) {
        assert (source == null);
        return CacheFactory.make(this, requestInfo);
    }

    protected Cursor document(InputStream inputStream, RequestInfo requestInfo) {
        return this.document(new InputStreamReader(inputStream), requestInfo);
    }

    protected Cursor document(String string2, RequestInfo requestInfo) {
        return this.document(new StringReader(string2), requestInfo);
    }

    protected Cursor document(Document document2, RequestInfo requestInfo) {
        throw new UnsupportedOperationException();
    }

    protected Cursor document(Reader reader, RequestInfo requestInfo) {
        throw new UnsupportedOperationException();
    }

    protected Cursor document(OutputStream outputStream, RequestInfo requestInfo) {
        Cursor cursor2 = Serialize.getTargetCursor((CursorFactory)this, outputStream, requestInfo.getParameters());
        return this.proxy(cursor2, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), null);
    }

    protected Cursor document(Writer writer, RequestInfo requestInfo) {
        Cursor cursor2 = Serialize.getTargetCursor((CursorFactory)this, writer, requestInfo.getParameters());
        return this.proxy(cursor2, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), null);
    }

    @Override
    public Cursor document(Result result2, RequestInfo requestInfo) {
        if (result2 == null) {
            return this.document(requestInfo);
        }
        if (result2 instanceof DOMResult) {
            Node node2 = ((DOMResult)result2).getNode();
            return this.proxy(DOMAdapter.makeCursor(this, node2, requestInfo, this.getErrorHandler(requestInfo)), requestInfo.getProfile(), false, requestInfo.getParameters(), null);
        }
        if (result2 instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result2;
            if (streamResult.getOutputStream() != null) {
                return this.document(streamResult.getOutputStream(), requestInfo);
            }
            if (streamResult.getWriter() != null) {
                return this.document(streamResult.getWriter(), requestInfo);
            }
            if (streamResult.getSystemId() != null) {
                try {
                    return this.document(XMLEntityManager.createOutputStream(streamResult.getSystemId()), requestInfo);
                }
                catch (IOException iOException) {
                    FFDCUtil.log(iOException, this);
                    throw new XCIDynamicErrorException(iOException);
                }
            }
            XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_STREAMRESULT", null));
            FFDCUtil.log(xCIDynamicErrorException, this);
            throw xCIDynamicErrorException;
        }
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNSUPPORTEDRESULT", new String[]{result2.getClass().getName()}));
        FFDCUtil.log(xCIDynamicErrorException, this);
        throw xCIDynamicErrorException;
    }

    @Override
    public void setSafe(boolean bl) {
        this.safe = bl;
    }

    @Override
    public boolean isSafe() {
        return this.safe;
    }

    @Override
    public final DatatypeFactory datatypeFactory() {
        return BaseCData.javaxFactory;
    }

    public CData data(CData cData, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (xSSimpleTypeDefinition == null || cData.getXSTypeDefinition() == xSSimpleTypeDefinition) {
            return cData;
        }
        return this.castAs(cData, xSSimpleTypeDefinition, null);
    }

    @Override
    public CData data(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (charSequence instanceof CData) {
            return this.data((CData)charSequence, xSSimpleTypeDefinition, bl);
        }
        if (xSSimpleTypeDefinition == null) {
            return new StoredCharsCData(CharsBase.toChars(charSequence), TypeRegistry.XSUNTYPEDATOMIC);
        }
        return TypedValueHelper.parse(this.getSessionContext(), charSequence, xSSimpleTypeDefinition, null, bl);
    }

    @Override
    public CData data(char[] cArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.data((CharSequence)CharBufferChars.make(cArray), xSSimpleTypeDefinition, false);
    }

    @Override
    public CData data(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, boolean bl) {
        return TypedValueHelper.parse(this.getSessionContext(), charSequence, xSSimpleTypeDefinition != null ? xSSimpleTypeDefinition : TypeRegistry.XSUNTYPEDATOMIC, namespaceContext, bl);
    }

    public CData data(char[] cArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext) {
        return this.data((CharSequence)CharBufferChars.make(cArray), xSSimpleTypeDefinition, false);
    }

    @Override
    public CData data(Bytes bytes2, Charset charset, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return new StoredCharsCData(CharsetEncodedChars.make(bytes2, null, charset), xSSimpleTypeDefinition);
    }

    @Override
    public CData data(Bytes bytes2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 17: {
                return new Base64BinaryCData(bytes2, xSSimpleTypeDefinition);
            }
            case 16: {
                return new HexBinaryCData(bytes2, xSSimpleTypeDefinition);
            }
        }
        assert (TypeHelper.isList(xSSimpleTypeDefinition));
        if (xSSimpleTypeDefinition.getItemType().derivedFrom(TypeRegistry.XSDECIMAL.getNamespace(), TypeRegistry.XSDECIMAL.getName(), (short)2)) {
            return new BytesCData(bytes2, xSSimpleTypeDefinition);
        }
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[(int)bytes2.byteLength()];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(bytes2.byteAt(i), xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(byte[] byArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 16: 
            case 17: {
                return this.data(BytesUtils.make(byArray), xSSimpleTypeDefinition, bl);
            }
        }
        assert (TypeHelper.isList(xSSimpleTypeDefinition));
        if (xSSimpleTypeDefinition.getItemType().derivedFrom(TypeRegistry.XSDECIMAL.getNamespace(), TypeRegistry.XSDECIMAL.getName(), (short)2)) {
            return new BytesCData(BytesUtils.make(byArray), xSSimpleTypeDefinition);
        }
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition != null ? xSSimpleTypeDefinition.getItemType() : null;
        CData[] cDataArray = new CData[byArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(byArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return new EmptyCData(xSSimpleTypeDefinition != null ? xSSimpleTypeDefinition : TypeRegistry.XSANYSIMPLETYPE);
    }

    @Override
    public CData data(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) {
        if (xSSimpleTypeDefinition == null || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSBOOLEAN)) {
            return new BooleanCData(bl, TypeRegistry.XSBOOLEAN);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSBOOLEAN.getNamespace(), TypeRegistry.XSBOOLEAN.getName(), (short)2)) {
                if (bl2) {
                    CastUtilities.validate(String.valueOf(bl), xSSimpleTypeDefinition);
                }
                return new BooleanCData(bl, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, bl, xSSimpleTypeDefinition, bl2);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSBOOLEAN.toString()});
        }
    }

    @Override
    public CData data(byte by2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (xSSimpleTypeDefinition == null || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSBYTE)) {
            return new ByteCData(by2, TypeRegistry.XSBYTE);
        }
        if (TypeRegistry.XSBYTE.derivedFrom(xSSimpleTypeDefinition.getNamespace(), xSSimpleTypeDefinition.getName(), (short)2)) {
            return new ByteCData(by2, xSSimpleTypeDefinition);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSINTEGER.getNamespace(), TypeRegistry.XSINTEGER.getName(), (short)2)) {
                if (bl) {
                    CastUtilities.validate(String.valueOf(by2), xSSimpleTypeDefinition);
                }
                return new ByteCData(by2, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, by2, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSBYTE.toString()});
        }
    }

    @Override
    public CData data(short s, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (xSSimpleTypeDefinition == null || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSSHORT)) {
            return new IntCData(s, TypeRegistry.XSSHORT);
        }
        if (TypeRegistry.XSINT.derivedFrom(xSSimpleTypeDefinition.getNamespace(), xSSimpleTypeDefinition.getName(), (short)2)) {
            return IntCData.toInt(s, xSSimpleTypeDefinition);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINTEGER, (short)2)) {
                if (bl) {
                    CastUtilities.validate(String.valueOf(s), xSSimpleTypeDefinition);
                }
                return IntCData.toInt(s, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, s, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSSHORT.toString()});
        }
    }

    @Override
    public CData data(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (xSSimpleTypeDefinition == null) {
            return IntCData.toInt(n2, TypeRegistry.XSINT);
        }
        if (TypeRegistry.XSINT.derivedFrom(xSSimpleTypeDefinition.getNamespace(), xSSimpleTypeDefinition.getName(), (short)2)) {
            return IntCData.toInt(n2, xSSimpleTypeDefinition);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSINTEGER.getNamespace(), TypeRegistry.XSINTEGER.getName(), (short)2)) {
                if (bl) {
                    CastUtilities.validate(String.valueOf(n2), xSSimpleTypeDefinition);
                }
                return IntCData.toInt(n2, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, n2, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSINT.toString()});
        }
    }

    @Override
    public CData data(long l, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (xSSimpleTypeDefinition == null) {
            return LongCData.toLong(l, TypeRegistry.XSLONG);
        }
        if (TypeRegistry.XSLONG.derivedFrom(xSSimpleTypeDefinition.getNamespace(), xSSimpleTypeDefinition.getName(), (short)2)) {
            return LongCData.toLong(l, xSSimpleTypeDefinition);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSINTEGER.getNamespace(), TypeRegistry.XSINTEGER.getName(), (short)2)) {
                if (bl) {
                    CastUtilities.validate(String.valueOf(l), xSSimpleTypeDefinition);
                }
                return LongCData.toLong(l, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, l, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSLONG.toString()});
        }
    }

    @Override
    public CData data(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (xSSimpleTypeDefinition == null || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSFLOAT)) {
            return new FloatCData(f2, TypeRegistry.XSFLOAT);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSFLOAT.getNamespace(), TypeRegistry.XSFLOAT.getName(), (short)2)) {
                if (bl) {
                    CastUtilities.validate(CastJV2String.jVToString(f2, TypeRegistry.XSSTRING, false), xSSimpleTypeDefinition);
                }
                return new FloatCData(f2, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, f2, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSFLOAT.toString()});
        }
    }

    @Override
    public CData data(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (xSSimpleTypeDefinition == null || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSDOUBLE)) {
            return new DoubleCData(d, TypeRegistry.XSDOUBLE);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSDOUBLE.getNamespace(), TypeRegistry.XSDOUBLE.getName(), (short)2)) {
                if (bl) {
                    CastUtilities.validate(CastJV2String.jVToString(d, TypeRegistry.XSSTRING, false), xSSimpleTypeDefinition);
                }
                return new DoubleCData(d, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, d, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSDOUBLE.toString()});
        }
    }

    @Override
    public CData data(BigInteger bigInteger, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (xSSimpleTypeDefinition == null) {
            return new BigIntegerCData(bigInteger, TypeRegistry.XSINTEGER);
        }
        if (TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSINTEGER) || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSDECIMAL)) {
            return new BigIntegerCData(bigInteger, xSSimpleTypeDefinition);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSINTEGER.getNamespace(), TypeRegistry.XSINTEGER.getName(), (short)2)) {
                if (bl) {
                    CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition);
                }
                return new BigIntegerCData(bigInteger, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, bigInteger, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSINTEGER.toString()});
        }
    }

    @Override
    public CData data(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (null == bigDecimal) {
            throw new NullPointerException(XCIMessages.createXCIMessage("ER_NULL_VALUE", new String[]{"BigDecimal", "com.ibm.xml.xci.dp.base.CursorFactory.data(BigDecimal, XSSimpleTypeDefinition, boolean"}));
        }
        if (xSSimpleTypeDefinition == null || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSDECIMAL)) {
            return new BigDecimalCData(bigDecimal, TypeRegistry.XSDECIMAL);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSDECIMAL.getNamespace(), TypeRegistry.XSDECIMAL.getName(), (short)2)) {
                if (bl) {
                    CastUtilities.validate(bigDecimal.toPlainString(), xSSimpleTypeDefinition);
                }
                return new BigDecimalCData(bigDecimal, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, bigDecimal, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSDECIMAL.toString()});
        }
    }

    @Override
    public CData data(URI uRI, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (null == uRI) {
            throw new NullPointerException(XCIMessages.createXCIMessage("ER_NULL_VALUE", new String[]{"URI", "com.ibm.xml.xci.dp.base.CursorFactory.data(URI, XSSimpleTypeDefinition, boolean"}));
        }
        if (xSSimpleTypeDefinition == null || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSANYURI)) {
            return new URICData(uRI, TypeRegistry.XSANYURI);
        }
        try {
            if (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSANYURI, (short)2)) {
                if (bl) {
                    CastUtilities.validate(uRI.toString(), xSSimpleTypeDefinition);
                }
                return new URICData(uRI, xSSimpleTypeDefinition);
            }
            return CastUtilities.convert((CursorFactory)this, uRI, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSANYURI.toString()});
        }
    }

    @Override
    public CData data(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (null == qName) {
            throw new NullPointerException(XCIMessages.createXCIMessage("ER_NULL_VALUE", new String[]{"QName", "com.ibm.xml.xci.dp.base.CursorFactory.data(QName, XSSimpleTypeDefinition, boolean"}));
        }
        if (xSSimpleTypeDefinition == null) {
            return new QNameCData(qName, TypeRegistry.XSQNAME);
        }
        if (xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSQNAME.getNamespace(), TypeRegistry.XSQNAME.getName(), (short)2) || xSSimpleTypeDefinition.derivedFrom(TypeRegistry.XSNOTATION.getNamespace(), TypeRegistry.XSNOTATION.getName(), (short)2)) {
            return new QNameCData(qName, xSSimpleTypeDefinition);
        }
        try {
            return CastUtilities.convert((CursorFactory)this, qName, xSSimpleTypeDefinition, bl);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), TypeRegistry.XSQNAME.toString()});
        }
    }

    @Override
    public CData data(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (charSequence == null && charSequence3 == null) {
            return this.data(new QName(((Object)charSequence2).toString()), xSSimpleTypeDefinition, false);
        }
        if (charSequence3 == null) {
            return this.data(new QName(((Object)charSequence).toString(), ((Object)charSequence2).toString()), xSSimpleTypeDefinition, false);
        }
        return this.data(new QName(((Object)charSequence).toString(), ((Object)charSequence2).toString(), ((Object)charSequence3).toString()), xSSimpleTypeDefinition, false);
    }

    @Override
    public CData data(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        return this.data(charSequence, charSequence2, charSequence3, null, false);
    }

    @Override
    public CData data(Duration duration2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (null == duration2) {
            throw new NullPointerException(XCIMessages.createXCIMessage("ER_NULL_VALUE", new String[]{"Duration", "com.ibm.xml.xci.dp.base.CursorFactory.data(Duration, XSSimpleTypeDefinition, boolean"}));
        }
        if (xSSimpleTypeDefinition == null || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSDURATION)) {
            return new DurationCData(duration2, TypeRegistry.XSDURATION);
        }
        if (CastTable.primitiveCastableAs(TypeRegistry.XSDURATION, xSSimpleTypeDefinition) == CastTable.Castable.NO) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{duration2.getXMLSchemaType().toString(), xSSimpleTypeDefinition.toString()});
        }
        try {
            if (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSDURATION, (short)2)) {
                if (bl) {
                    return new DurationCData(CastJV2Duration.jVToDuration(duration2, xSSimpleTypeDefinition, false), xSSimpleTypeDefinition);
                }
                return new DurationCData(CastJV2Duration.jVToDuration(duration2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition);
            }
            return new StringCData(CastJV2String.jVToString(duration2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), duration2.getXMLSchemaType().toString()});
        }
    }

    @Override
    public CData data(XMLGregorianCalendar xMLGregorianCalendar, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (null == xMLGregorianCalendar) {
            throw new NullPointerException(XCIMessages.createXCIMessage("ER_NULL_VALUE", new String[]{"Calendar", "com.ibm.xml.xci.dp.base.CursorFactory.data(Calendar, XSSimpleTypeDefinition, boolean"}));
        }
        if (xSSimpleTypeDefinition == null) {
            return new XMLGregorianCalendarCData(xMLGregorianCalendar, CastUtilities.getCalendarType(xMLGregorianCalendar));
        }
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 2: 
            case 50: {
                try {
                    return new StringCData(CharsString.make(CastJV2String.jVToString(xMLGregorianCalendar, xSSimpleTypeDefinition, bl)), xSSimpleTypeDefinition);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), CastUtilities.getCalendarType(xMLGregorianCalendar).toString()});
                }
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return new XMLGregorianCalendarCData(CastJV2XMLGregorianCalendar.jVToXMLGregorianCalendar(xMLGregorianCalendar, xSSimpleTypeDefinition, false), xSSimpleTypeDefinition);
            }
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST", new String[]{CastUtilities.getCalendarType(xMLGregorianCalendar).toString(), xSSimpleTypeDefinition.toString()}));
    }

    private CData data(CData[] cDataArray, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        switch (cDataArray.length) {
            case 0: {
                return new EmptyCData(xSSimpleTypeDefinition);
            }
            case 1: {
                return cDataArray[0];
            }
        }
        return new ArrayCData(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(CharSequence[] charSequenceArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition != null ? xSSimpleTypeDefinition.getItemType() : null;
        CData[] cDataArray = new CData[charSequenceArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(charSequenceArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(boolean[] blArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[blArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(blArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(short[] sArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[sArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(sArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(int[] nArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[nArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(nArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(long[] lArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[lArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(lArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(float[] fArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[fArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(fArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(double[] dArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[dArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(dArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(BigInteger[] bigIntegerArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[bigIntegerArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(bigIntegerArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(BigDecimal[] bigDecimalArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[bigDecimalArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(bigDecimalArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(URI[] uRIArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[uRIArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(uRIArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(QName[] qNameArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[qNameArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(qNameArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(Duration[] durationArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[durationArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(durationArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(XMLGregorianCalendar[] xMLGregorianCalendarArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition != null && TypeHelper.isList(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        CData[] cDataArray = new CData[xMLGregorianCalendarArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(xMLGregorianCalendarArray[i], xSSimpleTypeDefinition2, bl);
        }
        return this.data(cDataArray, xSSimpleTypeDefinition);
    }

    @Override
    public CData data(Cursor cursor2) {
        return new CursorCData(cursor2);
    }

    @Override
    public CData castAs(VolatileCData volatileCData, XSSimpleTypeDefinition xSSimpleTypeDefinition, Cursor cursor2) {
        if (TypeHelper.isAtomic(xSSimpleTypeDefinition) && TypeHelper.isAtomic(volatileCData.getXSTypeDefinition()) && !volatileCData.isEmptySequence()) {
            return CastUtilities.castAtomic(this, volatileCData.stripOriginalLexicalValue(true), xSSimpleTypeDefinition, cursor2 == null ? null : cursor2.itemNamespaceContext(false), true);
        }
        throw new XCIDynamicErrorException("ER_CAST_ATOMIC", (String[])null);
    }

    @Override
    public String getMediaType() {
        return "";
    }

    @Override
    public Cursor proxy(Cursor object2, Cursor.Profile profile, boolean bl, Map<String, Object> map2, String[] stringArray) {
        if (object2 == null) {
            return null;
        }
        if (!profile.containedIn(object2.profile())) {
            if (profile.containedIn(object2.futureProfile())) {
                Cursor cursor2 = object2.fork(Cursor.Profile.SEQUENCE.disjoint(profile) || bl, profile, object2.futureProfile());
                object2.release();
                object2 = cursor2;
            } else {
                Object object3;
                Cursor.Profile profile2;
                Cursor.Profile profile3 = object2.profile();
                if (!profile3.equals(profile2 = object2.futureProfile()) && profile2.difference(profile3).containedIn(profile)) {
                    object3 = object2.fork(false, profile2, profile2);
                    object2.release();
                    object2 = object3;
                    profile3 = object2.profile();
                }
                object3 = profile.difference(profile3);
                if (!profile.containedIn(profile3) && (((Cursor.Profile)object3).overlap(REQUIRE_CACHE_FIXER_BITS) || ((Cursor.Profile)object3).equals(Cursor.Profile.NONE))) {
                    if (Cursor.Profile.SIZE.containedIn(profile3) && !object2.contextIsSingleton()) {
                        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANT_FIX_NON_SINGLETON_SEQUENCE", new String[]{DMUtil.featuresSource(profile.difference(profile3), false)}));
                    }
                    object2 = CacheFactory.make((Cursor)object2, new RequestInfo(profile, 0, stringArray, map2));
                    profile3 = object2.profile();
                }
                if (!profile.containedIn(profile3) && profile.overlap(DESTRUCTIVE_FIXERS_BITS)) {
                    if (Cursor.Profile.MINIMAL_MUTATION.containedIn(profile) && !Cursor.Profile.MINIMAL_MUTATION.containedIn(profile3) || Cursor.Profile.SET_VALUE.containedIn(profile) && !Cursor.Profile.SET_VALUE.containedIn(profile3)) {
                        object2 = this.proxy((Cursor)object2, MinimalMutationFixer.NEEDED_FEATURES, false, map2, stringArray);
                        object2 = new MinimalMutationFixer((Cursor)object2, profile);
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.REMOVE_SUBTREE.containedIn(profile) && !Cursor.Profile.REMOVE_SUBTREE.containedIn(profile3)) {
                        object2 = this.proxy((Cursor)object2, RemoveSubtreeFixer.NEEDED_FEATURES, false, map2, stringArray);
                        object2 = new RemoveSubtreeFixer((Cursor)object2);
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.REMOVE_ATTRIBUTE.containedIn(profile) && !Cursor.Profile.REMOVE_ATTRIBUTE.containedIn(profile3)) {
                        object2 = this.proxy((Cursor)object2, RemoveAttributeFixer.NEEDED_FEATURES, false, map2, stringArray);
                        object2 = new RemoveAttributeFixer((Cursor)object2);
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.TO_IDREFS.containedIn(profile) && !Cursor.Profile.TO_IDREFS.containedIn(profile3) || Cursor.Profile.TO_IDS.containedIn(profile) && !Cursor.Profile.TO_IDS.containedIn(profile3)) {
                        object2 = this.proxy((Cursor)object2, IDFixer.NEEDED_FEATURES, false, map2, stringArray);
                        object2 = new IDFixer((Cursor)object2);
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.TO_FOLLOWING_SIBLINGS.containedIn(profile) && !Cursor.Profile.TO_FOLLOWING_SIBLINGS.containedIn(profile3)) {
                        object2 = this.proxy((Cursor)object2, ToFollowingSiblingsFixer.NEEDED_FEATURES, false, map2, stringArray);
                        object2 = new ToFollowingSiblingsFixer((Cursor)object2);
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.TO_PRECEDING_SIBLINGS.containedIn(profile) && !Cursor.Profile.TO_PRECEDING_SIBLINGS.containedIn(profile3)) {
                        object2 = this.proxy((Cursor)object2, ToPrecedingSiblingsFixer.NEEDED_FEATURES, false, map2, stringArray);
                        object2 = new ToPrecedingSiblingsFixer((Cursor)object2);
                        profile3 = object2.profile();
                    }
                }
                if (!profile.containedIn(profile3)) {
                    if (Cursor.Profile.SIZE.containedIn(profile) && !Cursor.Profile.SIZE.containedIn(profile3) || Cursor.Profile.POSITION.containedIn(profile) && !Cursor.Profile.POSITION.containedIn(profile3)) {
                        object2 = this.proxy((Cursor)object2, SizePositionFixer.NEEDED_FEATURES, false, map2, stringArray);
                        if (Cursor.Profile.SIZE.containedIn(profile) && !Cursor.Profile.SIZE.containedIn(object2.profile()) || Cursor.Profile.POSITION.containedIn(profile) && !Cursor.Profile.POSITION.containedIn(object2.profile())) {
                            object2 = new SizePositionFixer((Cursor)object2);
                        }
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.TO_PREVIOUS.containedIn(profile) && !Cursor.Profile.TO_PREVIOUS.containedIn(profile3)) {
                        if (!Cursor.Profile.TO_PREVIOUS.containedIn((object2 = this.proxy((Cursor)object2, ToPreviousFixer.NEEDED_FEATURES, false, map2, stringArray)).profile())) {
                            object2 = new ToPreviousFixer((Cursor)object2);
                        }
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.TO_POSITION.containedIn(profile) && !Cursor.Profile.TO_POSITION.containedIn(profile3)) {
                        if (!Cursor.Profile.TO_POSITION.containedIn((object2 = this.proxy((Cursor)object2, ToPositionFixer.NEEDED_FEATURES, false, map2, stringArray)).profile())) {
                            object2 = new ToPositionFixer((Cursor)object2);
                        }
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.TO_SELF.containedIn(profile) && !Cursor.Profile.TO_SELF.containedIn(profile3)) {
                        object2 = new SelfFixer((Cursor)object2);
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.MOVE.containedIn(profile) && !Cursor.Profile.MOVE.containedIn(profile3)) {
                        if (!Cursor.Profile.MOVE.containedIn((object2 = this.proxy((Cursor)object2, MoveFixer.NEEDED_FEATURES, false, map2, stringArray)).profile())) {
                            object2 = new MoveFixer((Cursor)object2);
                        }
                        profile3 = object2.profile();
                    }
                    if (Cursor.Profile.TO_NODE_TEST.containedIn(profile) && !Cursor.Profile.TO_NODE_TEST.containedIn(profile3)) {
                        if (!Cursor.Profile.TO_NODE_TEST.containedIn((object2 = this.proxy((Cursor)object2, NodeTestFixer.NEEDED_FEATURES, false, map2, stringArray)).profile())) {
                            object2 = new NodeTestFixer((Cursor)object2);
                        }
                        profile3 = object2.profile();
                    }
                }
            }
            if (!profile.containedIn(object2.profile())) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_MISSINGFEATURES", new String[]{DMUtil.featuresSource(profile.difference(object2.profile()), false)}));
            }
        }
        if (this.safe) {
            object2 = FeaturesChecker.checker((Cursor)object2, profile);
            if (LoggerUtil.isAnyTracingEnabled()) {
                object2 = TraceFixer.addTraceAndLogging((Cursor)object2, profile);
            }
        }
        return object2;
    }

    @Override
    public int getDataProviderID() {
        return this.dataProviderID;
    }

    @Override
    public Preparer getPreparer() {
        if (this instanceof Preparer) {
            return (Preparer)((Object)this);
        }
        return null;
    }

    @Override
    public Cursor sequence(CData cData, Cursor.Profile profile) {
        if (cData == null || cData.getSize() == 0) {
            return null;
        }
        return cData instanceof BaseCData ? ((BaseCData)cData).toCursor(this) : cData.toCursor();
    }

    @Override
    public Cursor sequence(CData cData) {
        return this.sequence(cData, Cursor.Profile.MINIMAL_FORK);
    }

    @Override
    public Cursor sequence(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(bigDecimal, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(BigDecimal[] bigDecimalArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[bigDecimalArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(bigDecimalArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(BigInteger bigInteger, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(bigInteger, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(BigInteger[] bigIntegerArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[bigIntegerArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(bigIntegerArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) {
        return this.sequence(this.data(bl, xSSimpleTypeDefinition, bl2));
    }

    @Override
    public Cursor sequence(boolean[] blArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[blArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(blArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(byte by2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(by2, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(byte[] byArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition != null ? xSSimpleTypeDefinition : TypeRegistry.XSBYTE;
        switch (xSSimpleTypeDefinition2.getBuiltInKind()) {
            case 16: 
            case 17: {
                return this.sequence(this.data(byArray, xSSimpleTypeDefinition, bl));
            }
        }
        CData[] cDataArray = new CData[byArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(byArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition2));
    }

    @Override
    public Cursor sequence(Bytes bytes2, Charset charset, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(bytes2, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(Bytes bytes2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(bytes2, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(char[] cArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(cArray, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(charSequence, xSSimpleTypeDefinition, false));
    }

    @Override
    public Cursor sequence(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        return this.sequence(this.data(charSequence, null, false));
    }

    @Override
    public Cursor sequence(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, boolean bl) {
        return this.sequence(this.data(charSequence, xSSimpleTypeDefinition, false));
    }

    @Override
    public Cursor sequence(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(charSequence, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(CharSequence[] charSequenceArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[charSequenceArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(charSequenceArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(Cursor cursor2) {
        return this.sequence(this.data(cursor2));
    }

    @Override
    public Cursor sequence(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(d, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(double[] dArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[dArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(dArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(Duration duration2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(duration2, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(Duration[] durationArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[durationArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(durationArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(f2, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(float[] fArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[fArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(fArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(n2, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(int[] nArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[nArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(nArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(long l, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(l, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(long[] lArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[lArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(lArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(qName, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(QName[] qNameArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[qNameArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(qNameArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(short s, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(s, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(short[] sArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[sArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(sArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(URI uRI, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(uRI, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(URI[] uRIArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[uRIArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(uRIArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor sequence(XMLGregorianCalendar xMLGregorianCalendar, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.sequence(this.data(xMLGregorianCalendar, xSSimpleTypeDefinition, bl));
    }

    @Override
    public Cursor sequence(XMLGregorianCalendar[] xMLGregorianCalendarArray, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        assert (xSSimpleTypeDefinition == null || TypeHelper.isAtomic(xSSimpleTypeDefinition));
        CData[] cDataArray = new CData[xMLGregorianCalendarArray.length];
        for (int i = 0; i < cDataArray.length; ++i) {
            cDataArray[i] = this.data(xMLGregorianCalendarArray[i], xSSimpleTypeDefinition, bl);
        }
        return this.sequence(this.data(cDataArray, xSSimpleTypeDefinition));
    }

    @Override
    public Cursor attribute(VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        return CacheFactory.makeAttribute(this, volatileCData, volatileCData2, requestInfo);
    }

    @Override
    public Cursor comment(VolatileCData volatileCData, RequestInfo requestInfo) {
        return CacheFactory.makeComment(this, volatileCData, requestInfo);
    }

    @Override
    public Cursor element(VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, RequestInfo requestInfo) {
        return CacheFactory.makeElement(this, volatileCData, xSTypeDefinition, requestInfo);
    }

    @Override
    public Cursor namespace(VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        return CacheFactory.makeNamespace(this, volatileCData, volatileCData2, requestInfo);
    }

    @Override
    public Cursor processingInstruction(VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        return CacheFactory.makeProcessingInstruction(this, volatileCData, volatileCData2, requestInfo);
    }

    @Override
    public Cursor text(VolatileCData volatileCData, RequestInfo requestInfo) {
        return CacheFactory.makeText(this, volatileCData, requestInfo);
    }

    @Override
    public CData data(Object object2) {
        return new ForeignObjectCData(object2);
    }

    @Override
    public Cursor sequence(Object object2) {
        return this.sequence(this.data(object2));
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public Cursor attribute(VolatileCData volatileCData, Chars chars, RequestInfo requestInfo) {
        return this.attribute(volatileCData, new StoredCharsCData(chars, TypeRegistry.XSUNTYPEDATOMIC), requestInfo);
    }

    @Override
    public Cursor comment(Chars chars, RequestInfo requestInfo) {
        return this.comment(new StoredCharsCData(chars, TypeRegistry.XSUNTYPEDATOMIC), requestInfo);
    }

    @Override
    public Cursor processingInstruction(VolatileCData volatileCData, Chars chars, RequestInfo requestInfo) {
        return this.processingInstruction(volatileCData, new StoredCharsCData(chars, TypeRegistry.XSUNTYPEDATOMIC), requestInfo);
    }

    @Override
    public Cursor text(Chars chars, RequestInfo requestInfo) {
        return this.text(new StoredCharsCData(chars, TypeRegistry.XSUNTYPEDATOMIC), requestInfo);
    }

    protected DOMErrorHandler getErrorHandler(RequestInfo requestInfo) {
        Object object2;
        DOMErrorHandler dOMErrorHandler = null;
        Map<String, Object> map2 = requestInfo.getParameters();
        if (map2 != null && (object2 = map2.get("error-handler")) instanceof DOMErrorHandler) {
            dOMErrorHandler = (DOMErrorHandler)object2;
        }
        return dOMErrorHandler != null ? dOMErrorHandler : this.sessionContext.getErrorHandler();
    }

    static {
        boolean bl;
        SIMPLY_ADDED_FIXED_BITS = SizePositionFixer.FIXED_FEATURES.union(NodeTestFixer.FIXED_FEATURES.union(SelfFixer.FIXED_FEATURES));
        SAFE_MODE = bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return "true".equals(System.getProperty("com.ibm.xml.xci.SAFE_MODE"));
            }
        }).booleanValue();
        BOOLEAN_TRUE = null;
        BOOLEAN_FALSE = null;
        FLOATING_CONSTS = null;
        DOUBLE_CONSTS = null;
        REQUIRE_CACHE_FIXER_BITS = Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_PARENT).union(Cursor.Profile.NODE_IDENTITY).union(Cursor.Profile.ALWAYS_VALID).union(Cursor.Profile.XSPSVINFO).union(Cursor.Profile.ADD_COPY).union(Cursor.Profile.SET_NAME).union(Cursor.Profile.IS_DEEP_EQUAL_TO).union(Cursor.Profile.SET_TYPE).union(Cursor.Profile.SET_BASE_URI).union(Cursor.Profile.SET_PSVI);
        DESTRUCTIVE_FIXERS_BITS = Cursor.Profile.REMOVE_ATTRIBUTE.union(Cursor.Profile.REMOVE_SUBTREE).union(Cursor.Profile.TO_IDREFS).union(Cursor.Profile.TO_IDS).union(Cursor.Profile.MINIMAL_MUTATION).union(Cursor.Profile.TO_FOLLOWING_SIBLINGS).union(Cursor.Profile.TO_PRECEDING_SIBLINGS).union(Cursor.Profile.SET_VALUE);
    }
}

