/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.bytes;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.bytes.NoBytes;
import com.ibm.xml.xci.errors.XCIUnsupportedOperationException;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

final class InputStreamBytes
implements Bytes {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final int BUF_SIZE = 1024;
    private InputStream stream;
    private List buffers;
    private long base;
    private long next;

    public InputStreamBytes(InputStream inputStream) {
        this.stream = inputStream;
        this.buffers = new LinkedList();
        this.base = 0L;
        this.next = 0L;
    }

    private byte[] buffer(int n2) {
        return (byte[])this.buffers.get(n2);
    }

    private boolean advanceNextTo(long l) {
        if (this.stream == null) {
            return l <= this.next;
        }
        try {
            while (this.next < l) {
                byte[] byArray;
                int n2 = (int)((this.next - this.base) % 1024L);
                if (n2 == 0) {
                    byArray = new byte[1024];
                    this.buffers.add(byArray);
                } else {
                    byArray = this.buffer(this.buffers.size() - 1);
                }
                int n3 = this.stream.available();
                int n4 = 1024 - n2;
                int n5 = this.stream.read(byArray, n2, n3 > 0 && n3 <= n4 ? n3 : n4);
                if (n5 <= 0) {
                    this.stream = null;
                    return false;
                }
                this.next += (long)n5;
            }
        }
        catch (IOException iOException) {
            this.stream = null;
            return false;
        }
        return true;
    }

    public boolean hasByteAt(long l) {
        if (l < 0L) {
            return false;
        }
        if (l < this.next) {
            return true;
        }
        if (this.stream == null) {
            return false;
        }
        return this.advanceNextTo(l + 1L);
    }

    public byte byteAt(long l) {
        if (l < this.base) {
            throw new UnsupportedOperationException();
        }
        if (l >= this.next && !this.advanceNextTo(l + 1L)) {
            throw new IndexOutOfBoundsException();
        }
        assert (this.base <= l && l < this.next) : "Could not read byte (" + l + ")";
        int n2 = (int)(l - this.base) / 1024;
        int n3 = (int)(l - this.base) % 1024;
        return this.buffer(n2)[n3];
    }

    public long byteLength() {
        this.advanceNextTo(Long.MAX_VALUE);
        return this.next;
    }

    public void discardBytesUpto(long l) {
        if (l >= this.next) {
            this.buffers.clear();
            if (l > this.next) {
                try {
                    long l2;
                    long l3 = this.next - l;
                    if (this.stream != null && (l2 = this.stream.skip(l3)) < l3) {
                        this.stream = null;
                    }
                }
                catch (IOException iOException) {
                    this.stream = null;
                }
            }
            this.base = this.next = l;
        } else {
            while (l - this.base >= 1024L) {
                this.buffers.remove(0);
                this.base += 1024L;
            }
        }
    }

    public Bytes byteSubSequence(long l, long l2) {
        long l3 = l2 - l;
        if (l < 0L || l3 < 0L) {
            throw new IndexOutOfBoundsException("Cannot take subsequence from " + l + " to " + l2);
        }
        if (l3 == 0L) {
            return NoBytes.INSTANCE;
        }
        byte[] byArray = new byte[(int)l3];
        int n2 = (int)(l - this.base) / 1024;
        int n3 = (int)(l - this.base) % 1024;
        int n4 = 0;
        while (l3 > 0L) {
            assert (l + l3 == l2);
            long l4 = Math.min((long)(1024 - n3), l3);
            if (!this.hasByteAt(l + l4 - 1L)) {
                if (this.stream == null) {
                    l4 = l3 = this.byteLength() - (long)n4;
                } else {
                    throw new IndexOutOfBoundsException();
                }
            }
            int n5 = n3;
            int n6 = n4;
            for (int i = 0; i < (int)l4; ++i) {
                byArray[n6++] = this.buffer(n2)[n5++];
            }
            l += l4;
            l3 -= l4;
            ++n2;
            n4 = (int)((long)n4 + l4);
            n3 = 0;
        }
        assert (l3 == 0L && l == l2);
        return BytesUtils.make(byArray);
    }

    public Bytes byteSubSequence(long l) {
        return this.byteSubSequence(l, this.byteLength());
    }

    public void writeBytesTo(OutputStream outputStream, boolean bl) throws IOException {
        if (this.base > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_WRITE_BYTES", null));
        }
        int n2 = 0;
        long l = 0L;
        while (l < this.next || this.stream != null) {
            long l2 = l + 1024L;
            int n3 = 1024;
            if (this.next < l2 && !this.advanceNextTo(l2)) {
                n3 = (int)(this.next - l);
            }
            outputStream.write(this.buffer(n2), 0, n3);
            l = l2;
            if (bl) {
                this.discardBytesUpto(l2);
                continue;
            }
            ++n2;
        }
    }

    public int writeBytesTo(int n2, byte[] byArray, int n3, boolean bl) {
        if (this.base > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_WRITE_BYTES", null));
        }
        int n4 = n2 / 1024;
        int n5 = n2;
        int n6 = 0;
        while (byArray.length - n3 > 0 && ((long)n5 < this.next || this.stream != null)) {
            int n7 = 1024 - n5 % 1024;
            int n8 = n5 + n7;
            if (this.next < (long)n8 && !this.advanceNextTo(n8)) {
                n7 = (int)(this.next - (long)n5);
            }
            int n9 = Math.min(n7, byArray.length - n3);
            System.arraycopy(this.buffer(n4), n5 % 1024, byArray, n3, n9);
            n3 += n9;
            n6 += n9;
            if (bl) {
                this.discardBytesUpto(n8);
            } else {
                ++n4;
            }
            n5 = n8;
        }
        return n6;
    }

    public void writeBytesTo(ByteBuffer byteBuffer, boolean bl) {
        if (this.base > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_WRITE_BYTES", null));
        }
        if ((long)byteBuffer.remaining() < this.next) {
            throw new BufferOverflowException();
        }
        int n2 = 0;
        long l = 0L;
        while (l < this.next || this.stream != null) {
            long l2 = l + 1024L;
            int n3 = 1024;
            if (this.next < l2 && !this.advanceNextTo(l2)) {
                n3 = (int)(this.next - l);
            }
            byteBuffer.put(ByteBuffer.wrap(this.buffer(n2), 0, n3));
            if (bl) {
                this.discardBytesUpto(l2);
            } else {
                ++n2;
            }
            l = l2;
        }
    }

    public InputStream toInputStream(boolean bl) {
        if (this.base > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_REREAD_BYTES", null));
        }
        if (this.next == 0L && bl) {
            InputStream inputStream = this.stream;
            this.stream = null;
            return inputStream;
        }
        return new ByteArrayInputStream(this.toByteArray(bl));
    }

    public byte[] toByteArray(boolean bl) {
        if (this.base > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_REREAD_BYTES", null));
        }
        if (this.byteLength() > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_TOO_LONG_BUFFER", null));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeBytesTo(byteArrayOutputStream, bl);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ByteBuffer toByteBuffer(boolean bl) {
        if (this.base > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_REREAD_BYTES", null));
        }
        return ByteBuffer.wrap(this.toByteArray(bl));
    }

    public boolean equals(Object object2) {
        if (this.base > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_COMPARE_BYTES", null));
        }
        if (object2 instanceof Bytes) {
            Bytes bytes2 = (Bytes)object2;
            if (this.byteLength() != bytes2.byteLength()) {
                return false;
            }
            for (long i = 0L; i < this.byteLength(); ++i) {
                if (this.byteAt(i) == bytes2.byteAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        throw new XCIUnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"hashCode", InputStreamBytes.class.getName()}));
    }
}

