/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.bytes;

import com.ibm.xml.xci.bytes.ByteArraySubBytes;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.NoBytes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class ByteArrayBytes
implements Bytes {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final byte[] subBytes;

    public ByteArrayBytes(byte[] byArray) {
        this.subBytes = byArray;
    }

    public boolean hasByteAt(long l) {
        return 0L <= l && l < (long)this.subBytes.length;
    }

    public byte byteAt(long l) {
        return this.subBytes[(int)l];
    }

    public long byteLength() {
        return this.subBytes.length;
    }

    public void discardBytesUpto(long l) {
    }

    public Bytes byteSubSequence(long l, long l2) {
        if (l >= l2 || l >= this.byteLength()) {
            return NoBytes.INSTANCE;
        }
        return new ByteArraySubBytes(this.subBytes, (int)l, (int)l2);
    }

    public Bytes byteSubSequence(long l) {
        return this.byteSubSequence(l, this.subBytes.length);
    }

    public void writeBytesTo(OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(this.subBytes);
    }

    public void writeBytesTo(ByteBuffer byteBuffer, boolean bl) {
        byteBuffer.put(this.subBytes);
    }

    public int writeBytesTo(int n2, byte[] byArray, int n3, boolean bl) {
        int n4 = Math.min(this.subBytes.length - n2, byArray.length - n3);
        System.arraycopy(this.subBytes, n2, byArray, n3, n4);
        return n4;
    }

    public InputStream toInputStream(boolean bl) {
        return new ByteArrayInputStream(this.subBytes);
    }

    public byte[] toByteArray(boolean bl) {
        return this.subBytes;
    }

    public ByteBuffer toByteBuffer(boolean bl) {
        return ByteBuffer.wrap(this.subBytes);
    }

    public boolean equals(Object object2) {
        if (object2 instanceof ByteArrayBytes) {
            return Arrays.equals(this.subBytes, ((ByteArrayBytes)object2).subBytes);
        }
        if (object2 instanceof Bytes) {
            return Arrays.equals(this.subBytes, ((Bytes)object2).toByteArray(false));
        }
        return false;
    }
}

