/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory;
import com.ibm.xml.xlxp.internal.s1.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import java.security.AccessController;
import java.security.PrivilegedAction;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XLXPSharedResources {
    private final int DEFAULT_BUFFER_SIZE = 8192;
    private DataBufferFactory bufferFactory;
    private SAX2ParsedEntityFactory entityFactory;
    private XLXPCursorFactory cursorFactory;
    private SymbolTable symbolTable;

    public XLXPSharedResources(XLXPCursorFactory xLXPCursorFactory) {
        this.cursorFactory = xLXPCursorFactory;
        this.bufferFactory = new SimpleDataBufferFactory();
        this.entityFactory = new SAX2ParsedEntityFactory(this.bufferFactory);
        this.symbolTable = new SymbolTable(xLXPCursorFactory.symbolMapHolder);
        this.setBufferLength();
    }

    public XLXPSharedResources(DataBufferFactory dataBufferFactory, SAX2ParsedEntityFactory sAX2ParsedEntityFactory, XLXPCursorFactory xLXPCursorFactory, SymbolTable symbolTable) {
        this.bufferFactory = dataBufferFactory;
        this.entityFactory = sAX2ParsedEntityFactory;
        this.cursorFactory = xLXPCursorFactory;
        this.symbolTable = symbolTable;
    }

    private void setBufferLength() {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.ibm.xml.xlxp.internal.s1.api.util.encoding.DataSourceFactory.bufferLength");
            }
        });
        if (string2 == null) {
            this.entityFactory.setBufferLength(8192);
        }
    }

    public DataBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public SAX2ParsedEntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public XLXPCursorFactory getCursorFactory() {
        return this.cursorFactory;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }
}

