/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.adapters.xlxp.XLXPCursor;
import com.ibm.xml.xci.adapters.xlxp.util.CursorWeakReference;
import com.ibm.xml.xci.xlxp.Scanner;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class WeakReferenceManager {
    private static final Logger logger = LoggerUtil.getLogger(WeakReferenceManager.class);
    private static final int REFERENCE_ARRAY_SIZE_DEFAULT = 100;
    public static final int REFERENCE_ARRAY_SIZE;
    private int lastSearchedIndex = 0;
    private final ReferenceQueue<XLXPCursor> myQueue = new ReferenceQueue();
    private CursorWeakReference[] ReferenceArray = new CursorWeakReference[REFERENCE_ARRAY_SIZE];
    private int[] FreeIndexArray = new int[REFERENCE_ARRAY_SIZE];
    private int freeIndexPointer = -1;

    public WeakReferenceManager() {
        this.initArrays();
    }

    private void initArrays() {
        for (int i = REFERENCE_ARRAY_SIZE - 1; i >= 0; --i) {
            this.FreeIndexArray[WeakReferenceManager.REFERENCE_ARRAY_SIZE - 1 - i] = i;
            ++this.freeIndexPointer;
        }
    }

    public void register(XLXPCursor xLXPCursor) {
        int n2 = this.popFreeIndex();
        if (n2 == -1) {
            xLXPCursor.scanner.setWeakReferenceIndex(-1);
            return;
        }
        CursorWeakReference cursorWeakReference = new CursorWeakReference(xLXPCursor, this.myQueue);
        cursorWeakReference.index = n2;
        xLXPCursor.scanner.setWeakReferenceIndex(n2);
        this.ReferenceArray[n2] = cursorWeakReference;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "register", "registering a new XLXPCursor into index:" + n2);
        }
    }

    public Scanner fetch() {
        Scanner scanner;
        Reference<XLXPCursor> reference = this.myQueue.poll();
        if (reference != null && (scanner = this.extractScanner((CursorWeakReference)reference)) != null) {
            return scanner;
        }
        return this.searchReferenceArray();
    }

    private Scanner extractScanner(CursorWeakReference cursorWeakReference) {
        Scanner scanner = cursorWeakReference.myScanner;
        if (cursorWeakReference.wasReleased || scanner.wasReleased()) {
            return null;
        }
        if (scanner.isZombie() ? scanner.isOwnerReferenced(scanner) : (scanner = scanner.checkReferencesGC()) == null) {
            return null;
        }
        scanner.resetScanner();
        this.releaseEntry(cursorWeakReference.index);
        return scanner;
    }

    private Scanner searchReferenceArray() {
        Scanner scanner = null;
        int n2 = REFERENCE_ARRAY_SIZE - (this.freeIndexPointer + 1);
        if (n2 == 0) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = this.lastSearchedIndex;
        int n6 = REFERENCE_ARRAY_SIZE;
        do {
            for (int i = n5; i < n6; ++i) {
                CursorWeakReference cursorWeakReference = this.ReferenceArray[i];
                if (cursorWeakReference == null) continue;
                ++n3;
                if (cursorWeakReference.get() == null && (scanner = this.extractScanner(cursorWeakReference)) != null) {
                    this.lastSearchedIndex = i;
                    return scanner;
                }
                if (n3 != n2) continue;
                this.lastSearchedIndex = i;
                return null;
            }
            n5 = 0;
            n6 = this.lastSearchedIndex;
        } while (++n4 <= 1);
        this.lastSearchedIndex = 0;
        return scanner;
    }

    private int popFreeIndex() {
        if (this.freeIndexPointer == -1) {
            return -1;
        }
        if (this.FreeIndexArray[this.freeIndexPointer] < 0 || this.FreeIndexArray[this.freeIndexPointer] >= REFERENCE_ARRAY_SIZE) {
            // empty if block
        }
        return this.FreeIndexArray[this.freeIndexPointer--];
    }

    public void releaseEntry(int n2) {
        if (n2 < 0 || n2 >= REFERENCE_ARRAY_SIZE) {
            return;
        }
        if (this.ReferenceArray[n2] == null) {
            return;
        }
        this.ReferenceArray[n2].wasReleased = true;
        this.pushFreeIndex(n2);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "releaseEntry", "recycling the entry at index:" + n2);
        }
    }

    private void pushFreeIndex(int n2) {
        this.ReferenceArray[n2] = null;
        this.FreeIndexArray[++this.freeIndexPointer] = n2;
        if (this.freeIndexPointer >= REFERENCE_ARRAY_SIZE) {
            // empty if block
        }
    }

    static {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("weak.ref.pool");
            }
        });
        REFERENCE_ARRAY_SIZE = string2 != null ? Integer.parseInt(string2) : 100;
    }
}

