/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class UniqueIntegerHashCounter {
    private int[][] hashTable = new int[1000][];
    private final int HASH_VALUE = 1000;
    private final int INITIAL_BUCKET_SIZE = 2;

    private void calculateHash(int n2, int[] nArray) {
        nArray[0] = n2 % 1000;
        nArray[1] = (n2 - nArray[0]) / 1000;
    }

    public int getValue(int n2) {
        int[] nArray = new int[2];
        this.calculateHash(n2, nArray);
        if (this.entryFound(nArray[0], nArray[1])) {
            return this.hashTable[nArray[0]][nArray[1]];
        }
        return -1;
    }

    private boolean entryFound(int n2, int n3) {
        int[] nArray = this.hashTable[n2];
        if (nArray == null) {
            return false;
        }
        return n3 < nArray.length;
    }

    public void incrementKey(int n2) {
        int n3 = this.getValue(n2);
        if (n3 == -1) {
            n3 = 0;
        }
        this.putValue(n2, ++n3);
    }

    public void decrementKey(int n2) {
        int n3 = this.getValue(n2);
        if (n3 == -1) {
            return;
        }
        this.putValue(n2, --n3);
    }

    public void putValue(int n2, int n3) {
        int[] nArray = new int[2];
        this.calculateHash(n2, nArray);
        if (!this.entryFound(nArray[0], nArray[1])) {
            this.makeEntry(nArray[0], nArray[1], n3);
        } else {
            this.hashTable[nArray[0]][nArray[1]] = n3;
        }
    }

    private void makeEntry(int n2, int n3, int n4) {
        int[] nArray = new int[n3 + 1];
        nArray[n3] = n4;
        this.hashTable[n2] = nArray;
    }
}

